/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.editor.dkml.parse;

import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.soda.devicekit.editor.dkml.messages.Messages;
import org.eclipse.soda.devicekit.editor.dkml.parse.AttributeHolder;
import org.eclipse.soda.devicekit.editor.dkml.parse.CommentHolder;
import org.eclipse.soda.devicekit.editor.dkml.parse.TagHolder;

public class TagHolderString {
    private TagHolder holder;
    private StringBuffer contents;
    private int indent = -1;

    public TagHolderString(TagHolder holder) {
        this.holder = holder;
        this.contents = new StringBuffer();
        this.createString();
    }

    public static String getXmlString(String string) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        while (i < string.length()) {
            char character = string.charAt(i);
            if (character == '&') {
                buffer.append("&amp;");
            } else if (character == '<') {
                buffer.append("&lt;");
            } else if (character == '>') {
                buffer.append("&gt;");
            } else {
                buffer.append(character);
            }
            ++i;
        }
        return buffer.toString();
    }

    private void createString() {
        this.printTag(this.holder);
    }

    private String getAttributes(TagHolder current) {
        StringBuffer buff = new StringBuffer();
        Vector atts = current.getAttributes();
        if (atts != null) {
            int i = 0;
            while (i < atts.size()) {
                AttributeHolder attribute = (AttributeHolder)atts.elementAt(i);
                buff.append(' ');
                buff.append(attribute.getName());
                buff.append("=\"");
                buff.append(attribute.getValue());
                buff.append('\"');
                ++i;
            }
        }
        return buff.toString();
    }

    private String getEntityEntry(String comment) {
        String entity = "";
        StringTokenizer st = new StringTokenizer(comment);
        String en = st.nextToken();
        String key = st.nextToken();
        String value = st.nextToken();
        entity = String.valueOf(en) + " % " + key + " '" + value + "'";
        return entity;
    }

    private String indent() {
        String indention = "";
        int i = 0;
        while (i < this.indent) {
            indention = String.valueOf(indention) + "\t";
            ++i;
        }
        return indention;
    }

    private void print(String s) {
        this.contents.append(s);
    }

    private void printComment(CommentHolder current) {
        String comment = current.getComment();
        this.print("\n");
        ++this.indent;
        this.print(this.indent());
        if (comment.startsWith(Messages.getString("ENTITY_TAG"))) {
            this.print("<!");
            this.print(this.getEntityEntry(comment));
            this.print(">");
        } else {
            this.print("<!--");
            this.print(comment);
            this.print("-->");
        }
        --this.indent;
    }

    public void printContents(String contents) {
        this.print(TagHolderString.getXmlString(contents));
    }

    private void printElement(TagHolder current) {
        this.print("\n");
        ++this.indent;
        this.print(this.indent());
        this.print("<" + current.getName() + this.getAttributes(current));
        Vector children = current.getChildren();
        String data = current.getData();
        if (children.size() > 0) {
            this.print(">");
            if (data != null) {
                this.printContents(data);
            }
            int i = 0;
            while (i < children.size()) {
                TagHolder child = (TagHolder)children.elementAt(i);
                this.printTag(child);
                ++i;
            }
            this.print("\n" + this.indent() + "</" + current.getName() + '>');
        } else if (data != null) {
            this.print(">");
            this.printContents(data);
            this.print("</" + current.getName() + '>');
        } else {
            this.print("/>");
        }
        --this.indent;
    }

    private void printTag(TagHolder current) {
        if (current instanceof CommentHolder) {
            this.printComment((CommentHolder)current);
        } else {
            this.printElement(current);
        }
    }

    public String toString() {
        return this.contents.toString();
    }
}

