/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.feature;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soda.devicekit.DeviceKitPlugin;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.generator.print.XmlPrinter;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.CoreUtility;

public class FeatureGenerator {
    private Map variables;
    static /* synthetic */ Class class$0;

    public FeatureGenerator(Map variables) {
        this.setVariables(variables);
    }

    public String buildString(Hashtable table, char character) {
        StringBuffer buffer = new StringBuffer(1024);
        Set set = table.keySet();
        Object[] results = new String[set.size()];
        results = set.toArray(results);
        Arrays.sort(results);
        int i = 0;
        while (i < results.length) {
            if (i > 0) {
                buffer.append(character);
            }
            buffer.append((String)results[i]);
            ++i;
        }
        return buffer.toString();
    }

    public String change(String data, String from, String to) {
        return this.change(data, from, to, 0);
    }

    public String change(String data, String from, String to, int index) {
        int index1 = data.indexOf(from, index);
        if (index1 >= 0) {
            StringBuffer buffer = new StringBuffer(256);
            buffer.append(data.substring(0, index1));
            buffer.append(to);
            buffer.append(data.substring(index1 + from.length()));
            return this.change(buffer.toString(), from, to, from.length());
        }
        return data;
    }

    public void createCommon(String baseType, String typeName, IProgressMonitor monitor) throws CoreException {
        String name = String.valueOf(this.getVariables().get("name"));
        String templateBaseName = typeName.replace('-', '.').trim();
        String dotName = DeviceKitUtilities.getPackageFromUserName(name, this.getPackageBase());
        String featureName = String.valueOf(dotName) + '-' + typeName;
        IProject project = CoreUtility.getProject(featureName);
        Map map = this.getVariables();
        String featureTypeName = this.change(typeName, "plugin", "feature");
        map.put("project_name", featureName);
        map.put("feature_id", String.valueOf(dotName) + '.' + featureTypeName.replace('-', '.'));
        map.put("feature_root_id", dotName);
        map.put("feature_plugins", this.getPluginsString(dotName));
        map.put("feature_features", this.getFeaturesString(dotName));
        String pluginTypeName = this.change(typeName, "feature", "plugin");
        map.put("plugin_id", String.valueOf(dotName) + '.' + pluginTypeName.replace('-', '.'));
        map.put("plugin_root_id", dotName);
        map.put("plugin_plugins", this.getPluginsString(dotName));
        if (!project.exists()) {
            project = CoreUtility.createProject(featureName, monitor);
            CoreUtility.addNatureToProject(project, "org.eclipse.pde.PluginNature", monitor);
        }
        CoreUtility.createWorkingSetBase(dotName);
        Object description = this.getVariables().get("description");
        if (description == null || description.toString().length() == 0) {
            map.put("description", name);
        }
        map.put("percent", "%");
        map.put("copyright_property", this.getCopyrightProperty(map));
        map.put("copyright_properties", GeneratorTemplates.getCopyrightPropertyString(map));
        map.put("copyright_xml", GeneratorTemplates.getCopyrightXmlString(map));
        String[] warningStrings = GeneratorTemplates.getStrings(GeneratorTemplates.getWarning(map));
        XmlPrinter printer = new XmlPrinter();
        printer.printComments(warningStrings);
        map.put("warning_xml", printer.getContents());
        String featureString = GeneratorTemplates.getResults(templateBaseName, map).trim();
        IFile file = project.getFile(String.valueOf(baseType) + ".xml");
        ByteArrayInputStream source = new ByteArrayInputStream(featureString.getBytes());
        if (file.exists()) {
            file.setContents((InputStream)source, true, true, monitor);
        } else {
            file.create((InputStream)source, true, monitor);
        }
        String featureBuildString = GeneratorTemplates.getResults(String.valueOf(templateBaseName) + ".build.properties", map).trim();
        IFile featureBuildFile = project.getFile("build.properties");
        ByteArrayInputStream featureBuildSource = new ByteArrayInputStream(featureBuildString.getBytes());
        if (featureBuildFile.exists()) {
            featureBuildFile.setContents((InputStream)featureBuildSource, true, true, monitor);
        } else {
            featureBuildFile.create((InputStream)featureBuildSource, true, monitor);
        }
        String featurePropertiesString = GeneratorTemplates.getResults(String.valueOf(templateBaseName) + '.' + baseType + ".properties", map).trim();
        IFile featurePropertiesFile = project.getFile(String.valueOf(baseType) + ".properties");
        ByteArrayInputStream featurePropertiesSource = new ByteArrayInputStream(featurePropertiesString.getBytes());
        if (featurePropertiesFile.exists()) {
            featurePropertiesFile.setContents((InputStream)featurePropertiesSource, true, true, monitor);
        } else {
            featurePropertiesFile.create((InputStream)featurePropertiesSource, true, monitor);
        }
        if (typeName.equals("plugin-samples") || typeName.equals("plugin-doc-reference")) {
            ByteArrayInputStream buildSamplesStringFileSource;
            IFile buildSamplesFile;
            String buildSamplesString;
            String customBuildString = GeneratorTemplates.getResults(String.valueOf(templateBaseName) + '.' + baseType + ".customBuild.xml", map).trim();
            IFile customBuildFile = project.getFile("customBuild.xml");
            ByteArrayInputStream customBuildStringFileSource = new ByteArrayInputStream(customBuildString.getBytes());
            if (customBuildFile.exists()) {
                customBuildFile.setContents((InputStream)customBuildStringFileSource, true, true, monitor);
            } else {
                customBuildFile.create((InputStream)customBuildStringFileSource, true, monitor);
            }
            if (typeName.equals("plugin-samples")) {
                map.put("plugin_build_samples", this.getSamplesBuildString(dotName));
                buildSamplesString = GeneratorTemplates.getResults(String.valueOf(templateBaseName) + '.' + baseType + ".build.samples", map).trim();
                buildSamplesFile = project.getFile("build-samples.xml");
                buildSamplesStringFileSource = new ByteArrayInputStream(buildSamplesString.getBytes());
                if (buildSamplesFile.exists()) {
                    buildSamplesFile.setContents((InputStream)buildSamplesStringFileSource, true, true, monitor);
                } else {
                    buildSamplesFile.create((InputStream)buildSamplesStringFileSource, true, monitor);
                }
                IFolder folder = project.getFolder("examples");
                if (!folder.exists()) {
                    folder.create(true, true, monitor);
                }
            }
            if (typeName.equals("plugin-doc-reference")) {
                IFolder tocFolder;
                buildSamplesString = GeneratorTemplates.getResults(String.valueOf(templateBaseName) + '.' + baseType + ".build.doc.reference", map).trim();
                buildSamplesFile = project.getFile("build-doc-reference.xml");
                buildSamplesStringFileSource = new ByteArrayInputStream(buildSamplesString.getBytes());
                if (buildSamplesFile.exists()) {
                    buildSamplesFile.setContents((InputStream)buildSamplesStringFileSource, true, true, monitor);
                } else {
                    buildSamplesFile.create((InputStream)buildSamplesStringFileSource, true, monitor);
                }
                IFolder docFolder = project.getFolder("doc");
                if (!docFolder.exists()) {
                    docFolder.create(true, true, monitor);
                }
                if (!(tocFolder = project.getFolder("toc")).exists()) {
                    tocFolder.create(true, true, monitor);
                }
            }
        }
    }

    public void createFeature(String typeName, IProgressMonitor monitor) throws CoreException {
        this.createCommon("feature", typeName, monitor);
    }

    public void createPlugin(String typeName, IProgressMonitor monitor) throws CoreException {
        this.createCommon("plugin", typeName, monitor);
    }

    public String getCopyrightProperty(Map map) {
        String[] strings = GeneratorTemplates.getCopyrightStrings(map);
        StringBuffer buffer = new StringBuffer(1024);
        int i = 0;
        while (i < strings.length) {
            if (i > 0) {
                buffer.append("\\r\\n");
            }
            buffer.append(strings[i]);
            ++i;
        }
        return buffer.toString();
    }

    public String getFeaturesString(String baseName) {
        IProject[] projects = CoreUtility.findMatchingProjects(baseName);
        StringBuffer buffer = new StringBuffer(1024);
        int i = 0;
        while (i < projects.length) {
            String data = projects[i].getName();
            if (data.indexOf(45) >= 0) {
                buffer.append("\t<includes\r\n");
                buffer.append("\t\tid=\"");
                buffer.append(data.replace('-', '.'));
                buffer.append("\"\r\n");
                buffer.append("\t\tversion=\"0.0.0\"/>\r\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    public String getJavadocInfo(String baseName, Map map) {
        Hashtable<String, String> packages = new Hashtable<String, String>();
        Hashtable<String, String> sourcefiles = new Hashtable<String, String>();
        Hashtable<String, String> sourcepath = new Hashtable<String, String>();
        Hashtable<String, String> classpath = new Hashtable<String, String>();
        IProject[] projects = CoreUtility.findMatchingProjects(baseName);
        StringBuffer buffer = new StringBuffer(1024);
        int i = 0;
        while (i < projects.length) {
            IProject project = projects[i];
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (javaProject.exists()) {
                String data = project.getName();
                String sourceFile = "../" + data + "/src";
                sourcepath.put(sourceFile, sourceFile);
                String binFile = "../" + data + "/bin";
                classpath.put(binFile, binFile);
                this.updateClassPathProperty(javaProject, classpath);
                try {
                    IPackageFragmentRoot[] roots = javaProject.getPackageFragmentRoots();
                    if (roots != null) {
                        int j = 0;
                        while (j < roots.length) {
                            IPackageFragmentRoot packageFragmentRoot = roots[j];
                            if (packageFragmentRoot.getKind() == 1) {
                                IJavaElement[] packs = packageFragmentRoot.getChildren();
                                int k = 0;
                                while (k < packs.length) {
                                    IPackageFragment frag;
                                    ICompilationUnit[] cus;
                                    if (packs[k] instanceof IPackageFragment && (cus = (frag = (IPackageFragment)packs[k]).getCompilationUnits()).length > 0) {
                                        String key = frag.getElementName();
                                        packages.put(key, key);
                                        int m = 0;
                                        while (m < cus.length) {
                                            String javaName = String.valueOf(sourceFile) + '/' + key.replace('.', '/') + '/' + cus[m].getElementName();
                                            sourcefiles.put(javaName, javaName);
                                            ++m;
                                        }
                                    }
                                    ++k;
                                }
                            }
                            ++j;
                        }
                    }
                }
                catch (JavaModelException exception) {
                    exception.printStackTrace();
                }
            }
            ++i;
        }
        map.put("javadoc_packagenames", this.buildString(packages, ','));
        map.put("javadoc_sourcefiles", this.buildString(sourcefiles, ','));
        map.put("javadoc_sourcepath", this.buildString(sourcepath, ';'));
        map.put("javadoc_classpath", this.buildString(classpath, ';'));
        return buffer.toString();
    }

    protected String getPackageBase() {
        Object object = this.getVariables().get("packagebase");
        if (object == null) {
            return DeviceKitPlugin.getDefault().getPreferenceStore().getString("packagebase");
        }
        return object.toString();
    }

    public String getPluginsString(String baseName) {
        IProject[] projects = CoreUtility.findMatchingProjects(baseName);
        StringBuffer buffer = new StringBuffer(1024);
        int i = 0;
        while (i < projects.length) {
            String data = projects[i].getName();
            if (data.indexOf(45) < 0) {
                buffer.append("\t<plugin\r\n");
                buffer.append("\t\tid=\"");
                buffer.append(data);
                buffer.append("\"\r\n");
                buffer.append("\t\tversion=\"0.0.0\"\r\n");
                buffer.append("\t\tunpack=\"false\"/>\r\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    public String getSamplesBuildString(String baseName) {
        IProject[] projects = CoreUtility.findMatchingProjects(baseName);
        StringBuffer buffer = new StringBuffer(1024);
        int i = 0;
        while (i < projects.length) {
            String data = projects[i].getName();
            if (data.indexOf(45) < 0) {
                buffer.append("\t\t<zip file=\"examples/");
                buffer.append(data);
                buffer.append(".zip\">\r\n");
                buffer.append("\t\t\t<fileset dir=\"../");
                buffer.append(data);
                buffer.append("\">\r\n");
                buffer.append("\t\t\t\t<exclude name=\"**/bin/**\"/>\r\n");
                buffer.append("\t\t\t</fileset>\r\n");
                buffer.append("\t\t</zip>\r\n");
            }
            ++i;
        }
        return buffer.toString();
    }

    public Map getVariables() {
        return this.variables;
    }

    public boolean isIcon(String name) {
        return name.endsWith(".gif") || name.endsWith(".jpg") || name.endsWith(".jpeg");
    }

    public void processTemplates(String baseType, String typeName, IProgressMonitor monitor) throws CoreException {
        String betterName;
        String name = String.valueOf(this.getVariables().get("name"));
        String templateBaseName = typeName.replace('-', '.').trim();
        String dotName = DeviceKitUtilities.getPackageFromUserName(name, this.getPackageBase());
        String featureName = String.valueOf(dotName) + '-' + typeName;
        IProject project = CoreUtility.getProject(featureName);
        Map map = this.getVariables();
        String featureTypeName = this.change(typeName, "plugin", "feature");
        Object incubation = map.get("incubation");
        if (incubation == null) {
            incubation = DeviceKitPlugin.getIncubation();
        }
        if (DeviceKitPlugin.isIncubation((String)((String)incubation))) {
            map.put("incubationstring", "(Incubation)");
        } else {
            map.put("incubationstring", "");
        }
        map.put("project_name", featureName);
        map.put("feature_id", String.valueOf(dotName) + '.' + featureTypeName.replace('-', '.'));
        map.put("feature_root_id", dotName);
        map.put("feature_plugins", this.getPluginsString(dotName));
        this.getJavadocInfo(dotName, map);
        map.put("feature_features", this.getFeaturesString(dotName));
        String pluginTypeName = this.change(typeName, "feature", "plugin");
        map.put("plugin_id", String.valueOf(dotName) + '.' + pluginTypeName.replace('-', '.'));
        map.put("plugin_root_id", dotName);
        map.put("plugin_plugins", this.getPluginsString(dotName));
        if (!project.exists()) {
            project = CoreUtility.createProject(featureName, monitor);
            CoreUtility.addNatureToProject(project, "org.eclipse.pde.PluginNature", monitor);
        }
        CoreUtility.createWorkingSetBase(dotName);
        Object description = this.getVariables().get("description");
        if (description == null || description.toString().length() == 0) {
            betterName = name;
            if (name.startsWith(this.getPackageBase())) {
                betterName = CodeUtilities.betterDescriptionFromProjectName(name, this.getPackageBase());
            }
            map.put("description", betterName);
        } else {
            betterName = description.toString();
            if (description.toString().startsWith(this.getPackageBase())) {
                betterName = CodeUtilities.betterDescriptionFromProjectName(description.toString(), this.getPackageBase());
                map.put("description", betterName);
            }
        }
        map.put("plugin_build_samples", this.getSamplesBuildString(dotName));
        map.put("percent", "%");
        map.put("copyright_property", this.getCopyrightProperty(map));
        map.put("copyright_properties", GeneratorTemplates.getCopyrightPropertyString(map));
        map.put("copyright_xml", GeneratorTemplates.getCopyrightXmlString(map));
        String[] warningStrings = GeneratorTemplates.getStrings(GeneratorTemplates.getWarning(map));
        XmlPrinter printer = new XmlPrinter();
        printer.printComments(warningStrings);
        map.put("warning_xml", printer.getContents());
        String listString = GeneratorTemplates.getResults(templateBaseName, map).trim();
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int index = token.indexOf(47);
            if (index >= 0) {
                this.saveAllDirectory(token, project);
            }
            String templateName = String.valueOf(templateBaseName) + '/' + token;
            IFile contentFile = project.getFile(token);
            if (this.isIcon(token)) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.soda.devicekit.generator.templates.IconsTemplates");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                InputStream contentSource = clazz.getResourceAsStream(token);
                if (contentFile.exists()) {
                    contentFile.setContents(contentSource, true, true, monitor);
                    continue;
                }
                contentFile.create(contentSource, true, monitor);
                continue;
            }
            String contentString = GeneratorTemplates.getResults(templateName, map).trim();
            ByteArrayInputStream contentSource = new ByteArrayInputStream(contentString.getBytes());
            if (contentFile.exists()) {
                try {
                    InputStream current = contentFile.getContents(true);
                    String oldContents = DkUtilities.getStringFromStream(current).trim();
                    current.close();
                    if (DkUtilities.isEqualString(oldContents, contentString)) continue;
                    contentFile.setContents((InputStream)contentSource, true, true, monitor);
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
                continue;
            }
            contentFile.create((InputStream)contentSource, true, monitor);
        }
    }

    public void run(IProgressMonitor progressMonitor) throws CoreException {
        IProgressMonitor monitor = progressMonitor != null ? progressMonitor : new NullProgressMonitor();
        SubProgressMonitor subMonitor = new SubProgressMonitor(monitor, 6);
        String name = String.valueOf(this.getVariables().get("name"));
        subMonitor.subTask(String.valueOf(name) + "-feature");
        this.processTemplates("feature", "feature", monitor);
        subMonitor.worked(1);
        subMonitor.subTask(String.valueOf(name) + "-feature-source");
        this.processTemplates("feature", "feature-source", monitor);
        subMonitor.worked(1);
        subMonitor.subTask(String.valueOf(name) + "-feature-sdk");
        this.processTemplates("feature", "feature-sdk", monitor);
        subMonitor.worked(1);
        subMonitor.subTask(String.valueOf(name) + "-plugin");
        this.processTemplates("plugin", "plugin", monitor);
        subMonitor.worked(1);
        subMonitor.subTask(String.valueOf(name) + "-plugin-samples");
        this.processTemplates("plugin", "plugin-samples", monitor);
        subMonitor.worked(1);
        subMonitor.subTask(String.valueOf(name) + "-doc-reference");
        this.processTemplates("plugin", "plugin-doc-reference", monitor);
        subMonitor.done();
    }

    public void saveAllDirectory(String name, IProject project) {
        try {
            StringTokenizer tokenizer = new StringTokenizer(name, "/");
            int count = tokenizer.countTokens();
            IFolder folder = null;
            int i = 0;
            while (i < count - 1) {
                String token = tokenizer.nextToken();
                if (i == 0) {
                    folder = project.getFolder(token);
                    if (!folder.exists()) {
                        folder.create(true, true, null);
                    }
                } else if (folder != null) {
                    IFolder newFolder = folder.getFolder(token);
                    if (!newFolder.exists()) {
                        newFolder.create(true, true, null);
                    }
                    folder = newFolder;
                }
                ++i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void setVariables(Map variables) {
        this.variables = variables;
    }

    protected void updateClassPathProperty(IJavaProject javaProject, Hashtable classpath) {
        try {
            IClasspathEntry[] entries = javaProject.getRawClasspath();
            int i = 0;
            while (i < entries.length) {
                IClasspathEntry entry = entries[i];
                switch (entry.getEntryKind()) {
                    case 5: {
                        break;
                    }
                    case 1: {
                        String key = entry.getPath().toPortableString();
                        classpath.put(key, key);
                        break;
                    }
                    case 4: {
                        break;
                    }
                }
                ++i;
            }
        }
        catch (JavaModelException exception) {
            exception.printStackTrace();
        }
    }
}

