/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.model.java;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.internal.model.java.Field;
import org.eclipse.soda.devicekit.generator.internal.model.java.JavaElement;
import org.eclipse.soda.devicekit.generator.internal.model.java.Method;
import org.eclipse.soda.devicekit.generator.internal.model.java.SourceField;
import org.eclipse.soda.devicekit.generator.internal.model.java.SourceMethod;
import org.eclipse.soda.devicekit.generator.internal.print.java.TypePrinter;
import org.eclipse.soda.devicekit.generator.model.java.IField;
import org.eclipse.soda.devicekit.generator.model.java.IMethod;
import org.eclipse.soda.devicekit.generator.model.java.IType;

public class Type
extends JavaElement
implements IType {
    private String pack;
    private long fSortOrder;
    private Vector fFields;
    private Vector fMethods;
    private boolean fNLS = false;
    private String fSuperClass;
    private String[] fSuperInterfaces;
    private Hashtable fTypes;

    public Type(String pack, String name) {
        this(pack, name, 1);
    }

    public Type(String pack, String name, int fileType, long identifiers, boolean NLS) {
        super(name);
        this.pack = pack == null ? "" : pack;
        this.fFields = new Vector();
        this.fMethods = new Vector();
        this.fTypes = new Hashtable();
        this.setFileType(fileType);
        this.setNLS(NLS);
        this.setIdentifiers(identifiers);
        this.setSuperClass("Object");
    }

    public Type(String pack, String name, int fileType) {
        this(pack, name, fileType, 1L, false);
    }

    public void addExtraField(String key, String source) {
        SourceField field = new SourceField(key, source);
        this.fFields.add(field);
    }

    public void addExtraMethod(String key, String source) {
        SourceMethod method = new SourceMethod(key, source);
        this.fMethods.add(method);
    }

    public void addSuperInterface(String superInterface) {
        if (this.fSuperInterfaces == null) {
            this.fSuperInterfaces = new String[]{superInterface};
        } else {
            String[] fTemp = new String[this.fSuperInterfaces.length + 1];
            System.arraycopy(this.fSuperInterfaces, 0, fTemp, 0, this.fSuperInterfaces.length);
            fTemp[this.fSuperInterfaces.length] = superInterface;
            this.fSuperInterfaces = fTemp;
        }
    }

    public IField createField(String type, String name) {
        Field field = new Field(type, name);
        field.setFileType(this.getFileType());
        this.fFields.addElement(field);
        return field;
    }

    public IField createField(String[] javaDoc, long identifiers, String type, String name, String value) {
        Field field = new Field(type, name);
        field.setIdentifiers(identifiers);
        field.setValue(value);
        field.setComment(javaDoc);
        field.setFileType(this.getFileType());
        this.fFields.addElement(field);
        return field;
    }

    public IType createInnerType(String name) {
        if (this.isClass()) {
            Type type = new Type(this.pack, name, 1);
            this.fTypes.put(name, type);
            return type;
        }
        System.out.println("Cannot add inner type to interface");
        return null;
    }

    public IMethod createMethod(String name) {
        Method meth = new Method(name);
        meth.setConstructor(name.equals(this.getName()));
        this.fMethods.addElement(meth);
        return meth;
    }

    public IMethod[] getConstructors() {
        Vector<IMethod> v = new Vector<IMethod>();
        IMethod[] allMethods = this.getMethods();
        int i = 0;
        while (i < allMethods.length) {
            if (allMethods[i].isConstructor()) {
                v.add(allMethods[i]);
            }
            ++i;
        }
        Object[] cons = new IMethod[v.size()];
        v.copyInto(cons);
        return cons;
    }

    public IField getField(String name) {
        int i = 0;
        while (i < this.fFields.size()) {
            IField field = (IField)this.fFields.get(i);
            if (field.getName().equals(name)) {
                return field;
            }
            ++i;
        }
        return null;
    }

    public IField[] getFields() {
        IField[] fields = new IField[this.fFields.size()];
        Enumeration values = this.fFields.elements();
        int count = 0;
        while (values.hasMoreElements()) {
            fields[count++] = (IField)values.nextElement();
        }
        return fields;
    }

    public IMethod[] getMethods() {
        IMethod[] methods = new IMethod[this.fMethods.size()];
        Enumeration values = this.fMethods.elements();
        int count = 0;
        while (values.hasMoreElements()) {
            methods[count++] = (IMethod)values.nextElement();
        }
        return methods;
    }

    public boolean getNLS() {
        return this.fNLS;
    }

    public IMethod[] getNonConstructorMethods() {
        Vector<IMethod> v = new Vector<IMethod>();
        IMethod[] allMethods = this.getMethods();
        int i = 0;
        while (i < allMethods.length) {
            if (!allMethods[i].isConstructor()) {
                v.add(allMethods[i]);
            }
            ++i;
        }
        Object[] cons = new IMethod[v.size()];
        v.copyInto(cons);
        return cons;
    }

    public String getPackage() {
        return this.pack;
    }

    public long getSortOrder() {
        return this.fSortOrder;
    }

    public String[] getSuperInterfaces() {
        return this.fSuperInterfaces;
    }

    public String getSuperclass() {
        return this.fSuperClass;
    }

    public IType getType(String name) {
        return (IType)this.fTypes.get(name);
    }

    public IType[] getTypes() {
        IType[] types = new IType[this.fTypes.size()];
        Enumeration values = this.fTypes.elements();
        int count = 0;
        while (values.hasMoreElements()) {
            types[count++] = (IType)values.nextElement();
        }
        return types;
    }

    public String print(int indentation) {
        return new TypePrinter(this, indentation).getContents();
    }

    public void setNLS(boolean NLS) {
        this.fNLS = NLS;
    }

    public void setSortOrder(long sortOrder) {
        this.fSortOrder = sortOrder;
    }

    public void setSuperClass(String superClass) {
        this.fSuperClass = superClass;
    }

    public void setSuperInterfaces(String[] interfaces) {
        this.fSuperInterfaces = interfaces;
    }
}

