/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.internal.print.ant;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.internal.print.ant.AntPrinter;
import org.eclipse.soda.devicekit.generator.internal.print.ant.AntPropertyPrinter;
import org.eclipse.soda.devicekit.generator.model.ant.IAntElement;
import org.eclipse.soda.devicekit.generator.model.ant.IAntProperty;
import org.eclipse.soda.devicekit.generator.model.ant.IAntTask;

public class AntTaskPrinter
extends AntPrinter {
    private IAntTask task;

    public AntTaskPrinter(int indentation, IAntTask task) {
        super(indentation);
        this.task = task;
        this.print();
    }

    protected IAntTask getTask() {
        return this.task;
    }

    protected void print() {
        this.printIndentation();
        this.startTag(this.getTask().getName());
        String[] attNames = this.getTask().getAttributeNames();
        int i = 0;
        while (i < attNames.length) {
            String value = this.getTask().getAttribute(attNames[i]);
            this.printAttribute(attNames[i], value);
            ++i;
        }
        if (this.getTask().getElements().size() == 0) {
            this.endEmpyTag();
        } else {
            this.endTag();
            this.incrementIndent();
            Vector elements = this.getTask().getElements();
            int i2 = 0;
            while (i2 < elements.size()) {
                IAntElement element = (IAntElement)elements.elementAt(i2);
                switch (element.getElementType()) {
                    case 0: {
                        this.printProperty((IAntProperty)element);
                        break;
                    }
                    case 1: {
                        this.printTask((IAntTask)element);
                    }
                }
                ++i2;
            }
            this.decrementIndent();
            this.printIndentation();
            this.endTag(this.getTask().getName(), true);
        }
    }

    protected void printProperty(IAntProperty property) {
        AntPropertyPrinter printer = new AntPropertyPrinter(this.getCurrentIndentenation(), false, property);
        this.print(printer.getContents());
    }

    protected void printTask(IAntTask task) {
        AntTaskPrinter printer = new AntTaskPrinter(this.getCurrentIndentenation(), task);
        this.print(printer.getContents());
    }
}

