/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.manifest;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.soda.devicekit.generator.manifest.ManifestModel;
import org.eclipse.soda.devicekit.generator.model.IGeneratorModel;
import org.eclipse.soda.devicekit.generator.save.IFileSaver;

public class EclipseManifestSaver
implements IFileSaver {
    private IFile manifestFile;

    public EclipseManifestSaver(IFile manfiestFile) {
        this.manifestFile = manfiestFile;
    }

    protected void createOtherOsgiFiles(IContainer parent) throws Exception {
        IFile iveRes;
        IFile attrs;
        if (this.generateAttrs() && (attrs = parent.getFile((IPath)new Path("IVEATTRS.XML"))) != null && !attrs.exists()) {
            attrs.create((InputStream)new ByteArrayInputStream(this.getDefaultAttrs().getBytes()), true, null);
        }
        if (this.generateRes() && (iveRes = parent.getFile((IPath)new Path("IVERES.XML"))) != null && !iveRes.exists()) {
            iveRes.create((InputStream)new ByteArrayInputStream(this.getDefaultRes().getBytes()), true, null);
        }
    }

    protected boolean generateAttrs() {
        return false;
    }

    protected boolean generateRes() {
        return false;
    }

    private String getDefaultAttrs() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
        buffer.append("<IVEAttrs>\n");
        buffer.append("\t<Processor/>\n");
        buffer.append("\t<Endian/>\n");
        buffer.append("\t<AddressLength/>\n");
        buffer.append("\t<OS/>\n");
        buffer.append("\t<OSVersion/>\n");
        buffer.append("\t<VM>J9</VM>\n");
        buffer.append("\t<ImplType>JCL_GatewayPlus_1_3</ImplType>\n");
        buffer.append("\t<Language/>\n");
        buffer.append("\t<Country/>\n");
        buffer.append("\t<Replaces/>\n");
        buffer.append("</IVEAttrs>\n");
        return buffer.toString();
    }

    private String getDefaultRes() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<?xml version=\"1.0\" standalone=\"yes\"?>\n");
        buffer.append("<IVERes/>\n");
        return buffer.toString();
    }

    protected boolean isEqualString(String s1, String s2) {
        if (s1 == null || s2 == null || s1.length() != s2.length()) {
            return false;
        }
        int i = 0;
        while (i < s1.length()) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 != (c2 = s2.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object organize(IGeneratorModel object) throws Exception {
        return null;
    }

    public Object save(IGeneratorModel object) throws Exception {
        if (object instanceof ManifestModel) {
            return this.save((ManifestModel)object);
        }
        return null;
    }

    protected Object save(ManifestModel model) throws Exception {
        String contents = model.getContents();
        ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes());
        if (this.manifestFile != null && !this.manifestFile.exists()) {
            this.manifestFile.create((InputStream)stream, true, null);
            this.createOtherOsgiFiles(this.manifestFile.getParent());
        }
        stream.close();
        return this.manifestFile;
    }
}

