/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.manifest;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.soda.devicekit.generator.manifest.ManifestModel;
import org.eclipse.soda.devicekit.generator.print.Printer;

public class ManifestPrinter
extends Printer
implements Comparator {
    private ManifestModel fModel;

    public ManifestPrinter(ManifestModel model) {
        this.fModel = model;
        this.printManifest();
    }

    public int compare(Object o1, Object o2) {
        String s1 = String.valueOf(o1);
        String s2 = String.valueOf(o2);
        int index = s1.indexOf(59);
        if (index > 0) {
            s1 = s1.substring(0, index);
        }
        if ((index = s2.indexOf(59)) > 0) {
            s2 = s2.substring(0, index);
        }
        return s1.compareTo(s2);
    }

    protected ManifestModel getModel() {
        return this.fModel;
    }

    public void printKeyValuePair(String key, String[] value) {
        if (value != null && value.length > 0 && value[0].trim().length() > 0) {
            Arrays.sort(value, this);
            this.print(key);
            this.print(':');
            int startLenth = key.length() + 1;
            int i = 0;
            while (i < value.length) {
                if (i != 0) {
                    this.println(',');
                }
                this.print(' ');
                String valueLine = value[i];
                int length = valueLine.length();
                if (startLenth + length < 70) {
                    this.print(valueLine);
                } else {
                    int index;
                    if (startLenth != 1) {
                        this.println();
                        this.print(' ');
                    }
                    if ((index = valueLine.indexOf(59)) < 0) {
                        this.printValue(valueLine);
                    } else {
                        this.printValue(valueLine.substring(0, index + 1));
                        this.println();
                        this.print(' ');
                        this.printValue(valueLine.substring(index + 1));
                    }
                }
                startLenth = 1;
                ++i;
            }
            this.println();
        }
    }

    private void printKeys() {
        String[] keys = this.fModel.getKeysArray();
        int i = 0;
        while (i < keys.length) {
            String key = keys[i];
            if (!"Export-Service".equals(key) && !"Import-Service".equals(key)) {
                if ("Bundle-Category".equals(key) || "Bundle-Copyright".equals(key) || "Bundle-Description".equals(key) || "Bundle-Name".equals(key) || "Bundle-Vendor".equals(key)) {
                    String pvalue = "%" + key.toLowerCase().replace('-', '.');
                    this.printKeyValuePair(key, new String[]{pvalue});
                } else {
                    String[] value = this.fModel.getKeyValue(key);
                    this.printKeyValuePair(key, value);
                }
            }
            ++i;
        }
    }

    protected void printManifest() {
        this.println("Manifest-Version: 1.0");
        this.printKeys();
    }

    public void printValue(String value) {
        if (value.length() < 70) {
            this.print(value);
        } else {
            int index = value.lastIndexOf(46);
            if (index < 0) {
                this.print(value);
            } else {
                this.print(value.substring(0, index + 1));
                this.println();
                this.print(' ');
                this.print(value.substring(index + 1));
            }
        }
    }
}

