/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.manifest;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.pde.internal.ui.wizards.tools.OrganizeManifestsOperation;
import org.eclipse.soda.devicekit.generator.constants.ManifestConstants;
import org.eclipse.soda.devicekit.generator.manifest.EclipseManifestSaver;
import org.eclipse.soda.devicekit.generator.manifest.ManifestModel;
import org.eclipse.soda.devicekit.generator.model.IGeneratorModel;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.util.JREPreferenceUtil;
import org.eclipse.swt.widgets.Display;

public class SourceFolderManifestSaver
extends EclipseManifestSaver {
    private IJavaProject project;
    private boolean create;
    private Hashtable extraFiles;

    public SourceFolderManifestSaver(IJavaProject project, String sourceFolderName, boolean create, Hashtable extraManifestFiles) {
        super(null);
        this.project = project;
        this.create = true;
        this.extraFiles = extraManifestFiles;
    }

    static IDialogSettings getSettings() {
        DialogSettings settings = new DialogSettings("");
        settings.put("OrganizeManifests.ExportedPackages.addMissing", false);
        settings.put("OrganizeManifests.ExportedPackages.makeInternal", true);
        settings.put("OrganizeManifests.ExportedPackages.removeUnresolved", true);
        settings.put("OrganizeManifests.AddDependencies", true);
        settings.put("OrganizeManifests.RequireImport.modifyDep", true);
        settings.put("OrganizeManifests.RequireImport.resolve:markOptional", true);
        settings.put("OrganizeManifests.RequireImport.findRemoveUnused", false);
        settings.put("OrganizeManifests.General.cleanup", true);
        return settings;
    }

    protected boolean contentsChanged(String oldStream, String newStream) throws IOException {
        boolean result = !this.isEqualString(oldStream, newStream);
        return result;
    }

    protected void createOtherOsgiFiles(IContainer parent) throws Exception {
        super.createOtherOsgiFiles(parent);
        if (this.extraFiles != null) {
            Enumeration keys = this.extraFiles.keys();
            while (keys.hasMoreElements()) {
                IFile file;
                String fileName = (String)keys.nextElement();
                int index = fileName.indexOf(47);
                if (index >= 0) {
                    this.saveAllDirectory(fileName, parent.getProject());
                    file = parent.getProject().getFile((IPath)new Path(fileName));
                } else {
                    file = parent.getFile((IPath)new Path(fileName));
                }
                String newString = (String)this.extraFiles.get(fileName);
                if (newString != null && newString.length() > 0) {
                    if (!file.exists() && this.create) {
                        ByteArrayInputStream stream = new ByteArrayInputStream(newString.getBytes());
                        file.create((InputStream)stream, true, null);
                    } else {
                        String oldString = DeviceKitUtilities.getStringFromStream(file.getContents());
                        if (this.create && this.contentsChanged(oldString, newString)) {
                            ByteArrayInputStream stream = new ByteArrayInputStream(newString.getBytes());
                            file.setContents((InputStream)stream, true, true, null);
                        }
                    }
                }
                this.extraFiles.remove(fileName);
            }
            this.extraFiles = null;
        }
    }

    protected IJavaProject getProject() {
        return this.project;
    }

    protected Map getTemplateVariables(ManifestModel model) {
        HashMap<String, String> map = new HashMap<String, String>(101);
        String year = String.valueOf(Calendar.getInstance().get(1));
        String vendor = model.getVendor();
        map.put("vendor", vendor);
        String vendors = model.getVendors();
        map.put("vendors", vendors);
        map.put("year", year);
        map.put("years", year);
        map.put("provider", vendor);
        map.put("packagebase", "packagebase");
        String version = model.getVersion();
        map.put("version", version);
        return map;
    }

    private boolean isIgnoredKey(Attributes.Name key) {
        int i = 0;
        while (i < ManifestConstants.IGNORED_KEYS.length) {
            if (ManifestConstants.IGNORED_KEYS[i].equals(key.toString())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean manifestChanged(IFile eclipseManifest, ManifestModel manifestModel) throws CoreException, IOException {
        boolean bl;
        block2: {
            InputStream currentStream = null;
            try {
                currentStream = eclipseManifest.getContents();
                Manifest currentManifest = new Manifest(currentStream);
                Manifest newManifest = manifestModel.getManifest();
                bl = this.manifestChanged(currentManifest, newManifest);
                Object var6_7 = null;
                if (currentStream == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var6_8 = null;
                    if (currentStream == null) break block3;
                    currentStream.close();
                    currentStream = null;
                }
                throw throwable;
            }
            currentStream.close();
            currentStream = null;
        }
        return bl;
    }

    private boolean manifestChanged(Manifest currentManifest, Manifest newManifest) {
        Attributes newAttributes = newManifest.getMainAttributes();
        Attributes currAttributes = currentManifest.getMainAttributes();
        Iterator<Object> newKeys = newAttributes.keySet().iterator();
        while (newKeys.hasNext()) {
            int newNumber;
            Attributes.Name key = (Attributes.Name)newKeys.next();
            if (this.isIgnoredKey(key)) continue;
            String newValue = newAttributes.getValue(key);
            String currValue = currAttributes.getValue(key);
            if (newValue == null) {
                newValue = "";
            }
            if (currValue == null) {
                currValue = "";
            }
            StringTokenizer currSt = new StringTokenizer(currValue, ",");
            StringTokenizer newSt = new StringTokenizer(newValue, ",");
            int currNumber = currSt.countTokens();
            if (currNumber != (newNumber = newSt.countTokens())) {
                return true;
            }
            String[] currArray = new String[currNumber];
            int i = 0;
            while (currSt.hasMoreTokens()) {
                currArray[i++] = currSt.nextToken();
            }
            String[] newArray = new String[newNumber];
            i = 0;
            while (newSt.hasMoreTokens()) {
                newArray[i++] = newSt.nextToken();
            }
            boolean found = false;
            int j = 0;
            while (j < newArray.length) {
                int k = 0;
                while (k < currArray.length) {
                    if (newArray[j].equals(currArray[k])) {
                        found = true;
                        break;
                    }
                    ++k;
                }
                if (!found) {
                    return true;
                }
                ++j;
            }
        }
        return false;
    }

    public Object organize(IGeneratorModel object) throws Exception {
        IJavaProject jProject = this.getProject();
        IProject root = jProject.getProject();
        final IFolder metaInf = root.getFolder("META-INF");
        Display display = Display.getDefault();
        if (display != null) {
            display.syncExec(new Runnable(){

                public void run() {
                    ArrayList<IProject> projects = new ArrayList<IProject>();
                    projects.add(metaInf.getProject());
                    OrganizeManifestsOperation op = new OrganizeManifestsOperation(projects);
                    op.setOperations(SourceFolderManifestSaver.getSettings());
                    try {
                        op.run((IProgressMonitor)new NullProgressMonitor());
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            });
        }
        return null;
    }

    public Object save(Object object) throws Exception {
        if (object instanceof ManifestModel) {
            return this.save((ManifestModel)object);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Object save(ManifestModel model) throws Exception {
        IFile manifest;
        block15: {
            IFile oldMetadataProperties;
            IJavaProject jProject = this.getProject();
            IProject root = jProject.getProject();
            IFolder metaInf = root.getFolder("META-INF");
            if (!metaInf.exists()) {
                metaInf.create(true, true, null);
            }
            if (!metaInf.exists()) {
                return null;
            }
            IFile oldMetadata = metaInf.getFile("METADATA.XML");
            if (oldMetadata.exists()) {
                oldMetadata.delete(true, null);
            }
            if ((oldMetadataProperties = metaInf.getFile("METADATA_en.properties")).exists()) {
                oldMetadataProperties.delete(true, null);
            }
            manifest = metaInf.getFile("MANIFEST.MF");
            InputStream stream = null;
            try {
                if (!manifest.exists()) {
                    if (model.getRequiredExecutionEnvironments() == null) {
                        JREPreferenceUtil.processExecutionEnvironmentsInManifest(jProject, model);
                    }
                    stream = new ByteArrayInputStream(model.getContents().getBytes());
                    manifest.create(stream, false, null);
                } else {
                    String existingEE = new Manifest(manifest.getContents()).getMainAttributes().getValue("Bundle-RequiredExecutionEnvironment");
                    if (existingEE == null) {
                        JREPreferenceUtil.processExecutionEnvironmentsInManifest(jProject, model);
                    } else if (model.getRequiredExecutionEnvironments() == null) {
                        model.setBundleRequiredExecutionEnvironments(existingEE);
                    }
                    if (this.manifestChanged(manifest, model)) {
                        stream = new ByteArrayInputStream(model.getContents().getBytes());
                        manifest.setContents(stream, true, true, null);
                    }
                }
                Object var10_12 = null;
                if (stream == null) break block15;
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (stream != null) {
                    stream.close();
                }
                throw throwable;
            }
            stream.close();
        }
        this.createOtherOsgiFiles(manifest.getParent());
        return manifest;
    }

    public void saveAllDirectory(String name, IProject project) {
        try {
            IFolder directory = null;
            StringTokenizer tokenizer = new StringTokenizer(name, "/");
            int count = tokenizer.countTokens();
            int i = 0;
            while (i < count - 1) {
                String token = tokenizer.nextToken();
                IFolder folder = null;
                if (i == 0) {
                    folder = project.getFolder(token);
                } else if (directory != null) {
                    folder = directory.getFolder(token);
                }
                if (folder != null && !folder.exists()) {
                    folder.create(true, true, null);
                }
                directory = folder;
                ++i;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

