/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.messageanalyzer;

import org.eclipse.soda.devicekit.generator.model.elements.ControlItem;

public class ControlMessage {
    private byte[] commonLengthBytes;
    private byte[] bytes;
    private int[] bits;
    private double percentage;
    private ControlItem ci;

    public ControlMessage(ControlItem ci, byte[] bytes) {
        this.ci = ci;
        this.bytes = bytes;
    }

    public int[] getBits() {
        return this.bits;
    }

    public int getByteLength() {
        return this.bytes.length;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public byte[] getCommonLengthBytes() {
        return this.commonLengthBytes;
    }

    public String getControlId() {
        String id = this.ci.getId();
        if (id == null) {
            id = this.ci.getAttribute("idref");
        }
        return id;
    }

    public String getControlType() {
        return this.ci.getName();
    }

    public double getLengthPercentage() {
        return this.percentage;
    }

    public void setBit(int bitPosition, int status) {
        this.bits[bitPosition] = status;
    }

    public void setCommonLengthBytes(byte[] bytes) {
        this.commonLengthBytes = bytes;
        this.bits = new int[this.commonLengthBytes.length * 8];
    }

    public void setLengthPercentage(double percentage) {
        this.percentage = percentage;
    }
}

