/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.metadata;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.soda.devicekit.generator.GeneratorPlugin;
import org.eclipse.soda.devicekit.generator.constants.ManifestConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.FieldInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.metadata.model.MethodInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.TypeInformation;
import org.eclipse.soda.devicekit.generator.model.java.IMethod;
import org.eclipse.soda.devicekit.generator.model.java.IParameter;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class MetaDataUtility {
    public static final String createMethodKey(Object method) throws JavaModelException {
        if (method instanceof org.eclipse.jdt.core.IMethod) {
            return MetaDataUtility.createMethodKeyFromEclipseMethod((org.eclipse.jdt.core.IMethod)method);
        }
        if (method instanceof IMethod) {
            return MetaDataUtility.createMethodKeyFromGenMethod((IMethod)method);
        }
        throw new JavaModelException((Throwable)new IllegalArgumentException(), 0);
    }

    public static final String createFieldKey(Object field) throws JavaModelException {
        if (field instanceof IField) {
            return MetaDataUtility.createFieldKeyFromEclipseField((IField)field);
        }
        if (field instanceof org.eclipse.soda.devicekit.generator.model.java.IField) {
            return MetaDataUtility.createFieldKeyFromGenField((org.eclipse.soda.devicekit.generator.model.java.IField)field);
        }
        throw new JavaModelException((Throwable)new IllegalArgumentException(), 0);
    }

    public static final String createFieldKeyFromGenField(org.eclipse.soda.devicekit.generator.model.java.IField field) {
        StringBuffer fieldBuffer = new StringBuffer(32);
        String type = field.getType();
        type = Signature.createTypeSignature((String)type, (boolean)false);
        fieldBuffer.append(type);
        fieldBuffer.append(' ');
        fieldBuffer.append(field.getName());
        return fieldBuffer.toString();
    }

    public static final String createFieldKeyFromEclipseField(IField field) throws JavaModelException {
        StringBuffer fieldBuffer = new StringBuffer(32);
        fieldBuffer.append(field.getTypeSignature());
        fieldBuffer.append(' ');
        fieldBuffer.append(field.getElementName());
        return fieldBuffer.toString();
    }

    public static final String createMethodKeyFromRawData(String name, String returnType, IParameter[] params, String[] exceptions) {
        int j;
        StringBuffer methodBuffer = new StringBuffer(64);
        String fReturnType = returnType == null ? "V" : Signature.createTypeSignature((String)returnType, (boolean)false);
        methodBuffer.append(fReturnType);
        methodBuffer.append(' ');
        methodBuffer.append(name);
        methodBuffer.append(' ');
        methodBuffer.append('(');
        if (params != null) {
            j = 0;
            while (j < params.length) {
                if (j > 0) {
                    methodBuffer.append(' ');
                }
                String parameterType = Signature.createTypeSignature((String)params[j].getType(), (boolean)false);
                methodBuffer.append(parameterType);
                ++j;
            }
        }
        methodBuffer.append(')');
        if (exceptions != null) {
            j = 0;
            while (j < exceptions.length) {
                if (j > 0) {
                    methodBuffer.append(',');
                }
                methodBuffer.append(Signature.createTypeSignature((String)exceptions[j], (boolean)false));
                ++j;
            }
        }
        return methodBuffer.toString();
    }

    public static final String createMethodKeyFromGenMethod(IMethod method) {
        StringBuffer methodBuffer = new StringBuffer(64);
        String returnType = method.getReturnType();
        returnType = returnType == null ? "V" : Signature.createTypeSignature((String)method.getReturnType(), (boolean)false);
        methodBuffer.append(returnType);
        methodBuffer.append(' ');
        methodBuffer.append(method.getName());
        methodBuffer.append(' ');
        methodBuffer.append('(');
        IParameter[] params = method.getParameters();
        int j = 0;
        while (j < params.length) {
            if (j > 0) {
                methodBuffer.append(' ');
            }
            String parameterType = Signature.createTypeSignature((String)params[j].getType(), (boolean)false);
            methodBuffer.append(parameterType);
            ++j;
        }
        methodBuffer.append(')');
        String[] exceptions = method.getThrownExceptions();
        int j2 = 0;
        while (j2 < exceptions.length) {
            if (j2 > 0) {
                methodBuffer.append(',');
            }
            methodBuffer.append(Signature.createTypeSignature((String)exceptions[j2], (boolean)false));
            ++j2;
        }
        return methodBuffer.toString();
    }

    public static final String createMethodKeyFromEclipseMethod(org.eclipse.jdt.core.IMethod method) throws JavaModelException {
        StringBuffer methodBuffer = new StringBuffer(64);
        methodBuffer.append(method.getReturnType());
        methodBuffer.append(' ');
        methodBuffer.append(method.getElementName());
        methodBuffer.append(' ');
        methodBuffer.append('(');
        String[] params = method.getParameterTypes();
        int j = 0;
        while (j < params.length) {
            if (j > 0) {
                methodBuffer.append(' ');
            }
            methodBuffer.append(params[j]);
            ++j;
        }
        methodBuffer.append(')');
        String[] exceptions = method.getExceptionTypes();
        int j2 = 0;
        while (j2 < exceptions.length) {
            if (j2 > 0) {
                methodBuffer.append(',');
            }
            methodBuffer.append(exceptions[j2]);
            ++j2;
        }
        return methodBuffer.toString();
    }

    public static final MethodInformation[] getCustomMethods(GeneratedInfo info, String packageName, String typeName, MethodInformation[] methods) {
        TypeInformation typeInfo = info.getTypeInformation(packageName, typeName);
        if (typeInfo == null) {
            return null;
        }
        return MetaDataUtility.getCustomMethods(typeInfo, methods);
    }

    public static final MethodInformation[] getCustomMethods(TypeInformation info, MethodInformation[] allMethods) {
        ArrayList<MethodInformation> result = new ArrayList<MethodInformation>();
        int i = 0;
        while (i < allMethods.length) {
            MethodInformation store = allMethods[i];
            String methodKey = store.getKey();
            if (info.getMethod(methodKey) == null) {
                result.add(store);
            }
            ++i;
        }
        MethodInformation[] resultArray = new MethodInformation[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public static final FieldInformation[] getCustomFields(TypeInformation info, FieldInformation[] allFields) {
        ArrayList<FieldInformation> result = new ArrayList<FieldInformation>();
        int i = 0;
        while (i < allFields.length) {
            FieldInformation store = allFields[i];
            String fieldKey = store.getKey();
            if (info.getField(fieldKey) == null) {
                result.add(store);
            }
            ++i;
        }
        FieldInformation[] resultArray = new FieldInformation[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public static final FieldInformation[] getAllFields(IType type) {
        try {
            IField[] fields = type.getFields();
            FieldInformation[] result = new FieldInformation[fields.length];
            int i = 0;
            while (i < result.length) {
                String fieldKey = MetaDataUtility.createFieldKeyFromEclipseField(fields[i]);
                String source = fields[i].getSource();
                result[i] = new FieldInformation(fieldKey, source, "1.0.0");
                ++i;
            }
            return result;
        }
        catch (JavaModelException javaModelException) {
            return new FieldInformation[0];
        }
    }

    public static final MethodInformation[] getAllMethods(IType type) {
        try {
            org.eclipse.jdt.core.IMethod[] methods = type.getMethods();
            MethodInformation[] result = new MethodInformation[methods.length];
            int i = 0;
            while (i < methods.length) {
                String methodKey = MetaDataUtility.createMethodKeyFromEclipseMethod(methods[i]);
                String source = methods[i].getSource();
                result[i] = new MethodInformation(methodKey, source, "1.0.0");
                ++i;
            }
            return result;
        }
        catch (JavaModelException javaModelException) {
            return new MethodInformation[0];
        }
    }

    public static final KeyValuePair[] getCustomManifestItems(Manifest manifest) {
        ArrayList<KeyValuePair> result = new ArrayList<KeyValuePair>();
        Attributes atts = manifest.getMainAttributes();
        Set<Object> keys = atts.keySet();
        Iterator<Object> iterator = keys.iterator();
        while (iterator.hasNext()) {
            Attributes.Name key = (Attributes.Name)iterator.next();
            boolean customKey = true;
            int i = 0;
            while (i < ManifestConstants.GENERATED_KEYS.length) {
                if (ManifestConstants.GENERATED_KEYS[i].equals(key.toString())) {
                    customKey = false;
                    break;
                }
                ++i;
            }
            if (customKey) {
                i = 0;
                while (i < ManifestConstants.IGNORED_KEYS.length) {
                    if (ManifestConstants.IGNORED_KEYS[i].equals(key.toString())) {
                        customKey = false;
                        break;
                    }
                    ++i;
                }
            }
            if (!customKey) continue;
            String value = atts.getValue(key);
            KeyValuePair pair = new KeyValuePair(key.toString(), value);
            result.add(pair);
        }
        KeyValuePair[] pairs = new KeyValuePair[result.size()];
        result.toArray(pairs);
        return pairs;
    }

    public static final String getDkVersion() {
        return GeneratorPlugin.getVersion();
    }
}

