/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.metadata.processing;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.soda.devicekit.generator.metadata.DeviceKitMetaDataException;
import org.eclipse.soda.devicekit.generator.metadata.model.FieldInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.metadata.model.MethodInformation;
import org.eclipse.soda.devicekit.generator.metadata.model.TypeInformation;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MetaDataXmlParser {
    private IFile metaDataFile;
    private GeneratedInfo info;

    public MetaDataXmlParser(IFile metaDataFile) {
        this.metaDataFile = metaDataFile;
        this.info = new GeneratedInfo();
    }

    private void buildGeneratedInfo(Node node) throws DeviceKitMetaDataException {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node childNode;
            String childNodeName;
            if (1 == children.item(i).getNodeType() && "type".equals(childNodeName = (childNode = children.item(i)).getNodeName())) {
                this.buildType(childNode);
            }
            ++i;
        }
    }

    private void buildType(Node node) throws DeviceKitMetaDataException {
        NamedNodeMap attributes = node.getAttributes();
        Node packageNode = attributes.getNamedItem("package");
        Node nameNode = attributes.getNamedItem("name");
        if (nameNode == null || packageNode == null) {
            throw new DeviceKitMetaDataException("You've got problems with your meta data");
        }
        Node dkmlVersionNode = attributes.getNamedItem("version");
        String dkmlVersion = null;
        if (dkmlVersionNode != null) {
            dkmlVersion = dkmlVersionNode.getNodeValue();
        }
        Node projectNode = attributes.getNamedItem("project-name");
        String projectName = null;
        if (projectNode != null) {
            projectName = projectNode.getNodeValue();
        }
        TypeInformation typeInfo = this.info.addTypeInformation(packageNode.getNodeValue(), nameNode.getNodeValue(), dkmlVersion, projectName);
        Node timeStampNode = attributes.getNamedItem("created");
        if (timeStampNode != null) {
            typeInfo.setTimeStamp(timeStampNode.getNodeValue());
        }
        this.buildTypeElements(node, typeInfo);
    }

    private void buildTypeElements(Node node, TypeInformation typeInfo) throws DeviceKitMetaDataException {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (1 == children.item(i).getNodeType()) {
                Node childNode = children.item(i);
                String childNodeName = childNode.getNodeName();
                if ("method".equals(childNodeName)) {
                    this.buildTypeMethod(childNode, typeInfo);
                } else if ("field".equals(childNodeName)) {
                    this.buildTypeField(childNode, typeInfo);
                }
            }
            ++i;
        }
    }

    private void buildTypeField(Node node, TypeInformation typeInfo) throws DeviceKitMetaDataException {
        Node dkVersionNode;
        NamedNodeMap attributes = node.getAttributes();
        Node keyNode = attributes.getNamedItem("key");
        if (keyNode == null) {
            throw new DeviceKitMetaDataException("You've got problems with your meta data");
        }
        Node dkmlVersionNode = attributes.getNamedItem("version");
        String dkmlVersion = null;
        if (dkmlVersionNode != null) {
            dkmlVersion = dkmlVersionNode.getNodeValue();
        }
        FieldInformation fieldInfo = typeInfo.addFieldInformation(keyNode.getNodeValue(), null, dkmlVersion);
        Node timeStampNode = attributes.getNamedItem("created");
        if (timeStampNode != null) {
            fieldInfo.setTimeStamp(timeStampNode.getNodeValue());
        }
        if ((dkVersionNode = attributes.getNamedItem("generator-version")) != null) {
            fieldInfo.setDkVersion(dkVersionNode.getNodeValue());
        }
    }

    private void buildTypeMethod(Node node, TypeInformation typeInfo) throws DeviceKitMetaDataException {
        Node dkVersionNode;
        NamedNodeMap attributes = node.getAttributes();
        Node keyNode = attributes.getNamedItem("key");
        if (keyNode == null) {
            throw new DeviceKitMetaDataException("You've got problems with your meta data");
        }
        Node dkmlVersionNode = attributes.getNamedItem("version");
        String dkmlVersion = null;
        if (dkmlVersionNode != null) {
            dkmlVersion = dkmlVersionNode.getNodeValue();
        }
        MethodInformation methodInfo = typeInfo.addMethodInformation(keyNode.getNodeValue(), null, dkmlVersion);
        Node timeStampNode = attributes.getNamedItem("created");
        if (timeStampNode != null) {
            methodInfo.setTimeStamp(timeStampNode.getNodeValue());
        }
        if ((dkVersionNode = attributes.getNamedItem("generator-version")) != null) {
            methodInfo.setDkVersion(dkVersionNode.getNodeValue());
        }
    }

    private void gatherInfo(Node node) throws DeviceKitMetaDataException {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node childNode = children.item(i);
            String childNodeName = childNode.getNodeName();
            if ("dk-meta".equals(childNodeName)) {
                this.buildGeneratedInfo(childNode);
                return;
            }
            ++i;
        }
        throw new DeviceKitMetaDataException("You've got problems in your xml meta data");
    }

    public GeneratedInfo getGeneratedInfo() throws CoreException, DeviceKitMetaDataException {
        Document node;
        if (this.metaDataFile == null) {
            throw new DeviceKitMetaDataException("you've got problems");
        }
        try {
            node = ParserUtilities.parse(this.metaDataFile.getContents());
        }
        catch (Exception e) {
            throw new DeviceKitMetaDataException(e.getMessage());
        }
        this.gatherInfo(node);
        return this.info;
    }
}

