/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.model.AbstractDkGenerator;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.FactoryMetaDataBuilder;
import org.eclipse.soda.devicekit.generator.model.elements.CommonConfigurationElement;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameter;
import org.eclipse.soda.devicekit.generator.model.elements.EnumElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;

public class DeviceFactoryMetaDataBuilder
extends FactoryMetaDataBuilder {
    protected Vector configurations;

    public DeviceFactoryMetaDataBuilder(AbstractDkGenerator generator, int pidType) {
        super(generator, pidType);
    }

    protected String getConfigurationProperty(CommonConfigurationElement element) {
        String description = element.getDescription();
        String name = element.getExternalId();
        String tname = this.validId(name);
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(tname);
        buffer.append('=');
        buffer.append(name.replace('/', ' '));
        buffer.append('\n');
        buffer.append(tname);
        buffer.append("_description=");
        if (description != null) {
            buffer.append(description);
        }
        buffer.append('\n');
        return buffer.toString();
    }

    protected String getPropertyCustom() throws Exception {
        StringBuffer buffer = new StringBuffer(32 * this.configurations.size());
        int i = 0;
        while (i < this.configurations.size()) {
            buffer.append(this.getConfigurationProperty((CommonConfigurationElement)this.configurations.get(i)));
            ++i;
        }
        Vector cps = this.getCustomParameters();
        int i2 = 0;
        while (i2 < cps.size()) {
            CustomParameter cp = (CustomParameter)cps.get(i2);
            buffer.append(this.getCustomParameterProperty(cp));
            ++i2;
        }
        return buffer.toString();
    }

    protected String getXmlConfigurationAttributeDefs(String type, String name, String defaultValue, String description, String cardinality, String size, String requiredValue, String min, String max, TagElement element) {
        Vector enums;
        String tname = this.validId(name);
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("\r\n\t\t<AD id=\"");
        buffer.append(tname);
        buffer.append("\"\r\n\t\t\ttype=\"");
        buffer.append(this.getValidMetaType(type));
        buffer.append("\"\r\n");
        if (defaultValue != null) {
            buffer.append(" default=\"");
            buffer.append(defaultValue);
            buffer.append("\"\r\n");
        } else if (cardinality == null) {
            buffer.append("\t\t\tdefault=\"\"\r\n");
        }
        buffer.append("\t\t\tname=\"%");
        buffer.append(tname);
        buffer.append("\"\r\n");
        buffer.append("\t\t\tdescription=\"%");
        buffer.append(String.valueOf(tname) + "_description");
        buffer.append("\"\r\n");
        if (cardinality != null) {
            buffer.append("\t\t\tcardinality=\"");
            if ("ARRAY".equals(cardinality)) {
                if (size != null) {
                    buffer.append(size);
                } else {
                    buffer.append(Integer.MAX_VALUE);
                }
            } else if (size != null) {
                buffer.append('-');
                buffer.append(size);
            } else {
                buffer.append(Integer.MIN_VALUE);
            }
            buffer.append("\"\r\n");
        } else {
            buffer.append("\t\t\tcardinality=\"0\"\r\n");
        }
        if (min == null || min.length() > 0) {
            buffer.append("\t\t\tmin=\"");
            buffer.append(min);
            buffer.append("\"\r\n");
        }
        if (max == null || max.length() > 0) {
            buffer.append("\t\t\tmax=\"");
            buffer.append(max);
            buffer.append("\"\r\n");
        }
        buffer.append("\t\t\trequired=\"");
        if (requiredValue == null || requiredValue.length() == 0) {
            buffer.append("false");
        } else {
            buffer.append(requiredValue);
        }
        buffer.append('\"');
        boolean done = true;
        if (element != null && (enums = element.getAllChildrenWithTagCode(77)) != null && enums.size() > 0) {
            int i = 0;
            while (i < enums.size()) {
                EnumElement enumElement = (EnumElement)enums.elementAt(i);
                String key = enumElement.getLabel();
                String value = enumElement.getValue();
                if (value == null) {
                    value = Integer.toString(i);
                }
                if (done) {
                    buffer.append(">\r\n");
                    done = false;
                }
                buffer.append("\t\t\t<Option value=\"");
                buffer.append(value);
                buffer.append("\" label=\"");
                buffer.append(key);
                buffer.append("\"/>\r\n");
                ++i;
            }
        }
        if (done) {
            buffer.append("/>\r\n");
        } else {
            buffer.append("\t\t</AD>\r\n");
        }
        return buffer.toString();
    }

    protected String getXmlConfigurationAttributeId(String name) {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("\t\t<ATTRIBUTE ID=\"");
        buffer.append(this.getValidMetaType(name));
        buffer.append("\" REQUIRED=\"no\"/>\n");
        return buffer.toString();
    }

    protected String getXmlCustomAttributeDefs() throws Exception {
        StringBuffer buffer = new StringBuffer(this.configurations.size() * 64);
        int i = 0;
        while (i < this.configurations.size()) {
            CommonConfigurationElement element = (CommonConfigurationElement)this.configurations.get(i);
            String name = element.getExternalId();
            String type = element.getType();
            String defaultValue = element.getDefaultValue();
            String description = element.getDescription();
            String cardinality = element.getCardinality();
            String size = element.getSize();
            String requiredValue = element.getRequired();
            String min = element.getMinimum();
            String max = element.getMaximum();
            buffer.append(this.getXmlConfigurationAttributeDefs(type, name, defaultValue, description, cardinality, size, requiredValue, min, max, element));
            ++i;
        }
        Vector cps = this.getCustomParameters();
        if (cps != null && cps.size() > 0) {
            buffer.append(this.getXmlCustomParameterAttributeDefs());
        }
        return buffer.toString();
    }

    protected String getXmlCustomAttributeIds() throws Exception {
        StringBuffer buffer = new StringBuffer(this.configurations.size() * 32);
        int i = 0;
        while (i < this.configurations.size()) {
            CommonConfigurationElement element = (CommonConfigurationElement)this.configurations.get(i);
            String name = element.getExternalId();
            buffer.append(this.getXmlConfigurationAttributeId(name));
            ++i;
        }
        return buffer.toString();
    }

    protected void init() {
        super.init();
        DkDeviceGenerator generator = (DkDeviceGenerator)this.getGenerator();
        MainTagElement element = generator.getDeviceElement();
        this.configurations = element.getConfigurations();
        this.setCustomParameters(element.getAllChildrenWithTagCode(46));
        Vector elements = element.getAllChildrenWithTagCodes(new int[]{86}, new int[]{85});
        Vector parents = element.getAllChildrenWithTagCodes(new int[]{86}, new int[]{83});
        if (parents != null) {
            int i = 0;
            while (i < parents.size()) {
                TagElement parent = (TagElement)parents.elementAt(i);
                Vector moreElements = parent.getAllChildrenWithTagCodes(new int[]{86}, new int[]{85});
                if (moreElements != null) {
                    elements.addAll(moreElements);
                }
                ++i;
            }
        }
        this.setProfiles(elements);
    }

    public String validId(String name) {
        int index = name.lastIndexOf(47);
        if (index < 0) {
            return name;
        }
        return name.substring(index + 1);
    }
}

