/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkAdapterGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkAdapterBundleGenerator
extends DkAdapterGenerator {
    public DkAdapterBundleGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Hashtable properties, int bundleType) {
        super(model, generatedInfo, properties, bundleType);
    }

    protected void codeBACreateService(IType ba) {
        KeyValuePair parameter;
        String[] comment;
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_ADAPTER_SERVICE);
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_ADAPTER_SERVICE);
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        this.getManifestModel().addImportPackage(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_ADAPTER_SERVICE));
        String contents = this.getBACreateServiceContents();
        if (this.targetDevice != null) {
            comment = new String[]{"Creates the adapter using the specified device service.", "", "@param deviceService The device service to used when creating the adatper service.", "@return Object The adapter service created by this bundle.", "@see " + this.getMainFqn()};
            parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE), "deviceService");
            this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        } else {
            comment = new String[]{"Creates the device using the specified bundleContext.", "", "@param bundleContext The osgi bundle context to used when creating the device service.", "@return Object The device service created by this bundle.", "@see " + this.getMainFqn()};
            parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE), "bundleContext");
            this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_BUNDLE_CONTEXT);
        }
        this.codeMethod(ba, "createService", comment, returnType, 1L, contents, new KeyValuePair[]{parameter}, null);
    }

    protected void codeBAGetInterestServiceName(IType ba) {
        String service;
        if (this.targetDevice != null && (service = this.targetDevice.getServiceName()) != null) {
            if (service.indexOf(46) == -1) {
                service = String.valueOf(DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase())) + '.' + service;
            }
            String[] comment = new String[]{"Return the device service name used by this bundle.", "", "@return String The interest service name.", "@see " + service};
            this.fBundleActivatorModel.addImport(service);
            String contents = this.getBAGetInterestServiceNameContents(service);
            this.codeMethod(ba, "getInterestServiceName", comment, "String", 1L, contents);
        }
    }

    public void generate() throws Exception {
        this.initialize();
        if (this.getManifestModel() != null) {
            this.getManifestModel().addImportPackage(this.getMainPackage());
            this.getBuildModel().addAdditionalBundles(this.getMainPackage());
        }
        if (!this.isAbstract() && this.doGenerateBundleActivator()) {
            this.generateBundleActivatorClass();
        }
        if (this.doGenerateService()) {
            this.generateManifest();
        }
        this.generateOtherFiles();
    }

    protected String getBACreateServiceContents() {
        StringBuffer buffer = new StringBuffer(32);
        String type = this.getDevice().getType();
        this.fBundleActivatorModel.addImport(type);
        buffer.append("final ");
        buffer.append(DeviceKitUtilities.stripPackage(type));
        buffer.append(" adapter = new ");
        buffer.append(DeviceKitUtilities.stripPackage(type));
        buffer.append("();\n");
        if (this.targetDevice != null) {
            buffer.append("adapter.setDevice(");
            buffer.append("deviceService");
            buffer.append(");\n");
        }
        buffer.append("return adapter;\n");
        return buffer.toString();
    }

    protected String getManifestBundleId() {
        return this.getSourceFolderName();
    }

    protected String getManifestBundleName() {
        return this.getBundleActivatorClass();
    }

    protected Vector getManifestExportPackages() {
        Vector<String> result = new Vector<String>();
        String bap = this.getBundleActivatorPackage();
        result.add(bap);
        return result;
    }

    protected Vector getManifestExportServices() {
        Vector vector = super.getManifestExportServices();
        vector.addElement(DeviceKitGenerationConstants.CLASS_ADAPTER_SERVICE);
        Vector list = this.getMainElement().getChildrenWithTagCode(30);
        int i = 0;
        while (i < list.size()) {
            String service = ((TagElement)list.elementAt(i)).getServiceNameFull();
            if (service != null && service.length() > 0) {
                if (service.indexOf(46) == -1) {
                    String pack = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                    service = String.valueOf(pack) + '.' + service;
                }
                vector.addElement(service);
            }
            ++i;
        }
        vector.addElement(this.getServiceFqn());
        return vector;
    }

    protected Vector getManifestImportPackages() {
        String serviceDevicePack;
        String corePack;
        String baseBundleActivatorPack;
        Vector result = super.getManifestImportPackages();
        switch (this.bundleType) {
            case 2: {
                String managedDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_ADAPTER_MANAGED_BA);
                if (result.contains(managedDevicePack)) break;
                result.add(managedDevicePack);
                break;
            }
            case 3: {
                String factoryDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_ADAPTER_MANAGED_FACTORY_BA);
                if (result.contains(factoryDevicePack)) break;
                result.add(factoryDevicePack);
            }
        }
        String connectionBundlePack = DeviceKitGenerationConstants.PACKAGE_CONNECTION_BUNDLE;
        if (!result.contains(connectionBundlePack)) {
            result.add(connectionBundlePack);
        }
        if (!result.contains(baseBundleActivatorPack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_SAT_BUNDLE_ACTIVATOR))) {
            result.add(baseBundleActivatorPack);
        }
        if (!result.contains(corePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_CORE_ESC_OBJECT))) {
            result.add(corePack);
        }
        if (!result.contains(serviceDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_OSGI_DEVICE))) {
            result.add(serviceDevicePack);
        }
        Vector importedServices = this.getImportedServices();
        int i = 0;
        while (i < importedServices.size()) {
            String serviceFqn = (String)importedServices.get(i);
            String servicePackage = DeviceKitUtilities.extractPackage(serviceFqn);
            result.add(servicePackage);
            ++i;
        }
        return result;
    }

    protected Vector getManifestImportServices() {
        String service;
        Vector vector = super.getManifestImportServices();
        if (this.targetDevice != null && (service = this.targetDevice.getServiceName()) != null) {
            if (service.indexOf(46) == -1) {
                String pack = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                service = String.valueOf(pack) + '.' + service;
            }
            vector.addElement(service);
        }
        vector.addElement(DeviceKitGenerationConstants.CLASS_NOTIFICATION_SERVICE);
        return vector;
    }

    public String getSourceFolderName() {
        String sfName = null;
        sfName = this.getBundleActivatorPackage();
        return sfName;
    }

    public Vector save() throws Exception {
        Vector<Object> result = new Vector<Object>();
        if (this.fBundleActivatorModel != null) {
            this.fBundleActivatorModel.setSaver(this.getSaver());
            this.fBundleActivatorModel.setSortOrder(3L);
            Object ba = this.fBundleActivatorModel.save();
            if (ba != null) {
                result.addElement(ba);
            }
        }
        this.saveCommon();
        return result;
    }
}

