/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.ConcreteElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class DkConcreteGenerator
extends DkDeviceGenerator {
    public DkConcreteGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        this(model, generatedInfo, new Hashtable(), 0);
    }

    public DkConcreteGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Hashtable properties, int bundleType) {
        super(model, generatedInfo, properties, bundleType);
    }

    protected ConcreteElement getConcreteElement() {
        Vector children = this.getRootElement().getChildren();
        int i = 0;
        while (i < children.size()) {
            if (18 == ((TagElement)children.elementAt(i)).getTagCode()) {
                return (ConcreteElement)children.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    protected void initialize() {
        Vector concretes = this.getRootElement().getAllChildrenWithTagCode(18);
        ConcreteElement ce = (ConcreteElement)concretes.elementAt(0);
        this.setDevice(ce);
        this.setTransport(ce.getTransportElement());
        this.setMainTagElement(ce);
        String className = DeviceKitUtilities.getClassNameFromTagElement(ce);
        this.setMainClassName(className);
        this.setPackageBase(ce.getPackageBase());
        this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
        if (ce.getAttribute("lazy") == null || "false".equals(ce.getAttribute("lazy"))) {
            this.setLazy(false);
        } else {
            this.setLazy(true);
        }
        if (ce.hasChildWithTagCode(45)) {
            this.setInitializeMeasurements(true);
        } else {
            this.setInitializeMeasurements(false);
        }
        String initWithMethod = ce.getAttribute("createmethod");
        if (initWithMethod != null && initWithMethod.trim().toLowerCase().equals("true")) {
            this.setInitializeWithMethod(true);
        } else {
            this.setInitializeWithMethod(false);
        }
        this.setupExportedPackages();
        this.initializeGet();
    }
}

