/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.ConnectionElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkConnectionGenerator
extends DkDeviceGenerator {
    protected int bundleType = 0;

    public DkConnectionGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Hashtable table, int bundleType) {
        super(model, generatedInfo, table, bundleType);
    }

    public DkConnectionGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    protected void codeBACreateService(IType ba) {
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        this.getManifestModel().addImportPackage(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE));
        String contents = this.getBACreateServiceContents();
        String[] comment = new String[]{"Creates the device using the specified bundleContext.", "", "@param bundleContext The osgi bundle context to used when creating the device service.", "@return Object The device service created by this bundle.", "@see " + this.getMainFqn()};
        KeyValuePair parameter = new KeyValuePair(DeviceKitUtilities.stripPackage("java.util.Dictionary"), "dictionary");
        this.fBundleActivatorModel.addImport("java.util.Dictionary");
        this.codeMethod(ba, "createService", comment, returnType, 1L, contents, new KeyValuePair[]{parameter}, null);
    }

    protected void codeCommandsSignalsMeasurementsFields(IType device) {
    }

    protected void codeConstructors(IType device) throws IOException {
    }

    protected void codeInitialize(IType device) {
    }

    protected void codeMethods(IType device) throws Exception {
    }

    protected void codeSetup(IType device) {
    }

    protected ConnectionElement findConnectionElement() {
        Vector children = this.getRootElement().getChildren();
        int i = 0;
        while (i < children.size()) {
            if (36 == ((TagElement)children.elementAt(i)).getTagCode()) {
                return (ConnectionElement)children.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    protected void generateEscProperties() {
    }

    protected String getBACreateServiceContents() {
        StringBuffer buffer = new StringBuffer(32);
        String type = this.getMainElement().getType();
        this.fBundleActivatorModel.addImport(type);
        buffer.append("final ");
        buffer.append(DeviceKitUtilities.stripPackage(type));
        buffer.append(" connection = new ");
        buffer.append(DeviceKitUtilities.stripPackage(type));
        buffer.append("(dictionary);\n");
        buffer.append("return connection;\n");
        return buffer.toString();
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_CONNECTION_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_CONNECTION_MANAGED_FACTORY_BA;
            }
        }
        return DeviceKitGenerationConstants.CLASS_CONNECTION_BA;
    }

    public int getBundleType() {
        return this.bundleType;
    }

    protected ConnectionElement getConnectionElement(TagElement parent) {
        Vector children = parent.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (36 == ((TagElement)children.elementAt(i)).getTagCode()) {
                return (ConnectionElement)children.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    protected Vector getImportedServices() {
        return new Vector();
    }

    protected String[] getManifestCategories() {
        return new String[]{"device"};
    }

    protected Vector getManifestExportPackages() {
        Vector vector = super.getManifestExportPackages();
        vector.addElement(DeviceKitUtilities.extractPackage(this.getMainElement().getType()));
        vector.addElement(this.getServicePackage());
        return vector;
    }

    public Hashtable getOtherManifestFiles() {
        return this.otherManifestFiles;
    }

    public String getServiceClassParent() {
        return DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE;
    }

    protected void initialize() {
        Vector connections = this.getRootElement().getAllChildrenWithTagCode(36);
        ConnectionElement connection = (ConnectionElement)connections.elementAt(0);
        this.setDevice(connection);
        this.setMainTagElement(connection);
        String className = DeviceKitUtilities.getClassNameFromTagElement(connection);
        this.setMainClassName(className);
        this.setPackageBase(connection.getPackageBase());
        this.setMainPackage(DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase()));
        this.setupExportedPackages();
        this.initializeGet();
    }

    public void setBundleType(int bundleType) {
        this.bundleType = bundleType;
    }

    public void setOtherManifestFiles(Hashtable otherManifestFiles) {
        this.otherManifestFiles = otherManifestFiles;
    }
}

