/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkTestCaseGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;

public class DkDeviceTestCaseGenerator
extends DkTestCaseGenerator {
    private String deviceClassName;

    public DkDeviceTestCaseGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkDeviceTestCaseGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Hashtable methodProperties) {
        super(model, generatedInfo, methodProperties);
    }

    private void codeCreateDevice(IType test) {
        String comment = this.getCreateDeviceComment();
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        this.getMainModel().addImport(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        String contents = this.getCreateDeviceContents();
        this.codeMethod(test, "createDevice", comment, returnType, 1L, contents);
        this.addAdditionalBundles(this.getDeviceClassPackage());
    }

    protected void codeMethods(IType test) {
        super.codeMethods(test);
        this.codeCreateDevice(test);
    }

    protected IType createTestType() throws Exception {
        IType test = super.createTestType();
        Vector devs = this.getTestElement().getAllChildrenWithTagCode(8);
        MainTagElement deviceElement = (MainTagElement)devs.elementAt(0);
        String deviceClassName = DeviceKitUtilities.getClassNameFromTagElement(deviceElement);
        this.setDeviceClassName(deviceClassName);
        this.getMainModel().addImport(this.getDeviceFqn());
        this.getMainModel().addImport(DeviceKitGenerationConstants.CLASS_DEVICE_TEST_CASE);
        return test;
    }

    protected String getBASuperClass() {
        return DeviceKitGenerationConstants.CLASS_DEVICE_TEST_CASE_BUNDLE_ACTIVATOR;
    }

    private String getCreateDeviceComment() {
        StringBuffer buffer = new StringBuffer(128);
        String deviceService = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE);
        buffer.append("Create device and return the ");
        buffer.append(deviceService);
        buffer.append(".\n");
        buffer.append("@return Results of the create device (<code>");
        buffer.append(deviceService);
        buffer.append("</code>) value.\n");
        return buffer.toString();
    }

    private String getCreateDeviceContents() {
        StringBuffer buffer = new StringBuffer(64);
        String deviceClassName = this.getDeviceClassName();
        buffer.append("return new ");
        buffer.append(deviceClassName);
        buffer.append("();\n");
        return buffer.toString();
    }

    protected String getDeviceClassName() {
        return this.deviceClassName;
    }

    protected String getDeviceClassPackage() {
        return DeviceKitUtilities.getPackageFromClassName(this.getDeviceClassName(), this.getPackageBase());
    }

    protected String getDeviceFqn() {
        return String.valueOf(this.getDeviceClassPackage()) + '.' + this.getDeviceClassName();
    }

    protected Vector getManifestImportPackages() {
        Vector<String> v = new Vector<String>();
        v.add(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE));
        v.add(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_DEVICE_TEST_CASE));
        v.add(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_DEVICE_TEST_CASE_BUNDLE_ACTIVATOR));
        v.add(this.getDeviceClassPackage());
        v.add(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_JUNIT_TESTRUNNER));
        v.add(DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_OSGI_BUNDLE_ACTIVATOR));
        return v;
    }

    protected String getSuperClass() {
        return DeviceKitGenerationConstants.CLASS_DEVICE_TEST_CASE;
    }

    protected String getTargetType() {
        return "device";
    }

    protected void setDeviceClassName(String deviceClassName) {
        this.deviceClassName = deviceClassName;
    }
}

