/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.Types;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.AbstractDkGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.FactoryMetaDataBuilder;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.model.java.JavaModelException;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public abstract class DkSwtGenerator
extends AbstractDkGenerator {
    protected JavaFileModel fTestModel;
    protected int bundleType = 0;

    protected DkSwtGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    protected DkSwtGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, Hashtable methodProperties) {
        super(model, generatedInfo, methodProperties);
    }

    protected void codeBundleActivatorConstructor(IType baType) {
        String name = this.getBundleActivatorClass();
        String comment = String.valueOf(name) + '.';
        String returnType = null;
        this.codeMethod(baType, name, comment, returnType, 1L, "super();\n");
    }

    protected void codeConstructors(IType test) {
        this.codeDefaultConstructor(test);
    }

    protected void codeDefaultConstructor(IType test) {
        String name = this.getMainClassName();
        String comment = String.valueOf(name) + '.';
        String returnType = null;
        this.codeMethod(test, name, comment, returnType, 1L, "super();\n");
    }

    protected void codeFields(IType test) {
    }

    protected void codeMain(IType test) {
        String targetClass = this.getTestElement().getTargetClass();
        if (targetClass.indexOf(46) == -1) {
            String tcPack = DeviceKitUtilities.getPackageFromClassName(targetClass, this.getPackageBase());
            targetClass = String.valueOf(tcPack) + '.' + targetClass;
        }
        String[] comment = new String[]{"Main method to run tests in a standalone mode.", "", "@param args", "@see " + targetClass};
        String contents = this.getMainContents();
        KeyValuePair parameter = new KeyValuePair("String[]", "args");
        this.codeMethod(test, "main", comment, "void", 17L, contents, new KeyValuePair[]{parameter}, null);
    }

    protected void codeMethods(IType test) {
        this.codeConstructors(test);
        this.codeMain(test);
    }

    protected void codeOneParamConstructor(IType test) {
        String name = this.getMainClassName();
        String comment = String.valueOf(name) + '.';
        String returnType = null;
        KeyValuePair pair = new KeyValuePair("String", "name");
        this.codeMethod(test, name, comment, returnType, 1L, "super(name);\n", new KeyValuePair[]{pair}, null);
    }

    protected void codeRun(IType test) {
        String comment = "Run tests for the " + this.getTargetType() + '.';
        String contents = this.getRunContents();
        this.codeMethod(test, "run", comment, "void", 1L, contents);
    }

    protected IType createBundleActivatorType() throws Exception {
        String baName = this.getBundleActivatorClass();
        String baPackage = this.getBundleActivatorPackage();
        this.fBundleActivatorModel = new JavaFileModel(baName);
        this.fBundleActivatorModel.setComment(this.getCopyright());
        this.fBundleActivatorModel.setPackage(baPackage);
        IType baType = this.createClass(this.fBundleActivatorModel, baPackage, baName, this.getSourceFolderName());
        baType.setSuperClass(DeviceKitUtilities.stripPackage(this.getBASuperClass()));
        this.fBundleActivatorModel.addImport(this.getBASuperClass());
        baType.setComment(this.getBundleActivatorComment());
        return baType;
    }

    protected IType createTestType() throws Exception {
        String testName = this.getMainClassName();
        String testPack = this.getMainPackage();
        this.fTestModel = new JavaFileModel(testName);
        this.fTestModel.setComment(this.getCopyright());
        this.fTestModel.setPackage(testPack);
        this.fTestModel.addImport(this.getServiceFqn());
        IType test = this.createClass(this.fTestModel, testPack, testName, this.getSourceFolderName());
        test.setComment(this.getMainClassComment());
        String superClass = this.getSuperClass();
        this.fTestModel.addImport(superClass);
        superClass = DeviceKitUtilities.stripPackage(superClass);
        test.setSuperClass(superClass);
        String[] interfaces = new String[]{this.getServiceClass()};
        test.setSuperInterfaces(interfaces);
        return test;
    }

    protected boolean doGenerateService() {
        return true;
    }

    protected void generateBundleActivatorClass() throws Exception {
    }

    protected void generateSpecificClass() throws JavaModelException {
        try {
            IType test = this.createTestType();
            this.codeFields(test);
            this.codeMethods(test);
            this.generateCustomMainItems();
        }
        catch (Exception e) {
            throw new JavaModelException(e.getMessage());
        }
    }

    protected String getBundleActivatorClass() {
        return String.valueOf(this.getMainClassName()) + "Bundle";
    }

    protected String getBundleActivatorFqn() {
        return "";
    }

    public int getBundleType() {
        return this.bundleType;
    }

    protected String getMainClassComment() {
        return "TEST CASE";
    }

    protected String getMainContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("final ");
        buffer.append(this.getMainClassName());
        buffer.append(" userInterfaceSwt = new ");
        buffer.append(this.getMainClassName());
        buffer.append("();\n");
        buffer.append("userInterfaceSwt.run(args);\n");
        return buffer.toString();
    }

    public JavaFileModel getMainModel() {
        return this.fTestModel;
    }

    protected String getManifestBundleId() {
        return this.getSourceFolderName();
    }

    protected String getManifestBundleName() {
        return this.getMainClassName();
    }

    protected String[] getManifestCategories() {
        return new String[0];
    }

    protected String getManifestDescription() {
        TagElement element = null;
        MainTagElement mainElement = this.getMainElement();
        String mainElementDescription = mainElement.getDescription();
        String mainElementId = mainElement.getId();
        Vector bundles = this.getMainElement().getAllChildrenWithTagCode(71);
        element = (TagElement)bundles.get(0);
        if (element != null && element.getDescription() != null) {
            return element.getDescription();
        }
        if (mainElementDescription != null) {
            return String.valueOf(mainElementDescription) + " Swt";
        }
        return String.valueOf(mainElementId) + " Swt";
    }

    protected String getMetaDataProperties() {
        FactoryMetaDataBuilder builder = new FactoryMetaDataBuilder(this, this.bundleType);
        return builder.getMetaDataPropertiesContents();
    }

    protected String getRunContents() {
        StringBuffer buffer = new StringBuffer(32);
        String runnerClass = Types.getString("TestRunner");
        this.fBundleActivatorModel.addImport(runnerClass);
        buffer.append(DeviceKitUtilities.stripPackage(runnerClass));
        buffer.append(".run(");
        buffer.append(this.getMainClassName());
        buffer.append(".class);\n");
        this.fBundleActivatorModel.addImport(this.getMainFqn());
        return buffer.toString();
    }

    protected abstract String getSuperClass();

    protected abstract String getTargetType();

    protected TestElement getTestElement() {
        Vector children = this.getRootElement().getChildren();
        int i = 0;
        while (i < children.size()) {
            if (10 == ((TagElement)children.elementAt(i)).getTagCode()) {
                return (TestElement)children.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    protected void initialize() {
        this.setMainTagElement(this.getTestElement());
        this.setPackageBase(this.getTestElement().getPackageBase());
        TestElement element = this.getTestElement();
        String testClassName = DeviceKitUtilities.getClassNameFromTagElement(element);
        String testCaseClassName = String.valueOf(testClassName.substring(0, testClassName.length() - 4)) + "Swt";
        this.setMainClassName(testCaseClassName);
        String pack = DeviceKitUtilities.getPackageFromClassName(testCaseClassName, this.getPackageBase());
        this.setMainPackage(pack);
        super.initialize();
    }

    protected Vector save() throws Exception {
        Vector<Object> result = new Vector<Object>();
        this.fTestModel.setSaver(this.getSaver());
        this.fTestModel.setSortOrder(3L);
        Object test = this.fTestModel.save();
        if (test != null) {
            result.addElement(test);
        }
        Vector supersResult = super.save();
        return DeviceKitUtilities.mergeVectors(result, supersResult);
    }

    public void setBundleType(int bundleType) {
        this.bundleType = bundleType;
    }
}

