/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkDeviceGenerator;
import org.eclipse.soda.devicekit.generator.model.TestFactoryMetaDataBuilder;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.model.java.JavaFileModel;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkTestBundleGenerator
extends DkDeviceGenerator {
    private TestElement fTest;
    private int testType;

    public DkTestBundleGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkTestBundleGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, int bundleType, int testType) {
        super(model, generatedInfo, new Hashtable(), bundleType);
        this.testType = testType;
    }

    protected void codeBACreateService(IType ba) {
        String serviceType = this.getMainElement().getServiceType();
        this.fBundleActivatorModel.addImport(serviceType);
        String returnType = this.fTest.getServiceType();
        String[] comment = new String[]{"Creates the test for the specified " + this.getTargetType() + '.', "", "@param " + this.getTargetType() + ' ' + DeviceKitUtilities.stripPackage(serviceType), "@return " + returnType + " The " + this.getTargetType() + " test.", "@see " + this.getMainFqn()};
        KeyValuePair parameter = new KeyValuePair(DeviceKitUtilities.stripPackage(serviceType), this.getTargetType());
        this.fBundleActivatorModel.addImport(returnType);
        String contents = this.getBACreateServiceContents();
        this.codeMethod(ba, "createService", comment, DeviceKitUtilities.stripPackage(returnType), 1L, contents, new KeyValuePair[]{parameter}, null);
        this.fBundleActivatorModel.addImport(this.getMainFqn());
    }

    protected void codeBAGetImportedServiceNames(IType ba) {
        this.codeBAGetImportedServiceNames(this.fTest.getBundleName(), ba);
    }

    protected void codeBAGetInterestServiceName(IType ba) {
        String[] comment = new String[]{"Gets the " + this.getTargetType() + " service name to be tested.", "", "@return String The interest service name.", "@see " + this.getModelServiceName()};
        String contents = this.getBAGetInterestServiceNameContents();
        this.codeMethod(ba, "getInterestServiceName", comment, "String", 1L, contents);
    }

    public void generate() throws Exception {
        this.initialize();
        if (this.getManifestModel() != null) {
            this.getManifestModel().addImportPackage(this.getMainPackage());
            this.getBuildModel().addAdditionalBundles(this.getMainPackage());
        }
        this.generateBundleActivatorClass();
        if (this.doGenerateService()) {
            this.generateManifest();
        }
        this.generateOtherFiles();
    }

    protected void generateOtherFiles() {
        switch (this.bundleType) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                String metaData = this.getMetaDataContents();
                if (metaData == null) break;
                this.otherManifestFiles.put("OSGI-INF/metatype/Metadata.xml", metaData);
            }
        }
        String property = this.getMetaDataProperties();
        if (property != null) {
            this.otherManifestFiles.put("OSGI-INF/l10n/bundle.properties", property);
            this.otherManifestFiles.put("OSGI-INF/l10n/bundle_en.properties", property);
        }
    }

    protected void generateSpecificClass() throws Exception {
    }

    protected String getBACreateServiceContents() {
        String serviceType = this.getMainElement().getServiceType();
        String serviceTypeSimple = DeviceKitUtilities.stripPackage(serviceType);
        String type = this.getTargetType();
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("final ");
        buffer.append(this.getMainClassName());
        buffer.append(" test = new ");
        buffer.append(this.getMainClassName());
        this.fBundleActivatorModel.addImport(this.getMainFqn());
        buffer.append("();\n");
        buffer.append("test.set");
        buffer.append(serviceTypeSimple.substring(0, serviceTypeSimple.length() - 7));
        buffer.append('(');
        buffer.append(type);
        buffer.append(");\n");
        buffer.append("return test;\n");
        return buffer.toString();
    }

    protected String getBAGetInterestServiceNameContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("return " + this.getModelServiceName() + ".SERVICE_NAME;\n");
        return buffer.toString();
    }

    protected String getBASuperClass() {
        switch (this.testType) {
            case 8: {
                switch (this.bundleType) {
                    case 2: {
                        return DeviceKitGenerationConstants.CLASS_DEVICE_TEST_MANAGED_BA;
                    }
                    case 3: {
                        return DeviceKitGenerationConstants.CLASS_DEVICE_TEST_MANAGED_FACTORY_BA;
                    }
                    case 1: {
                        return DeviceKitGenerationConstants.CLASS_DEVICE_TEST_BUNDLE_ACTIVATOR;
                    }
                }
                return "";
            }
            case 9: 
            case 97: {
                switch (this.bundleType) {
                    case 2: {
                        return DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_MANAGED_BA;
                    }
                    case 3: {
                        return DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_MANAGED_FACTORY_BA;
                    }
                    case 1: {
                        return DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_BUNDLE_ACTIVATOR;
                    }
                }
                return "";
            }
            case 72: {
                switch (this.bundleType) {
                    case 2: {
                        return DeviceKitGenerationConstants.CLASS_ADAPTER_TEST_MANAGED_BA;
                    }
                    case 3: {
                        return DeviceKitGenerationConstants.CLASS_ADAPTER_TEST_MANAGED_FACTORY_BA;
                    }
                    case 1: {
                        return DeviceKitGenerationConstants.CLASS_ADAPTER_TEST_BUNDLE_ACTIVATOR;
                    }
                }
                return "";
            }
            case 91: {
                switch (this.bundleType) {
                    case 2: {
                        return DeviceKitGenerationConstants.CLASS_AGENT_TEST_MANAGED_BA;
                    }
                    case 3: {
                        return DeviceKitGenerationConstants.CLASS_AGENT_TEST_MANAGED_FACTORY_BA;
                    }
                    case 1: {
                        return DeviceKitGenerationConstants.CLASS_AGENT_TEST_BUNDLE_ACTIVATOR;
                    }
                }
                return "";
            }
            case 74: {
                switch (this.bundleType) {
                    case 2: {
                        return DeviceKitGenerationConstants.CLASS_PROFILE_TEST_MANAGED_BA;
                    }
                    case 3: {
                        return DeviceKitGenerationConstants.CLASS_PROFILE_TEST_MANAGED_FACTORY_BA;
                    }
                    case 1: {
                        return DeviceKitGenerationConstants.CLASS_PROFILE_TEST_BUNDLE_ACTIVATOR;
                    }
                }
                return "";
            }
        }
        return "";
    }

    protected Vector getImportedServices() {
        return new Vector();
    }

    public JavaFileModel getMainModel() {
        return null;
    }

    protected String getManifestBundleId() {
        return this.getSourceFolderName();
    }

    protected String getManifestBundleName() {
        return this.getBundleActivatorClass();
    }

    protected String[] getManifestCategories() {
        return new String[]{"device"};
    }

    protected Vector getManifestExportPackages() {
        Vector<String> result = new Vector<String>();
        String bap = this.getBundleActivatorPackage();
        result.add(bap);
        return result;
    }

    protected Vector getManifestExportServices() {
        Vector vector = super.getManifestExportServices();
        Vector list = this.getMainElement().getAllChildrenWithTagCode(30);
        int i = 0;
        while (i < list.size()) {
            String service = ((TagElement)list.elementAt(i)).getServiceNameFull();
            if (service != null && service.length() > 0) {
                if (service.indexOf(46) == -1) {
                    String pack = DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase());
                    service = String.valueOf(pack) + '.' + service;
                }
                vector.addElement(service);
            }
            ++i;
        }
        vector.addElement(this.getServiceFqn());
        return vector;
    }

    protected Vector getManifestImportPackages() {
        String serviceDevicePack;
        String corePack;
        String baseBundleActivatorPack;
        Vector result = super.getManifestImportPackages();
        switch (this.bundleType) {
            case 2: {
                String managedDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_DEVICE_MANAGED_BA);
                if (result.contains(managedDevicePack)) break;
                result.add(managedDevicePack);
                break;
            }
            case 3: {
                String factoryDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_DEVICE_MANAGED_FACTORY_BA);
                if (result.contains(factoryDevicePack)) break;
                result.add(factoryDevicePack);
            }
        }
        String connectionBundlePack = DeviceKitGenerationConstants.PACKAGE_CONNECTION_BUNDLE;
        if (!result.contains(connectionBundlePack)) {
            result.add(connectionBundlePack);
        }
        if (!result.contains(baseBundleActivatorPack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_SAT_BUNDLE_ACTIVATOR))) {
            result.add(baseBundleActivatorPack);
        }
        if (!result.contains(corePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_CORE_ESC_OBJECT))) {
            result.add(corePack);
        }
        if (!result.contains(serviceDevicePack = DkUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_OSGI_DEVICE))) {
            result.add(serviceDevicePack);
        }
        Vector importedServices = this.getImportedServices();
        int i = 0;
        while (i < importedServices.size()) {
            String serviceFqn = (String)importedServices.get(i);
            String servicePackage = DeviceKitUtilities.extractPackage(serviceFqn);
            result.add(servicePackage);
            ++i;
        }
        return result;
    }

    protected Vector getManifestImportServices() {
        Vector vector = super.getManifestImportServices();
        vector.addElement(this.getModelServiceName());
        vector.addElement(DeviceKitGenerationConstants.CLASS_NOTIFICATION_SERVICE);
        return vector;
    }

    public Vector getManifestRequiredBundles() {
        Vector result = super.getManifestRequiredBundles();
        String targetId = this.getMainElement().getProjectId();
        boolean isConnection = targetId.endsWith(".connection");
        switch (this.bundleType) {
            case 1: {
                if (isConnection) break;
                result.add(String.valueOf(targetId) + ".bundle");
                break;
            }
            case 2: {
                result.add(String.valueOf(targetId) + ".managed");
                result.add("org.eclipse.equinox.metatype");
                result.add("org.eclipse.equinox.cm");
                break;
            }
            case 3: {
                result.add(String.valueOf(targetId) + ".factory");
                result.add("org.eclipse.equinox.metatype");
                result.add("org.eclipse.equinox.cm");
            }
        }
        Vector required = this.getMainElement().getRequiredBundles();
        String notificationString = DeviceKitUtilities.extractPackage(DeviceKitGenerationConstants.CLASS_NOTIFICATION);
        result.add(notificationString);
        result.add(String.valueOf(notificationString) + ".bundle");
        result.add("org.eclipse.equinox.event");
        int i = 0;
        while (i < required.size()) {
            TagElement element = (TagElement)required.elementAt(i);
            String bundleId = element.getProjectId();
            if (bundleId != null && bundleId.length() > 0) {
                String id = bundleId;
                result.add(id);
                isConnection = id.endsWith(".connection");
                switch (this.bundleType) {
                    case 1: {
                        if (isConnection) break;
                        result.add(String.valueOf(id) + ".bundle");
                        break;
                    }
                    case 2: {
                        result.add(String.valueOf(id) + ".managed");
                        break;
                    }
                    case 3: {
                        result.add(String.valueOf(id) + ".factory");
                    }
                }
            }
            ++i;
        }
        return result;
    }

    protected String getMetaDataContents() {
        TestFactoryMetaDataBuilder builder = new TestFactoryMetaDataBuilder(this, this.bundleType);
        return builder.getMetaDataXmlContents();
    }

    protected String getMetaDataProperties() {
        TestFactoryMetaDataBuilder builder = new TestFactoryMetaDataBuilder(this, this.bundleType);
        return builder.getMetaDataPropertiesContents();
    }

    protected String getModelServiceName() {
        Vector devices = this.fTest.getAllChildrenWithTagCode(this.testType);
        String service = null;
        TagElement device = (TagElement)devices.elementAt(0);
        service = device.getAttribute("service") != null ? device.getAttribute("service") : device.getImplementation();
        if (service != null) {
            if (!service.endsWith("Service")) {
                service = String.valueOf(service) + "Service";
            }
            if (service.indexOf(46) == -1) {
                service = String.valueOf(DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase())) + '.' + service;
            }
            return service;
        }
        return "";
    }

    public String getServiceClassParent() {
        switch (this.testType) {
            case 8: {
                return DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE;
            }
            case 18: {
                return DeviceKitGenerationConstants.CLASS_DEVICE_SERVICE;
            }
            case 9: 
            case 97: {
                return DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE;
            }
            case 72: {
                return DeviceKitGenerationConstants.CLASS_ADAPTER_SERVICE;
            }
            case 91: {
                return DeviceKitGenerationConstants.CLASS_AGENT_SERVICE;
            }
            case 74: {
                return DeviceKitGenerationConstants.CLASS_PROFILE_SERVICE;
            }
        }
        return super.getServiceClassParent();
    }

    public String getSourceFolderName() {
        String sfName = null;
        sfName = this.getBundleActivatorPackage();
        return sfName;
    }

    protected String getTargetType() {
        switch (this.testType) {
            case 9: {
                return "transport";
            }
            case 97: {
                return "transport";
            }
            case 8: {
                return "device";
            }
            case 72: {
                return "adapter";
            }
            case 91: {
                return "agent";
            }
            case 74: {
                return "profile";
            }
        }
        return "";
    }

    protected TestElement getTestElement() {
        Vector children = this.getRootElement().getChildren();
        int i = 0;
        while (i < children.size()) {
            if (10 == ((TagElement)children.elementAt(i)).getTagCode()) {
                return (TestElement)children.elementAt(i);
            }
            ++i;
        }
        return null;
    }

    protected void initialize() {
        this.fTest = this.getTestElement();
        String className = DeviceKitUtilities.getClassNameFromTagElement(this.fTest);
        this.setMainClassName(className);
        this.setPackageBase(this.fTest.getPackageBase());
        String pack = DeviceKitUtilities.getPackageFromClassName(className, this.getPackageBase());
        this.setMainPackage(pack);
        Vector devices = this.fTest.getAllChildrenWithTagCode(this.testType);
        if (devices.size() > 0) {
            MainTagElement target = (MainTagElement)devices.elementAt(0);
            this.setMainTagElement(target);
            this.setDevice(target);
        }
    }

    public Vector save() throws Exception {
        Vector<Object> result = new Vector<Object>();
        if (this.fBundleActivatorModel != null) {
            this.fBundleActivatorModel.setSaver(this.getSaver());
            this.fBundleActivatorModel.setSortOrder(3L);
            Object ba = this.fBundleActivatorModel.save();
            if (ba != null) {
                result.addElement(ba);
            }
        }
        this.saveCommon();
        return result;
    }
}

