/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.DkTestGenerator;
import org.eclipse.soda.devicekit.generator.model.EscPropertiesModel;
import org.eclipse.soda.devicekit.generator.model.NewCodeGenerator;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.SendElement;
import org.eclipse.soda.devicekit.generator.model.elements.SleepElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransportElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkTransportTestGenerator
extends DkTestGenerator {
    protected int bundleType = 0;

    public DkTransportTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    public DkTransportTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo, int bundleType) {
        super(model, generatedInfo);
        this.bundleType = bundleType;
    }

    protected void cleanup() {
        super.cleanup();
        Vector trans = this.getMainElement().getAllChildrenWithTagCodes(new int[]{9, 97});
        TransportElement tran = (TransportElement)trans.elementAt(0);
        String configKey = this.getConfigurationKey(tran);
        if (configKey != null) {
            Hashtable[] properties = tran.getTransportProperties();
            int i = 0;
            while (i < properties.length) {
                EscPropertiesModel model = EscPropertiesModel.getModel(this);
                Enumeration keys = properties[i].keys();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = (String)properties[i].get(key);
                    model.addProperty(String.valueOf(configKey) + '.' + key, value);
                }
                ++i;
            }
        }
    }

    protected void codeBACreateService(IType ba) {
        String[] comment = new String[]{"Creates the test for the specified " + this.getTargetType() + '.', "", "@param " + this.getTargetType(), "@return Object The transport test.", "@see " + this.getMainFqn()};
        KeyValuePair targetType = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE), this.getTargetType());
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        String contents = this.getBACreateServiceContents();
        this.codeMethod(ba, "createService", comment, "Object", 1L, contents, new KeyValuePair[]{targetType}, null);
    }

    protected void codeBADeactivate(IType ba) {
        String[] comment = new String[]{"Stop the test case and the bundle."};
        String contents = this.getBADeactivateContents();
        this.codeMethod(ba, "deactivate", comment, "void", 4L, contents);
    }

    private void codeBAExportedServiceNamesField(IType ba) {
        String bundle = this.fTest.getBundleName();
        StringBuffer fieldComment = new StringBuffer(64);
        fieldComment.append("Defines the service name(s) to be registered by the " + bundle + " bundle.\n");
        String[] services = this.fTest.getImplementedInterfaces();
        int indentation = 0;
        if (services.length > 0) {
            fieldComment.append(this.getHtmlHelper().startTable(0));
            ++indentation;
            int i = 0;
            while (i < services.length) {
                fieldComment.append(this.getHtmlHelper().getTableRow(indentation, services[i]));
                ++i;
            }
            fieldComment.append(this.getHtmlHelper().endTable(--indentation));
        }
        StringBuffer value = new StringBuffer(64);
        value.append("\n\t" + this.getServiceClass() + '.' + "SERVICE_NAME");
        this.fBundleActivatorModel.addImport(this.getServiceFqn());
        this.getManifestModel().addImportPackage(this.getServicePackage());
        int i = 0;
        while (i < services.length) {
            value.append(',');
            String curr = services[i];
            this.fBundleActivatorModel.addImport(curr);
            String currPack = DeviceKitUtilities.extractPackage(curr);
            this.getManifestModel().addImportPackage(currPack);
            if (curr.equals(DeviceKitGenerationConstants.CLASS_OSGI_DEVICE)) {
                value.append("\n\t" + this.quote(curr));
            } else {
                value.append("\n\t" + DeviceKitUtilities.stripPackage(curr) + '.' + "SERVICE_NAME");
            }
            ++i;
        }
        this.codeBAExportedServiceNamesField(ba, value.toString(), fieldComment.toString());
    }

    protected void codeBAGetExportedServiceNames(IType ba) {
        this.codeBAExportedServiceNamesField(ba);
        String bundle = this.fTest.getBundleName();
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("Return the exported service name(s) to be registered by the " + bundle + " bundle.\n");
        buffer.append("\n@return String[] The transport test's service names.\n");
        this.codeBAGetExportedServiceNames(ba, buffer.toString());
    }

    protected void codeBAMethods(IType ba) {
        super.codeBAMethods(ba);
        this.codeBACreateService(ba);
        this.codeBAGetExportedServiceNames(ba);
        this.codeBAGetImportedServiceNames(ba);
        this.codeBACreateProperties(ba);
    }

    protected void codeFields(IType test) {
        super.codeFields(test);
    }

    protected void codeGetDefaultTransport(IType type) {
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        String[] comment = new String[]{"Gets the default TransportService to be tested.", "", "@return TransportService The Transport to be tested.", "@see org.eclipse.soda.dk.transport.test.TransportTest#getDefaultTransport()"};
        String contents = this.getGetDefaultTransportContents();
        this.codeMethod(type, "getDefaultTransport", comment, returnType, 1L, contents);
    }

    protected void codeGetTransport(IType test) {
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        String contents = this.getGetTransportContents();
        this.codeMethod(test, "getTransport", "Gets the transport to be tested.", returnType, 1L, contents);
    }

    protected void codeMessageField(TagElement element, IType test) {
        String fieldType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE);
        String fieldName = element.getId();
        String[] comment = element.getFieldComment();
        if (comment != null && comment.length > 0 && !comment[0].trim().endsWith(".")) {
            comment[0] = String.valueOf(comment[0]) + '.';
        }
        String value = this.getMessageFieldValue(element);
        this.codeField(test, fieldName, fieldType, 50L, comment, value);
    }

    protected void codeMessageGetterMethod(TagElement element, IType test) {
        String type = DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE;
        this.fTestModel.addImport(type);
        String name = element.getId();
        String getterName = "get" + name;
        String returnType = DeviceKitUtilities.stripPackage(type);
        String[] comment = new String[]{"Gets the " + element.getId() + " value.", "", "@return MessageService The " + element.getId() + '.'};
        String contents = this.getMessageGetterContents(name);
        this.codeMethod(test, getterName, comment, returnType, 17L, contents);
    }

    protected void codeMessageReceived(IType test) {
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE);
        KeyValuePair transport = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE), "transport");
        KeyValuePair timeStamp = new KeyValuePair("Object", "timestamp");
        KeyValuePair message = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE), "message");
        KeyValuePair[] parameters = new KeyValuePair[]{transport, timeStamp, message};
        String contents = this.getMessageReceivedContents();
        this.codeMethod(test, "messageReceived", "The messageReceived method is called when a message is received.", "void", 1L, contents, parameters, null);
    }

    protected void codeMethods(IType test) {
        super.codeMethods(test);
        this.codeSetup(test);
        this.codeGetDefaultTransport(test);
        this.codeRunTestsMethod(test);
        this.codeSendMethods(test);
    }

    protected void codeRunTestsMethod(IType type) {
        String[] comment = new String[]{"Runs the user-defined tests.", "", "@see org.eclipse.soda.dk.transport.test.TransportTest#runTests()"};
        String contents = this.getRunTestsContents();
        this.codeMethod(type, "runTests", comment, "void", 1L, contents);
    }

    protected void codeSendMethod(SendElement sendElement, IType test) {
        String id = sendElement.getId();
        String name = "send" + id;
        String[] comment = new String[]{"Sends the series of messages defined in the send " + id + " testcase."};
        String contents = this.getSendContents(test, sendElement);
        this.codeMethod(test, name, comment, "void", 1L, contents);
    }

    protected void codeSendMethods(IType test) {
        Vector sends = this.getMainElement().getAllChildrenWithTagCode(60, false);
        int i = 0;
        while (i < sends.size()) {
            SendElement element = (SendElement)sends.get(i);
            this.codeSendMethod(element, test);
            ++i;
        }
    }

    protected void codeSetTransport(IType test) {
        String[] comment = new String[]{"Sets the transport to be tested."};
        String transportServiceClass = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        KeyValuePair transportService = new KeyValuePair(transportServiceClass, "transportService");
        KeyValuePair[] parameters = new KeyValuePair[]{transportService};
        String contents = this.getSetTransportContents();
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        this.codeMethod(test, "setTransport", comment, "void", 1L, contents, parameters, null);
    }

    protected void codeSetup(IType type) {
        String[] comment = new String[]{"Sets user-defined variables to use in the test.", "", "@see org.eclipse.soda.dk.transport.test.TransportTest#setup()"};
        String contents = this.getSetupContents();
        this.codeMethod(type, "setup", comment, "void", 1L, contents);
    }

    protected void codeTestDelay(IType test) {
        if (TagElement.collection.getSends().size() > 0) {
            String dValue = this.getTestElement().getTestDelay();
            if (dValue == null) {
                dValue = "0";
            }
            String value = this.getConfLong(this.getTestElement(), "testdelay", dValue);
            this.codeField(test, "testDelay", "long", 2L, "Specifies the amount of time to wait between test method calls.\n", value);
        }
    }

    protected void codeTransportChanged(IType test) {
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        String ts = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        KeyValuePair transportService = new KeyValuePair(ts, "transportService");
        KeyValuePair timeStamp = new KeyValuePair("Object", "timestamp");
        KeyValuePair newState = new KeyValuePair("int", "newState");
        KeyValuePair oldState = new KeyValuePair("int", "oldState");
        KeyValuePair[] parameters = new KeyValuePair[]{transportService, timeStamp, newState, oldState};
        String contents = this.getTransportChangedContents();
        this.codeMethod(test, "transportChanged", "The transportChanged method is called when the state of the transport changes.", "void", 1L, contents, parameters, null);
    }

    protected String getBACreateServiceContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("final ");
        buffer.append(this.getMainClassName());
        this.fBundleActivatorModel.addImport(this.getMainFqn());
        buffer.append(" testCase = new ");
        buffer.append(this.getMainClassName());
        buffer.append("();\n");
        buffer.append("testCase.setTransport(" + this.getTargetType() + ");\n");
        buffer.append("return testCase;\n");
        return buffer.toString();
    }

    protected String getBADeactivateContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("if (this.testCase != null) {\n");
        buffer.append("\ttestCase.stop();\n");
        buffer.append("\ttestCase.setTransport(null);\n");
        buffer.append("}\n");
        buffer.append("testCase = null;\n");
        buffer.append("super.deactivate();\n");
        return buffer.toString();
    }

    protected String getBASuperClass() {
        switch (this.bundleType) {
            case 2: {
                return DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_MANAGED_BA;
            }
            case 3: {
                return DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_MANAGED_FACTORY_BA;
            }
            case 1: {
                return DeviceKitGenerationConstants.CLASS_TRANSPORT_TEST_BUNDLE_ACTIVATOR;
            }
        }
        return "";
    }

    protected String getBundleActivatorComment() {
        StringBuffer buffer = new StringBuffer(64);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    protected String getGetDefaultTransportContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("return new ");
        String targetClass = this.getTestElement().getTargetClass();
        buffer.append(targetClass);
        String targetPack = DkUtilities.getPackageFromClassName(targetClass, this.getPackageBase());
        String targetFqn = String.valueOf(targetPack) + '.' + targetClass;
        this.fTestModel.addImport(targetFqn);
        String bundleId = DeviceKitUtilities.extractPackage(targetFqn);
        this.addAdditionalBundles(bundleId);
        bundleId = String.valueOf(bundleId) + ".bundle";
        this.addAdditionalBundles(bundleId);
        buffer.append("();\n");
        return buffer.toString();
    }

    protected String getGetTransportContents() {
        return "return this.transport;\n";
    }

    protected String[] getImplementedInterfaces() {
        return new String[]{this.getServiceFqn()};
    }

    protected String getIsActiveContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("return this.active &&\n");
        buffer.append("\t(getTransport() != null) &&\n");
        buffer.append("\t(getTransport().getState() >= TransportService.ACTIVE);\n");
        return buffer.toString();
    }

    protected String getMainClassComment() {
        StringBuffer buffer = new StringBuffer(64);
        String desc = this.getMainElement().getDescription();
        if (desc != null) {
            buffer.append(desc);
            if (!desc.trim().endsWith(".")) {
                buffer.append('.');
            }
            buffer.append("\n\n ");
        }
        buffer.append("The " + this.getMainClassName() + " class implements a set of transport tests.\n");
        buffer.append(this.getCommonClassComment());
        return buffer.toString();
    }

    protected String getMainContents() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("try {\n");
        String mainClassName = this.getMainClassName();
        buffer.append('\t');
        buffer.append("final ");
        buffer.append(mainClassName);
        buffer.append(" testCase = new ");
        buffer.append(mainClassName);
        buffer.append("();\n");
        buffer.append("\ttestCase.run(args);\n");
        buffer.append("} catch (final Exception exception) {\n");
        buffer.append("\texception.printStackTrace(System.out);\n");
        buffer.append("}\n");
        buffer.append("System.exit(0);");
        return buffer.toString();
    }

    private String getMessageFieldValue(TagElement element) {
        NewCodeGenerator gen = new NewCodeGenerator(this.getMainFqn(), this.getMainFqn(), this.getServiceFqn(), true);
        String value = gen.getNewCode(0, element);
        Vector newImports = gen.getImports();
        int j = 0;
        while (j < newImports.size()) {
            String importedItem = (String)newImports.elementAt(j);
            this.fTestModel.addImport(importedItem);
            String importedPack = DeviceKitUtilities.extractPackage(importedItem);
            this.getManifestModel().addImportPackage(importedPack);
            ++j;
        }
        return value;
    }

    protected String getMessageGetterContents(String name) {
        StringBuffer contents = new StringBuffer(64);
        contents.append("return ");
        contents.append(name);
        contents.append(';');
        return contents.toString();
    }

    protected String getMessageReceivedContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("StringBuffer buffer = new StringBuffer(256);\n");
        buffer.append("buffer.append(\"Transport: \");\n");
        buffer.append("buffer.append(transport);\n");
        buffer.append("buffer.append(\"\\r\\n\tmessage: \");\n");
        buffer.append("buffer.append(message);\n");
        buffer.append("buffer.append(\" at: \");\n");
        buffer.append("buffer.append(timestamp);\n");
        buffer.append("log(");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE));
        buffer.append(".LOG_INFO, buffer.toString());\n");
        return buffer.toString();
    }

    protected String getModelName() {
        Vector transports = this.fTest.getAllChildrenWithTagCodes(new int[]{15, 9, 97});
        if (transports.size() > 0) {
            TagElement transport = (TagElement)transports.elementAt(0);
            String name = transport.getImplementation();
            if (name != null) {
                if (name.indexOf(46) == -1) {
                    String pack = DeviceKitUtilities.getPackageFromClassName(name, this.getPackageBase());
                    name = String.valueOf(pack) + '.' + name;
                }
                return name;
            }
            String idref = transport.getAttribute("idref");
            if (idref != null) {
                Vector devs = this.getTestElement().getParent().getAllChildrenWithTagCodes(new int[]{9, 97});
                int i = 0;
                while (i < devs.size()) {
                    TagElement element = (TagElement)devs.elementAt(i);
                    if (idref.equals(element.getId())) {
                        return element.getImplementation();
                    }
                    ++i;
                }
            }
        }
        return null;
    }

    protected String getModelServiceName() {
        Vector transports = this.fTest.getAllChildrenWithTagCodes(new int[]{9, 97});
        String service = null;
        TagElement device = (TagElement)transports.elementAt(0);
        service = device.getAttribute("service") != null ? device.getAttribute("service") : device.getImplementation();
        if (service != null) {
            if (!service.endsWith("Service")) {
                service = String.valueOf(service) + "Service";
            }
            if (service.indexOf(46) == -1) {
                return String.valueOf(DeviceKitUtilities.getPackageFromClassName(service, this.getPackageBase())) + '.' + service;
            }
            return service;
        }
        return "";
    }

    protected String getRunContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("int count = 0;\n");
        buffer.append("while(!isActive() && (getTransport() != null)) {\n");
        buffer.append("\ttry {\n");
        buffer.append("\t\tsynchronized(this) {\n");
        buffer.append("\t\t\tcount++;\n");
        buffer.append("\t\t\tif ((count % 20) == 0) {\n");
        buffer.append("\t\t\t\tcount = 0;\n");
        buffer.append("\t\t\t\tlog(LOG_INFO, \"The transport test is still waiting for the transport to initialize.\");\n");
        buffer.append("\t\t\t}\n");
        buffer.append("\t\t\twait(500);\n");
        buffer.append("\t\t}\n");
        buffer.append("\t} catch (final Exception exception) {\n");
        buffer.append("\t}\n");
        buffer.append("}\n");
        buffer.append("for (int i = 0; i < testCount; i++) {\n");
        buffer.append(this.getRunLoopContents("\t"));
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getRunLoopContents(String indentation) {
        Vector sends = this.getTestElement().getAllChildrenWithTagCode(60);
        StringBuffer buffer = new StringBuffer(sends.size() * 32);
        int i = 0;
        while (i < sends.size()) {
            SendElement element = (SendElement)sends.get(i);
            buffer.append(indentation);
            buffer.append("send");
            if (element.getId() != null) {
                buffer.append(element.getId());
            } else {
                buffer.append(element.getAttribute("idref"));
            }
            buffer.append("();\n");
            buffer.append("sleep(");
            buffer.append("testDelay");
            buffer.append(");\n");
            ++i;
        }
        return buffer.toString();
    }

    protected String getRunTestsContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append(this.getRunTestsLoopContents(""));
        return buffer.toString();
    }

    protected String getRunTestsLoopContents(String indentation) {
        Vector sends = this.getTestElement().getAllChildrenWithTagCode(60);
        StringBuffer buffer = new StringBuffer(sends.size() * 32);
        int i = 0;
        while (i < sends.size()) {
            SendElement element = (SendElement)sends.get(i);
            buffer.append(indentation);
            buffer.append("send");
            if (element.getId() != null) {
                buffer.append(element.getId());
            } else {
                buffer.append(element.getAttribute("idref"));
            }
            buffer.append("();\n");
            buffer.append("sleep(getTestDelay());\n");
            ++i;
        }
        return buffer.toString();
    }

    protected String getSendContents(IType test, SendElement sendElement) {
        Vector children = sendElement.getChildren();
        StringBuffer buffer = new StringBuffer(children.size() * 32);
        int i = 0;
        while (i < children.size()) {
            TagElement element = (TagElement)children.get(i);
            switch (element.getTagCode()) {
                case 7: {
                    TagElement me = element;
                    buffer.append("getTransport().send(");
                    buffer.append(this.handleMessage(me, test));
                    buffer.append(");\n");
                    break;
                }
                case 17: {
                    SleepElement se = (SleepElement)element;
                    buffer.append("sleep(");
                    buffer.append(se.getSleepTime());
                    buffer.append(");\n");
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    protected String getSetTransportContents() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("if (this.transport != null) {\n");
        buffer.append("\tthis.transport.removeTransportListener(this);\n");
        buffer.append("}\n");
        buffer.append("this.transport = transport;\n");
        buffer.append("if (this.transport != null) {\n");
        buffer.append("\tthis.transport.addTransportListener(this);\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getSetupContents() {
        TestElement element = this.getTestElement();
        EscPropertiesModel model = EscPropertiesModel.getModel(this);
        String configKey = this.getConfigurationKey(element);
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("super.setup();\n");
        String value = null;
        value = "DEFAULT_PRIORITY";
        buffer.append("setPriority(");
        buffer.append(this.getConfInt(element, "priority", value));
        model.addProperty(String.valueOf(configKey) + ".priority", "3");
        buffer.append(");\n");
        value = element.getTestCount();
        buffer.append("setTestCount(");
        if (value == null) {
            value = "DEFAULT_TEST_COUNT";
        }
        buffer.append(this.getConfInt(element, "testcount", value));
        model.addProperty(String.valueOf(configKey) + ".testcount", "2");
        buffer.append(");\n");
        value = this.getTestElement().getTestDelay();
        buffer.append("setTestDelay(");
        if (value == null) {
            value = "DEFAULT_TEST_DELAY";
        }
        buffer.append(this.getConfLong(element, "testdelay", value));
        model.addProperty(String.valueOf(configKey) + ".testdelay", "0");
        buffer.append(");\n");
        value = "DEFAULT_TOTAL_TEST_TIME";
        buffer.append("setTotalTestTime(");
        buffer.append(this.getConfLong(element, "totaltesttime", value));
        model.addProperty(String.valueOf(configKey) + ".totaltesttime", "60000");
        buffer.append(");\n");
        return buffer.toString();
    }

    protected String getStartContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("setActive(true);\n");
        buffer.append("if (getTransport() != null) {\n");
        buffer.append("\tStringBuffer buffer = new StringBuffer(256);\n");
        buffer.append("\tbuffer.append(\"Test: ");
        buffer.append(this.getUserName(this.fTest));
        buffer.append(" start at: \");\n");
        buffer.append("\tbuffer.append(");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT);
        buffer.append(".getCurrentTimestamp());\n");
        buffer.append("\tbuffer.append('.');\n");
        buffer.append("\tlog(");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE));
        buffer.append(".LOG_INFO, buffer.toString());\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE);
        buffer.append("\ttest();\n");
        buffer.append('}');
        return buffer.toString();
    }

    protected String getStopContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("setActive(false);\n");
        buffer.append("if (getThread() != null) {\n");
        buffer.append("\ttry {\n");
        buffer.append("\t\tgetThread().join(2000);\n");
        buffer.append("\t} catch (final Exception exception) {\n");
        buffer.append("\t\tlog(" + DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE) + ".LOG_ERROR, \"Exception on join.\", exception);\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE);
        buffer.append("\t}\n");
        buffer.append("}\n");
        buffer.append("setThread(null);\n");
        buffer.append("if (getTransport() != null) {\n");
        buffer.append("\tStringBuffer buffer = new StringBuffer(256);\n");
        buffer.append("\tbuffer.append(\"Test: ");
        buffer.append(this.getUserName(this.fTest));
        buffer.append(" stop at: \");\n");
        buffer.append("buffer.append(getCurrentTimestamp());\n");
        buffer.append("buffer.append(\".\");\n");
        buffer.append("\tlog(LOG_INFO, buffer.toString());\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getTargetType() {
        return "transport";
    }

    protected String getTransportChangedContents() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("StringBuffer buffer = new StringBuffer(256);\n");
        buffer.append("buffer.append(\"Transport: \");\n");
        buffer.append("buffer.append(transportService);\n");
        buffer.append("buffer.append(\"\\r\\n\\tstate: \");\n");
        buffer.append("buffer.append(stateStrings[newState]);\n");
        buffer.append("buffer.append(\" old state: \");\n");
        buffer.append("buffer.append(stateStrings[oldState]);\n");
        buffer.append("buffer.append(\" at: \");\n");
        buffer.append("buffer.append(timestamp);\n");
        buffer.append("buffer.append(\".\");\n");
        buffer.append("log(");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE));
        buffer.append(".LOG_INFO, buffer.toString());\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_OSGI_LOG_SERVICE);
        buffer.append("if (newState >= TransportService.ACTIVE){\n");
        buffer.append("\ttest();\n");
        buffer.append("}\n");
        buffer.append("synchronized (this) {\n");
        buffer.append("\tnotify();\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String handleMessage(TagElement element, IType test) {
        String id = element.getAttribute("id");
        if (id != null) {
            this.codeMessageField(element, test);
            this.codeMessageGetterMethod(element, test);
        }
        String idref = element.getAttribute("idref");
        if (id != null) {
            return "get" + id + "()";
        }
        if (idref != null) {
            return "get" + idref + "()";
        }
        NewCodeGenerator gen = new NewCodeGenerator(this.getMainFqn(), this.getMainFqn(), this.getServiceFqn(), true);
        return gen.getNewCode(0, element);
    }

    protected boolean isAbstract() {
        Vector trans = this.getMainElement().getAllChildrenWithTagCodes(new int[]{9, 97});
        MainTagElement tran = (MainTagElement)trans.elementAt(0);
        String abs = tran.getAttribute("abstract");
        return abs != null && abs.equals("true");
    }
}

