/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.IOException;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.BytesGenerator;
import org.eclipse.soda.devicekit.generator.model.DeviceKitGeneratorMessages;
import org.eclipse.soda.devicekit.generator.model.EscPropertiesModel;
import org.eclipse.soda.devicekit.generator.model.elements.BlockElement;
import org.eclipse.soda.devicekit.generator.model.elements.BytesItem;
import org.eclipse.soda.devicekit.generator.model.elements.ChoiceSegmentElement;
import org.eclipse.soda.devicekit.generator.model.elements.ConnectionElement;
import org.eclipse.soda.devicekit.generator.model.elements.ControlItem;
import org.eclipse.soda.devicekit.generator.model.elements.DecrementCommandElement;
import org.eclipse.soda.devicekit.generator.model.elements.FileElement;
import org.eclipse.soda.devicekit.generator.model.elements.FilterElement;
import org.eclipse.soda.devicekit.generator.model.elements.GeneralParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.IncrementCommandElement;
import org.eclipse.soda.devicekit.generator.model.elements.MessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.MultiParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.ParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.RandomAccessFileElement;
import org.eclipse.soda.devicekit.generator.model.elements.ReadCommandElement;
import org.eclipse.soda.devicekit.generator.model.elements.SegmentElement;
import org.eclipse.soda.devicekit.generator.model.elements.SentMessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.SerialElement;
import org.eclipse.soda.devicekit.generator.model.elements.SignalElement;
import org.eclipse.soda.devicekit.generator.model.elements.SingleParameterSegmentElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TcpipElement;
import org.eclipse.soda.devicekit.generator.model.elements.TcpipServerElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransformItem;
import org.eclipse.soda.devicekit.generator.model.elements.UnitsElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnitsLinkElement;
import org.eclipse.soda.devicekit.generator.model.elements.UrlConnectionElement;
import org.eclipse.soda.devicekit.generator.model.elements.UsbElement;
import org.eclipse.soda.devicekit.generator.model.elements.ValueElement;
import org.eclipse.soda.devicekit.generator.model.elements.VariableLengthParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.WriteCommandElement;
import org.eclipse.soda.devicekit.generator.model.java.CodeUtilities;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.util.BinaryOuputStream;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.Nls;

public class NewCodeGenerator {
    private Vector fImports;
    private int fIndent = 0;
    private String fMainClass;
    private String fMessageClass;
    private IType messageType;
    private String fServiceClass;
    private boolean lazy;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public NewCodeGenerator(String mainClass) {
        this(mainClass, false);
    }

    public NewCodeGenerator(String mainClass, boolean lazy) {
        this(mainClass, null, null, lazy);
    }

    public NewCodeGenerator(String mainClass, String messageClass, String serviceClass) {
        this(mainClass, messageClass, serviceClass, false);
    }

    public NewCodeGenerator(String mainClass, String messageClass, String serviceClass, boolean lazy) {
        this.fMainClass = mainClass;
        this.fMessageClass = messageClass;
        this.fServiceClass = serviceClass;
        this.lazy = lazy;
        this.fImports = new Vector();
    }

    public NewCodeGenerator(String mainClass, IType messageType, String messageClass, String serviceClass, boolean lazy) {
        this.fMainClass = mainClass;
        this.messageType = messageType;
        this.fMessageClass = messageClass;
        this.fServiceClass = serviceClass;
        this.lazy = lazy;
        this.fImports = new Vector();
    }

    protected static String codeByte(byte value, String format) {
        StringBuffer buffer = new StringBuffer(32);
        if (value > 127 || value < -1) {
            buffer.append('(');
            buffer.append("byte");
            buffer.append(')');
        }
        if ("hex".equals(format) && (value > 9 || value < -1)) {
            buffer.append("0x");
            buffer.append(Integer.toHexString(value & 0xFF));
            return buffer.toString();
        }
        buffer.append(Integer.toString(value));
        return buffer.toString();
    }

    protected void addImport(String imp) {
        this.fImports.add(imp);
    }

    protected String codeGetInt(String majorKey, String minorKey, String value) {
        if (majorKey == null) {
            return value;
        }
        String key = String.valueOf(majorKey) + '.' + minorKey;
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("getInt(");
        buffer.append(this.quote(key));
        buffer.append(", ");
        buffer.append(value);
        buffer.append(')');
        return buffer.toString();
    }

    protected String convertToAsciiByteArray(String string, TagElement element) {
        StringBuffer comment = new StringBuffer(string.length() * 5 + 12);
        StringBuffer result = new StringBuffer(string.length() * 5 + 12);
        result.append("new byte[] {");
        char[] array = string.toCharArray();
        int i = 0;
        block5: while (i < array.length) {
            if (i > 0) {
                result.append(", ");
            }
            if (array[i] == '\\') {
                if (++i >= array.length) {
                    throw this.error("Invalid character sequence" + element.toString());
                }
                switch (array[i]) {
                    case '\"': 
                    case '\'': 
                    case '\\': 
                    case 'b': 
                    case 'n': 
                    case 'r': 
                    case 't': {
                        result.append('\'');
                        result.append('\\');
                        result.append(array[i]);
                        result.append('\'');
                        ++i;
                        break;
                    }
                    case 'u': {
                        throw this.error("Invalid character sequence" + element.toString());
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        result.append(array[i]);
                        if (++i < array.length) {
                            if (Character.isDigit(array[i])) {
                                result.append(array[i]);
                                ++i;
                            }
                        } else {
                            throw this.error("Invalid character sequence" + element.toString());
                        }
                        if (i < array.length) {
                            if (!Character.isDigit(array[i])) continue block5;
                            result.append(array[i]);
                            ++i;
                            break;
                        }
                        throw this.error("Invalid character sequence: " + element.toString());
                    }
                }
                continue;
            }
            if (array[i] == '\'') {
                result.append('\'');
                result.append('\\');
                result.append(array[i]);
                result.append('\'');
                comment.append(39);
            } else {
                result.append('\'');
                result.append(array[i]);
                result.append('\'');
                comment.append((byte)array[i]);
                comment.append(' ');
            }
            ++i;
        }
        result.append('}');
        if (array.length > 16) {
            result.append('\n');
            result = this.indent(result);
        } else {
            result.append(' ');
        }
        result.append("// ");
        result.append(comment.toString());
        result.append('\n');
        return result.toString();
    }

    protected void decindent() {
        --this.fIndent;
    }

    protected RuntimeException error(String message) {
        return new RuntimeException(message);
    }

    protected String getBytes(TagElement element) {
        return this.getBytes(element, false);
    }

    protected String getBytes(TagElement element, boolean reduce) {
        StringBuffer buffer = new StringBuffer(32);
        Vector list = element.getByteChildren();
        BytesItem bi = null;
        int listSize = list.size();
        if (listSize == 0) {
            Vector parameters = element.getParameterChildren();
            int parameterSize = parameters.size();
            int newCode = 0;
            BytesGenerator byteGenerator = new BytesGenerator();
            if (parameterSize > 0) {
                int i = 0;
                while (i < parameterSize) {
                    TagElement tagElement = (TagElement)parameters.elementAt(i);
                    if (tagElement instanceof GeneralParameterElement) {
                        ++newCode;
                    }
                    tagElement.updateBytes(byteGenerator);
                    ++i;
                }
            }
            if (newCode > 0) {
                String comment;
                buffer.append('\n');
                buffer = this.indent(buffer);
                if (reduce) {
                    byteGenerator.reduce();
                }
                if ((comment = byteGenerator.getCodeComment()).length() > 0) {
                    buffer.append(comment);
                    buffer.append('\n');
                }
                buffer.append(byteGenerator.getBytesCode());
                return buffer.toString();
            }
            String value = this.outputString(element.getTextData());
            if (value == null) {
                buffer.append("null");
            } else {
                buffer.append(this.quote(value));
                buffer.append(".getBytes");
                buffer.append("()");
            }
        } else if (listSize == 1) {
            bi = (BytesItem)list.elementAt(0);
            if (bi.getId() != null || bi.getAttribute("idref") != null) {
                boolean inMessageClass = true;
                String key = null;
                key = bi.getId() != null ? bi.getId() : bi.getAttribute("idref");
                if (bi.isMessageClassElement() && !this.fMainClass.equals(this.fMessageClass)) {
                    this.addImport(this.fMessageClass);
                    buffer.append(DeviceKitUtilities.stripPackage(this.fMessageClass));
                    buffer.append('.');
                    inMessageClass = false;
                }
                if (inMessageClass) {
                    buffer.append("get");
                    buffer.append(CodeUtilities.methodName(key));
                    buffer.append("()");
                }
            } else {
                buffer.append(this.getNewCode(this.fIndent, bi));
            }
        } else {
            String format = element.getFormat();
            BinaryOuputStream byteArrayOutputStream = new BinaryOuputStream(100);
            int i = 0;
            while (i < list.size()) {
                bi = (BytesItem)list.elementAt(i);
                try {
                    bi.append(byteArrayOutputStream);
                }
                catch (IOException exception) {
                    throw this.error(exception.getMessage());
                }
                ++i;
            }
            buffer.append("new byte []");
            buffer.append(' ');
            buffer.append("{\n");
            this.incindent();
            byte[] bytes = byteArrayOutputStream.toByteArray();
            int i2 = 0;
            while (i2 < bytes.length) {
                if (i2 != 0) {
                    buffer.append(",\n");
                }
                buffer = this.indent(buffer);
                buffer.append(NewCodeGenerator.codeByte(bytes[i2], format));
                ++i2;
            }
            buffer.append('\n');
            this.decindent();
            buffer = this.indent(buffer);
            buffer.append('}');
        }
        return buffer.toString();
    }

    protected String getCommand(ControlItem command) {
        StringBuffer buffer = new StringBuffer(32);
        if (command.getId() != null || command.getAttribute("idref") != null) {
            String key = null;
            key = command.getId() != null ? command.getId() : command.getAttribute("idref");
            CodeUtilities.fieldReference(key, this.lazy, buffer);
        } else {
            buffer.append(this.getNewFilter(command));
        }
        return buffer.toString();
    }

    protected String getCommands(TagElement element) {
        StringBuffer buffer = new StringBuffer(32);
        Vector list = element.getAllChildrenWithTagCode(1);
        buffer.append("new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_COMMAND_SERVICE));
        this.addImport(DeviceKitGenerationConstants.CLASS_COMMAND_SERVICE);
        buffer.append(" [] {\n");
        this.incindent();
        int i = 0;
        while (i < list.size()) {
            if (i != 0) {
                buffer.append(",\n");
            }
            buffer = this.indent(buffer);
            buffer.append(this.getCommand((ControlItem)list.elementAt(i)));
            ++i;
        }
        buffer.append('\n');
        this.decindent();
        buffer = this.indent(buffer);
        buffer.append('}');
        return buffer.toString();
    }

    protected String getConfString(TagElement element, String key, String defaultString) {
        StringBuffer buffer = new StringBuffer(32);
        if (this.getConfigurationKey(element) == null) {
            buffer.append(defaultString);
        } else {
            buffer.append("getString(");
            buffer.append(this.quote(String.valueOf(this.getConfigurationKey(element)) + '.' + key));
            buffer.append(", ");
            buffer.append(defaultString);
            buffer.append(')');
        }
        return buffer.toString();
    }

    protected String getConfigurationKey(TagElement element) {
        String key = element.getBundleName();
        if (key != null && key.length() > 0) {
            return key.toLowerCase();
        }
        key = element.getKey();
        if (key != null && key.length() > 0) {
            return key.toLowerCase();
        }
        return null;
    }

    protected String getDecrementCommand(DecrementCommandElement element) {
        StringBuffer buffer = new StringBuffer(32);
        String idref = element.getAttribute("idref");
        if (idref != null && idref.length() > 0) {
            CodeUtilities.fieldReference(idref, this.lazy, buffer);
        } else {
            buffer.append("null");
        }
        return buffer.toString();
    }

    protected String getDefaultMeasurementValue(TagElement element) {
        return element.getDefaultMeasurementValue();
    }

    protected String getFilter(FilterElement filter) {
        StringBuffer buffer = new StringBuffer(32);
        if (filter.getId() != null || filter.getAttribute("idref") != null) {
            boolean inMessageClass = true;
            String key = null;
            key = filter.getId() != null ? filter.getId() : filter.getAttribute("idref");
            if (filter.isMessageClassElement() && !this.fMainClass.equals(this.fMessageClass)) {
                this.addImport(this.fMessageClass);
                buffer.append(DeviceKitUtilities.stripPackage(this.fMessageClass));
                buffer.append('.');
                buffer.append("get");
                buffer.append(CodeUtilities.methodName(key));
                buffer.append("()");
                inMessageClass = false;
            }
            if (inMessageClass) {
                buffer.append("get");
                buffer.append(CodeUtilities.methodName(key));
                buffer.append("()");
            }
        } else {
            String serviceType = filter.getServiceType();
            this.addImport(serviceType);
            buffer.append('(');
            buffer.append(DeviceKitUtilities.stripPackage(serviceType));
            buffer.append(')');
            buffer.append(this.getNewFilter(filter));
        }
        return buffer.toString();
    }

    protected String getFilters(TagElement element) {
        StringBuffer buffer = new StringBuffer(32);
        Vector list = element.getFilterChildren();
        switch (list.size()) {
            case 0: {
                buffer.append("null");
                break;
            }
            case 1: {
                buffer.append(this.getFilter((FilterElement)list.elementAt(0)));
                this.addImport(DeviceKitGenerationConstants.CLASS_FILTER);
                this.addImport(DeviceKitGenerationConstants.CLASS_FILTER_SERVICE);
                break;
            }
            default: {
                buffer.append("new ");
                buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_FILTERS));
                this.addImport(DeviceKitGenerationConstants.CLASS_FILTER);
                buffer.append("(\n");
                this.incindent();
                buffer = this.indent(buffer);
                buffer.append("new ");
                buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_FILTER_SERVICE));
                buffer.append("[]");
                this.addImport(DeviceKitGenerationConstants.CLASS_FILTER_SERVICE);
                buffer.append(" {\n");
                this.incindent();
                buffer = this.indent(buffer);
                int i = 0;
                while (i < list.size()) {
                    if (i != 0) {
                        buffer.append(", ");
                    }
                    buffer.append(this.getFilter((FilterElement)list.elementAt(i)));
                    ++i;
                }
                buffer.append('\n');
                this.decindent();
                buffer = this.indent(buffer);
                buffer.append("}\n");
                this.decindent();
                buffer = this.indent(buffer);
                buffer.append(')');
            }
        }
        return buffer.toString();
    }

    public Vector getImports() {
        return this.fImports;
    }

    protected String getIncrementCommand(IncrementCommandElement element) {
        StringBuffer buffer = new StringBuffer(32);
        String idref = element.getAttribute("idref");
        if (idref != null && idref.length() > 0) {
            CodeUtilities.fieldReference(idref, this.lazy, buffer);
        } else {
            buffer.append("null");
        }
        return buffer.toString();
    }

    protected String getKey(TagElement element) {
        StringBuffer key = new StringBuffer(32);
        String id = element.getId();
        if (id != null) {
            if (this.fServiceClass != null && this.fServiceClass.length() > 0 && id.length() > 0) {
                key.append(DeviceKitUtilities.stripPackage(this.fServiceClass));
                this.addImport(this.fServiceClass);
                key.append('.');
                key.append(id);
            } else {
                key.append(this.quote(id));
            }
            return key.toString();
        }
        return "null";
    }

    protected String getMeasurement(ControlItem measurement) {
        StringBuffer buffer = new StringBuffer(32);
        if (measurement.getId() != null || measurement.getAttribute("idref") != null) {
            String key = null;
            key = measurement.getId() != null ? measurement.getId() : measurement.getAttribute("idref");
            CodeUtilities.fieldReference(key, this.lazy, buffer);
        } else {
            buffer.append(this.getNewFilter(measurement));
        }
        return buffer.toString();
    }

    protected String getMeasurementConcreteValue(ControlItem measurement) {
        StringBuffer buffer = new StringBuffer(32);
        Vector list = measurement.getAllChildrenWithTagCode(13);
        if (list.size() > 0) {
            int i = 0;
            while (i < list.size()) {
                buffer.append(this.getValue((ValueElement)list.elementAt(i)));
                ++i;
            }
        } else {
            String textData = measurement.getTextData();
            if (textData == null || textData.trim().length() == 0) {
                String value = this.outputString(textData);
                if (value == null || value.trim().length() == 0) {
                    buffer.append(this.getDefaultMeasurementValue(measurement));
                } else {
                    buffer.append(this.quote(value));
                }
            }
        }
        return buffer.toString();
    }

    protected String getMeasurementValue(ControlItem measurement) {
        StringBuffer buffer = new StringBuffer(32);
        Vector list = measurement.getAllChildrenWithTagCode(13);
        if (list.size() > 0) {
            int i = 0;
            while (i < list.size()) {
                buffer.append(this.getValue((ValueElement)list.elementAt(i)));
                ++i;
            }
        } else {
            String textData = measurement.getTextData();
            if (textData == null || textData.trim().length() == 0) {
                String value = this.outputString(textData);
                if (value == null || value.trim().length() == 0) {
                    buffer.append(this.getDefaultMeasurementValue(measurement));
                } else {
                    buffer.append(this.quote(value));
                }
            }
        }
        return buffer.toString();
    }

    protected String getMessage(TagElement message) {
        StringBuffer buffer = new StringBuffer(32);
        if (message.getId() != null || message.getAttribute("idref") != null) {
            String key = null;
            key = message.getId() != null ? message.getId() : message.getAttribute("idref");
            if (message.isMessageClassElement() && !this.fMainClass.equals(this.fMessageClass)) {
                this.addImport(this.fMessageClass);
                buffer.append(DeviceKitUtilities.stripPackage(this.fMessageClass));
                buffer.append('.');
            }
            buffer.append("get");
            buffer.append(CodeUtilities.methodName(key));
            buffer.append("()");
        } else {
            buffer.append(this.getNewMessage(message));
        }
        return buffer.toString();
    }

    public IType getMessageType() {
        return this.messageType;
    }

    protected String getMessages(TagElement element) {
        StringBuffer buffer = new StringBuffer(32);
        Vector messages = element.getMessageChildren();
        switch (messages.size()) {
            case 0: {
                buffer.append("null");
                return buffer.toString();
            }
            case 1: {
                buffer.append(this.getMessage((TagElement)messages.elementAt(0)));
                return buffer.toString();
            }
        }
        buffer.append(this.getNewMessages(element));
        return buffer.toString();
    }

    protected String getNewBytes(TagElement element) {
        String data;
        StringBuffer codeBuffer = new StringBuffer(64);
        StringBuffer comment = new StringBuffer(256);
        String format = element.getFormat();
        if (element.getTagCode() == 63) {
            data = element.getTextData();
            String asciiByteArray = this.convertToAsciiByteArray(data, element);
            comment.append(data);
            codeBuffer.append(asciiByteArray);
        } else if (element.getTagCode() == 696) {
            data = element.getTextData();
            codeBuffer.append(this.quote(data));
            codeBuffer.append("getBytes(\"UTF-8\")");
        } else {
            codeBuffer.append("new ");
            codeBuffer.append(element.getTypeWithoutPackage());
            codeBuffer.append('{');
            byte[] bytes = ((BytesItem)element).bytes();
            int i = 0;
            while (i < bytes.length) {
                if (i != 0) {
                    codeBuffer.append(", ");
                }
                codeBuffer.append(NewCodeGenerator.codeByte(bytes[i], format));
                if (format.equals("hex")) {
                    comment.append(bytes[i]);
                    comment.append(' ');
                } else {
                    comment.append(NewCodeGenerator.codeByte(bytes[i], "hex"));
                    comment.append(' ');
                }
                ++i;
            }
            codeBuffer.append('}');
            codeBuffer.append('\n');
        }
        if (comment.length() == 0) {
            return codeBuffer.toString();
        }
        StringBuffer buffer = new StringBuffer(84);
        buffer.append('\n');
        buffer = this.indent(buffer);
        buffer.append("// ");
        buffer.append(comment.toString());
        buffer.append('\n');
        buffer = this.indent(buffer);
        buffer.append(codeBuffer.toString());
        return buffer.toString();
    }

    public String getNewCode(int indent, TagElement element) {
        this.fIndent = indent;
        switch (element.getTagCode()) {
            case 1: {
                return this.getNewCommand(element);
            }
            case 19: {
                return this.getNewCommands(element);
            }
            case 2: {
                return this.getNewMeasurment(element);
            }
            case 3: {
                return this.getNewSignal(element);
            }
            case 4: {
                return this.getNewUnits(element);
            }
            case 7: {
                return this.getNewMessage(element);
            }
            case 50: {
                return this.getNewMessages(element);
            }
            case 6: {
                return this.getNewFilter(element);
            }
            case 5: {
                return this.getNewParameter(element);
            }
            case 23: {
                return this.getParameters(element);
            }
            case 26: {
                return this.getNewNegative(element);
            }
            case 22: {
                return this.getNewScale(element);
            }
            case 24: {
                return this.getNewNot(element);
            }
            case 16: 
            case 21: 
            case 27: 
            case 28: {
                return this.getNewTransform(element);
            }
            case 12: 
            case 25: 
            case 40: 
            case 63: 
            case 696: {
                return this.getNewBytes(element);
            }
            case 36: {
                return this.getNewConnectionConnection(element);
            }
            case 33: {
                return this.getNewFileConnection(element);
            }
            case 32: {
                return this.getNewSerialConnection(element);
            }
            case 51: {
                return this.getNewUsbConnection(element);
            }
            case 37: {
                return this.getNewTcpipConnection(element);
            }
            case 94: {
                return this.getNewSSLConnection(element);
            }
            case 34: {
                return this.getNewUrlConnection(element);
            }
            case 31: {
                return this.getNewEchoConnection(element);
            }
            case 35: 
            case 39: {
                return this.getNewConnection(element);
            }
            case 38: {
                return this.getNewMostConnection(element);
            }
            case 56: {
                return this.getNewTcpipServerConnection(element);
            }
            case 95: {
                return this.getNewSSLServerConnection(element);
            }
            case 61: {
                return this.getNewRandomAccessFileConnection(element);
            }
        }
        return "";
    }

    protected String getNewCommand(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        boolean hasMessageParam = false;
        Vector measurements = element.getAllChildrenWithTagCode(2);
        Vector transforms = element.getTransformChildren();
        Vector messages = element.getMessageChildren();
        if (messages.size() > 0 && ((TagElement)messages.elementAt(0)).getParameterChildrenAll().size() > 0) {
            hasMessageParam = true;
        }
        Vector parameters = element.getParameterChildrenAll();
        buffer.append('\n');
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(element.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append("(\n");
        this.incindent();
        buffer = this.indent(buffer);
        buffer.append(this.getKey(element));
        if (messages.size() > 0) {
            if (measurements.size() > 0) {
                buffer.append(", \n");
                buffer = this.indent(buffer);
                buffer.append(this.getMessages(element));
                buffer.append(", \n");
                buffer = this.indent(buffer);
                buffer.append(this.getTransforms(element));
                buffer.append(", \n");
                buffer = this.indent(buffer);
                buffer.append(this.getParameters(element));
                buffer.append(", \n");
                buffer = this.indent(buffer);
                ControlItem me = (ControlItem)measurements.get(0);
                buffer.append(this.getMeasurement(me));
            } else if (parameters.size() > 0) {
                buffer.append(", \n");
                buffer = this.indent(buffer);
                buffer.append(this.getMessages(element));
                buffer.append(", \n");
                buffer = this.indent(buffer);
                buffer.append(this.getTransforms(element));
                buffer.append(", \n");
                buffer = this.indent(buffer);
                buffer.append(this.getParameters(element));
            } else if (transforms.size() > 0 || hasMessageParam) {
                buffer.append(", \n");
                buffer = this.indent(buffer);
                buffer.append(this.getMessages(element));
                if (transforms.size() > 0) {
                    buffer.append(", \n");
                    buffer = this.indent(buffer);
                    buffer.append(this.getTransforms(element));
                }
            } else if (messages.size() > 0) {
                buffer.append(", \n");
                buffer = this.indent(buffer);
                buffer.append(this.getMessages(element));
            }
        }
        this.decindent();
        buffer.append(')');
        return buffer.toString();
    }

    protected String getNewCommands(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append('\n');
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(element.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append("(\n");
        this.incindent();
        buffer = this.indent(buffer);
        buffer.append(this.getKey(element));
        buffer.append(",\n");
        buffer = this.indent(buffer);
        buffer.append(this.getCommands(element));
        buffer.append(')');
        this.decindent();
        return buffer.toString();
    }

    protected String getNewConnection(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        String defaultValue = this.outputString(element.getTextData());
        if (defaultValue == null) {
            defaultValue = "";
        }
        Vector children = element.getChildren();
        String name = "name";
        int i = 0;
        while (i < children.size()) {
            if (((TagElement)children.elementAt(i)).getName().equals("name")) {
                name = this.outputString(((TagElement)children.elementAt(i)).getTextData());
                break;
            }
            ++i;
        }
        String url = name;
        buffer.append("new ");
        buffer.append(element.getTypeWithoutPackage());
        buffer.append('(');
        buffer.append(this.getConfString(element, "name", url));
        buffer.append(')');
        return buffer.toString();
    }

    protected String getNewConnectionConnection(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        ConnectionElement connectionElement = (ConnectionElement)element;
        buffer.append("new ");
        buffer.append(connectionElement.getTypeWithoutPackage());
        this.addImport(connectionElement.getType());
        buffer.append('(');
        buffer.append(')');
        return buffer.toString();
    }

    protected String getNewEchoConnection(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        String defaultValue = this.outputString(element.getTextData());
        if (defaultValue == null) {
            defaultValue = "";
        }
        String url = defaultValue;
        buffer.append("new ");
        buffer.append(element.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append('(');
        url = DeviceKitUtilities.quote(url);
        buffer.append(this.getConfString(element, "name", url));
        buffer.append(')');
        return buffer.toString();
    }

    protected String getNewFileConnection(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        FileElement fe = (FileElement)element;
        String inputPath = fe.getInputPath();
        String inputName = fe.getInputName();
        String outputPath = fe.getOutputPath();
        String outputName = fe.getOutputName();
        buffer.append("new ");
        buffer.append(fe.getTypeWithoutPackage());
        this.addImport(fe.getType());
        buffer.append('(');
        buffer.append(this.getConfString(fe, "inputpath", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_INPUTPATH"));
        buffer.append(",\n");
        this.incindent();
        buffer = this.indent(buffer);
        buffer.append(this.getConfString(element, "inputname", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_INPUTNAME"));
        buffer.append(",\n");
        buffer = this.indent(buffer);
        buffer.append(this.getConfString(element, "outputpath", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_OUTPUTPATH"));
        buffer.append(",\n");
        buffer = this.indent(buffer);
        buffer.append(this.getConfString(element, "outputname", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_OUTPUTNAME"));
        buffer.append(')');
        this.decindent();
        String configKey = this.getConfigurationKey(fe);
        if (configKey != null) {
            EscPropertiesModel model = EscPropertiesModel.getModel();
            model.addProperty(String.valueOf(configKey) + ".inputpath", inputPath);
            model.addProperty(String.valueOf(configKey) + ".inputname", inputName);
            model.addProperty(String.valueOf(configKey) + ".outputpath", outputPath);
            model.addProperty(String.valueOf(configKey) + ".outputname", outputName);
        }
        return buffer.toString();
    }

    protected String getNewFilter(TagElement element) {
        StringBuffer buffer = new StringBuffer(64);
        FilterElement filter = (FilterElement)element;
        buffer.append('\n');
        String serviceType = element.getServiceType();
        buffer = this.indent(buffer);
        buffer.append(" new ");
        buffer.append(filter.getTypeWithoutPackage());
        this.addImport(element.getType());
        this.addImport(serviceType);
        buffer.append("(\n");
        this.incindent();
        buffer = this.indent(buffer);
        if (this.isSimpleFilter(filter)) {
            int length = filter.getBitLengthValue(0);
            int offset = filter.getBitOffsetValue(0);
            buffer.append(offset / 8);
            buffer.append(", ");
            buffer.append((length - offset) / 8);
        } else {
            buffer.append(this.getBytes(filter));
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected String getNewMeasurment(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        ControlItem measurement = (ControlItem)element;
        Vector readComms = measurement.getAllChildrenWithTagCode(20);
        Vector writeComms = measurement.getAllChildrenWithTagCode(45);
        Vector incCommands = measurement.getAllChildrenWithTagCode(43);
        Vector decrementCommands = measurement.getAllChildrenWithTagCode(44);
        Vector signals = measurement.getAllChildrenWithTagCode(3);
        Vector measurements = measurement.getAllChildrenWithTagCode(2);
        Vector transforms = measurement.getTransformChildren();
        Vector messages = measurement.getMessageChildren();
        int index = measurement.getInteger("index", 0);
        boolean isConcrete = measurement.isChildOfCode(18);
        buffer.append('\n');
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(measurement.getTypeWithoutPackage());
        this.addImport(measurement.getType());
        buffer.append("(\t//\n");
        this.incindent();
        buffer = this.indent(buffer);
        buffer.append(this.getKey(measurement));
        String field = measurement.getField();
        if (isConcrete && field != null && field.length() > 0) {
            buffer.append(", \n");
            buffer = this.indent(buffer);
            if (!"null".equals(this.getMeasurementValue(measurement))) {
                buffer = this.indent(buffer);
                buffer.append(this.getMeasurementValue(measurement));
                buffer.append(",\n");
            }
            if (measurements.size() == 1) {
                ControlItem target = (ControlItem)measurements.elementAt(0);
                buffer.append(this.getMeasurement(target));
                buffer.append(',');
            }
            buffer.append(this.quote(field));
        } else if (isConcrete || readComms.size() > 0 || writeComms.size() > 0 || signals.size() > 0) {
            buffer.append(",\t//Key\n");
            buffer = this.indent(buffer);
            buffer.append(this.getMeasurementValue(measurement));
            buffer.append(",\t//Value\n");
            buffer = this.indent(buffer);
            buffer.append(this.getUnits(measurement));
            buffer.append(",\t//Units\n");
            buffer = this.indent(buffer);
            buffer.append(this.getTransforms(measurement));
            buffer.append(",\t//Transform\n");
            if (signals.size() > 0) {
                ControlItem se = (ControlItem)signals.elementAt(0);
                buffer = this.indent(buffer);
                buffer.append(this.getSignal(se));
            } else {
                buffer = this.indent(buffer);
                buffer.append("null");
            }
            if (isConcrete || readComms.size() > 0 || writeComms.size() > 0) {
                buffer.append(",\t//Report Signal\n");
                buffer = this.indent(buffer);
                if (readComms.size() > 0) {
                    buffer.append(this.getReadCommand((ReadCommandElement)readComms.elementAt(0)));
                } else {
                    buffer.append("null");
                }
                buffer.append(",\t//Read (Get) Command\n");
                buffer = this.indent(buffer);
                if (writeComms.size() > 0) {
                    buffer.append(this.getWriteCommand((WriteCommandElement)writeComms.elementAt(0)));
                } else {
                    buffer.append("null");
                }
                if (measurements.size() > 0) {
                    buffer.append(",\t//Write (Set) Command\n");
                    buffer = this.indent(buffer);
                    ControlItem me = (ControlItem)measurements.get(0);
                    buffer.append(this.getMeasurement(me));
                }
            }
            if (isConcrete && (incCommands.size() > 0 || decrementCommands.size() > 0)) {
                buffer.append(",\n");
                buffer = this.indent(buffer);
                if (incCommands.size() > 0) {
                    buffer.append(this.getIncrementCommand((IncrementCommandElement)incCommands.elementAt(0)));
                } else {
                    buffer.append("null");
                }
                buffer.append(",\n");
                buffer = this.indent(buffer);
                if (decrementCommands.size() > 0) {
                    buffer.append(this.getDecrementCommand((DecrementCommandElement)decrementCommands.elementAt(0)));
                } else {
                    buffer.append("null");
                }
            }
        } else if (measurement.getInteger("index", -1) != -1) {
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getMeasurementValue(measurement));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getUnits(measurement));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getMessages(measurement));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getTransforms(measurement));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(index);
        } else if (transforms.size() > 0) {
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getMeasurementValue(measurement));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getUnits(measurement));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getMessages(measurement));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getTransforms(measurement));
        } else if (messages.size() > 0) {
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getMeasurementValue(measurement));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getUnits(measurement));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getMessages(measurement));
        } else if (field != null && field.length() > 0) {
            buffer.append(", \n");
            buffer = this.indent(buffer);
            if (!"null".equals(this.getMeasurementValue(measurement))) {
                buffer = this.indent(buffer);
                buffer.append(this.getMeasurementValue(measurement));
                buffer.append(",\n");
            }
            if (measurements.size() == 1) {
                ControlItem target = (ControlItem)measurements.elementAt(0);
                buffer.append(this.getMeasurement(target));
                buffer.append(',');
            }
            buffer.append(this.quote(field));
        } else if (!"null".equals(this.getMeasurementValue(measurement))) {
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getMeasurementValue(measurement));
        }
        this.decindent();
        buffer.append(')');
        return buffer.toString();
    }

    protected String getNewMessage(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        Vector filters = element.getFilterChildren();
        Vector parameters = element.getParameterChildrenAll();
        Vector sentMessage = element.getAllChildrenWithTagCode(62);
        MessageElement me = (MessageElement)element;
        String tokens = me.getTokens();
        buffer.append('\n');
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(element.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append("(\n");
        this.incindent();
        buffer = this.indent(buffer);
        if (tokens != null && tokens.length() > 0) {
            buffer.append(this.getBytes(element));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getFilters(element));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getParameters(element));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.quote(this.outputString(tokens)));
        } else if (sentMessage != null && sentMessage.size() > 0) {
            buffer.append(this.getBytes(element));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getFilters(element));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getParameters(element));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            SentMessageElement sem = (SentMessageElement)sentMessage.get(0);
            buffer.append(this.getSentMessage(sem, me));
        } else if (parameters.size() > 0) {
            buffer.append(this.getBytes(element));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getFilters(element));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getParameters(element));
        } else if (filters.size() > 0) {
            buffer.append(this.getBytes(element));
            buffer.append(",\n");
            buffer = this.indent(buffer);
            buffer.append(this.getFilters(element));
        } else {
            Vector list = me.getByteChildren();
            if (list.size() == 0) {
                String value = this.outputString(me.getTextData());
                if (value == null) {
                    buffer.append("null");
                } else {
                    buffer.append(this.quote(value));
                }
            } else {
                buffer.append(this.getBytes(element));
            }
        }
        this.decindent();
        buffer.append(')');
        return buffer.toString();
    }

    protected String getNewMessages(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        Vector messages = element.getAllChildrenWithTagCode(7);
        this.addImport(DeviceKitGenerationConstants.CLASS_MESSAGE);
        buffer.append("new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MESSAGES));
        this.addImport(DeviceKitGenerationConstants.CLASS_MESSAGES);
        buffer.append("(\n");
        this.incindent();
        buffer = this.indent(buffer);
        this.addImport(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE);
        buffer.append("new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE));
        this.addImport(DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE);
        buffer.append("[]");
        buffer.append("{\n");
        this.incindent();
        int i = 0;
        while (i < messages.size()) {
            if (i != 0) {
                buffer.append(",\n");
            }
            buffer = this.indent(buffer);
            buffer.append(this.getMessage((TagElement)messages.elementAt(i)));
            ++i;
        }
        buffer.append('\n');
        this.decindent();
        buffer = this.indent(buffer);
        buffer.append('}');
        buffer.append(')');
        this.decindent();
        return buffer.toString();
    }

    protected String getNewMostConnection(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(element.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append("()");
        return buffer.toString();
    }

    protected String getNewNegative(TagElement element) {
        StringBuffer buffer = new StringBuffer(32);
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(element.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append('(');
        buffer.append(')');
        return buffer.toString();
    }

    protected String getNewNot(TagElement element) {
        StringBuffer buffer = new StringBuffer(32);
        buffer = this.indent(buffer);
        buffer.append(element.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append("getTransform()");
        return buffer.toString();
    }

    protected String getNewParameter(TagElement element) {
        if (element instanceof GeneralParameterElement) {
            return this.getNewSpecificParameter(element);
        }
        StringBuffer buffer = new StringBuffer(32);
        ParameterElement parameter = (ParameterElement)element;
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(parameter.getTypeWithoutPackage());
        this.addImport(parameter.getType());
        buffer.append('(');
        this.incindent();
        buffer.append('\n');
        buffer = this.indent(buffer);
        String key = parameter.getKey();
        if (key != null) {
            buffer.append(DeviceKitUtilities.stripPackage(this.fServiceClass));
            buffer.append('.');
            String correctKey = CodeUtilities.staticFieldName(key);
            buffer.append(correctKey);
            buffer.append(',');
        } else {
            if (parameter.getParent() != null && parameter.getParent().getTagCode() == 23) {
                String parentId = element.getParent().getId();
                if (parentId == null) {
                    parentId = "";
                }
                throw this.error(String.valueOf(Nls.format(DeviceKitGeneratorMessages.getString("DkNewCodeGenerator.error.no.id"), parentId)) + parameter.toString());
            }
            buffer.append(this.quote(""));
            buffer.append(',');
        }
        buffer.append('\n');
        buffer = this.indent(buffer);
        buffer.append(this.getTransforms(parameter));
        String field = parameter.getField();
        if (field != null) {
            buffer.append(", ");
            buffer.append('\n');
            buffer = this.indent(buffer);
            buffer.append(this.quote(field));
            if (this.getParameterStyles(parameter).size() > 0) {
                buffer.append(", ");
                buffer.append('\n');
                buffer = this.indent(buffer);
                buffer.append(this.getParameterStyle(parameter));
            }
        } else {
            buffer.append(", ");
            buffer.append('\n');
            buffer = this.indent(buffer);
            int offset = parameter.getBitOffsetValue(0);
            if (offset != -1) {
                int length = parameter.getBitLengthValue(0);
                if (offset < 0) {
                    throw this.error(String.valueOf(Nls.format(DeviceKitGeneratorMessages.getString("DkNewCodeGenerator.error.invalid.offset"), new Integer(offset))) + parameter.toString());
                }
                if (length < 0) {
                    throw this.error(String.valueOf(Nls.format(DeviceKitGeneratorMessages.getString("DkNewCodeGenerator.error.invalid.length"), new Integer(length))) + parameter.toString());
                }
                if (offset % 8 == 0 && length % 8 == 0) {
                    buffer.append(offset / 8);
                    buffer.append(", ");
                    buffer.append('\n');
                    buffer = this.indent(buffer);
                    buffer.append(length / 8);
                } else {
                    buffer.append(offset);
                    buffer.append(", ");
                    buffer.append('\n');
                    buffer = this.indent(buffer);
                    buffer.append(length);
                }
            } else if (parameter.getSize() != null) {
                if (parameter.getIndex() != null) {
                    buffer.append(parameter.getIndex());
                } else {
                    buffer.append("0");
                }
                buffer.append(", ");
                buffer.append(parameter.getSize());
            } else {
                if (parameter.getIndex() != null) {
                    buffer.append(parameter.getIndex());
                } else {
                    buffer.append("0");
                }
                buffer.append(", ");
                buffer.append("0\n");
            }
            if (this.getParameterStyles(parameter).size() > 0) {
                buffer.append(", ");
                buffer.append('\n');
                buffer = this.indent(buffer);
                buffer.append(this.getParameterStyle(parameter));
            }
        }
        buffer.append(')');
        this.addImport(DeviceKitGenerationConstants.CLASS_TRANSFORM_SERVICE);
        return buffer.toString();
    }

    protected String getNewRandomAccessFileConnection(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        RandomAccessFileElement rafe = (RandomAccessFileElement)element;
        buffer.append("new ");
        buffer.append(rafe.getTypeWithoutPackage());
        this.addImport(rafe.getType());
        buffer.append('(');
        buffer.append(this.getConfString(rafe, "path", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_PATH"));
        buffer.append(",\n");
        this.incindent();
        buffer = this.indent(buffer);
        buffer.append(this.getConfString(element, "name", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_NAME"));
        buffer.append(",\n");
        buffer = this.indent(buffer);
        buffer.append(this.getConfString(element, "mode", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_MODE"));
        buffer.append(')');
        this.decindent();
        return buffer.toString();
    }

    protected String getNewSSLConnection(TagElement element) {
        return this.getNewTcpipConnection(element);
    }

    protected String getNewSSLServerConnection(TagElement element) {
        return this.getNewTcpipServerConnection(element);
    }

    protected String getNewScale(TagElement element) {
        StringBuffer buffer = new StringBuffer(32);
        String value = this.outputString(element.getTextData());
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(element.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append('(');
        int index = value.indexOf(47, 0);
        if (index == -1) {
            buffer.append(value);
        } else {
            String as = value.substring(0, index);
            int a = Integer.parseInt(as);
            String bs = value.substring(index + 1);
            int b = Integer.parseInt(bs);
            int gcd = DeviceKitUtilities.gcd(a, b);
            buffer.append(a / gcd);
            buffer.append(", ");
            buffer.append(b / gcd);
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected String getNewSeqment(TagElement element) {
        if (element instanceof SegmentElement) {
            SegmentElement segmentElement = (SegmentElement)element;
            StringBuffer buffer = new StringBuffer(32);
            buffer.append("new ");
            buffer.append(element.getTypeWithoutPackage());
            this.addImport(element.getType());
            buffer.append('(');
            buffer = this.indent(buffer);
            SegmentElement segmentElementReal = segmentElement;
            if (segmentElement.getIdRef() != null) {
                segmentElementReal = (SegmentElement)TagElement.collection.getParameter(segmentElement.getIdRef());
            }
            String key = segmentElementReal.getKey();
            boolean needComma = false;
            if (key != null) {
                buffer.append(DeviceKitUtilities.stripPackage(this.fServiceClass));
                buffer.append('.');
                buffer.append(key);
                needComma = true;
            } else if (segmentElementReal.getParent() != null && segmentElementReal.getParent().getTagCode() == 23) {
                String parentId = segmentElementReal.getParent().getId();
                if (parentId == null) {
                    parentId = "";
                }
                throw this.error(String.valueOf(Nls.format(DeviceKitGeneratorMessages.getString("DkNewCodeGenerator.error.no.id"), parentId)) + segmentElementReal.toString());
            }
            if (needComma) {
                buffer.append(',');
                buffer.append('\n');
                buffer = this.indent(buffer);
            }
            int min = segmentElement.getOccursminimum();
            int max = segmentElement.getOccursmaximum();
            if (!(segmentElement instanceof ChoiceSegmentElement)) {
                buffer.append(this.getBytes(segmentElementReal, true));
                buffer.append(", ");
                buffer.append(this.getFilters(segmentElementReal));
                buffer.append(", ");
                buffer.append(this.getParameters(segmentElementReal, segmentElementReal.getParameterChildren()));
                if (min > 1 || max > 1) {
                    buffer.append(',');
                    buffer.append(segmentElement.getOccursminimumString());
                    buffer.append(',');
                    buffer.append(segmentElement.getOccursmaximumString());
                }
            } else {
                buffer.append(this.getParametersArray(segmentElementReal, segmentElementReal.getParameterChildren(), DeviceKitGenerationConstants.CLASS_SEGMENT_SERVICE));
                if (min != 1 || max != 1) {
                    buffer.append(',');
                    buffer.append(segmentElement.getOccursminimumString());
                    buffer.append(',');
                    buffer.append(segmentElement.getOccursmaximumString());
                }
            }
            buffer.append(')');
            return buffer.toString();
        }
        throw new IllegalArgumentException(String.valueOf(element));
    }

    protected String getNewSerialConnection(TagElement element) {
        StringBuffer buffer = new StringBuffer(256);
        this.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_SERIAL);
        SerialElement se = (SerialElement)element;
        this.incindent();
        buffer = this.indent(buffer);
        buffer.append('\n');
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(se.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append("(\n");
        this.incindent();
        buffer = this.indent(buffer);
        String configKey = this.getConfigurationKey(se);
        String portName = se.getComport();
        int port = new Integer(portName);
        if (port < 1) {
            throw this.error(String.valueOf(Nls.format(DeviceKitGeneratorMessages.getString("DkNewCodeGenerator.error.invalid.comport"), portName)) + element.toString());
        }
        buffer.append(this.codeGetInt(configKey, "comport", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_COMPORT"));
        buffer.append(", \n");
        buffer = this.indent(buffer);
        String baudString = se.getBaudRate();
        buffer.append(this.codeGetInt(configKey, "baudrate", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_BAUDRATE"));
        buffer.append(", \n");
        buffer = this.indent(buffer);
        String dataBits = se.getDataBits();
        buffer.append(this.codeGetInt(configKey, "databits", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_DATABITS"));
        buffer.append(", \n");
        buffer = this.indent(buffer);
        buffer.append(this.codeGetInt(configKey, "parity", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_PARITY"));
        buffer.append(", \n");
        buffer = this.indent(buffer);
        String stopBits = se.getStopBits();
        buffer.append(this.codeGetInt(configKey, "stopbits", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_STOPBITS"));
        buffer.append(", \n");
        buffer = this.indent(buffer);
        String hardwareFlowControl = se.getHwFlowControl();
        buffer.append(this.codeGetInt(configKey, "hardwareflowcontrol", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_HWFLOW"));
        buffer.append(", \n");
        buffer = this.indent(buffer);
        String softwareFlowControl = se.getSwFlowControl();
        buffer.append(this.codeGetInt(configKey, "softwareflowcontrol", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_SWFLOW"));
        buffer.append(", \n");
        buffer = this.indent(buffer);
        String readTotalTimeout = se.getReadTotalTimeout();
        buffer.append(this.codeGetInt(configKey, "readtotaltimeout", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_READTOTALTIMEOUT"));
        buffer.append(", \n");
        buffer = this.indent(buffer);
        String readIntervalTimeout = se.getReadIntervalTimeout();
        buffer.append(this.codeGetInt(configKey, "readintervaltimeout", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_READINTERVALTIMEOUT"));
        buffer.append(", \n");
        buffer = this.indent(buffer);
        String writeTotalTimeout = se.getWriteTotalTimeout();
        buffer.append(this.codeGetInt(configKey, "writetotaltimeout", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_WRITETOTALTIMEOUT"));
        buffer = this.indent(buffer);
        buffer.append(')');
        this.decindent();
        if (configKey != null) {
            EscPropertiesModel model = EscPropertiesModel.getModel();
            model.addProperty(String.valueOf(configKey) + ".comport", portName);
            model.addProperty(String.valueOf(configKey) + ".baudrate", baudString);
            model.addProperty(String.valueOf(configKey) + ".databits", dataBits);
            model.addProperty(String.valueOf(configKey) + ".parity", se.getParityAsInt());
            model.addProperty(String.valueOf(configKey) + ".stopbits", stopBits);
            model.addProperty(String.valueOf(configKey) + ".hardwareflowcontrol", hardwareFlowControl);
            model.addProperty(String.valueOf(configKey) + ".softwareflowcontrol", softwareFlowControl);
            model.addProperty(String.valueOf(configKey) + ".readtotaltimeout", readTotalTimeout);
            model.addProperty(String.valueOf(configKey) + ".readintervaltimeout", readIntervalTimeout);
            model.addProperty(String.valueOf(configKey) + ".writetotaltimeout", writeTotalTimeout);
        }
        return buffer.toString();
    }

    protected String getNewSignal(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        Vector transforms = element.getTransformChildren();
        Vector messages = element.getMessageChildren();
        Vector parameters = element.getParameterChildrenAll();
        boolean isConcrete = element.isChildOfCode(18);
        boolean hasMessageParam = false;
        if (messages.size() > 0) {
            TagElement me = (TagElement)messages.get(0);
            String idref = me.getAttribute("idref");
            if (idref != null) {
                me = TagElement.collection.getMessage(idref);
            }
            hasMessageParam = me.getParameterChildrenAll().size() > 0;
        }
        buffer.append('\n');
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(element.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append("(\n");
        this.incindent();
        buffer = this.indent(buffer);
        buffer.append(this.getKey(element));
        if (element instanceof SignalElement) {
            ControlItem signalElement = (ControlItem)element;
            String field = signalElement.getField();
            if (isConcrete && field != null && field.length() > 0) {
                buffer.append(", \n");
                buffer = this.indent(buffer);
                Vector signals = element.getAllChildrenWithTagCode(3);
                if (signals.size() == 1) {
                    ControlItem target = (ControlItem)signals.elementAt(0);
                    buffer.append(this.getSignal(target));
                    buffer.append(',');
                }
                buffer.append(this.quote(field));
            } else if (messages.size() > 0) {
                if (isConcrete || parameters.size() > 0) {
                    buffer.append(", \n");
                    buffer = this.indent(buffer);
                    buffer.append(this.getMessages(element));
                    buffer.append(", \n");
                    buffer = this.indent(buffer);
                    buffer.append(this.getTransforms(element));
                    buffer.append(", \n");
                    buffer = this.indent(buffer);
                    buffer.append(this.getParameters(element));
                } else if (transforms.size() > 0 || messages.size() > 0 && hasMessageParam) {
                    buffer.append(", \n");
                    buffer = this.indent(buffer);
                    buffer.append(this.getMessages(element));
                    if (transforms.size() > 0) {
                        buffer.append(", \n");
                        buffer = this.indent(buffer);
                        buffer.append(this.getTransforms(element));
                    }
                } else if (messages.size() != 0) {
                    buffer.append(", \n");
                    buffer = this.indent(buffer);
                    buffer.append(this.getMessages(element));
                }
            } else if (field != null && field.length() > 0) {
                buffer.append(", \n");
                buffer = this.indent(buffer);
                Vector signals = element.getAllChildrenWithTagCode(3);
                if (signals.size() == 1) {
                    ControlItem target = (ControlItem)signals.elementAt(0);
                    buffer.append(this.getSignal(target));
                    buffer.append(',');
                }
                buffer.append(this.quote(field));
            }
        }
        this.decindent();
        buffer.append(')');
        return buffer.toString();
    }

    protected String getNewSpecificParameter(TagElement element) {
        if (element instanceof SegmentElement) {
            return this.getNewSeqment(element);
        }
        StringBuffer buffer = new StringBuffer(32);
        ParameterElement parameter = (ParameterElement)element;
        buffer.append("new ");
        buffer.append(parameter.getTypeWithoutPackage());
        this.addImport(parameter.getType());
        buffer.append('(');
        String key = parameter.getKey();
        boolean needComma = false;
        if (key != null) {
            buffer.append(DeviceKitUtilities.stripPackage(this.fServiceClass));
            buffer.append('.');
            String correctKey = CodeUtilities.staticFieldName(key);
            buffer.append(correctKey);
            needComma = true;
        } else if (parameter.getParent() != null && parameter.getParent().getTagCode() == 23) {
            String parentId = element.getParent().getId();
            if (parentId == null) {
                parentId = "";
            }
            throw this.error(String.valueOf(Nls.format(DeviceKitGeneratorMessages.getString("DkNewCodeGenerator.error.no.id"), parentId)) + parameter.toString());
        }
        if (element instanceof VariableLengthParameterElement || element instanceof MultiParameterElement) {
            if (needComma) {
                buffer.append(", ");
            }
            buffer.append(this.getParametersArray(element, element.getParameterChildren()));
            needComma = true;
        } else {
            BlockElement blockElement;
            String bytesCode;
            if (element instanceof BlockElement && (bytesCode = (blockElement = (BlockElement)element).getBytesCodeString()).length() > 0) {
                if (needComma) {
                    buffer.append(", ");
                }
                buffer.append(bytesCode);
                needComma = true;
            }
            int offset = parameter.getBitOffsetValue(0);
            int length = parameter.getBitLengthValue(0);
            String offsetString = parameter.getOffset();
            String indexString = parameter.getIndex();
            boolean insert = parameter.getInsert();
            if (insert) {
                this.addImport(DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE);
                String parameterService = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE);
                if (offsetString != null || indexString != null) {
                    if (needComma) {
                        buffer.append(", ");
                    }
                    buffer.append(offset);
                    needComma = true;
                } else {
                    if (needComma) {
                        buffer.append(", ");
                    }
                    buffer.append(parameterService);
                    buffer.append(".USE_CURSOR_INSERT");
                    needComma = true;
                }
                String lengthString = parameter.getLength();
                String sizeString = parameter.getSize();
                if (lengthString != null || sizeString != null) {
                    if (needComma) {
                        buffer.append(", ");
                    }
                    buffer.append(length);
                } else {
                    if (needComma) {
                        buffer.append(", ");
                    }
                    buffer.append(parameterService);
                    buffer.append(".USE_CURSOR_INSERT");
                }
            } else {
                if (offsetString != null || indexString != null) {
                    if (needComma) {
                        buffer.append(", ");
                    }
                    buffer.append(offset);
                    needComma = true;
                }
                String lengthString = parameter.getLength();
                String sizeString = parameter.getSize();
                if (lengthString != null || sizeString != null) {
                    if (needComma) {
                        buffer.append(", ");
                    }
                    buffer.append(length);
                }
            }
        }
        buffer.append(')');
        return buffer.toString();
    }

    protected String getNewTcpipConnection(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        TcpipElement tcpip = (TcpipElement)element;
        buffer.append('\n');
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(tcpip.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append("(\n");
        this.incindent();
        buffer = this.indent(buffer);
        String remotePort = tcpip.getRemotePort();
        String host = tcpip.getHost();
        String localPort = tcpip.getLocalPort();
        String readTimeout = tcpip.getReadTimeout();
        String linger = tcpip.getLinger();
        buffer.append(this.getConfString(tcpip, "host", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_HOST"));
        buffer.append(',');
        buffer.append('\n');
        buffer = this.indent(buffer);
        String configKey = this.getConfigurationKey(tcpip);
        buffer.append(this.codeGetInt(configKey, "remoteport", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_REMOTEPORT"));
        buffer.append(",\n");
        buffer = this.indent(buffer);
        buffer.append(this.codeGetInt(configKey, "localport", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_LOCALPORT"));
        buffer.append(",\n");
        buffer = this.indent(buffer);
        buffer.append(this.codeGetInt(configKey, "readtimeout", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_READTIMEOUT"));
        buffer.append(",\n");
        buffer = this.indent(buffer);
        buffer.append(this.codeGetInt(configKey, "readsize", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_READSIZE"));
        buffer.append(", \n");
        buffer = this.indent(buffer);
        buffer.append(this.codeGetInt(configKey, "writesize", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_WRITESIZE"));
        buffer.append(", \n");
        buffer = this.indent(buffer);
        buffer.append(this.codeGetInt(configKey, "linger", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_LINGER"));
        buffer.append(')');
        this.decindent();
        String readSize = tcpip.getReadSize();
        String writeSize = tcpip.getWriteSize();
        if (configKey != null) {
            EscPropertiesModel model = EscPropertiesModel.getModel();
            model.addProperty(String.valueOf(configKey) + ".linger", linger);
            model.addProperty(String.valueOf(configKey) + ".writesize", writeSize);
            model.addProperty(String.valueOf(configKey) + ".readsize", readSize);
            model.addProperty(String.valueOf(configKey) + ".readtimeout", readTimeout);
            model.addProperty(String.valueOf(configKey) + ".localport", localPort);
            model.addProperty(String.valueOf(configKey) + ".remoteport", remotePort);
            model.addProperty(String.valueOf(configKey) + ".host", host);
        }
        return buffer.toString();
    }

    protected String getNewTcpipServerConnection(TagElement element) {
        StringBuffer buffer = new StringBuffer(128);
        TcpipServerElement tcpip = (TcpipServerElement)element;
        buffer.append('\n');
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(tcpip.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append("(\n");
        String port = tcpip.getPort();
        String configKey = this.getConfigurationKey(tcpip);
        buffer.append(this.codeGetInt(configKey, "port", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_PORT"));
        buffer.append(')');
        if (configKey != null) {
            EscPropertiesModel.getModel().addProperty(String.valueOf(configKey) + ".port", port);
        }
        return buffer.toString();
    }

    protected String getNewTransform(TagElement element) {
        StringBuffer buffer = new StringBuffer(32);
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(element.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append('(');
        buffer.append(this.outputString(element.getTextData()));
        buffer.append(')');
        return buffer.toString();
    }

    protected String getNewUnits(TagElement element) {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append('\n');
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(element.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append("(\n");
        this.incindent();
        buffer = this.indent(buffer);
        buffer.append(this.quote(this.outputString(element.getTextData())));
        buffer.append(')');
        this.decindent();
        return buffer.toString();
    }

    protected String getNewUrlConnection(TagElement element) {
        String url;
        StringBuffer buffer = new StringBuffer(128);
        UrlConnectionElement ue = (UrlConnectionElement)element;
        String defaultValue = this.outputString(ue.getTextData());
        if (defaultValue == null) {
            defaultValue = "";
        }
        if ((url = ue.getUrl()) == null) {
            url = defaultValue;
        }
        buffer.append("new ");
        buffer.append(ue.getTypeWithoutPackage());
        this.addImport(ue.getType());
        buffer.append('(');
        buffer.append(this.getConfString(ue, "url", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_URL"));
        buffer.append(')');
        if (this.getConfigurationKey(ue) != null) {
            EscPropertiesModel.getModel().addProperty(String.valueOf(this.getConfigurationKey(ue)) + ".url", url);
        }
        return buffer.toString();
    }

    protected String getNewUsbConnection(TagElement element) {
        StringBuffer buffer = new StringBuffer(256);
        this.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_USB);
        UsbElement ue = (UsbElement)element;
        String productId = ue.getProductId();
        String usagePage = ue.getUsagePage();
        String usage = ue.getUsage();
        buffer.append('\n');
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(ue.getTypeWithoutPackage());
        this.addImport(element.getType());
        buffer.append("(\n");
        this.incindent();
        buffer = this.indent(buffer);
        String configKey = this.getConfigurationKey(ue);
        String vendorId = ue.getVendorId();
        buffer.append(this.codeGetInt(configKey, "vendorid", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_VENDORID"));
        buffer.append(", \n");
        buffer = this.indent(buffer);
        buffer.append(this.codeGetInt(configKey, "productid", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_PRODUCTID"));
        buffer.append(", \n");
        buffer = this.indent(buffer);
        buffer.append(this.codeGetInt(configKey, "usagepage", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_USAGEPAGE"));
        buffer.append(", \n");
        buffer = this.indent(buffer);
        buffer.append(this.codeGetInt(configKey, "usage", String.valueOf(DeviceKitUtilities.stripPackage(this.fServiceClass)) + '.' + "DEFAULT_USAGE"));
        buffer.append(')');
        this.decindent();
        if (configKey != null) {
            EscPropertiesModel model = EscPropertiesModel.getModel();
            model.addProperty(String.valueOf(configKey) + ".vendorid", vendorId);
            model.addProperty(String.valueOf(configKey) + ".productid", productId);
            model.addProperty(String.valueOf(configKey) + ".usagepage", usagePage);
            model.addProperty(String.valueOf(configKey) + ".usage", usage);
        }
        return buffer.toString();
    }

    protected String getParameter(TagElement parameter) {
        return this.getParameter(parameter, false);
    }

    protected String getParameter(TagElement parameter, boolean extraLines) {
        String extendedName = "";
        if (parameter instanceof SegmentElement && parameter.getAttribute("idref") != null) {
            SegmentElement segmentElement = (SegmentElement)parameter;
            String max = segmentElement.getOccursmaximumRaw();
            String min = segmentElement.getOccursminimumRaw();
            if (min != null || max != null) {
                extendedName = "_" + segmentElement.getOccursminimumStringName() + '_' + segmentElement.getOccursmaximumStringName();
                String idref = parameter.getAttribute("idref");
                if (idref != null && idref.equals(parameter.getParent().getId())) {
                    StringBuffer buffer = new StringBuffer(32);
                    String type = parameter.getType();
                    if (extraLines) {
                        buffer.append('\n');
                        buffer = this.indent(buffer);
                        buffer.append("// ");
                        buffer.append(type);
                        buffer.append('\n');
                        buffer = this.indent(buffer);
                    }
                    buffer.append("new ");
                    buffer.append(DeviceKitUtilities.stripPackage(type));
                    this.addImport(type);
                    buffer.append('(');
                    buffer.append(this.quote(String.valueOf(idref) + extendedName));
                    buffer.append(')');
                    return buffer.toString();
                }
            }
        }
        StringBuffer buffer = new StringBuffer(32);
        if (parameter.getId() != null || parameter.getAttribute("idref") != null) {
            boolean inMessageClass = true;
            String key = null;
            key = parameter.getId() != null ? parameter.getId() : parameter.getAttribute("idref");
            if (parameter.isMessageClassElement() && !this.fMainClass.equals(this.fMessageClass)) {
                this.addImport(this.fMessageClass);
                if (extraLines) {
                    buffer.append('\n');
                    buffer = this.indent(buffer);
                    buffer.append("// ");
                    buffer.append(String.valueOf(key) + extendedName);
                    buffer.append('\n');
                    buffer = this.indent(buffer);
                }
                buffer.append(DeviceKitUtilities.stripPackage(this.fMessageClass));
                buffer.append('.');
                buffer.append("get");
                buffer.append(CodeUtilities.methodName(String.valueOf(key) + extendedName));
                buffer.append('(');
                buffer.append("");
                buffer.append(')');
                inMessageClass = false;
            }
            if (inMessageClass) {
                if (extraLines) {
                    buffer.append('\n');
                    buffer = this.indent(buffer);
                    buffer.append("// ");
                    buffer.append(String.valueOf(key) + extendedName);
                    buffer.append('\n');
                    buffer = this.indent(buffer);
                }
                buffer.append("get");
                buffer.append(CodeUtilities.methodName(String.valueOf(key) + extendedName));
                buffer.append('(');
                buffer.append("");
                buffer.append(')');
            }
        } else {
            buffer.append(this.getNewCode(this.fIndent, parameter));
        }
        return buffer.toString();
    }

    protected String getParameterStyle(ParameterElement parameter) {
        StringBuffer buffer = new StringBuffer(32);
        Vector styles = this.getParameterStyles(parameter);
        switch (styles.size()) {
            case 0: {
                buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE));
                buffer.append(".NULL");
                this.addImport(DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE);
                break;
            }
            case 1: {
                buffer.append(styles.elementAt(0).toString());
                break;
            }
            default: {
                int i = 0;
                while (i < styles.size()) {
                    if (i == 0) {
                        buffer.append("(short)(");
                    } else {
                        buffer.append(" + ");
                    }
                    Object object = styles.elementAt(i);
                    buffer.append(object.toString());
                    ++i;
                }
                buffer.append(')');
            }
        }
        return buffer.toString();
    }

    protected Vector getParameterStyles(ParameterElement parameter) {
        String name = parameter.getAttribute("type");
        Vector<String> styles = new Vector<String>();
        String parameterService = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE);
        if (parameter.getAllChildrenWithTagCode(41).size() > 0) {
            styles.addElement(String.valueOf(parameterService) + ".LITTLEENDIAN");
        }
        if (parameter.getAllChildrenWithTagCode(42).size() > 0) {
            styles.addElement(String.valueOf(parameterService) + ".UNSIGNED");
        }
        if (name != null) {
            String baseName = name;
            if (name.startsWith("u")) {
                styles.addElement(String.valueOf(parameterService) + ".UNSIGNED");
                baseName = name.substring(1);
            }
            if (name.equals("boolean")) {
                styles.addElement(String.valueOf(parameterService) + ".BOOLEAN");
            } else if (name.equals("float")) {
                styles.addElement(String.valueOf(parameterService) + ".FLOAT");
            } else if (baseName.equals("long")) {
                styles.addElement(String.valueOf(parameterService) + ".LONG");
            } else if (baseName.equals("short")) {
                styles.addElement(String.valueOf(parameterService) + ".SHORT");
            } else if (name.equals("double")) {
                styles.addElement(String.valueOf(parameterService) + ".DOUBLE");
            } else if (name.equals("string")) {
                styles.addElement(String.valueOf(parameterService) + ".STRING");
            } else if (name.equals("bytes")) {
                styles.addElement(String.valueOf(parameterService) + ".BYTES");
            } else if (name.equals("numericstring")) {
                styles.addElement(String.valueOf(parameterService) + ".NSTRING");
            } else if (name.equals("nstring")) {
                styles.addElement(String.valueOf(parameterService) + ".NSTRING");
            } else if (name.equals("hexstring")) {
                styles.addElement(String.valueOf(parameterService) + ".HEXSTRING");
            } else if (name.equals("hexascii")) {
                styles.addElement(String.valueOf(parameterService) + ".HEXASCII");
            } else if (name.equals("asciistring")) {
                styles.addElement(String.valueOf(parameterService) + ".ASCIISTRING");
            } else if (name.equals("ascii")) {
                styles.addElement(String.valueOf(parameterService) + ".ASCII");
            } else if (name.equals("nascii")) {
                styles.addElement(String.valueOf(parameterService) + ".NASCII");
            } else if (name.equals("asciiz")) {
                styles.addElement(String.valueOf(parameterService) + ".ASCIIZ");
            }
        }
        if (parameter.getInsert()) {
            styles.addElement(String.valueOf(parameterService) + ".INSERT");
        }
        if (styles.size() > 0) {
            this.addImport(DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE);
        }
        return styles;
    }

    protected String getParameters(TagElement element) {
        Vector list = element.getParameterChildrenAll();
        return this.getParameters(element, list);
    }

    protected String getParameters(TagElement element, Vector list) {
        StringBuffer buffer = new StringBuffer(32);
        switch (list.size()) {
            case 0: {
                buffer.append("null");
                break;
            }
            case 1: {
                buffer.append(this.getParameter((TagElement)list.elementAt(0)));
                break;
            }
            default: {
                String type = element.getAttribute("type");
                String key = element.getKey();
                buffer.append("new ");
                int constantCount = 0;
                int parameterCount = 0;
                int newParameterCount = 0;
                int i = 0;
                while (i < list.size()) {
                    TagElement tagElement = (TagElement)list.elementAt(i);
                    if (tagElement.isConstantParameter()) {
                        ++constantCount;
                    } else {
                        ++parameterCount;
                    }
                    if (tagElement instanceof GeneralParameterElement) {
                        ++newParameterCount;
                    }
                    ++i;
                }
                String defaultClass = DeviceKitGenerationConstants.CLASS_PARAMETERS;
                if (parameterCount == 1) {
                    defaultClass = DeviceKitGenerationConstants.CLASS_MAP_PARAMETER;
                    if (element instanceof SingleParameterSegmentElement) {
                        defaultClass = DeviceKitGenerationConstants.CLASS_SINGLE_PARAMETER;
                    }
                } else if (newParameterCount > 0) {
                    defaultClass = DeviceKitGenerationConstants.CLASS_MAP_PARAMETER;
                }
                if (type != null) {
                    if (type.toLowerCase().equals("map")) {
                        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_PARAMETERS_MAP));
                        this.addImport(DeviceKitGenerationConstants.CLASS_PARAMETERS_MAP);
                    } else if (type.toLowerCase().equals("list")) {
                        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_PARAMETERS_LIST));
                        this.addImport(DeviceKitGenerationConstants.CLASS_PARAMETERS_LIST);
                    } else if (type.indexOf(40) != -1) {
                        if (type.indexOf(46) == -1) {
                            throw this.error(String.valueOf(DeviceKitGeneratorMessages.getString("DkNewCodeGenerator.error.invalid.custom.parameter")) + element.toString());
                        }
                        buffer.append(key);
                    } else {
                        buffer.append(DeviceKitUtilities.stripPackage(defaultClass));
                        this.addImport(defaultClass);
                    }
                } else {
                    buffer.append(DeviceKitUtilities.stripPackage(defaultClass));
                    this.addImport(defaultClass);
                }
                buffer.append('(');
                buffer = this.indent(buffer);
                if (key != null) {
                    buffer.append(this.quote(key));
                } else {
                    buffer.append(this.quote(""));
                }
                buffer.append(", ");
                buffer.append('\n');
                buffer = this.indent(buffer);
                buffer.append("new ");
                buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE));
                this.addImport(DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE);
                buffer.append("[]");
                buffer.append(' ');
                buffer.append('{');
                this.incindent();
                buffer = this.indent(buffer);
                int i2 = 0;
                while (i2 < list.size()) {
                    if (i2 != 0) {
                        buffer.append(", ");
                        buffer.append('\n');
                        buffer = this.indent(buffer);
                    }
                    buffer.append(this.getParameter((TagElement)list.elementAt(i2), true));
                    ++i2;
                }
                buffer.append('\n');
                this.decindent();
                buffer = this.indent(buffer);
                buffer.append('}');
                buffer.append(')');
                this.decindent();
            }
        }
        return buffer.toString();
    }

    protected String getParametersArray(TagElement element) {
        Vector list = element.getParameterChildrenAll();
        return this.getParametersArray(element, list, DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE);
    }

    protected String getParametersArray(TagElement element, Vector list) {
        return this.getParametersArray(element, list, DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE);
    }

    protected String getParametersArray(TagElement element, Vector list, String className) {
        StringBuffer buffer = new StringBuffer(32);
        switch (list.size()) {
            case 0: {
                buffer.append("null");
                break;
            }
            default: {
                buffer.append('\n');
                buffer = this.indent(buffer);
                buffer.append("new ");
                buffer.append(DeviceKitUtilities.stripPackage(className));
                this.addImport(className);
                buffer.append("[]");
                buffer.append(' ');
                buffer.append('{');
                this.incindent();
                buffer = this.indent(buffer);
                int i = 0;
                while (i < list.size()) {
                    TagElement messageClassItem = (TagElement)list.elementAt(i);
                    if (i != 0) {
                        buffer.append(", ");
                    }
                    buffer.append(this.getParameter(messageClassItem, true));
                    ++i;
                }
                buffer.append('\n');
                this.decindent();
                buffer = this.indent(buffer);
                buffer.append('}');
                this.decindent();
            }
        }
        return buffer.toString();
    }

    protected String getPrimitiveType(String tag) {
        if ("int".equals(tag)) {
            return "Integer";
        }
        if ("short".equals(tag)) {
            return "Short";
        }
        if ("long".equals(tag)) {
            return "Long";
        }
        if ("byte".equals(tag)) {
            return "Byte";
        }
        if ("double".equals(tag)) {
            return "Double";
        }
        if ("float".equals(tag)) {
            return "Float";
        }
        if ("char".equals(tag)) {
            return "Character";
        }
        return tag;
    }

    protected String getPriority() {
        return null;
    }

    protected String getReadCommand(ReadCommandElement element) {
        StringBuffer buffer = new StringBuffer(32);
        String idref = element.getAttribute("idref");
        if (idref != null && idref.length() > 0) {
            CodeUtilities.fieldReference(idref, this.lazy, buffer);
        } else {
            buffer.append("null");
        }
        return buffer.toString();
    }

    protected String getSentMessage(SentMessageElement element, TagElement message) {
        StringBuffer buffer = new StringBuffer(64);
        if (element.getMessageId() != null) {
            String key = element.getMessageId();
            if (message.isMessageClassElement() && !this.fMainClass.equals(this.fMessageClass)) {
                this.addImport(this.fMessageClass);
                buffer.append(DeviceKitUtilities.stripPackage(this.fMessageClass));
                buffer.append('.');
            }
            buffer.append("get");
            buffer.append(CodeUtilities.methodName(key));
            buffer.append("()");
        } else {
            buffer.append(this.getNewMessage(message));
        }
        return buffer.toString();
    }

    protected String getSignal(ControlItem si) {
        StringBuffer buffer = new StringBuffer(32);
        String id = si.getId();
        if (id == null) {
            id = si.getAttribute("idref");
        }
        if (id != null) {
            CodeUtilities.fieldReference(id, this.lazy, buffer);
            return buffer.toString();
        }
        return "null";
    }

    protected String getTransform(TransformItem ti) {
        StringBuffer buffer = new StringBuffer(32);
        String id = ti.getId();
        if (id == null) {
            id = ti.getAttribute("idref");
        }
        if (id != null) {
            if (ti.isChildOfCode(7)) {
                buffer.append("get");
                buffer.append(id);
                buffer.append("()");
                return buffer.toString();
            }
            buffer.append(DeviceKitUtilities.stripPackage(this.fMessageClass));
            buffer.append(".get");
            buffer.append(id);
            buffer.append("()");
            return buffer.toString();
        }
        return this.getNewCode(this.fIndent, ti);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected String getTransforms(TagElement element) {
        StringBuffer buffer = new StringBuffer(32);
        Vector transforms = element.getTransformChildren();
        if (transforms.size() <= 0) {
            buffer.append("null");
            return buffer.toString();
        }
        if (transforms.size() == 1) {
            buffer.append(this.getTransform((TransformItem)transforms.elementAt(0)));
            return buffer.toString();
        }
        buffer.append("new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSFORMS));
        this.addImport(DeviceKitGenerationConstants.CLASS_TRANSFORMS);
        buffer.append('(');
        buffer.append("\n ");
        this.incindent();
        buffer = this.indent(buffer);
        buffer.append("new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSFORM_SERVICE));
        this.addImport(DeviceKitGenerationConstants.CLASS_TRANSFORM_SERVICE);
        buffer.append("[] {\n");
        this.incindent();
        buffer = this.indent(buffer);
        int i = 0;
        while (i < transforms.size()) {
            if (i != 0) {
                buffer.append(", \n");
                buffer = this.indent(buffer);
            }
            buffer.append(this.getTransform((TransformItem)transforms.elementAt(i)));
            ++i;
        }
        buffer.append('\n');
        this.decindent();
        buffer = this.indent(buffer);
        buffer.append('}');
        buffer.append(" \n");
        this.decindent();
        buffer = this.indent(buffer);
        buffer.append(')');
        return buffer.toString();
    }

    protected String getUnits(TagElement element) {
        StringBuffer buffer = new StringBuffer(32);
        Vector units = element.getAllChildrenWithTagCodes(new int[]{4, 1004});
        if (units.size() > 0) {
            UnitsLinkElement ule;
            TagElement real;
            if (((TagElement)units.elementAt(0)).getId() != null) {
                UnitsElement ue = (UnitsElement)units.elementAt(0);
                if (this.lazy) {
                    buffer.append("get");
                    buffer.append(ue.getId());
                    buffer.append("()");
                } else {
                    buffer.append(ue.getId());
                }
            } else if (((TagElement)units.elementAt(0)).getAttribute("idref") != null && (real = (ule = (UnitsLinkElement)units.elementAt(0)).getRealElement()) != null) {
                if (real.isChildOfCode(7)) {
                    buffer.append(DeviceKitUtilities.stripPackage(this.fMessageClass));
                    buffer.append(".get");
                    buffer.append(real.getId());
                    buffer.append("()");
                    return buffer.toString();
                }
                if (this.lazy) {
                    buffer.append("get");
                    buffer.append(real.getId());
                    buffer.append("()");
                } else {
                    buffer.append(real.getId());
                }
            }
        } else {
            buffer.append("null");
        }
        return buffer.toString();
    }

    protected String getValue(ValueElement element) {
        StringBuffer buffer = new StringBuffer(32);
        String value = null;
        String tag = null;
        boolean cast = false;
        Vector listChildren = element.getAllChildrenWithTagCode(90);
        Vector mapChildren = element.getAllChildrenWithTagCode(89);
        Vector bytesChildren = element.getAllChildrenWithTagCode(12);
        if (element.getInt() != null) {
            value = element.getInt();
            if (value != null) {
                buffer.append("new ");
                buffer.append(this.getPrimitiveType("int"));
                buffer.append('(');
                buffer.append(value);
                buffer.append(')');
                return buffer.toString();
            }
        } else {
            if (bytesChildren != null && bytesChildren.size() > 0) {
                value = this.getNewBytes((TagElement)bytesChildren.get(0));
                buffer.append(value);
                return buffer.toString();
            }
            if (mapChildren != null && mapChildren.size() > 0) {
                value = "";
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.util.Hashtable");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                tag = clazz.getName();
            } else if (listChildren != null && listChildren.size() > 0) {
                value = "";
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.util.Vector");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                tag = clazz.getName();
            } else if (element.getDouble() != null) {
                value = element.getDouble();
                tag = "double";
            } else if (element.getFloat() != null) {
                value = element.getFloat();
                tag = "float";
            } else if (element.getLong() != null) {
                value = element.getLong();
                tag = "long";
            } else if (element.getChar() != null) {
                value = element.getChar();
                value = DeviceKitUtilities.character(value);
                tag = "char";
            } else {
                if (element.getString() != null) {
                    value = element.getString();
                    value = DeviceKitUtilities.quote(value);
                    tag = "String";
                    return value;
                }
                if (element.getByte() != null) {
                    value = element.getByte();
                    tag = "byte";
                    cast = true;
                } else if (element.getShort() != null) {
                    value = element.getShort();
                    tag = "short";
                    cast = true;
                } else if (element.getBoolean() != null) {
                    value = element.getBoolean();
                    tag = "boolean";
                    if (Boolean.valueOf(value).booleanValue()) {
                        return "Boolean.TRUE";
                    }
                    return "Boolean.FALSE";
                }
            }
        }
        if (value != null) {
            buffer.append("new ");
            buffer.append(this.getPrimitiveType(tag));
            buffer.append('(');
            if (cast) {
                buffer.append('(');
                buffer.append(tag);
                buffer.append(')');
            }
            buffer.append(value);
            buffer.append(')');
            return buffer.toString();
        }
        value = this.outputString(element.getTextData());
        if (value == null) {
            buffer.append("null");
        } else {
            buffer.append(this.quote(value));
        }
        return buffer.toString();
    }

    protected String getWriteCommand(WriteCommandElement element) {
        StringBuffer buffer = new StringBuffer(32);
        String idref = element.getAttribute("idref");
        if (idref != null && idref.length() > 0) {
            CodeUtilities.fieldReference(idref, this.lazy, buffer);
        } else {
            buffer.append("null");
        }
        return buffer.toString();
    }

    protected void incindent() {
        ++this.fIndent;
    }

    protected StringBuffer indent(StringBuffer buffer) {
        int i = 0;
        while (i < this.fIndent) {
            buffer.append('\t');
            ++i;
        }
        return buffer;
    }

    protected boolean isSimpleFilter(FilterElement filter) {
        byte[] bytes = filter.getBytes();
        if (bytes != null) {
            int start = 0;
            start = 0;
            while (start < bytes.length) {
                if (bytes[start] != 0) break;
                ++start;
            }
            int end = 0;
            end = bytes.length - 1;
            while (end >= 0) {
                if (bytes[end] != 0) break;
                --end;
            }
            int i = start;
            while (i <= end) {
                if (bytes[i] != -1) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String outputString(String string) {
        if (string == null) {
            return null;
        }
        StringBuffer buffer = new StringBuffer(string.length());
        int i = 0;
        while (i < string.length()) {
            char character = string.charAt(i);
            switch (character) {
                case '\r': {
                    buffer.append("\\r");
                    break;
                }
                case '\n': {
                    buffer.append("\\n");
                    break;
                }
                case '\t': {
                    buffer.append("\\t");
                    break;
                }
                case '\"': {
                    buffer.append("\\\"");
                    break;
                }
                default: {
                    buffer.append(character);
                }
            }
            ++i;
        }
        return buffer.toString();
    }

    protected String quote(String string) {
        if (string.length() == 0) {
            return "\"\"";
        }
        return "\"" + string + "\"";
    }

    public void setMessageClass(String messageClass) {
        this.fMessageClass = messageClass;
    }

    public void setMessageType(IType messageType) {
        this.messageType = messageType;
    }

    public void setServiceClass(String serviceClass) {
        this.fServiceClass = serviceClass;
    }
}

