/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model;

import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.util.CoreUtility;

public class PropertiesModel {
    protected Properties properties = new Properties();

    public void addProperties(Map map) {
        this.properties.putAll((Map<?, ?>)map);
    }

    public void addProperty(String key, String value) {
        Properties props = this.getProperties();
        if (!this.contains(key)) {
            props.put(key, value);
        }
    }

    public void addProperty(String key, boolean value) {
        this.addProperty(key, new Boolean(value).toString());
    }

    public boolean contains(String key) {
        Properties props = this.getProperties();
        return props.contains(key);
    }

    public String getContents(Map map) throws Exception {
        Properties properties = this.getProperties();
        StringBuffer buffer = new StringBuffer(1024 + properties.size() * 128);
        buffer.append(GeneratorTemplates.getCopyrightPropertyString(map));
        CoreUtility.outputPropertiesTo(buffer, (Hashtable)properties);
        return buffer.toString();
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void readProperties(InputStream inputStream) throws IOException {
        this.properties.load(inputStream);
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public String toString() {
        if (this.getProperties() != null) {
            return this.getProperties().toString();
        }
        return super.toString();
    }
}

