/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.model.elements.EnumElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class CommonConfigurationElement
extends TagElement {
    protected String minimum;
    protected String maximum;

    public CommonConfigurationElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public CommonConfigurationElement(Node node, TagElement parent, Vector references) {
        super(node, parent, references);
    }

    public String getCardinality() {
        String cardinality = this.getAttribute("cardinality");
        if (cardinality != null) {
            cardinality = cardinality.toUpperCase();
            this.validateCardinality(cardinality);
        }
        return cardinality;
    }

    public String getDefaultValue() {
        String defaultValue = this.getAttribute("defaultvalue");
        if (defaultValue != null) {
            return defaultValue;
        }
        String type = this.getValidMetaType();
        if ("Integer".equals(type)) {
            return "0";
        }
        return defaultValue;
    }

    public String getMaximum() {
        if (this.maximum != null && this.maximum.length() > 0) {
            return this.maximum;
        }
        String type = this.getValidMetaType();
        if ("Integer".equals(type)) {
            Vector list = this.getAllChildrenWithTagCode(77);
            if (list.size() > 0) {
                return String.valueOf(list.size() - 1);
            }
            return String.valueOf(Integer.MAX_VALUE);
        }
        return "";
    }

    public String getMinimum() {
        if (this.minimum != null && this.minimum.length() > 0) {
            return this.minimum;
        }
        String type = this.getValidMetaType();
        if ("Integer".equals(type)) {
            Vector list = this.getAllChildrenWithTagCode(77);
            if (list.size() > 0) {
                return "0";
            }
            return String.valueOf(Integer.MIN_VALUE);
        }
        return "";
    }

    public String getRequired() {
        String value = this.getAttribute("required");
        return value;
    }

    public String getSize() {
        String size = this.getAttribute("size");
        return size;
    }

    public int getTagCode() {
        return 0;
    }

    public String getType() {
        String type = this.getAttribute("type");
        if (type == null) {
            return "String";
        }
        return type;
    }

    public String getValidMetaType() {
        String type = this.getType();
        String ttype = type.toLowerCase();
        if (type.endsWith("[]")) {
            ttype = ttype.substring(0, ttype.length() - 2);
        }
        if ("string".equals(ttype)) {
            return "String";
        }
        if ("int".equals(ttype) || "integer".equals(ttype)) {
            return "Integer";
        }
        if ("boolean".equals(ttype) || "bool".equals(ttype)) {
            return "Boolean";
        }
        if ("char".equals(ttype) || "character".equals(ttype)) {
            return "Char";
        }
        if ("long".equals(ttype)) {
            return "Long";
        }
        if ("float".equals(ttype)) {
            return "Float";
        }
        if ("double".equals(ttype)) {
            return "Double";
        }
        if ("short".equals(ttype)) {
            return "Short";
        }
        if ("byte".equals(ttype)) {
            return "Byte";
        }
        if ("biginteger".equals(ttype)) {
            return "BigInteger";
        }
        if ("bigdecimal".equals(ttype)) {
            return "BigDecimal";
        }
        return type;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("minimum".equals(childNodeName)) {
            this.setMinimum(ParserUtilities.extractData(childNode));
        } else if ("maximum".equals(childNodeName)) {
            this.setMaximum(ParserUtilities.extractData(childNode));
        } else if ("enum".equals(childNodeName)) {
            this.addChild(new EnumElement(childNode, this));
        } else {
            super.handleChild(childNode);
        }
    }

    public void setMaximum(String maximum) {
        this.maximum = maximum;
    }

    public void setMinimum(String minimum) {
        this.minimum = minimum;
    }

    private void validateCardinality(String cardinality) {
        if (!("SCALAR".equals(cardinality) || "ARRAY".equals(cardinality) || "VECTOR".equals(cardinality))) {
            throw this.error("Invalid cardinality type - Cardinality must be set to SCALAR, ARRAY, or VECTOR.");
        }
    }
}

