/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.ValueElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class EnumElement
extends TagElement {
    protected String label;

    public EnumElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        String value = this.getTextData();
        int index = -1;
        if (value != null) {
            index = value.indexOf(47, 0);
        }
        if (index == -1) {
            return DeviceKitGenerationConstants.CLASS_TRANSFORM_INT_SCALE;
        }
        return DeviceKitGenerationConstants.CLASS_TRANSFORM_SCALE;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        return this.getKey();
    }

    public int getTagCode() {
        return 77;
    }

    public String getValue() {
        Vector list = this.getAllChildrenWithTagCode(13);
        if (list.size() > 0) {
            return this.getValue((ValueElement)list.elementAt(0));
        }
        return null;
    }

    protected String getValue(ValueElement element) {
        StringBuffer buffer = new StringBuffer(32);
        String value = null;
        Vector listChildren = element.getAllChildrenWithTagCode(90);
        Vector mapChildren = element.getAllChildrenWithTagCode(89);
        Vector bytesChildren = element.getAllChildrenWithTagCode(12);
        if (element.getInt() != null) {
            value = element.getInt();
            if (value != null) {
                buffer.append(value);
                return buffer.toString();
            }
        } else {
            if (bytesChildren != null && bytesChildren.size() > 0) {
                buffer.append(value);
                return buffer.toString();
            }
            if (mapChildren != null && mapChildren.size() > 0) {
                value = "";
            } else if (listChildren != null && listChildren.size() > 0) {
                value = "";
            } else if (element.getDouble() != null) {
                value = element.getDouble();
            } else if (element.getFloat() != null) {
                value = element.getFloat();
            } else if (element.getLong() != null) {
                value = element.getLong();
            } else if (element.getChar() != null) {
                value = element.getChar();
                value = DeviceKitUtilities.character(value);
            } else {
                if (element.getString() != null) {
                    value = element.getString();
                    value = DeviceKitUtilities.quote(value);
                    return value;
                }
                if (element.getByte() != null) {
                    value = element.getByte();
                } else if (element.getShort() != null) {
                    value = element.getShort();
                } else if (element.getBoolean() != null) {
                    value = element.getBoolean();
                    if (Boolean.valueOf(value).booleanValue()) {
                        return "true";
                    }
                    return "false";
                }
            }
        }
        if (value != null) {
            buffer.append(value);
            return buffer.toString();
        }
        value = element.getTextData();
        if (value == null) {
            return null;
        }
        buffer.append(value);
        return buffer.toString();
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("value".equals(childNodeName)) {
            this.handleValue(childNode);
        } else if ("label".equals(childNodeName)) {
            this.setLabel(ParserUtilities.extractData(childNode));
        } else {
            super.handleChild(childNode);
        }
    }

    protected void handleValue(Node node) {
        ValueElement element = new ValueElement(node, this);
        this.addChild(element);
    }

    public void setLabel(String label) {
        this.label = label;
    }
}

