/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.IConnectionItem;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class FileElement
extends TagElement
implements IConnectionItem {
    private String fInputName;
    private String fInputPath;
    private String fOutputName;
    private String fOutputPath;

    public FileElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        return DeviceKitGenerationConstants.CLASS_CONNECTION_FILE;
    }

    public ConfigurationField[] getConfigurationOptions() {
        ArrayList<ConfigurationField> list = new ArrayList<ConfigurationField>();
        list.add(new ConfigurationField("String", "DEFAULT_INPUTNAME", DeviceKitUtilities.quote(this.getInputName())));
        list.add(new ConfigurationField("String", "DEFAULT_INPUTPATH", DeviceKitUtilities.quote(this.getInputPath())));
        list.add(new ConfigurationField("String", "DEFAULT_OUTPUTNAME", DeviceKitUtilities.quote(this.getOutputName())));
        list.add(new ConfigurationField("String", "DEFAULT_OUTPUTPATH", DeviceKitUtilities.quote(this.getOutputPath())));
        ConfigurationField[] pairs = new ConfigurationField[list.size()];
        list.toArray(pairs);
        return pairs;
    }

    public String getConnectionConstant() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_FILE_SERVICE));
        buffer.append('.');
        buffer.append("CONNECTION_TYPE");
        return buffer.toString();
    }

    public String getConnectionTag() {
        return "file";
    }

    public String[] getExtraImports() {
        return new String[0];
    }

    public String getInputName() {
        if (this.fInputName == null) {
            this.fInputName = "inputname";
        }
        return this.fInputName;
    }

    public String getInputPath() {
        if (this.fInputPath == null) {
            this.fInputPath = "inputpath";
        }
        return this.fInputPath;
    }

    public String getOutputName() {
        if (this.fOutputName == null) {
            this.fOutputName = "outputname";
        }
        return this.fOutputName;
    }

    public String getOutputPath() {
        if (this.fOutputPath == null) {
            this.fOutputPath = "outputpath";
        }
        return this.fOutputPath;
    }

    public Hashtable getProperties() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        table.put("outputname", this.getOutputName());
        table.put("outputpath", this.getOutputPath());
        table.put("inputname", this.getInputName());
        table.put("inputpath", this.getInputPath());
        return table;
    }

    public int getTagCode() {
        return 33;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("inputname".equals(childNodeName)) {
            this.setInputName(ParserUtilities.extractData(childNode));
        } else if ("inputpath".equals(childNodeName)) {
            this.setInputPath(ParserUtilities.extractData(childNode));
        } else if ("outputname".equals(childNodeName)) {
            this.setOutputName(ParserUtilities.extractData(childNode));
        } else if ("outputpath".equals(childNodeName)) {
            this.setOutputPath(ParserUtilities.extractData(childNode));
        } else {
            super.handleChild(childNode);
        }
    }

    protected void setInputName(String inputName) {
        this.fInputName = inputName;
    }

    protected void setInputPath(String inputPath) {
        this.fInputPath = inputPath;
    }

    protected void setOutputName(String outputName) {
        this.fOutputName = outputName;
    }

    protected void setOutputPath(String outputPath) {
        this.fOutputPath = outputPath;
    }
}

