/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.GeneralParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.MessageClassItem;
import org.eclipse.soda.devicekit.generator.model.elements.SingleParameterSegmentElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class MessageElement
extends MessageClassItem {
    private String fTokens;

    public MessageElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        if (this.fTokens != null) {
            return DeviceKitGenerationConstants.CLASS_MESSAGE_TOKENS;
        }
        if (this.hasChildWithTagCode(62)) {
            return DeviceKitGenerationConstants.CLASS_MESSAGE_RESPONSE;
        }
        if (this.hasChildWithTagCode(5) || this.hasChildWithTagCode(23)) {
            return DeviceKitGenerationConstants.CLASS_MESSAGE_PARAMETER;
        }
        if (this.hasChildWithTagCode(6)) {
            return DeviceKitGenerationConstants.CLASS_MESSAGE_FILTER;
        }
        if (this.hasChildWithTagCode(63) || !this.hasChildWithTagCode(12) && !this.hasChildWithTagCode(25)) {
            return DeviceKitGenerationConstants.CLASS_MESSAGE_ASCII;
        }
        return DeviceKitGenerationConstants.CLASS_MESSAGE;
    }

    public String getFieldExtraComment(String fieldName) {
        StringBuffer buffer = new StringBuffer(512);
        this.addFieldExtraCommentParameters(buffer, true, fieldName);
        return buffer.toString();
    }

    public String getParameterDataType() {
        Vector list = this.getParameterChildren();
        switch (list.size()) {
            case 0: {
                return "";
            }
            case 1: {
                return ((TagElement)list.elementAt(0)).getParameterDataType();
            }
        }
        TagElement element = null;
        String type = this.getAttribute("type");
        int constantCount = 0;
        int parameterCount = 0;
        int newParameterCount = 0;
        int i = 0;
        while (i < list.size()) {
            TagElement tagElement = (TagElement)list.elementAt(i);
            if (tagElement.isConstantParameter()) {
                ++constantCount;
            } else {
                ++parameterCount;
                element = tagElement;
            }
            if (tagElement instanceof GeneralParameterElement) {
                ++newParameterCount;
            }
            ++i;
        }
        if (parameterCount == 1) {
            if (element instanceof SingleParameterSegmentElement) {
                return element.getParameterDataType();
            }
        } else if (newParameterCount > 0) {
            return "Map";
        }
        if (type != null) {
            if (type.toLowerCase().equals("map")) {
                return "Map";
            }
            if (type.toLowerCase().equals("list")) {
                return "List";
            }
        }
        return "";
    }

    public TagElement getRealElement() {
        TagElement realElement = this;
        String idref = this.getAttribute("idref");
        if (idref != null) {
            TagElement tagElementRef = TagElement.collection.getMessage(idref);
            if (tagElementRef != null) {
                realElement = tagElementRef;
                return realElement;
            }
            throw new IllegalArgumentException(idref);
        }
        return this;
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_MESSAGE_SERVICE;
    }

    public int getTagCode() {
        return 7;
    }

    public String getTokens() {
        return this.fTokens;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("parameter".equals(childNodeName)) {
            this.handleParameter(childNode);
        } else if (childNodeName.endsWith("parameter")) {
            this.handleSpecificParameter(childNode);
        } else if (childNodeName.endsWith("block")) {
            this.handleSpecificBlock(childNode);
        } else if (childNodeName.endsWith("segment")) {
            this.handleSpecificSegment(childNode);
        } else if ("parameters".equals(childNodeName)) {
            this.handleParameters(childNode);
        } else if ("bytes".equals(childNodeName)) {
            this.handleBytes(childNode);
        } else if ("nibbles".equals(childNodeName)) {
            this.handleNibbles(childNode);
        } else if ("tokens".equals(childNodeName)) {
            this.setTokens(ParserUtilities.extractData(childNode));
        } else if ("filter".equals(childNodeName)) {
            this.handleFilter(childNode);
        } else if ("sentmessage".equals(childNodeName)) {
            this.handleSentMessage(childNode);
        } else if ("ascii".equals(childNodeName)) {
            this.handleAscii(childNode);
        } else if ("utf8".equals(childNodeName)) {
            this.handleUtf8(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    protected void setTokens(String tokens) {
        this.fTokens = tokens;
    }
}

