/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.EnumElement;
import org.eclipse.soda.devicekit.generator.model.elements.LittleEndianElement;
import org.eclipse.soda.devicekit.generator.model.elements.MaximumElement;
import org.eclipse.soda.devicekit.generator.model.elements.MessageClassItem;
import org.eclipse.soda.devicekit.generator.model.elements.MinimumElement;
import org.eclipse.soda.devicekit.generator.model.elements.NegativeElement;
import org.eclipse.soda.devicekit.generator.model.elements.NotElement;
import org.eclipse.soda.devicekit.generator.model.elements.ScaleElement;
import org.eclipse.soda.devicekit.generator.model.elements.ShiftElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TranslateElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnitsElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnitsLinkElement;
import org.eclipse.soda.devicekit.generator.model.elements.UnsignedElement;
import org.eclipse.soda.devicekit.generator.model.elements.ValueElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class ParameterElement
extends MessageClassItem {
    private String fField;
    private String fIndex;
    private boolean fInsert;
    private String fLength;
    private String fOffset;
    private String fSize;

    public ParameterElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        if (this.fField != null) {
            return DeviceKitGenerationConstants.CLASS_PARAMETER_FIELD;
        }
        int length = this.getBitLengthValue(this.getLengthDefault());
        int offset = this.getBitOffsetValue(this.getOffsetDefault());
        if (offset % 8 == 0 && length % 8 == 0) {
            return DeviceKitGenerationConstants.CLASS_PARAMETER_SIMPLE;
        }
        return DeviceKitGenerationConstants.CLASS_PARAMETER_OFFSET;
    }

    public int getBitLengthValue(int defaultValue) {
        String length = this.getLength();
        String size = this.getSize();
        if (length != null) {
            int len = Integer.parseInt(length);
            return super.getBitLengthValue(len);
        }
        if (size != null) {
            int s = Integer.parseInt(size);
            return super.getBitLengthValue(s * 8);
        }
        return super.getBitLengthValue(defaultValue);
    }

    public String getField() {
        return this.fField;
    }

    public String getIndex() {
        return this.fIndex;
    }

    public boolean getInsert() {
        return this.fInsert;
    }

    public String getLength() {
        return this.fLength;
    }

    public String getOffset() {
        return this.fOffset;
    }

    public String getParameterDataType() {
        String name = this.getAttribute("type");
        if (name != null) {
            String baseName = name;
            if (name.startsWith("u")) {
                baseName = name.substring(1);
            }
            if (name.equals("boolean")) {
                return "Boolean";
            }
            if (name.equals("float")) {
                return "Float";
            }
            if (baseName.equals("long")) {
                return "Number";
            }
            if (baseName.equals("short")) {
                return "Number";
            }
            if (name.equals("double")) {
                return "Double";
            }
            if (name.equals("string")) {
                return "String";
            }
            if (name.equals("bytes")) {
                return "byte[]";
            }
            if (name.equals("numericstring")) {
                return "";
            }
            if (name.equals("nstring")) {
                return "";
            }
            if (name.equals("hexstring")) {
                return "";
            }
            if (name.equals("asciistring")) {
                return "";
            }
            if (name.equals("ascii")) {
                return "";
            }
            if (name.equals("nascii")) {
                return "";
            }
            if (name.equals("asciiz")) {
                return "";
            }
        }
        return "";
    }

    public TagElement getRealElement() {
        TagElement realElement = this;
        String idref = this.getAttribute("idref");
        if (idref != null) {
            TagElement tagElementRef = TagElement.collection.getParameter(idref);
            if (tagElementRef != null) {
                realElement = tagElementRef;
                return realElement;
            }
            throw new IllegalArgumentException(idref);
        }
        return this;
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_PARAMETER_SERVICE;
    }

    public String getSize() {
        return this.fSize;
    }

    public int getTagCode() {
        return 5;
    }

    protected Object getValueValue() {
        Vector values = this.getValueChildren();
        if (values.size() == 1) {
            ValueElement element = (ValueElement)values.elementAt(0);
            StringBuffer buffer = new StringBuffer(32);
            Vector listChildren = element.getAllChildrenWithTagCode(90);
            Vector mapChildren = element.getAllChildrenWithTagCode(89);
            Vector bytesChildren = element.getAllChildrenWithTagCode(12);
            if (element.getInt() != null) {
                String svalue = element.getInt();
                if (svalue != null) {
                    return new Integer(svalue);
                }
            } else if (bytesChildren == null || bytesChildren.size() <= 0) {
                if (mapChildren != null && mapChildren.size() > 0) {
                    return new Hashtable();
                }
                if (listChildren != null && listChildren.size() > 0) {
                    return new Vector();
                }
                if (element.getDouble() != null) {
                    String svalue = element.getDouble();
                    if (svalue != null) {
                        return new Double(svalue);
                    }
                } else if (element.getFloat() != null) {
                    String svalue = element.getFloat();
                    if (svalue != null) {
                        return new Float(svalue);
                    }
                } else if (element.getLong() != null) {
                    String svalue = element.getLong();
                    if (svalue != null) {
                        return new Long(svalue);
                    }
                } else if (element.getChar() != null) {
                    String svalue = element.getChar();
                    if (svalue != null) {
                        return new Character(svalue.charAt(0));
                    }
                } else {
                    if (element.getString() != null) {
                        String svalue = element.getString();
                        return svalue;
                    }
                    if (element.getByte() != null) {
                        String svalue = element.getByte();
                        if (svalue != null) {
                            return new Byte(svalue);
                        }
                    } else if (element.getShort() != null) {
                        String svalue = element.getShort();
                        if (svalue != null) {
                            return new Short(svalue);
                        }
                    } else if (element.getBoolean() != null) {
                        String svalue = element.getBoolean();
                        if (Boolean.valueOf(svalue).booleanValue()) {
                            return Boolean.TRUE;
                        }
                        return Boolean.FALSE;
                    }
                }
            }
            return buffer.toString();
        }
        return null;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("field".equals(childNodeName)) {
            this.setField(ParserUtilities.extractData(childNode));
        } else if ("index".equals(childNodeName)) {
            this.setIndex(ParserUtilities.extractData(childNode));
        } else if ("insert".equals(childNodeName)) {
            this.setInsert(true);
        } else if ("key".equals(childNodeName)) {
            this.setKey(ParserUtilities.extractData(childNode));
        } else if ("length".equals(childNodeName)) {
            this.setLength(ParserUtilities.extractData(childNode));
        } else if ("maximum".equals(childNodeName)) {
            this.handleMaximum(childNode);
        } else if ("minimum".equals(childNodeName)) {
            this.handleMinimum(childNode);
        } else if ("negative".equals(childNodeName)) {
            this.handleNegative(childNode);
        } else if ("not".equals(childNodeName)) {
            this.handleNot(childNode);
        } else if ("offset".equals(childNodeName)) {
            this.setOffset(ParserUtilities.extractData(childNode));
        } else if ("scale".equals(childNodeName)) {
            this.handleScale(childNode);
        } else if ("enum".equals(childNodeName)) {
            this.handleEnum(childNode);
        } else if ("shift".equals(childNodeName)) {
            this.handleShift(childNode);
        } else if ("size".equals(childNodeName)) {
            this.setSize(ParserUtilities.extractData(childNode));
        } else if ("translate".equals(childNodeName)) {
            this.handleTranslate(childNode);
        } else if ("units".equals(childNodeName)) {
            this.handleUnits(childNode);
        } else if ("value".equals(childNodeName)) {
            this.handleValue(childNode);
        } else if ("littleendian".equals(childNodeName)) {
            this.handleLittleEndian(childNode);
        } else if ("le".equals(childNodeName)) {
            this.handleLittleEndian(childNode);
        } else if ("unsigned".equals(childNodeName)) {
            this.handleUnsigned(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    private void handleEnum(Node node) {
        EnumElement element = new EnumElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addEnum(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleLittleEndian(Node node) {
        this.addChild(new LittleEndianElement(node, this));
    }

    private void handleMaximum(Node node) {
        MaximumElement element = new MaximumElement(node, this);
        this.addChild(element);
    }

    private void handleMinimum(Node node) {
        MinimumElement element = new MinimumElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleNegative(Node node) {
        NegativeElement element = new NegativeElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleNot(Node node) {
        NotElement element = new NotElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleScale(Node node) {
        ScaleElement element = new ScaleElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleShift(Node node) {
        ShiftElement element = new ShiftElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleTranslate(Node node) {
        TranslateElement element = new TranslateElement(node, this);
        this.addChild(element);
        if (element.getId() != null) {
            try {
                TagElement.collection.addTransform(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleUnits(Node node) {
        if (ParserUtilities.containsAttribute("idref", node)) {
            this.addChild(new UnitsLinkElement(node, this));
        } else {
            UnitsElement element = new UnitsElement(node, this);
            this.addChild(element);
            if (ParserUtilities.containsAttribute("id", node)) {
                try {
                    TagElement.collection.addUnits(element.getId(), element);
                }
                catch (Exception e) {
                    throw this.error(e.getMessage());
                }
            }
        }
    }

    private void handleUnsigned(Node node) {
        this.addChild(new UnsignedElement(node, this));
    }

    public boolean isConstantParameter() {
        return false;
    }

    public boolean isMessageClassElement() {
        return true;
    }

    protected void setField(String field) {
        this.fField = field;
    }

    protected void setIndex(String index) {
        this.fIndex = index;
    }

    protected void setInsert(boolean insert) {
        this.fInsert = insert;
    }

    protected void setLength(String length) {
        if (DeviceKitUtilities.isInteger(length)) {
            int val = Integer.parseInt(length);
            if (val < 0) {
                throw this.error("Parameter length value: " + length + " must be positive");
            }
        } else {
            throw this.error("Parameter length value: " + length + " must be a number");
        }
        this.fLength = length;
    }

    protected void setOffset(String offset) {
        this.fOffset = offset;
    }

    protected void setSize(String size) {
        if (DeviceKitUtilities.isInteger(size)) {
            int val = Integer.parseInt(size);
            if (val < 0) {
                throw this.error("Parameter size value: " + size + " must be positive");
            }
        } else {
            throw this.error("Parameter size value: " + size + " must be a number");
        }
        this.fSize = size;
    }
}

