/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.model.elements.AdapterElement;
import org.eclipse.soda.devicekit.generator.model.elements.AdapterTestElement;
import org.eclipse.soda.devicekit.generator.model.elements.AgentElement;
import org.eclipse.soda.devicekit.generator.model.elements.AgentTestElement;
import org.eclipse.soda.devicekit.generator.model.elements.ConcreteElement;
import org.eclipse.soda.devicekit.generator.model.elements.ConcreteTestElement;
import org.eclipse.soda.devicekit.generator.model.elements.ConnectionElement;
import org.eclipse.soda.devicekit.generator.model.elements.DeviceElement;
import org.eclipse.soda.devicekit.generator.model.elements.DeviceTestElement;
import org.eclipse.soda.devicekit.generator.model.elements.PidElement;
import org.eclipse.soda.devicekit.generator.model.elements.PidsElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProfileElement;
import org.eclipse.soda.devicekit.generator.model.elements.ProfileTestElement;
import org.eclipse.soda.devicekit.generator.model.elements.ReceiverElement;
import org.eclipse.soda.devicekit.generator.model.elements.ReceiverTestElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagCollection;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestAgentElement;
import org.eclipse.soda.devicekit.generator.model.elements.TestElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransportElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransportTestElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RootElement
extends TagElement {
    private String fVendor;
    private String fVersion;
    private Vector fTypes;

    public RootElement(Node node, Vector references) {
        super(node, null, references);
    }

    public RootElement(Node node, Vector references, boolean followReferences) {
        super(node, null, references, followReferences);
    }

    private void addTypeToGenerate(Object object) {
        this.fTypes.add(object);
    }

    protected void buildAttributes() {
        NamedNodeMap attributes = this.getNode().getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node node = attributes.item(i);
                if (node.getNodeType() == 2) {
                    if ("packagebase".equals(node.getNodeName())) {
                        this.setPackageBase(node.getNodeValue());
                    }
                    this.addAttribute(node.getNodeName(), node.getNodeValue());
                }
                ++i;
            }
        }
    }

    public Vector getRootTypes() {
        return this.fTypes;
    }

    public int getTagCode() {
        return 11;
    }

    public String getVendor() {
        return this.fVendor;
    }

    public String getVersion() {
        return this.fVersion;
    }

    protected void handleAdapter(Node node) {
        AdapterElement element = new AdapterElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    protected void handleAdapterTest(Node node) {
        AdapterTestElement element = new AdapterTestElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    private void handleAgent(Node node) {
        AgentElement element = new AgentElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    private void handleAgentTest(Node node) {
        AgentTestElement element = new AgentTestElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("vendor".equals(childNodeName)) {
            this.setVendor(ParserUtilities.extractData(childNode));
        } else if ("version".equals(childNodeName)) {
            this.setVersion(ParserUtilities.extractData(childNode));
        } else if ("device".equals(childNodeName)) {
            this.handleDevice(childNode);
        } else if ("transport".equals(childNodeName)) {
            this.handleTransport(childNode);
        } else if ("receiver".equals(childNodeName)) {
            this.handleReceiver(childNode);
        } else if ("connection".equals(childNodeName)) {
            this.handleConnection(childNode);
        } else if ("testagent".equals(childNodeName)) {
            this.handleTestAgent(childNode);
        } else if ("concrete".equals(childNodeName)) {
            this.handleConcrete(childNode);
        } else if ("test".equals(childNodeName)) {
            this.handleTest(childNode);
        } else if ("pid".equals(childNodeName)) {
            this.handlePid(childNode);
        } else if ("pids".equals(childNodeName)) {
            this.handlePids(childNode);
        } else if ("devicetest".equals(childNodeName)) {
            this.handleDeviceTest(childNode);
        } else if ("transporttest".equals(childNodeName)) {
            this.handleTransportTest(childNode);
        } else if ("receivertest".equals(childNodeName)) {
            this.handleReceiverTest(childNode);
        } else if ("concretetest".equals(childNodeName)) {
            this.handleConcreteTest(childNode);
        } else if ("adapter".equals(childNodeName)) {
            this.handleAdapter(childNode);
        } else if ("adaptertest".equals(childNodeName)) {
            this.handleAdapterTest(childNode);
        } else if ("profile".equals(childNodeName)) {
            this.handleProfile(childNode);
        } else if ("profiletest".equals(childNodeName)) {
            this.handleProfileTest(childNode);
        } else if ("agent".equals(childNodeName)) {
            this.handleAgent(childNode);
        } else if ("agenttest".equals(childNodeName)) {
            this.handleAgentTest(childNode);
        } else {
            super.handleChild(childNode);
        }
    }

    protected void handleConcrete(Node node) {
        ConcreteElement element = new ConcreteElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    protected void handleConcreteTest(Node node) {
        ConcreteTestElement element = new ConcreteTestElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    protected void handleConnection(Node node) {
        ConnectionElement element = new ConnectionElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    private void handleDevice(Node node) {
        DeviceElement element = new DeviceElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    private void handleDeviceTest(Node node) {
        DeviceTestElement element = new DeviceTestElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    private void handlePid(Node node) {
        PidElement pid = new PidElement(node, this);
        this.addChild(pid);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addPid(pid.getId(), pid);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handlePids(Node node) {
        PidsElement pids = new PidsElement(node, this);
        this.addChild(pids);
    }

    protected void handleProfile(Node node) {
        ProfileElement element = new ProfileElement(node, (TagElement)this, this.isFollowReferences());
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    protected void handleProfileTest(Node node) {
        ProfileTestElement element = new ProfileTestElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    protected void handleReceiver(Node node) {
        ReceiverElement element = new ReceiverElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    private void handleReceiverTest(Node node) {
        ReceiverTestElement element = new ReceiverTestElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    private void handleTest(Node node) {
        TestElement element = new TestElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    protected void handleTestAgent(Node node) {
        TestAgentElement element = new TestAgentElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    protected void handleTransport(Node node) {
        TransportElement element = new TransportElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    private void handleTransportTest(Node node) {
        TransportTestElement element = new TransportTestElement(node, this);
        this.addChild(element);
        this.addTypeToGenerate(element);
    }

    protected void initialize() {
        TagElement.collection = new TagCollection();
        this.fTypes = new Vector();
    }

    public void setVendor(String vendor) {
        this.fVendor = vendor;
    }

    public void setVersion(String version) {
        this.fVersion = version;
    }
}

