/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.GeneralParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public abstract class SegmentElement
extends GeneralParameterElement {
    private String occursminimum;
    private String occursmaximum;

    protected SegmentElement(Node node, TagElement parent) {
        super(node, parent);
    }

    public String getNormalType() {
        if (this.getOccursminimum() == 1 && this.getOccursmaximum() == 1) {
            return DeviceKitGenerationConstants.CLASS_SIMPLE_SEGMENT;
        }
        if (this.getOccursminimum() == 0 && this.getOccursmaximum() == 1) {
            return DeviceKitGenerationConstants.CLASS_OPTIONAL_SEGMENT;
        }
        return DeviceKitGenerationConstants.CLASS_MULTI_SEGMENT;
    }

    public int getOccursmaximum() {
        if (this.occursmaximum == null) {
            return 1;
        }
        if (this.occursmaximum.equals("n")) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(this.occursmaximum);
    }

    public String getOccursmaximumRaw() {
        return this.occursmaximum;
    }

    public String getOccursmaximumString() {
        if (this.occursmaximum == null) {
            return "1";
        }
        if (this.occursmaximum.equals("n")) {
            return "ParameterService.UNLIMITED";
        }
        return this.occursmaximum;
    }

    public String getOccursmaximumStringName() {
        if (this.occursmaximum == null) {
            return "1";
        }
        if (this.occursmaximum.equals("n")) {
            return "N";
        }
        return this.occursmaximum;
    }

    public int getOccursminimum() {
        if (this.occursminimum == null) {
            return 1;
        }
        if (this.occursminimum.equals("n")) {
            return Integer.MAX_VALUE;
        }
        return Integer.parseInt(this.occursminimum);
    }

    public String getOccursminimumRaw() {
        return this.occursminimum;
    }

    public String getOccursminimumString() {
        if (this.occursminimum == null) {
            return "1";
        }
        if (this.occursminimum.equals("n")) {
            return "ParameterService.UNLIMITED";
        }
        return this.occursminimum;
    }

    public String getOccursminimumStringName() {
        if (this.occursminimum == null) {
            return "1";
        }
        if (this.occursminimum.equals("n")) {
            return "N";
        }
        return this.occursminimum;
    }

    public String getParameterDataType() {
        if (this.getOccursmaximum() <= 1) {
            return "Map";
        }
        return "List";
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("parameter".equals(childNodeName)) {
            this.handleParameter(childNode);
        } else if (childNodeName.endsWith("parameter")) {
            this.handleSpecificParameter(childNode);
        } else if (childNodeName.endsWith("block")) {
            this.handleSpecificBlock(childNode);
        } else if (childNodeName.endsWith("segment")) {
            this.handleSpecificSegment(childNode);
        } else if ("parameters".equals(childNodeName)) {
            this.handleParameters(childNode);
        } else if ("bytes".equals(childNodeName)) {
            this.handleBytes(childNode);
        } else if ("nibbles".equals(childNodeName)) {
            this.handleNibbles(childNode);
        } else if ("filter".equals(childNodeName)) {
            this.handleFilter(childNode);
        } else if ("ascii".equals(childNodeName)) {
            this.handleAscii(childNode);
        } else if ("utf8".equals(childNodeName)) {
            this.handleUtf8(childNode);
        } else if ("occursmaximum".equals(childNodeName)) {
            this.setOccursmaximum(ParserUtilities.extractData(childNode));
        } else if ("occursminimum".equals(childNodeName)) {
            this.setOccursminimum(ParserUtilities.extractData(childNode));
        } else {
            super.handleChild(childNode);
        }
    }

    public boolean isFilterValid() {
        return this.getOccursmaximum() == this.getOccursminimum();
    }

    public boolean isRequiredParameter() {
        return this.getOccursminimum() > 0;
    }

    public void setOccursmaximum(String occursmaximum) {
        this.occursmaximum = occursmaximum;
    }

    public void setOccursminimum(String occursminimum) {
        this.occursminimum = occursminimum;
    }
}

