/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.io.InputStream;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.model.BytesGenerator;
import org.eclipse.soda.devicekit.generator.model.TagException;
import org.eclipse.soda.devicekit.generator.model.elements.DkgElementsMessages;
import org.eclipse.soda.devicekit.generator.model.elements.GeneralParameterElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.SignalElement;
import org.eclipse.soda.devicekit.generator.model.elements.SignalLinkElement;
import org.eclipse.soda.devicekit.generator.model.elements.SpecReferenceElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagCollection;
import org.eclipse.soda.devicekit.generator.model.elements.TransformItem;
import org.eclipse.soda.devicekit.generator.model.elements.ValueElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitDefaults;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.SortedSet;
import org.eclipse.soda.devicekit.util.AnchorUtil;
import org.eclipse.soda.devicekit.util.DkmlReferenceResolver;
import org.eclipse.soda.devicekit.util.Nls;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class TagElement {
    public static TagCollection collection = new TagCollection();
    public static String fPackageBase;
    protected static Vector references;
    private Hashtable fAttributes;
    private Vector fChildren;
    private String fDefaultPackage;
    private DeviceKitDefaults fDefaults;
    private String fDescription;
    private String fKey;
    private String fName;
    private Node fNode;
    private TagElement fParent;
    private String fTextData;
    private String fType;
    private Hashtable fVariables;
    private String packageBase;
    private boolean followReferences = true;

    protected TagElement(Node node, TagElement parent) {
        this(node, parent, null);
    }

    protected TagElement(Node node, TagElement parent, Vector references) {
        this(node, parent, references, true);
    }

    protected TagElement(Node node, TagElement parent, Vector references, boolean followReferences) {
        this.fNode = node;
        if (references != null) {
            TagElement.references = references;
        }
        this.initialize();
        this.followReferences = followReferences;
        this.fAttributes = new Hashtable();
        this.fVariables = new Hashtable();
        this.fChildren = new Vector();
        this.fDefaults = DeviceKitDefaults.getInstance();
        if (this.fNode != null) {
            this.setName(this.fNode.getNodeName());
            this.setParent(parent);
            this.buildData();
            this.buildAttributes();
            this.build();
        }
    }

    protected void addAttribute(String name, String value) {
        this.fAttributes.put(name, value);
    }

    protected void addChild(TagElement child) {
        this.fChildren.addElement(child);
    }

    public void addFieldExtraCommentMessages(StringBuffer buffer, String fieldName) {
        Vector messages;
        int parameterSize;
        TagElement realElement = this;
        String idref = this.getAttribute("idref");
        if (idref != null) {
            TagElement tagElementRef = collection.getParameter(idref);
            if (tagElementRef != null) {
                realElement = tagElementRef;
            } else {
                throw new IllegalArgumentException(idref);
            }
        }
        if ((parameterSize = (messages = realElement.getMessageChildren()).size()) > 0) {
            int i = 0;
            while (i < parameterSize) {
                TagElement tagElement = (TagElement)messages.elementAt(i);
                tagElement.addFieldExtraCommentParameters(buffer, true, fieldName);
                ++i;
            }
        }
    }

    public void addFieldExtraCommentParameters(StringBuffer buffer, boolean full, String fieldName) {
        TagElement realElement = this;
        String idref = this.getAttribute("idref");
        if (idref != null) {
            TagElement tagElementRef = collection.getParameter(idref);
            if (tagElementRef != null) {
                realElement = tagElementRef;
            } else {
                throw new IllegalArgumentException(idref);
            }
        }
        String keyThis = realElement.getAnyId();
        Vector parameters = realElement.getParameterChildren();
        int parameterSize = parameters.size();
        int count = 0;
        StringBuffer subbuffer = new StringBuffer(1024);
        if (parameterSize > 0) {
            int i = 0;
            while (i < parameterSize) {
                String key;
                TagElement tagElement = (TagElement)parameters.elementAt(i);
                if (!tagElement.isConstantParameter() && (key = tagElement.getAnyId()) != null && key.length() > 0) {
                    if (fieldName.equals("") || fieldName.equals(key)) {
                        if (count == 0) {
                            buffer.append("\n<ul>");
                        }
                        ++count;
                        buffer.append("\n<li> ");
                        if (fieldName.equals(key)) {
                            buffer.append("<b>");
                            buffer.append(key);
                            buffer.append("</b>");
                        } else {
                            buffer.append(key);
                        }
                        String dataType = tagElement.getParameterDataType();
                        if (dataType != null && dataType.length() > 0) {
                            buffer.append(" (");
                            buffer.append(dataType);
                            buffer.append(')');
                        }
                        if (!tagElement.isRequiredParameter()) {
                            buffer.append(" <i>optional</i>");
                        }
                        buffer.append(" </li>");
                        if (full && !keyThis.equals(key)) {
                            if (fieldName.equals(key)) {
                                tagElement.addFieldExtraCommentParameters(buffer, false, "");
                            } else {
                                tagElement.addFieldExtraCommentParameters(buffer, false, fieldName);
                            }
                        }
                    } else if (!keyThis.equals(key) && fieldName.length() > 0 && subbuffer.length() == 0) {
                        tagElement.addFieldExtraCommentParameters(subbuffer, true, fieldName);
                    }
                }
                ++i;
            }
            if (count > 0) {
                buffer.append("\n</ul>");
            } else if (subbuffer.length() > 0) {
                buffer.append(subbuffer.toString());
            }
        }
    }

    public void addTemplateVariable(String key, String value) {
        this.fVariables.put(key, value);
    }

    public void build() {
        if (this.fNode != null) {
            this.buildChildren();
            this.validate();
        }
    }

    protected void buildAttributes() {
        NamedNodeMap attributes = this.getNode().getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node node = attributes.item(i);
                if (node.getNodeType() == 2) {
                    if ("idref".equals(node.getNodeName())) {
                        Node nodeId;
                        boolean check = true;
                        String value = node.getNodeValue();
                        Node parent = this.getNode().getParentNode();
                        if (parent != null && (nodeId = parent.getAttributes().getNamedItem("id")) != null) {
                            String parentId = nodeId.getNodeValue();
                            boolean bl = check = !value.equals(parentId);
                        }
                        if (check) {
                            this.checkValidReference(value);
                        }
                    }
                    this.addAttribute(node.getNodeName(), node.getNodeValue());
                }
                ++i;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void buildChildren() {
        NodeList children = this.getNode().getChildNodes();
        if (children != null) {
            int i = 0;
            while (i < children.getLength()) {
                if (this.isReferencedIdref(children.item(i))) {
                    if (this.isFollowReferences()) {
                        Node child = this.handleReference(children.item(i));
                        if (child == null) {
                            StringBuffer buffer = new StringBuffer(1024);
                            buffer.append("can not find reference ");
                            buffer.append(AnchorUtil.getAnchorRefValue(children.item(i)));
                            buffer.append(" in ");
                            buffer.append(this.getName());
                            throw new IllegalArgumentException(buffer.toString());
                        }
                        this.handleChild(child);
                    } else {
                        System.out.println("not following");
                    }
                }
                this.handleChild(children.item(i));
                ++i;
            }
        }
    }

    protected void buildData() {
        this.setTextData(ParserUtilities.extractData(this.getNode()));
    }

    protected void checkValidReference(String name) {
        TagElement element = null;
        switch (this.getTagCode()) {
            case 1: 
            case 19: 
            case 20: 
            case 43: 
            case 44: 
            case 45: 
            case 1001: {
                element = collection.getCommand(name);
                break;
            }
            case 3: 
            case 1003: {
                element = collection.getSignal(name);
                break;
            }
            case 2: {
                element = collection.getMeasurement(name);
                break;
            }
            case 4: 
            case 1004: {
                element = collection.getUnit(name);
                break;
            }
            case 7: 
            case 50: 
            case 1007: {
                element = collection.getMessage(name);
                break;
            }
            case 6: 
            case 1006: {
                element = collection.getFilter(name);
                break;
            }
            case 5: 
            case 23: 
            case 1005: 
            case 1023: {
                element = collection.getParameter(name);
                break;
            }
            case 16: 
            case 21: 
            case 22: 
            case 24: 
            case 26: 
            case 27: 
            case 28: 
            case 1021: 
            case 1022: 
            case 1024: 
            case 1026: 
            case 1027: 
            case 1028: {
                element = collection.getTransform(name);
                break;
            }
            case 53: {
                element = collection.getPid(name);
                break;
            }
            case 60: {
                element = collection.getSend(name);
                break;
            }
            case 62: {
                element = collection.getMessage(name);
                if (element != null) break;
                element = collection.getMessage(String.valueOf(name) + "Message");
                break;
            }
            case 64: {
                element = collection.getSpec(name);
                break;
            }
            default: {
                return;
            }
        }
        if (element == null) {
            throw this.error(Nls.format(DkgElementsMessages.getString("TagElement.error.invalid.idref"), name));
        }
    }

    public int compare(Object object1, Object object2) {
        String string1 = object1.toString();
        String string2 = object2.toString();
        if (object1 instanceof TagElement && object2 instanceof TagElement) {
            string1 = ((TagElement)object1).getKey();
            if (string1 == null || string1.length() == 0) {
                string1 = object1.toString();
            }
            if ((string2 = ((TagElement)object2).getKey()) == null || string2.length() == 0) {
                string2 = object2.toString();
            }
        }
        return string1.compareTo(string2);
    }

    protected RuntimeException error(String message) {
        return new TagException(9, String.valueOf(message) + "\r\n" + this.toString(this));
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        return this.getClassNameFull();
    }

    protected String format(String pattern, String[] values) {
        return Nls.format(pattern, values);
    }

    public Vector getAdapterChildren() {
        return this.getAllChildrenWithTagCode(72);
    }

    public Vector getAgentChildren() {
        return this.getAllChildrenWithTagCode(91);
    }

    public Vector getAllChildren(boolean includeRef, boolean includeLink) {
        Vector<TagElement> result = new Vector<TagElement>();
        Vector children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            TagElement element = (TagElement)children.elementAt(i);
            int tagCode = element.getTagCode();
            if (element instanceof MainTagElement) {
                result.addElement(element);
                return result;
            }
            boolean tagLink = tagCode >= 1000;
            String idref = element.getAttribute("idref");
            if (idref != null && idref.length() > 0) {
                if (includeRef) {
                    result.addElement(element);
                    if (!tagLink || includeLink && tagLink) {
                        result.addAll(element.getAllChildren(includeRef, includeLink));
                    }
                }
            } else {
                result.addElement(element);
                if (!tagLink || includeLink && tagLink) {
                    result.addAll(element.getAllChildren(includeRef, includeLink));
                }
            }
            ++i;
        }
        return result;
    }

    public Vector getAllChildrenWithTagCode(int code) {
        return this.getAllChildrenWithTagCode(code, true);
    }

    public Vector getAllChildrenWithTagCode(int code, boolean includeRef) {
        Vector<TagElement> result = new Vector<TagElement>();
        Vector children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            TagElement element = (TagElement)children.elementAt(i);
            int tagCode = element.getTagCode();
            if (tagCode == code) {
                result.addElement(element);
            } else if (tagCode == 82) {
                result.addAll(element.getAllChildrenWithTagCode(code, includeRef));
            } else if (tagCode == 1000 + code && includeRef) {
                result.addElement((TagElement)children.elementAt(i));
            }
            ++i;
        }
        return result;
    }

    public Vector getAllChildrenWithTagCodes(int[] codes) {
        return this.getAllChildrenWithTagCodes(codes, true);
    }

    public Vector getAllChildrenWithTagCodes(int[] codes, boolean includeRef) {
        Vector<TagElement> result = new Vector<TagElement>();
        Vector children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            int j = 0;
            while (j < codes.length) {
                int code = codes[j];
                TagElement element = (TagElement)children.elementAt(i);
                int tagCode = element.getTagCode();
                if (tagCode == code) {
                    result.addElement(element);
                } else if (tagCode == 82) {
                    result.addAll(element.getAllChildrenWithTagCode(code, includeRef));
                } else if (tagCode == 1000 + code && includeRef) {
                    result.addElement((TagElement)children.elementAt(i));
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public Vector getAllChildrenWithTagCodes(int[] codes, int[] parentCodes) {
        Vector<TagElement> result = new Vector<TagElement>();
        Vector children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            int j = 0;
            while (j < codes.length) {
                int code = codes[j];
                TagElement element = (TagElement)children.elementAt(i);
                int tagCode = element.getTagCode();
                if (tagCode == code) {
                    result.addElement(element);
                }
                int k = 0;
                while (k < parentCodes.length) {
                    if (tagCode == parentCodes[k]) {
                        result.addAll(element.getAllChildrenWithTagCodes(new int[]{code}, parentCodes));
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public Vector getAllSubChildrenWithTagCode(int code, boolean includeRef) {
        SortedSet result = new SortedSet();
        Vector children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            TagElement element = (TagElement)children.elementAt(i);
            int tagCode = element.getTagCode();
            if (tagCode == code) {
                result.addElement(element);
                result.addAll((Collection)element.getAllSubChildrenWithTagCode(code, includeRef));
            } else if (tagCode == 1000 + code) {
                if (includeRef) {
                    result.addElement(children.elementAt(i));
                }
            } else {
                result.addAll((Collection)element.getAllSubChildrenWithTagCode(code, includeRef));
            }
            ++i;
        }
        return result;
    }

    public String getAnyId() {
        String key = this.getKey();
        if (key != null) {
            return key;
        }
        String idref = this.getIdRef();
        if (idref != null) {
            return idref;
        }
        return this.getName();
    }

    public String getAttribute(String name) {
        String attribute = (String)this.fAttributes.get(name);
        if (attribute != null) {
            return attribute;
        }
        return this.getDefaultAttribute(name);
    }

    public Enumeration getAttributeNames() {
        return this.fAttributes.keys();
    }

    public int getBase() {
        String format = this.getFormat();
        if ("decimal".equals(format)) {
            return 10;
        }
        if ("hex".equals(format)) {
            return 16;
        }
        if ("octal".equals(format)) {
            return 8;
        }
        if ("binary".equals(format)) {
            return 2;
        }
        return 0;
    }

    public int getBitLengthValue(int defaultValue) {
        int length;
        String lengthString;
        int size = -1;
        String name = this.getAttribute("type");
        if (name != null) {
            if ("boolean".equals(name) || name.endsWith("byte")) {
                size = 1;
            } else if (name.endsWith("short") || name.endsWith("char")) {
                size = 2;
            } else if (name.endsWith("int") || name.endsWith("float")) {
                size = 4;
            } else if (name.endsWith("long") || name.endsWith("double")) {
                size = 8;
            }
        }
        if ((lengthString = this.getLength()) == null) {
            lengthString = "-1";
        }
        if ((length = Integer.parseInt(lengthString)) == -1) {
            int xmlSize;
            String sizeString = this.getSize();
            if (sizeString != null && (xmlSize = Integer.parseInt(sizeString)) >= 0) {
                return xmlSize * 8;
            }
            if (size == -1) {
                return defaultValue;
            }
            return size * 8;
        }
        return length;
    }

    public int getBitOffsetValue(int defaultValue) {
        int index = this.getIndex() != null ? Integer.parseInt(this.getIndex()) : -1;
        int offset = this.getOffset() != null ? Integer.parseInt(this.getOffset()) : -1;
        if (offset == -1) {
            if (index == -1) {
                return defaultValue;
            }
            return index * 8;
        }
        return offset;
    }

    public String getBundleId() {
        String bundleId = this.getAttribute("bundleid");
        if (bundleId != null) {
            return bundleId;
        }
        if (this.getParent() != null) {
            return this.getParent().getBundleId();
        }
        return this.getId();
    }

    public String getBundleIdFull() {
        String name = this.getBundleId();
        return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, this.getDefaultPackage())) + '.' + name;
    }

    public String getBundleName() {
        String bundle = this.getAttribute("bundle");
        if (bundle != null) {
            return bundle;
        }
        if (this.getParent() != null) {
            return this.getParent().getBundleName();
        }
        String id = this.getId();
        if (id != null) {
            return id;
        }
        String idref = this.getAttribute("idref");
        int index = idref.indexOf(35);
        if (index < 0) {
            return idref;
        }
        return idref.substring(index + 1);
    }

    public Vector getByteChildren() {
        return this.getAllChildrenWithTagCodes(new int[]{12, 25, 40, 63, 696});
    }

    public Vector getChildren() {
        return this.fChildren;
    }

    public Vector getChildrenWithTagCode(int code) {
        Vector vector = new Vector();
        int i = 0;
        while (i < this.getChildren().size()) {
            if (((TagElement)this.getChildren().elementAt(i)).getTagCode() == code) {
                vector.add(this.getChildren().elementAt(i));
            } else if (((TagElement)this.getChildren().elementAt(i)).getTagCode() == 1000 + code) {
                vector.add(this.getChildren().elementAt(i));
            }
            ++i;
        }
        return vector;
    }

    public Vector getChildrenWithTagCodes(int[] codes) {
        Vector vector = new Vector();
        int i = 0;
        while (i < this.getChildren().size()) {
            int j = 0;
            while (j < codes.length) {
                if (((TagElement)this.getChildren().elementAt(i)).getTagCode() == codes[j]) {
                    vector.add(this.getChildren().elementAt(i));
                } else if (((TagElement)this.getChildren().elementAt(i)).getTagCode() == 1000 + codes[j]) {
                    vector.add(this.getChildren().elementAt(i));
                }
                ++j;
            }
            ++i;
        }
        return vector;
    }

    public String getClassNameFull() {
        int index;
        String name = this.getAttribute("implementation");
        if (name == null || name.length() == 0) {
            name = this.getAttribute("id");
            if (name == null) {
                name = this.getAttribute("idref");
            }
            if ((index = name.indexOf(35)) >= 0) {
                String url = name.substring(0, index);
                name = name.substring(index + 1);
                int sindex = url.indexOf(47);
                if (sindex >= 0) {
                    String projectName;
                    String packageName = projectName = url.substring(0, sindex);
                    name = String.valueOf(packageName) + '.' + name;
                }
            } else {
                String prefix = this.getPackageBase();
                if (prefix != null) {
                    return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, prefix)) + '.' + name;
                }
            }
        }
        if (name.length() > 0 && (index = name.indexOf(46)) == -1 && this.getDefaultPackage() != null) {
            return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, this.getDefaultPackage())) + '.' + name;
        }
        return name;
    }

    public Vector getConcreteChildren() {
        return this.getAllChildrenWithTagCode(18);
    }

    public Vector getConfigurations() {
        return new Vector();
    }

    private String getDefaultAttribute(String name) {
        return this.fDefaults.getDefaultValue(name);
    }

    protected String getDefaultFieldComment() {
        String key = this.getKey();
        if (key == null) {
            key = this.getIdRef();
        }
        return this.format("Defines the {0} {1}.", new String[]{key, this.getNiceName()});
    }

    public String getDefaultMeasurementValue() {
        return "null";
    }

    public String getDefaultPackage() {
        if (this.fDefaultPackage != null) {
            return this.fDefaultPackage;
        }
        if (this.getParent() != null) {
            return this.getParent().getDefaultPackage();
        }
        return null;
    }

    public String getDescription() {
        return this.fDescription;
    }

    public Vector getDeviceChildren() {
        return this.getAllChildrenWithTagCode(8);
    }

    public TagElement getElement(String fieldName) {
        return null;
    }

    public String getExternalId() {
        String groupId;
        TagElement parent;
        String id = this.getId();
        if (id != null && (parent = this.getParent()) != null && (groupId = parent.getGroupId()) != null && groupId.length() > 0) {
            StringBuffer buffer = new StringBuffer(groupId.length() + 1 + id.length());
            buffer.append(groupId);
            buffer.append('/');
            buffer.append(id);
            return buffer.toString();
        }
        return id;
    }

    public String getFactoryNameFull() {
        int index;
        String name = this.getAttribute("factory");
        if (name == null || name.length() == 0) {
            name = this.getBundleName();
            if (name == null && (index = (name = this.getAttribute("idref")).indexOf(35)) >= 0) {
                String url = name.substring(0, index);
                name = name.substring(index + 1);
                int sindex = url.indexOf(47);
                if (sindex >= 0) {
                    String projectName = url.substring(0, sindex);
                    String packageName = String.valueOf(projectName) + ".factory";
                    name = String.valueOf(packageName) + '.' + name;
                }
            }
            if (name.length() > 0) {
                name = String.valueOf(name) + "Factory";
            }
        }
        if (name.length() > 0 && (index = name.indexOf(46)) == -1 && this.getDefaultPackage() != null) {
            return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, this.getDefaultPackage())) + '.' + name;
        }
        return name;
    }

    public String[] getFieldComment() {
        String fieldExtraComment = this.getFieldExtraComment("");
        StringBuffer buffer = new StringBuffer(512);
        if (this.getDescription() != null) {
            buffer.append(this.getDescription());
        } else {
            buffer.append(this.getDefaultFieldComment());
        }
        if (fieldExtraComment != null && fieldExtraComment.length() > 0) {
            buffer.append("\n<p>\n");
            buffer.append(fieldExtraComment);
            buffer.append("\n</p>");
        }
        return DeviceKitUtilities.convertStringToArray(buffer.toString());
    }

    public String getFieldExtraComment(String fieldName) {
        return "";
    }

    public Vector getFilterChildren() {
        return this.getAllChildrenWithTagCode(6);
    }

    public Vector getFilterChildren(boolean includeRef) {
        return this.getAllChildrenWithTagCode(6, includeRef);
    }

    public String getFormat() {
        TagElement parent;
        String format = this.getAttribute("format");
        if (format.length() == 0 && (parent = this.getParent()) != null) {
            return parent.getFormat();
        }
        return format;
    }

    public String getGroupId() {
        return "";
    }

    public String getId() {
        return this.getAttribute("id");
    }

    protected String getIdForMessage(String parentId, TagElement me) {
        if (parentId == null || me.getAttribute("idref") != null) {
            return null;
        }
        String messageId = String.valueOf(parentId) + "Message";
        if (collection.getMessage(messageId) != null) {
            int i = 0;
            while (i < 100) {
                messageId = String.valueOf(parentId) + i + "Message";
                if (collection.getMessage(messageId) == null) {
                    return messageId;
                }
                ++i;
            }
            return null;
        }
        return messageId;
    }

    public String getIdRaw() {
        return this.getAttribute("id");
    }

    public String getIdRef() {
        return this.getAttribute("idref");
    }

    public String getImplementation() {
        String implementation = this.getAttribute("implementation");
        if (implementation != null) {
            return implementation;
        }
        if (this.getParent() != null) {
            return this.getParent().getImplementation();
        }
        return this.getId();
    }

    public String getIndex() {
        return null;
    }

    public int getInteger(String tagName, int defaultValue) {
        String string = this.getString(tagName);
        if (string == null) {
            return defaultValue;
        }
        return Integer.parseInt(string);
    }

    public String getKey() {
        if (this.fKey != null) {
            return this.fKey;
        }
        return this.getId();
    }

    protected String getKey(boolean noId) {
        if (noId) {
            return this.fKey;
        }
        return this.getKey();
    }

    protected String getLength() {
        return "-1";
    }

    public int getLengthDefault() {
        return 0;
    }

    public String getManagedNameFull() {
        int index;
        String name = this.getAttribute("factory");
        if (name == null || name.length() == 0) {
            name = this.getBundleName();
            if (name == null && (index = (name = this.getAttribute("idref")).indexOf(35)) >= 0) {
                String url = name.substring(0, index);
                name = name.substring(index + 1);
                int sindex = url.indexOf(47);
                if (sindex >= 0) {
                    String projectName = url.substring(0, sindex);
                    String packageName = String.valueOf(projectName) + ".managed";
                    name = String.valueOf(packageName) + '.' + name;
                }
            }
            if (name.length() > 0) {
                name = String.valueOf(name) + "Managed";
            }
        }
        if (name.length() > 0 && (index = name.indexOf(46)) == -1 && this.getDefaultPackage() != null) {
            return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, this.getDefaultPackage())) + '.' + name;
        }
        return name;
    }

    public Vector getMessageChildren() {
        return this.getAllChildrenWithTagCodes(new int[]{7, 50});
    }

    public Vector getMessageChildren(boolean includeRef) {
        return this.getAllChildrenWithTagCode(7, includeRef);
    }

    public Vector getMessageClassElements() {
        Vector elements = new Vector();
        int i = 0;
        while (i < this.getChildren().size()) {
            if (((TagElement)this.getChildren().elementAt(i)).isMessageClassElement() && ((TagElement)this.getChildren().elementAt(i)).getId() != null) {
                elements.addElement(this.getChildren().elementAt(i));
            }
            Vector childElements = ((TagElement)this.getChildren().elementAt(i)).getMessageClassElements();
            elements = DeviceKitUtilities.mergeVectors(elements, childElements);
            ++i;
        }
        return elements;
    }

    public String getName() {
        return this.fName;
    }

    public String getNiceName() {
        return this.getNiceName(this.getName());
    }

    public String getNiceName(String name) {
        int length = name.length();
        if (name.endsWith("block")) {
            if (length > 5) {
                return String.valueOf(this.getNiceName(name.substring(0, length - 5))) + " block";
            }
        } else if (name.endsWith("segment")) {
            if (length > 7) {
                return String.valueOf(this.getNiceName(name.substring(0, length - 7))) + " segment";
            }
        } else if (name.endsWith("parameter")) {
            if (length > 9) {
                return String.valueOf(this.getNiceName(name.substring(0, length - 9))) + " parameter";
            }
        } else if (name.startsWith("unsigned") && length > 8) {
            return "unsigned " + this.getNiceName(name.substring(8));
        }
        return name;
    }

    protected Node getNode() {
        return this.fNode;
    }

    public String getOffset() {
        return null;
    }

    public String getPackageBase() {
        if (this.packageBase == null) {
            if (this.getParent() != null) {
                return this.getParent().getPackageBase();
            }
            return fPackageBase;
        }
        return this.packageBase;
    }

    public Vector getParameterChildren() {
        return this.getChildrenWithTagCodes(new int[]{23, 5});
    }

    public Vector getParameterChildrenAll() {
        return this.getAllChildrenWithTagCodes(new int[]{23, 5});
    }

    public String getParameterDataType() {
        return "";
    }

    public TagElement getParent() {
        return this.fParent;
    }

    public Vector getProfileChildren() {
        return this.getAllChildrenWithTagCode(74);
    }

    public String getProjectId() {
        String type = this.getType();
        if (type != null && type.indexOf(46) >= 0) {
            return DeviceKitUtilities.extractPackage(type);
        }
        return "";
    }

    public Hashtable getProperties() {
        return new Hashtable();
    }

    public TagElement getRealElement() {
        return this;
    }

    public Vector getRequiredBundles() {
        return new Vector();
    }

    public String[] getServiceFieldComment() {
        return this.getFieldComment();
    }

    public String getServiceName() {
        int index;
        String name = this.getAttribute("service");
        if (name == null || name.length() == 0) {
            name = this.getBundleName();
            if (name == null) {
                name = this.getAttribute("idref");
                if (name == null) {
                    name = this.getAttribute("id");
                }
                if (name != null && (index = name.indexOf(35)) >= 0) {
                    name = name.substring(index + 1);
                }
            }
            if (name != null && name.length() > 0) {
                name = String.valueOf(name) + "Service";
            }
        }
        if (name != null && name.length() > 0 && (index = name.indexOf(46)) == -1 && this.getDefaultPackage() != null) {
            return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, this.getDefaultPackage())) + '.' + name;
        }
        return name;
    }

    public String getServiceNameFull() {
        int index;
        String name = this.getAttribute("service");
        if (name == null || name.length() == 0) {
            name = this.getBundleName();
            if (name == null && (index = (name = this.getAttribute("idref")).indexOf(35)) >= 0) {
                String url = name.substring(0, index);
                name = name.substring(index + 1);
                int sindex = url.indexOf(47);
                if (sindex >= 0) {
                    String projectName = url.substring(0, sindex);
                    String packageName = String.valueOf(projectName) + ".service";
                    name = String.valueOf(packageName) + '.' + name;
                }
            }
            if (name.length() > 0) {
                name = String.valueOf(name) + "Service";
            }
        }
        if (name.length() > 0 && (index = name.indexOf(46)) == -1 && this.getDefaultPackage() != null) {
            return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, this.getDefaultPackage())) + '.' + name;
        }
        return name;
    }

    public String getServiceType() {
        return this.getType();
    }

    protected String getSize() {
        return "-1";
    }

    public String getString(String tagName) {
        return this.getString(tagName, null);
    }

    public String getString(String tagName, String defaultString) {
        Vector list = this.getChildren();
        int i = 0;
        while (i < list.size()) {
            if (tagName.equals(((TagElement)list.elementAt(i)).getName())) {
                if (((TagElement)list.elementAt(i)).getTextData() != null) {
                    return ((TagElement)list.elementAt(i)).getTextData();
                }
                return defaultString;
            }
            ++i;
        }
        return defaultString;
    }

    public String getSuperclassFull() {
        int index;
        String name = this.getAttribute("superclass");
        if (name == null || name.length() == 0) {
            return this.getSuperclassFullDefault();
        }
        if (name.length() > 0 && (index = name.indexOf(46)) == -1 && this.getDefaultPackage() != null) {
            return String.valueOf(DeviceKitUtilities.getPackageFromClassName(name, this.getDefaultPackage())) + '.' + name;
        }
        return name;
    }

    public String getSuperclassFullDefault() {
        return this.getType();
    }

    public abstract int getTagCode();

    public Hashtable getTemplateVariables() {
        return this.fVariables;
    }

    public String getTextData() {
        return this.fTextData;
    }

    public String getTextDataFix() {
        String string = this.getTextData();
        if (string == null) {
            return new String();
        }
        if (string.length() == 1) {
            return string;
        }
        StringBuffer result = new StringBuffer(string.length());
        char[] array = string.toCharArray();
        int i = 0;
        block11: while (i < array.length) {
            if (array[i] == '\\') {
                if (++i > array.length) {
                    throw this.error("Invalid character sequence" + this.toString());
                }
                switch (array[i]) {
                    case 'b': {
                        result.append('\b');
                        ++i;
                        break;
                    }
                    case 't': {
                        result.append('\t');
                        ++i;
                        break;
                    }
                    case 'n': {
                        result.append('\n');
                        ++i;
                        break;
                    }
                    case 'r': {
                        result.append('\r');
                        ++i;
                        break;
                    }
                    case '\'': {
                        result.append('\'');
                        ++i;
                        break;
                    }
                    case '\"': {
                        result.append('\"');
                        ++i;
                        break;
                    }
                    case '\\': {
                        result.append('\\');
                        ++i;
                        break;
                    }
                    case 'u': {
                        throw this.error("Invalid character sequence" + this.toString());
                    }
                    case '1': 
                    case '2': 
                    case '3': 
                    case '4': 
                    case '5': 
                    case '6': 
                    case '7': {
                        result.append(array[i]);
                        if (++i < array.length) {
                            if (Character.isDigit(array[i])) {
                                result.append(array[i]);
                                ++i;
                            }
                        } else {
                            throw this.error("Invalid character sequence" + this.toString());
                        }
                        if (i < array.length) {
                            if (!Character.isDigit(array[i])) continue block11;
                            result.append(array[i]);
                            ++i;
                            break;
                        }
                        throw this.error("Invalid character sequence: " + this.toString());
                    }
                }
                continue;
            }
            result.append(array[i]);
            ++i;
        }
        return result.toString();
    }

    public Vector getTransformChildren() {
        Vector result = new Vector();
        int i = 0;
        while (i < this.getChildren().size()) {
            if (this.getChildren().elementAt(i) instanceof TransformItem) {
                result.addElement(this.getChildren().elementAt(i));
            }
            ++i;
        }
        return result;
    }

    public Vector getTransportServiceChildren() {
        return this.getAllChildrenWithTagCode(15);
    }

    public String getType() {
        if (this.fType == null) {
            this.fType = this.findType();
        }
        return this.fType;
    }

    public String getTypeWithoutPackage() {
        return DeviceKitUtilities.stripPackage(this.getType());
    }

    public Vector getValueChildren() {
        return this.getChildrenWithTagCode(13);
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("description".equals(childNodeName)) {
            this.setDescription(ParserUtilities.extractData(childNode));
        } else if ("specreference".equals(childNodeName)) {
            this.handleSpecReference(childNode);
        } else if ("key".equals(childNodeName)) {
            this.setKey(ParserUtilities.extractData(childNode));
        }
    }

    protected Node handleReference(Node node) {
        int i = 0;
        while (i < references.size()) {
            Vector small = new Vector();
            small.add(references.elementAt(i));
            AnchorUtil util = new AnchorUtil(node, small);
            InputStream stream = null;
            try {
                stream = util.getAnchorFile();
                Document refDoc = ParserUtilities.parse(stream);
                stream.close();
                Node rnode = util.findAnchor(refDoc);
                if (rnode != null) {
                    return rnode;
                }
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
            ++i;
        }
        return null;
    }

    protected void handleSignal(Node node) {
        if (ParserUtilities.containsAttribute("idref", node)) {
            this.addChild(new SignalLinkElement(node, this));
        } else {
            SignalElement se = new SignalElement(node, this);
            this.addChild(se);
            if (ParserUtilities.containsAttribute("id", node)) {
                try {
                    collection.addSignal(se.getId(), se);
                }
                catch (Exception e) {
                    throw this.error(e.getMessage());
                }
            }
        }
    }

    protected void handleSpecReference(Node node) {
        SpecReferenceElement element = new SpecReferenceElement(node, this);
        String id = element.getId();
        if (id != null) {
            this.addChild(element);
            try {
                collection.addSpecReference(id, element);
            }
            catch (Exception exception) {}
        } else {
            SpecReferenceElement realSpec;
            String idref = element.getAttribute("idref");
            if (idref != null && (realSpec = (SpecReferenceElement)collection.getSpecReference(idref)) != null) {
                this.addChild(realSpec);
            }
        }
    }

    protected void handleValue(Node node) {
        ValueElement element = new ValueElement(node, this);
        this.addChild(element);
    }

    public boolean hasChildWithTagCode(int code) {
        int i = 0;
        while (i < this.getChildren().size()) {
            if (((TagElement)this.getChildren().elementAt(i)).getTagCode() == code) {
                return true;
            }
            if (((TagElement)this.getChildren().elementAt(i)).getTagCode() == 1000 + code) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasTransformChild() {
        Vector children = this.getChildren();
        int i = 0;
        while (i < children.size()) {
            if (children.elementAt(i) instanceof TransformItem) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void initialize() {
    }

    public boolean isChildOfCode(int code) {
        TagElement parent = this.getParent();
        while (parent != null) {
            if (parent.getTagCode() == code) {
                return true;
            }
            parent = parent.getParent();
        }
        return false;
    }

    public boolean isConstantParameter() {
        return true;
    }

    public boolean isFilterValid() {
        return true;
    }

    public boolean isFollowReferences() {
        return this.followReferences;
    }

    public boolean isLittleEndian() {
        return this.getAllChildrenWithTagCode(41).size() > 0;
    }

    public boolean isMessageClassElement() {
        return false;
    }

    public boolean isReferencedIdref(Node node) {
        return DkmlReferenceResolver.hasReferenceRef(node);
    }

    public boolean isRequiredParameter() {
        return true;
    }

    public final TagElement lookupField(String fieldName) {
        TagElement tagElement;
        String any = this.getAnyId();
        if (fieldName.equals(any)) {
            return this;
        }
        Vector list = this.getRealElement().getChildren();
        int i = 0;
        while (i < list.size()) {
            tagElement = (TagElement)list.get(i);
            String key = tagElement.getAnyId();
            if (key != null && key.length() > 0 && fieldName.equals(key)) {
                return tagElement;
            }
            ++i;
        }
        i = 0;
        while (i < list.size()) {
            TagElement fieldControl;
            tagElement = (TagElement)list.get(i);
            String controlKey = tagElement.getAnyId();
            if (any != null && !any.equals(controlKey) && (fieldControl = tagElement.lookupField(fieldName)) != null) {
                return fieldControl;
            }
            ++i;
        }
        return this.getRealElement().getElement(fieldName);
    }

    protected void setAttribute(String name, String value) {
        this.fAttributes.put(name, value);
    }

    protected void setChildren(TagElement[] children) {
        this.fChildren = new Vector();
        int i = 0;
        while (i < children.length) {
            this.fChildren.addElement(children[i]);
            ++i;
        }
    }

    protected void setDescription(String description) {
        this.fDescription = description;
    }

    public void setFollowReferences(boolean followReferences) {
        this.followReferences = followReferences;
    }

    protected void setKey(String key) {
        this.fKey = key;
    }

    protected void setName(String name) {
        this.fName = name;
    }

    protected void setPackageBase(String packageBase) {
        fPackageBase = packageBase;
        this.packageBase = packageBase;
        this.fDefaultPackage = packageBase;
    }

    protected void setParent(TagElement parent) {
        this.fParent = parent;
    }

    protected void setTextData(String data) {
        this.fTextData = data;
    }

    protected String toNewArrayString(String type) {
        return String.valueOf(this.toNewString(type)) + "[]";
    }

    protected String toNewString(String type) {
        return "new " + DeviceKitUtilities.stripPackage(type);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.getNode() != null) {
            Node parent = this.getNode().getParentNode();
            if (parent instanceof TagElement) {
                buffer.append(this.toString((TagElement)((Object)parent)));
                buffer.append("\r\n");
            }
            buffer.append("<");
            buffer.append(this.getName());
            Enumeration map = this.getAttributeNames();
            while (map.hasMoreElements()) {
                String name = (String)map.nextElement();
                buffer.append(' ');
                buffer.append(String.valueOf(name) + " = \"" + this.getAttribute(name));
            }
            String key = this.getKey();
            if (key != null && key.length() > 0) {
                buffer.append(" key=");
                buffer.append(key);
            }
            buffer.append(">");
        } else {
            TagElement parent = this.getParent();
            if (parent != null) {
                buffer.append(parent.toString());
                buffer.append("\r\n");
            }
        }
        return buffer.toString();
    }

    public String toString(TagElement element) {
        StringBuffer buffer = new StringBuffer();
        int parentCount = 0;
        TagElement temp = element;
        while (temp.getParent() != null) {
            ++parentCount;
            temp = temp.getParent();
        }
        TagElement parent = element.getParent();
        if (parent != null) {
            buffer.append(this.toString(parent));
            buffer.append("\r\n");
        }
        int i = 0;
        while (i < parentCount) {
            buffer.append(' ');
            ++i;
        }
        buffer.append("<");
        buffer.append(element.getName());
        if (element.getAttribute("id") != null) {
            buffer.append(" id=\"");
            buffer.append(element.getAttribute("id"));
            buffer.append('\"');
        }
        buffer.append(">");
        return buffer.toString();
    }

    public final void updateBytes(BytesGenerator bytesGenerator) {
        TagElement realElement = this;
        String idref = this.getAttribute("idref");
        if (idref != null) {
            TagElement tagElementRef = collection.getParameter(idref);
            if (tagElementRef != null) {
                realElement = tagElementRef;
            } else {
                throw new IllegalArgumentException(idref);
            }
        }
        if (!this.isFilterValid()) {
            bytesGenerator.setFilterValid(false);
        }
        realElement.updateBytes(bytesGenerator, this.isFilterValid());
    }

    public void updateBytes(BytesGenerator bytesGenerator, boolean filterValid) {
        int length = this.getBitLengthValue(this.getLengthDefault());
        if (length > 0 && this.getOffset() == null & this.getIndex() == null) {
            String comment = this.getId();
            if (comment == null && (comment = this.getIdRef()) == null) {
                comment = "";
            }
            bytesGenerator.add(length, 0L, false, comment);
        }
        this.updateBytesChildren(bytesGenerator, filterValid);
    }

    public void updateBytesChildren(BytesGenerator bytesGenerator, boolean filterValid) {
        if (filterValid && this.isFilterValid()) {
            Vector parameters = this.getParameterChildren();
            int parameterSize = parameters.size();
            int newCode = 0;
            if (parameterSize > 0) {
                int i = 0;
                while (i < parameterSize) {
                    TagElement tagElement = (TagElement)parameters.elementAt(i);
                    if (tagElement instanceof GeneralParameterElement) {
                        ++newCode;
                    }
                    tagElement.updateBytes(bytesGenerator);
                    ++i;
                }
            }
        }
    }

    protected void validate() {
    }
}

