/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.ConnectionElement;
import org.eclipse.soda.devicekit.generator.model.elements.CustomParameter;
import org.eclipse.soda.devicekit.generator.model.elements.EchoElement;
import org.eclipse.soda.devicekit.generator.model.elements.ExportedServiceElement;
import org.eclipse.soda.devicekit.generator.model.elements.FileElement;
import org.eclipse.soda.devicekit.generator.model.elements.GpioElement;
import org.eclipse.soda.devicekit.generator.model.elements.I2CElement;
import org.eclipse.soda.devicekit.generator.model.elements.IConnectionItem;
import org.eclipse.soda.devicekit.generator.model.elements.ImportElement;
import org.eclipse.soda.devicekit.generator.model.elements.MainTagElement;
import org.eclipse.soda.devicekit.generator.model.elements.MessageElement;
import org.eclipse.soda.devicekit.generator.model.elements.MostElement;
import org.eclipse.soda.devicekit.generator.model.elements.RandomAccessFileElement;
import org.eclipse.soda.devicekit.generator.model.elements.RootElement;
import org.eclipse.soda.devicekit.generator.model.elements.SSLElement;
import org.eclipse.soda.devicekit.generator.model.elements.SSLServerElement;
import org.eclipse.soda.devicekit.generator.model.elements.SerialElement;
import org.eclipse.soda.devicekit.generator.model.elements.SpecElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.elements.TcpipElement;
import org.eclipse.soda.devicekit.generator.model.elements.TcpipServerElement;
import org.eclipse.soda.devicekit.generator.model.elements.TransportServiceElement;
import org.eclipse.soda.devicekit.generator.model.elements.UrlConnectionElement;
import org.eclipse.soda.devicekit.generator.model.elements.UsbElement;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class TransportElement
extends MainTagElement {
    private String fResponseTimeout;
    private String fRetryTime;
    private String noActivityTimeout;
    private Vector connections;

    public TransportElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected void buildChildren() {
        String name = this.getAttribute("bundle");
        if (name == null) {
            name = this.getId();
        }
        if (name != null) {
            if (!name.toLowerCase().endsWith("transport")) {
                name = String.valueOf(name) + "Transport";
            }
            TagElement root = this.getParent();
            while (root != null && !(root instanceof RootElement)) {
                root = root.getParent();
            }
        }
        super.buildChildren();
    }

    public Vector getConnectionChildren() {
        return this.getConnections();
    }

    private Vector getConnections() {
        if (this.connections == null) {
            this.connections = new Vector();
        }
        return this.connections;
    }

    public String[] getImplementedInterfaces() {
        Vector<String> result = new Vector<String>();
        result.addElement(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        String service = this.getAttribute("service");
        if (service != null) {
            result.addElement(service);
        }
        Vector exportedService = this.getAllChildrenWithTagCode(30);
        int i = 0;
        while (i < exportedService.size()) {
            if (((TagElement)exportedService.elementAt(i)).getTextData() != null) {
                result.addElement(((TagElement)exportedService.elementAt(i)).getTextData());
            }
            ++i;
        }
        String[] interfaces = new String[result.size()];
        int i2 = 0;
        while (i2 < result.size()) {
            interfaces[i2] = (String)result.elementAt(i2);
            ++i2;
        }
        return interfaces;
    }

    public String getNoActivityTimeout() {
        return this.noActivityTimeout;
    }

    public Vector getRequiredBundles() {
        return this.getConnections();
    }

    public String getResponseTimeout() {
        return this.fResponseTimeout;
    }

    public String getRetryTime() {
        if (this.fRetryTime == null) {
            return null;
        }
        if (this.fRetryTime.trim().length() == 0) {
            return null;
        }
        return this.fRetryTime.trim();
    }

    public String getServiceType() {
        return DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE;
    }

    public String getSuperClass() {
        String name = this.getAttribute("superclass");
        if (name != null && name.length() > 0) {
            return name;
        }
        if (this.getConnectionChildren().size() > 0) {
            if (this.getResponseTimeout() != null) {
                return DeviceKitGenerationConstants.CLASS_TRANSPORT_RESPONSE;
            }
            return DeviceKitGenerationConstants.CLASS_TRANSPORT_CONNECTION;
        }
        if (this.getTransportServiceChildren().size() > 0) {
            return DeviceKitGenerationConstants.CLASS_TRANSPORT_TUNNEL;
        }
        return DeviceKitGenerationConstants.CLASS_TRANSPORT_THREAD;
    }

    public int getTagCode() {
        return 9;
    }

    public Hashtable[] getTransportProperties() {
        Vector customParams;
        ArrayList properties = new ArrayList();
        Vector connections = this.getConnectionChildren();
        int i = 0;
        while (i < connections.size()) {
            TagElement te = (TagElement)connections.elementAt(i);
            properties.add(te.getProperties());
            ++i;
        }
        if (connections.size() > 0) {
            Hashtable<String, String> table = new Hashtable<String, String>();
            table.put("connection", ((IConnectionItem)connections.get(0)).getConnectionTag());
            properties.add(table);
        }
        if (this.getResponseTimeout() != null) {
            Hashtable<String, String> table = new Hashtable<String, String>();
            table.put("responsetimeout", this.getResponseTimeout());
            properties.add(table);
        }
        if ((customParams = this.getAllChildrenWithTagCode(46)) != null && customParams.size() > 0) {
            Hashtable<String, String> table = new Hashtable<String, String>();
            int i2 = 0;
            while (i2 < customParams.size()) {
                CustomParameter parameter = (CustomParameter)customParams.get(i2);
                String name = parameter.getAttribute("name");
                String value = parameter.getAttribute("defaultvalue");
                if (value != null) {
                    table.put(name, value);
                }
                ++i2;
            }
            properties.add(table);
        }
        Hashtable[] propertisArray = new Hashtable[properties.size()];
        properties.toArray(propertisArray);
        return propertisArray;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("message".equals(childNodeName)) {
            this.handleMessage(childNode);
        } else if ("exportservice".equals(childNodeName)) {
            this.handleExportService(childNode);
        } else if ("import".equals(childNodeName)) {
            this.handleImport(childNode);
        } else if ("connection".equals(childNodeName)) {
            this.handleConnection(childNode);
        } else if ("echo".equals(childNodeName)) {
            this.handleEcho(childNode);
        } else if ("file".equals(childNodeName)) {
            this.handleFile(childNode);
        } else if ("gpio".equals(childNodeName)) {
            this.handleGpio(childNode);
        } else if ("i2c".equals(childNodeName)) {
            this.handleI2C(childNode);
        } else if ("most".equals(childNodeName)) {
            this.handleMost(childNode);
        } else if ("serial".equals(childNodeName)) {
            this.handleSerial(childNode);
        } else if ("tcpip".equals(childNodeName)) {
            this.handleTcpip(childNode);
        } else if ("ssl".equals(childNodeName)) {
            this.handleSSL(childNode);
        } else if ("usb".equals(childNodeName)) {
            this.handleUsb(childNode);
        } else if ("urlconnection".equals(childNodeName)) {
            this.handleUrlConnection(childNode);
        } else if ("tcpipserver".equals(childNodeName)) {
            this.handleTcpipServer(childNode);
        } else if ("sslserver".equals(childNodeName)) {
            this.handleSSLServer(childNode);
        } else if ("transportservice".equals(childNodeName)) {
            this.handleTransportService(childNode);
        } else if ("responsetimeout".equals(childNodeName)) {
            this.setResponseTimeout(ParserUtilities.extractData(childNode));
        } else if ("retrytime".equals(childNodeName)) {
            this.setRetryTime(ParserUtilities.extractData(childNode));
        } else if ("randomaccessfile".equals(childNodeName)) {
            this.handleRandomAccessFile(childNode);
        } else if ("spec".equals(childNodeName)) {
            this.handleSpec(childNode);
        } else if ("noactivitytimeout".equals(childNodeName)) {
            this.setNoActivityTimeout(ParserUtilities.extractData(childNode));
        } else {
            super.handleChild(childNode);
        }
    }

    private void handleConnection(Node node) {
        ConnectionElement element = new ConnectionElement(node, this);
        this.addChild(element);
        this.getConnections().addElement(element);
    }

    private void handleEcho(Node node) {
        EchoElement element = new EchoElement(node, this);
        this.addChild(element);
        this.getConnections().addElement(element);
    }

    private void handleExportService(Node node) {
        ExportedServiceElement element = new ExportedServiceElement(node, this);
        this.addChild(element);
    }

    private void handleFile(Node node) {
        FileElement element = new FileElement(node, this);
        this.addChild(element);
        this.getConnections().addElement(element);
    }

    private void handleGpio(Node node) {
        GpioElement element = new GpioElement(node, this);
        this.addChild(element);
        this.getConnections().addElement(element);
    }

    private void handleI2C(Node node) {
        I2CElement element = new I2CElement(node, this);
        this.addChild(element);
        this.getConnections().addElement(element);
    }

    private void handleImport(Node node) {
        ImportElement element = new ImportElement(node, this);
        this.addChild(element);
    }

    private void handleMessage(Node node) {
        MessageElement element = new MessageElement(node, this);
        this.addChild(element);
        if (ParserUtilities.containsAttribute("id", node)) {
            try {
                TagElement.collection.addMessage(element.getId(), element);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleMost(Node node) {
        MostElement element = new MostElement(node, this);
        this.addChild(element);
        this.getConnections().addElement(element);
    }

    private void handleRandomAccessFile(Node node) {
        RandomAccessFileElement element = new RandomAccessFileElement(node, this);
        this.addChild(element);
        this.getConnections().addElement(element);
    }

    private void handleSSL(Node node) {
        SSLElement element = new SSLElement(node, this);
        this.addChild(element);
        this.getConnections().addElement(element);
    }

    private void handleSSLServer(Node node) {
        SSLServerElement element = new SSLServerElement(node, this);
        this.addChild(element);
        this.getConnections().addElement(element);
    }

    private void handleSerial(Node node) {
        SerialElement element = new SerialElement(node, this);
        this.addChild(element);
        this.getConnections().addElement(element);
    }

    public void handleSpec(Node node) {
        SpecElement se = new SpecElement(node, this);
        this.addChild(se);
        if (se.getId() != null) {
            try {
                TagElement.collection.addSpec(se.getId(), se);
            }
            catch (Exception e) {
                throw this.error(e.getMessage());
            }
        }
    }

    private void handleTcpip(Node node) {
        TcpipElement element = new TcpipElement(node, this);
        this.addChild(element);
        this.getConnections().addElement(element);
    }

    private void handleTcpipServer(Node node) {
        TcpipServerElement element = new TcpipServerElement(node, this);
        this.addChild(element);
        this.getConnections().addElement(element);
    }

    private void handleTransportService(Node node) {
        TransportServiceElement element = new TransportServiceElement(node, this);
        this.addChild(element);
    }

    private void handleUrlConnection(Node node) {
        UrlConnectionElement element = new UrlConnectionElement(node, this);
        this.addChild(element);
        this.getConnections().addElement(element);
    }

    private void handleUsb(Node node) {
        UsbElement element = new UsbElement(node, this);
        this.addChild(element);
        this.getConnections().addElement(element);
    }

    public boolean isAbstract() {
        String abs = this.getAttribute("abstract");
        return abs != null && abs.equals("true");
    }

    public void setNoActivityTimeout(String string) {
        this.noActivityTimeout = string;
    }

    private void setResponseTimeout(String responseTimeout) {
        this.fResponseTimeout = responseTimeout;
    }

    private void setRetryTime(String retryTime) {
        this.fRetryTime = retryTime;
    }
}

