/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.elements;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.model.elements.ConfigurationField;
import org.eclipse.soda.devicekit.generator.model.elements.IConnectionItem;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.Node;

public class UrlConnectionElement
extends TagElement
implements IConnectionItem {
    private String fUrl;

    public UrlConnectionElement(Node node, TagElement parent) {
        super(node, parent);
    }

    protected String findType() {
        if (this.getAttribute("implementation") != null) {
            return this.getAttribute("implementation");
        }
        return DeviceKitGenerationConstants.CLASS_CONNECTION_URL;
    }

    public ConfigurationField[] getConfigurationOptions() {
        ArrayList<ConfigurationField> list = new ArrayList<ConfigurationField>();
        list.add(new ConfigurationField("String", "DEFAULT_URL", DeviceKitUtilities.quote(this.getUrl())));
        ConfigurationField[] pairs = new ConfigurationField[list.size()];
        list.toArray(pairs);
        return pairs;
    }

    public String getConnectionConstant() {
        StringBuffer buffer = new StringBuffer(32);
        buffer.append(DkUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_URL_SERVICE));
        buffer.append('.');
        buffer.append("CONNECTION_TYPE");
        return buffer.toString();
    }

    public String getConnectionTag() {
        return "url";
    }

    public String[] getExtraImports() {
        return new String[0];
    }

    public Hashtable getProperties() {
        Hashtable<String, String> table = new Hashtable<String, String>();
        if (this.getUrl() != null) {
            table.put("url", this.getUrl());
        }
        return table;
    }

    public int getTagCode() {
        return 34;
    }

    public String getUrl() {
        if (this.fUrl == null) {
            return "";
        }
        return this.fUrl;
    }

    protected void handleChild(Node childNode) {
        String childNodeName = childNode.getNodeName();
        if ("url".equals(childNodeName)) {
            this.setUrl(ParserUtilities.extractData(childNode));
        } else {
            super.handleChild(childNode);
        }
    }

    protected void setUrl(String url) {
        this.fUrl = url;
    }
}

