/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.model.xml;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.soda.devicekit.generator.internal.model.xml.XmlElement;
import org.eclipse.soda.devicekit.generator.internal.print.xml.XmlModelPrinter;
import org.eclipse.soda.devicekit.generator.model.IGeneratorModel;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;
import org.eclipse.soda.devicekit.generator.save.IFileSaver;

public class XmlModel
implements IGeneratorModel {
    private List elements;
    private List comments;
    private String fileName;
    private IFileSaver saver;

    public XmlModel(String fileName) {
        this.fileName = fileName;
        this.elements = new ArrayList();
        this.comments = new ArrayList();
    }

    public void addComment(String comment) {
        this.comments.add(comment);
    }

    public void addComments(String[] comments) {
        int i = 0;
        while (i < comments.length) {
            this.addComment(comments[i]);
            ++i;
        }
    }

    public IXmlElement addElement(String tag) {
        XmlElement element = new XmlElement(tag);
        this.getElements().add(element);
        return element;
    }

    public List getComments() {
        return this.comments;
    }

    public String getContents() {
        return new XmlModelPrinter(this).getContents();
    }

    public List getElements() {
        return this.elements;
    }

    public String getFileName() {
        return this.fileName;
    }

    public IFileSaver getSaver() {
        return this.saver;
    }

    public Object save() throws Exception {
        IFileSaver saver = this.getSaver();
        if (saver != null) {
            return saver.save(this);
        }
        return null;
    }

    public void setComments(List comments) {
        this.comments = comments;
    }

    public void setSaver(IFileSaver saver) {
        this.saver = saver;
    }
}

