/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.save.java.eclipse;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.formatter.CodeFormatter;
import org.eclipse.jdt.internal.ui.actions.MultiOrganizeImportAction;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.soda.devicekit.generator.html.PackageHtmlGenerator;
import org.eclipse.soda.devicekit.generator.model.java.IJavaModel;
import org.eclipse.soda.devicekit.generator.save.java.IJavaSaver;
import org.eclipse.soda.devicekit.generator.save.java.eclipse.JavaSaverEclipseUtilities;
import org.eclipse.soda.devicekit.generator.util.JREPreferenceUtil;
import org.eclipse.soda.devicekit.preference.jre.DeviceKitJREConstants;
import org.eclipse.soda.devicekit.util.CoreUtility;
import org.eclipse.swt.widgets.Display;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class DeviceKitJavaSaver
implements IJavaSaver {
    private String projectName;
    private IProgressMonitor progressMonitor;

    public DeviceKitJavaSaver(String projectName) throws JavaModelException {
        this(projectName, (IProgressMonitor)new NullProgressMonitor());
    }

    public DeviceKitJavaSaver(String projectName, IProgressMonitor progressMonitor) throws JavaModelException {
        this.projectName = projectName;
        this.setProgressMonitor(progressMonitor);
    }

    protected boolean contentsChanged(ICompilationUnit cu, String newContents, boolean excludeImports) throws Exception {
        String tnewContents = newContents;
        String currContents = cu.getSource();
        if (excludeImports) {
            currContents = this.format(this.stripImports(currContents));
            tnewContents = this.format(this.stripImports(tnewContents));
        }
        return !this.isEqualString(currContents, tnewContents);
    }

    private void createProject(IProject project) throws Exception {
        project.create(null);
        project.open(null);
        CoreUtility.addNatureToProject(project, "org.eclipse.jdt.core.javanature", null);
        CoreUtility.addDeviceKitNatureToProject(project, null);
        CoreUtility.addNatureToProject(project, "org.eclipse.pde.PluginNature", null);
        IJavaProject jProject = JavaCore.create((IProject)project);
        String projectName = project.getName();
        String jreName = JREPreferenceUtil.getJRERuntimePath(JREPreferenceUtil.getJreInClasspath(DeviceKitJREConstants.PROJECT_TYPE_BY_JRE_DEFAULT));
        if (projectName.endsWith(".test")) {
            jreName = JREPreferenceUtil.getJRERuntimePath(JREPreferenceUtil.getJreInClasspath(DeviceKitJREConstants.PROJECT_TYPE_BY_JRE_TEST));
        } else if (projectName.endsWith(".test.agent") || projectName.endsWith(".test.agent.bundle") || projectName.endsWith("test.agent.factory") || projectName.endsWith("test.agent.managed")) {
            jreName = JREPreferenceUtil.getJRERuntimePath(JREPreferenceUtil.getJreInClasspath(DeviceKitJREConstants.PROJECT_TYPE_BY_JRE_TESTAGENT));
        }
        IClasspathEntry jre = JavaCore.newContainerEntry((IPath)new Path(jreName));
        IClasspathEntry plugins = JavaCore.newContainerEntry((IPath)new Path("org.eclipse.pde.core.requiredPlugins"));
        IFolder folder = project.getFolder("src");
        if (!folder.exists()) {
            folder.create(true, true, null);
        }
        IPath path = folder.getFullPath();
        path = path.makeAbsolute();
        IClasspathEntry sourceEntry = JavaCore.newSourceEntry((IPath)path);
        jProject.setRawClasspath(new IClasspathEntry[]{jre, plugins, sourceEntry}, null);
        CoreUtility.createCopyrightFile((IContainer)project, null);
        CoreUtility.createAboutFile((IContainer)project, null);
        CoreUtility.createCvsIgnoreFile((IContainer)project, null);
        CoreUtility.createEscPropertiesFile((IContainer)project, null);
        CoreUtility.createBuildPropertiesFile(project, null);
        CoreUtility.createSettings((IContainer)project, null);
    }

    protected String format(String source) {
        try {
            Hashtable table = JavaCore.getOptions();
            CodeFormatter codeFormatter = ToolFactory.createCodeFormatter((Map)table);
            TextEdit textEdit = codeFormatter.format(8, source, 0, source.length(), 0, null);
            if (textEdit != null) {
                Document doc = new Document(source);
                textEdit.apply((IDocument)doc);
                return doc.get();
            }
        }
        catch (Exception exception) {
            return source;
        }
        return source;
    }

    private IJavaProject getJavaProject(IProject project) {
        IJavaProject jProject = JavaCore.create((IProject)project);
        return jProject;
    }

    protected IPackageFragment getPackageFragment(IJavaModel model) throws Exception {
        IProject project = this.getProject(this.projectName);
        if (!project.exists()) {
            this.createProject(project);
        }
        IJavaProject javaProject = this.getJavaProject(project);
        return JavaSaverEclipseUtilities.getDkPackageFragment(javaProject, model.getPackage());
    }

    public IProgressMonitor getProgressMonitor() {
        if (this.progressMonitor == null) {
            this.progressMonitor = new NullProgressMonitor();
        }
        return this.progressMonitor;
    }

    private IProject getProject(String projectName) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsRoot = ws.getRoot();
        IProject project = wsRoot.getProject(projectName);
        return project;
    }

    protected boolean isEqualString(String s1, String s2) {
        if (s1 == null || s2 == null || s1.length() != s2.length()) {
            return false;
        }
        int i = 0;
        while (i < s1.length()) {
            char c2;
            char c1 = s1.charAt(i);
            if (c1 != (c2 = s2.charAt(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Object save(IJavaModel model) throws Exception {
        IPackageFragment pack = this.getPackageFragment(model);
        ICompilationUnit cu = null;
        if (pack != null && pack.exists()) {
            cu = pack.getCompilationUnit(String.valueOf(model.getName()) + ".java");
            String contents = this.format(model.getContents());
            return this.save(model, pack, cu, contents);
        }
        return cu;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object save(IJavaModel model, IPackageFragment pack, final ICompilationUnit cu, String contents) throws Exception {
        ICompilationUnit results = cu;
        this.savePackageHtml(pack);
        boolean doImports = false;
        if (cu.exists()) {
            IImportDeclaration[] imports = cu.getImports();
            if (this.contentsChanged(cu, contents, true)) {
                cu.getBuffer().setContents(contents);
                cu.getBuffer().save(this.getProgressMonitor(), true);
                doImports = true;
            } else {
                IFile resource = (IFile)cu.getResource();
                IMarker[] markers = resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 2);
                doImports = markers.length > 0;
            }
            int i = 0;
            while (i < imports.length) {
                IImportDeclaration aimport = imports[i];
                if (!aimport.isOnDemand()) {
                    String name = aimport.getElementName();
                    try {
                        cu.createImport(name, null, this.getProgressMonitor());
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                ++i;
            }
        } else {
            results = pack.createCompilationUnit(String.valueOf(model.getName()) + ".java", contents, true, this.getProgressMonitor());
            doImports = true;
        }
        if (doImports) {
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    try {
                        IWorkbenchPartSite site = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActivePart().getSite();
                        MultiOrganizeImportAction organizeImportsAction = new MultiOrganizeImportAction((IWorkbenchSite)site);
                        StructuredSelection structuredSelection = new StructuredSelection((Object[])new ICompilationUnit[]{cu});
                        organizeImportsAction.run((IStructuredSelection)structuredSelection);
                    }
                    catch (Exception exception) {}
                    1 var1_1 = this;
                    synchronized (var1_1) {
                        this.notifyAll();
                    }
                }
            };
            Display.getDefault().asyncExec(runnable);
            DeviceKitJavaSaver deviceKitJavaSaver = this;
            synchronized (deviceKitJavaSaver) {
                this.wait(5000L);
            }
        }
        return results;
    }

    private void savePackageHtml(IPackageFragment pack) {
        PackageHtmlGenerator packageHtmlGenerator = new PackageHtmlGenerator(pack);
        packageHtmlGenerator.generate();
    }

    public void setProgressMonitor(IProgressMonitor progressMonitor) {
        this.progressMonitor = progressMonitor;
    }

    protected String stripImports(String original) throws IOException {
        StringBuffer buff = new StringBuffer();
        LineNumberReader reader = new LineNumberReader(new StringReader(original));
        String line = reader.readLine();
        while (line != null) {
            if (!line.startsWith("import")) {
                buff.append(line);
            }
            line = reader.readLine();
        }
        return buff.toString();
    }
}

