/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.save.java.eclipse;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soda.devicekit.generator.model.java.IJavaModel;
import org.eclipse.soda.devicekit.generator.save.java.IJavaSaver;
import org.eclipse.soda.devicekit.generator.save.java.eclipse.DeviceKitJavaSaver;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;

public class DeviceKitResourceBundleSaver
implements IJavaSaver {
    private DeviceKitJavaSaver deviceKitJavaSaver;
    private Properties messages;

    public DeviceKitResourceBundleSaver(IJavaSaver deviceKitJavaSaver, Properties messages) {
        this.deviceKitJavaSaver = (DeviceKitJavaSaver)deviceKitJavaSaver;
        this.messages = messages;
    }

    public DeviceKitResourceBundleSaver(String projectName) throws JavaModelException {
        this.deviceKitJavaSaver = new DeviceKitJavaSaver(projectName);
    }

    public DeviceKitResourceBundleSaver(String projectName, IProgressMonitor progressMonitor) throws JavaModelException {
        this.deviceKitJavaSaver = new DeviceKitJavaSaver(projectName, progressMonitor);
    }

    private IJavaProject getJavaProject(IJavaElement javaElement) {
        if (javaElement instanceof IJavaProject || javaElement == null) {
            return (IJavaProject)javaElement;
        }
        return this.getJavaProject(javaElement.getParent());
    }

    public String getPropertiesFileContent() {
        StringBuffer content = new StringBuffer(1024);
        content.append(GeneratorTemplates.getCopyrightPropertyString(GeneratorTemplates.getTemplateVariables(-1)));
        content.append('\n');
        if (this.messages != null) {
            Enumeration<Object> msgIds = this.messages.keys();
            while (msgIds.hasMoreElements()) {
                String msgId = (String)msgIds.nextElement();
                String message = this.messages.getProperty(msgId);
                content.append(String.valueOf(msgId) + '=' + message + '\n');
            }
        }
        return content.toString();
    }

    public Object save(IJavaModel model) throws Exception {
        IPackageFragment pack = this.deviceKitJavaSaver.getPackageFragment(model);
        this.savePropertiesFile(pack, String.valueOf(model.getName()) + ".properties");
        ICompilationUnit cu = null;
        if (pack != null && pack.exists() && !(cu = pack.getCompilationUnit(String.valueOf(model.getName()) + ".java")).exists()) {
            String contents = this.deviceKitJavaSaver.format(model.getContents());
            return this.deviceKitJavaSaver.save(model, pack, cu, contents);
        }
        return cu;
    }

    private void savePropertiesFile(IPackageFragment pack, String fileName) throws Exception {
        IJavaProject javaProject = this.getJavaProject((IJavaElement)pack);
        String name = String.valueOf(pack.getResource().getProjectRelativePath().toPortableString()) + '/' + fileName;
        IFile file = javaProject.getProject().getFile(name);
        if (!file.exists()) {
            ByteArrayInputStream source = new ByteArrayInputStream(this.getPropertiesFileContent().getBytes());
            file.create((InputStream)source, true, (IProgressMonitor)new NullProgressMonitor());
        }
    }
}

