/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.save.java.eclipse;

import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.soda.devicekit.util.CoreUtility;

public class JavaSaverEclipseUtilities {
    public static IPackageFragment getDkPackageFragement(IJavaProject project, String pack, boolean sourceFolder, String sfName) throws Exception {
        if (!sourceFolder) {
            return JavaSaverEclipseUtilities.getPackageFragmentForPackage(project, pack);
        }
        return JavaSaverEclipseUtilities.getPackageFragmentForSourceFolder(project, pack, sfName);
    }

    public static IPackageFragment getDkPackageFragment(IJavaProject project, String pack) throws Exception {
        return JavaSaverEclipseUtilities.getDkPackageFragement(project, pack, false, null);
    }

    public static IJavaProject getJavaProjectFromProject(IProject project) {
        return JavaCore.create((IProject)project);
    }

    public static IFile getManifest(IContainer resource) throws CoreException {
        IResource[] res = resource.members();
        int i = 0;
        while (i < res.length) {
            IFile file;
            if (res[i].getName().equals("META-INF")) {
                IFolder metaInf = (IFolder)res[i];
                return metaInf.getFile("MANIFEST.MF");
            }
            if (res[i] instanceof IContainer && (file = JavaSaverEclipseUtilities.getManifest((IContainer)res[i])) != null) {
                return file;
            }
            ++i;
        }
        return null;
    }

    public static IPackageFragment getPackageFragmentForPackage(IJavaProject project, String pack) throws Exception {
        IPackageFragmentRoot firstRoot = null;
        IPackageFragmentRoot sameProject = null;
        Vector<IPackageFragmentRoot> sourceRoots = new Vector<IPackageFragmentRoot>();
        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getKind() == 1) {
                IPackageFragment packFrag;
                boolean exists;
                sourceRoots.addElement(roots[i]);
                if (firstRoot == null) {
                    firstRoot = roots[i];
                }
                if (sameProject == null && roots[i].getJavaProject().equals(project)) {
                    sameProject = roots[i];
                }
                boolean bl = exists = (packFrag = roots[i].getPackageFragment(pack)) != null && packFrag.getResource().exists();
                if (exists) {
                    return roots[i].getPackageFragment(pack);
                }
            }
            ++i;
        }
        String projectName = project.getElementName();
        int i2 = 0;
        while (i2 < sourceRoots.size()) {
            IPackageFragmentRoot currRoot = (IPackageFragmentRoot)sourceRoots.elementAt(i2);
            if (projectName.equals(currRoot.getElementName())) {
                return currRoot.createPackageFragment(pack, false, null);
            }
            ++i2;
        }
        if (sameProject != null) {
            return sameProject.createPackageFragment(pack, false, null);
        }
        if (firstRoot != null) {
            return firstRoot.createPackageFragment(pack, false, null);
        }
        IFolder folder = project.getProject().getFolder(project.getElementName());
        if (folder != null && !folder.exists()) {
            folder.create(false, true, null);
        }
        IPackageFragmentRoot root = project.getPackageFragmentRoot((IResource)folder);
        return root.createPackageFragment(pack, false, null);
    }

    public static IPackageFragment getPackageFragmentForSourceFolder(IJavaProject project, String pack, String sfName) throws Exception {
        IFile copyright;
        IPackageFragmentRoot[] roots = project.getAllPackageFragmentRoots();
        IPackageFragmentRoot matchingName = null;
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getKind() == 1 && roots[i].getElementName().equals(sfName)) {
                matchingName = roots[i];
                break;
            }
            ++i;
        }
        IFolder folder = null;
        folder = project.getProject().getFolder(sfName);
        if (!folder.exists()) {
            folder.create(false, true, null);
        }
        if ((copyright = folder.getFile((IPath)new Path("copyright.txt"))) == null || !copyright.exists()) {
            CoreUtility.createCopyrightFile((IContainer)folder, null);
        }
        if ((matchingName = project.getPackageFragmentRoot((IResource)folder)) == null || !matchingName.exists()) {
            IClasspathEntry entry = JavaCore.newSourceEntry((IPath)folder.getFullPath());
            IClasspathEntry[] cp = project.getRawClasspath();
            IClasspathEntry[] newCp = new IClasspathEntry[cp.length + 1];
            System.arraycopy(cp, 0, newCp, 0, cp.length);
            newCp[newCp.length - 1] = entry;
            project.setRawClasspath(newCp, null);
        }
        if (matchingName != null) {
            IPackageFragment frag = matchingName.getPackageFragment(pack);
            if (frag == null || !frag.exists()) {
                matchingName.createPackageFragment(pack, true, null);
            }
            return frag;
        }
        return null;
    }
}

