/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.sim;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.MonitorElement;
import org.eclipse.soda.devicekit.generator.model.elements.TagElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.sim.DkTransportSimGenerator;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkTransportMonitorTestGenerator
extends DkTransportSimGenerator {
    public DkTransportMonitorTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    protected void codeBACreateService(IType ba) {
        String[] comment = new String[]{"Creates the monitor test.", "", "@return Object The monitor test.", "@see " + this.getMainFqn()};
        KeyValuePair param = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE), "transportService");
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(this.getMainClassName());
        buffer.append(" monitor = new ");
        buffer.append(this.getMainClassName());
        this.fBundleActivatorModel.addImport(this.getMainFqn());
        buffer.append("();\n");
        buffer.append("monitor.setTransport(transportService);\n");
        buffer.append("return monitor;\n");
        String contents = buffer.toString();
        this.codeMethod(ba, "createService", comment, "Object", 1L, contents, new KeyValuePair[]{param}, null);
    }

    protected void codeFields(IType monitorTest) {
        super.codeFields(monitorTest);
        this.codeMonitorConnectionField(monitorTest);
        this.codeMonitorTransportField(monitorTest);
        this.codeTransportRecFileNameField(monitorTest);
        this.codeTransportField(monitorTest);
    }

    protected void codeGetTransport(IType test) {
        String returnType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        this.codeMethod(test, "getTransport", "Gets the transport to be tested.", returnType, 1L, "return this.transport;\n");
    }

    protected void codeMethods(IType test) {
        super.codeMethods(test);
        this.codeSetTransport(test);
        this.codeGetTransport(test);
    }

    private void codeMonitorConnectionField(IType monitorTest) {
        String fieldType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MONITOR_CONNECTION);
        String value = null;
        this.codeField(monitorTest, "monitorConnection", fieldType, 2L, "Field monitorConnection.", value);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MONITOR_CONNECTION);
    }

    private void codeMonitorTransportField(IType monitorTest) {
        String fieldType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MONITOR_TRANSPORT);
        String value = null;
        this.codeField(monitorTest, "monitorTransport", fieldType, 2L, "Field monitorTransport.", value);
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MONITOR_TRANSPORT);
    }

    protected void codeSetTransport(IType test) {
        KeyValuePair param = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE), "transport");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        StringBuffer buffer = new StringBuffer(32);
        buffer.append("this.transport = transport;\n");
        String contents = buffer.toString();
        this.codeMethod(test, "setTransport", "Sets the transport to be tested.", "void", 1L, contents, new KeyValuePair[]{param}, null);
    }

    private void codeTransportField(IType monitorTest) {
        String fieldType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        this.codeField(monitorTest, "transport", fieldType, 2L, "Define the transport service to tested.", "null");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
    }

    private void codeTransportRecFileNameField(IType monitorTest) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("getStaticString(\"");
        buffer.append(this.getBaseName().toLowerCase());
        buffer.append(".transportrec\", \"");
        buffer.append(this.getBaseName());
        buffer.append("TransportRec.xml\");");
        String value = buffer.toString();
        this.codeField(monitorTest, "TRANSPORT_REC_FILENAME", "String", 50L, "Field TRANSPORT_REC_FILENAME.", value);
    }

    protected boolean doGenerateBundleActivator() {
        return true;
    }

    protected boolean doGenerateService() {
        return true;
    }

    protected String getBAActivateContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("if (monitor != null)\n");
        buffer.append("monitor.start();\n");
        return buffer.toString();
    }

    protected String getBADeactivateContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("if (this.");
        buffer.append("monitor");
        buffer.append(" != null) {\n");
        buffer.append('\t');
        buffer.append("monitor");
        buffer.append(".stop();\n");
        buffer.append('\t');
        buffer.append("monitor");
        buffer.append(".setTransport(null);\n");
        buffer.append("}\n");
        buffer.append("monitor");
        buffer.append(" = null;\n");
        buffer.append("super.deactivate();\n");
        return buffer.toString();
    }

    protected String getBASetInterestContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("super.setInterest(interest);\n");
        buffer.append("if (this.");
        buffer.append("monitor");
        buffer.append(" != null) {\n");
        buffer.append("\tthis.");
        buffer.append("monitor");
        buffer.append(".setTransport((");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE));
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        buffer.append(") interest);\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getBaseName() {
        return DeviceKitUtilities.removeLastOccurence(this.getMainClassName(), "Monitor");
    }

    protected String getConstructorContents() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("super();\n");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT);
        buffer.append(' ');
        buffer.append("transport");
        buffer.append(" = ");
        buffer.append("new " + DeviceKitUtilities.stripPackage(this.getTestElement().getTargetClass()) + "();\n");
        buffer.append("transport");
        buffer.append(".setup();\n");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_SERVICE);
        buffer.append(' ');
        buffer.append("defaultConnection");
        buffer.append(" = ");
        buffer.append("transport");
        buffer.append('.');
        buffer.append("getConnection");
        buffer.append("();\n");
        buffer.append(" \n");
        buffer.append("try {\n");
        buffer.append('\t');
        buffer.append("monitorConnection");
        buffer.append(" = new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MONITOR_CONNECTION));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MONITOR_CONNECTION);
        buffer.append("(defaultConnection, new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_FILE_OUTPUT_HANDLER));
        buffer.append('(');
        buffer.append("CONNECTION_REC_FILENAME");
        buffer.append("));\n");
        buffer.append("} catch (IOException ioe) {\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_IOEXCEPTION);
        buffer.append("\tioe.printStackTrace();\n");
        buffer.append("}\n");
        buffer.append("if (transport instanceof ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_TRANSPORT_SERVICE));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_TRANSPORT_SERVICE);
        buffer.append(") {\n");
        buffer.append("\t((");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_TRANSPORT_SERVICE));
        buffer.append(") transport).setConnection(");
        buffer.append("monitorConnection");
        buffer.append(");\n");
        buffer.append("}\n");
        buffer.append("try {\n");
        buffer.append('\t');
        buffer.append("monitorTransport");
        buffer.append(" = new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_MONITOR_TRANSPORT));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_MONITOR_TRANSPORT);
        buffer.append("(transport, new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_FILE_OUTPUT_HANDLER));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_FILE_OUTPUT_HANDLER);
        buffer.append('(');
        buffer.append("TRANSPORT_REC_FILENAME");
        buffer.append("));\n");
        buffer.append("} catch (IOException ioe) {\n");
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_IOEXCEPTION);
        buffer.append("\tioe.printStackTrace();\n");
        buffer.append("}\n");
        buffer.append("setTransport");
        buffer.append('(');
        buffer.append("monitorTransport");
        buffer.append(");\n");
        return buffer.toString();
    }

    protected String[] getImplementedInterfaces() {
        return new String[]{this.getServiceFqn()};
    }

    protected String getMainContents() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("try {\n");
        buffer.append('\t');
        buffer.append("final ");
        buffer.append(this.getMainClassName());
        buffer.append(' ');
        buffer.append("monitor");
        buffer.append(" = new ");
        buffer.append(this.getMainClassName());
        buffer.append("();\n");
        buffer.append('\t');
        buffer.append("monitor");
        buffer.append(".start();\n");
        buffer.append('\t');
        buffer.append(DeviceKitUtilities.stripPackage("Thread"));
        this.fTestModel.addImport("Thread");
        buffer.append(".sleep(getStaticLong(\"");
        buffer.append(this.getMainClassName().toLowerCase());
        String monitorTime = this.getMonitorTime("30000");
        buffer.append(".maintime\", ");
        buffer.append(monitorTime);
        buffer.append("));\n");
        buffer.append('\t');
        buffer.append("monitor");
        buffer.append(".stop();\n");
        buffer.append("} catch (final Exception exception) {\n");
        buffer.append("\texception.printStackTrace(System.out);\n");
        buffer.append("}\n");
        buffer.append("System.exit(0);\n");
        return buffer.toString();
    }

    protected String getManifestDescription() {
        Vector monitor = this.getTestElement().getAllChildrenWithTagCode(48);
        MonitorElement element = (MonitorElement)monitor.get(0);
        if (element.getDescription() != null) {
            return element.getDescription();
        }
        return String.valueOf(this.getMainElement().getId()) + " Monitor";
    }

    protected String getMonitorTime(String defaultTime) {
        Vector monitor = this.getTestElement().getAllChildrenWithTagCode(48);
        if (monitor.size() > 0) {
            TagElement element = (TagElement)monitor.elementAt(0);
            if (element.getAttribute("monitortime") != null) {
                return element.getAttribute("monitortime");
            }
            return defaultTime;
        }
        return defaultTime;
    }

    protected String getSimTestName(String defaultName) {
        String className = DeviceKitUtilities.removeLastOccurence(defaultName, "Test");
        className = String.valueOf(className) + "Monitor";
        return className;
    }

    protected String getStartContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("monitorConnection");
        buffer.append(".startMonitoring();\n");
        buffer.append("monitorTransport");
        buffer.append(".startMonitoring();\n");
        buffer.append("if (getTransport() != null) {\n");
        buffer.append("\tgetTransport().start();\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getStopContents() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("monitorConnection");
        buffer.append(".stopMonitoring();\n");
        buffer.append("try {\n");
        buffer.append('\t');
        buffer.append(DeviceKitUtilities.stripPackage("Thread"));
        this.fTestModel.addImport("Thread");
        buffer.append(".sleep(100);\n");
        buffer.append("\t} catch (InterruptedException e) {\n");
        buffer.append("\te.printStackTrace();\n");
        buffer.append("}\n");
        buffer.append("if (getTransport() != null) {\n");
        buffer.append("\tgetTransport().exit();\n");
        buffer.append("}\n");
        buffer.append("monitorTransport");
        buffer.append(".stopMonitoring();\n");
        return buffer.toString();
    }

    protected String getSuperClass() {
        return DeviceKitGenerationConstants.CLASS_CORE_ESC_OBJECT;
    }
}

