/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.sim;

import java.util.Vector;
import org.eclipse.soda.devicekit.generator.constants.DeviceKitGenerationConstants;
import org.eclipse.soda.devicekit.generator.metadata.model.GeneratedInfo;
import org.eclipse.soda.devicekit.generator.model.DeviceKitTagModel;
import org.eclipse.soda.devicekit.generator.model.elements.PlayBackElement;
import org.eclipse.soda.devicekit.generator.model.java.IType;
import org.eclipse.soda.devicekit.generator.sim.DkTransportSimGenerator;
import org.eclipse.soda.devicekit.generator.util.DeviceKitUtilities;
import org.eclipse.soda.devicekit.util.KeyValuePair;

public class DkTransportPlayBackTestGenerator
extends DkTransportSimGenerator {
    public DkTransportPlayBackTestGenerator(DeviceKitTagModel model, GeneratedInfo generatedInfo) {
        super(model, generatedInfo);
    }

    protected void codeBACreateService(IType ba) {
        String[] comment = new String[]{"Creates the play back test.", "", "@return Object The play back test.", "@see " + this.getMainFqn()};
        KeyValuePair param = new KeyValuePair(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE), "transportService");
        this.fBundleActivatorModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT_SERVICE);
        StringBuffer buffer = new StringBuffer(64);
        buffer.append(this.getMainClassName());
        buffer.append(" playBack = new ");
        buffer.append(this.getMainClassName());
        this.fBundleActivatorModel.addImport(this.getMainFqn());
        buffer.append("();\n");
        buffer.append("playBack.setTransport(transportService);\n");
        buffer.append("return playBack;\n");
        String contents = buffer.toString();
        this.codeMethod(ba, "createService", comment, "Object", 1L, contents, new KeyValuePair[]{param}, null);
    }

    protected void codeConstructors(IType test) {
        super.codeConstructors(test);
        String name = this.getMainClassName();
        KeyValuePair param = new KeyValuePair("String", "playbackFilePath");
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("super();\n");
        buffer.append("try {\n");
        buffer.append("playbackConnection");
        buffer.append(" = new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_PLAY_BACK_CONNECTION));
        buffer.append("(new ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_XML_PLAY_BACK_CONNECTION_HANDLER));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_XML_PLAY_BACK_CONNECTION_HANDLER);
        buffer.append("(playbackFilePath), this);\n");
        buffer.append("} catch (");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_FILE_NOT_FOUND_EXCEPTION));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_FILE_NOT_FOUND_EXCEPTION);
        buffer.append(" e) {\n");
        buffer.append("\te.printStackTrace();\n");
        buffer.append("}\n");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_TRANSPORT));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_TRANSPORT);
        buffer.append(" transport = ");
        buffer.append("new " + DeviceKitUtilities.stripPackage(this.getTestElement().getTargetClass()) + "();\n");
        buffer.append("if (transport instanceof ");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_TRANSPORT));
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_CONNECTION_TRANSPORT);
        buffer.append(") {\n");
        buffer.append("\t((");
        buffer.append(DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_CONNECTION_TRANSPORT));
        buffer.append(") transport).setConnection(playbackConnection);\n");
        buffer.append("}\n");
        buffer.append("setTransport(transport);\n");
        String contents = buffer.toString();
        String returnType = null;
        String comment = String.valueOf(name) + '.';
        this.codeMethod(test, name, comment, returnType, 1L, contents, new KeyValuePair[]{param}, null);
    }

    protected void codeFields(IType test) {
        super.codeFields(test);
        this.codePlaybackConnectionField(test);
    }

    protected void codeMethods(IType test) {
        super.codeMethods(test);
        this.codePlayBackComplete(test);
    }

    protected void codePlayBackComplete(IType test) {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("try {\n");
        buffer.append('\t');
        buffer.append(DeviceKitUtilities.stripPackage("Thread"));
        this.fTestModel.addImport("Thread");
        buffer.append(".sleep(100);\n");
        buffer.append("} catch (InterruptedException e) {\n");
        buffer.append("\t//Ignored\n");
        buffer.append("}\n");
        buffer.append("stop();\n");
        String contents = buffer.toString();
        this.codeMethod(test, "playbackComplete", "playbackComplete.", "void", 1L, contents);
    }

    private void codePlaybackConnectionField(IType test) {
        String fieldType = DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_PLAY_BACK_CONNECTION);
        this.codeField(test, "playbackConnection", fieldType, 2L, "Field playbackConnection.", "null");
    }

    protected String getBAActivateContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("if (playBack != null)\n");
        buffer.append("playBack.start();\n");
        return buffer.toString();
    }

    protected String getBADeactivateContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("if (this.");
        buffer.append("playBack");
        buffer.append(" != null) {\n");
        buffer.append('\t');
        buffer.append("playBack");
        buffer.append(".stop();\n");
        buffer.append("}\n");
        buffer.append("playBack");
        buffer.append(" = null;\n");
        buffer.append("super.deactivate();\n");
        return buffer.toString();
    }

    protected String getBASetInterestContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("super.setInterest(interest);\n");
        buffer.append("if (this.");
        buffer.append("playBack");
        buffer.append(" != null) {\n");
        buffer.append("}\n");
        return buffer.toString();
    }

    protected String getBaseName() {
        return DeviceKitUtilities.removeLastOccurence(this.getMainClassName(), "Playback");
    }

    protected String getConstructorContents() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("this(CONNECTION_REC_FILENAME);\n");
        return buffer.toString();
    }

    protected String[] getImplementedInterfaces() {
        this.fTestModel.addImport(DeviceKitGenerationConstants.CLASS_PLAY_BACK_LISTENER);
        return new String[]{this.getServiceFqn(), DeviceKitUtilities.stripPackage(DeviceKitGenerationConstants.CLASS_PLAY_BACK_LISTENER)};
    }

    protected String getMainContents() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append("try {\n");
        buffer.append('\t');
        buffer.append("final ");
        buffer.append(this.getMainClassName());
        buffer.append(' ');
        buffer.append("playBack");
        buffer.append(" = new ");
        buffer.append(this.getMainClassName());
        buffer.append("();\n");
        buffer.append('\t');
        buffer.append("playBack");
        buffer.append(".start();\n");
        buffer.append('\t');
        buffer.append("for (int i = 1; i < 100; i++){\n");
        buffer.append("\tif (");
        buffer.append("playBack");
        buffer.append(".isStarted()){\n");
        buffer.append("\t\tbreak;\n");
        buffer.append("\t} else {\n");
        buffer.append("\t\t");
        buffer.append(DeviceKitUtilities.stripPackage("Thread"));
        this.fTestModel.addImport("Thread");
        buffer.append(".sleep(100);\n");
        buffer.append("\t}\n");
        buffer.append("}\n");
        buffer.append("do {\n");
        buffer.append("\t\t");
        buffer.append(DeviceKitUtilities.stripPackage("Thread"));
        this.fTestModel.addImport("Thread");
        buffer.append(".sleep(100);\n");
        buffer.append("\t} while (playBack.isStarted());\n");
        buffer.append("} catch (final Exception exception) {\n");
        buffer.append("\texception.printStackTrace(System.out);\n");
        buffer.append("}\n");
        buffer.append("System.exit(0);\n");
        return buffer.toString();
    }

    protected String getManifestDescription() {
        Vector monitor = this.getTestElement().getAllChildrenWithTagCode(47);
        PlayBackElement element = (PlayBackElement)monitor.get(0);
        if (element.getDescription() != null) {
            return element.getDescription();
        }
        return String.valueOf(this.getMainElement().getId()) + " Playback";
    }

    protected String getSimTestName(String defaultName) {
        String className = DeviceKitUtilities.removeLastOccurence(defaultName, "Test");
        className = String.valueOf(className) + "Playback";
        return className;
    }

    protected String getStartContents() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("playbackConnection");
        buffer.append(".startPlayback();\n");
        buffer.append("if (getTransport() != null) {\n");
        buffer.append("\tgetTransport().start();\n");
        buffer.append("}\n");
        buffer.append("super.start();\n");
        return buffer.toString();
    }

    protected String getStopContents() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append("super.stop();\n");
        buffer.append("if (getTransport() != null) {\n");
        buffer.append("\tgetTransport().exit();\n");
        buffer.append("}\n");
        return buffer.toString();
    }
}

