/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.template;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class TemplateInputStream
extends InputStream {
    private ArrayList stack;
    private ByteArrayOutputStream buffer;
    private Map variables = new HashMap();
    private Map entities = new HashMap();
    int depth = 0;
    boolean commentLine = false;
    boolean entityRef = false;

    public TemplateInputStream() {
        this.stack = new ArrayList();
        this.buffer = new ByteArrayOutputStream();
        this.initializeVariables();
    }

    public TemplateInputStream(InputStream inputStream) {
        this.stack = new ArrayList();
        this.buffer = new ByteArrayOutputStream();
        this.push(inputStream);
        this.initializeVariables();
    }

    public static void main(String[] args) {
        try {
            int data;
            FileInputStream fileStream = new FileInputStream("test.ssi");
            TemplateInputStream inputStream = new TemplateInputStream(fileStream);
            while ((data = inputStream.read()) != -1) {
                System.out.print((char)data);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        System.exit(0);
    }

    public void addEntity(String key, String value) {
        this.getEntities().put(key, value);
    }

    public void addVariable(String key, String value) {
        this.getVariables().put(key, value);
    }

    public boolean expr(String variableName) {
        if ("true".equals(variableName) || "1".equals(variableName)) {
            return true;
        }
        if ("false".equals(variableName) || "0".equals(variableName)) {
            return false;
        }
        String value = this.getVariable(variableName);
        return "true".equals(value) || "1".equals(value);
    }

    public InputStream getBlankStream() {
        return new ByteArrayInputStream("".getBytes());
    }

    public InputStream getEchoVar(String variableName) {
        String value = this.getVariable(variableName);
        if (value != null) {
            return new ByteArrayInputStream(value.getBytes());
        }
        return null;
    }

    public Map getEntities() {
        return this.entities;
    }

    public String getEntity(String key) {
        return (String)this.getEntities().get(key);
    }

    public InputStream getIncludeFile(String value) {
        return null;
    }

    public InputStream getIncludeVirtual(String value) {
        return null;
    }

    public InputStream getInputStream() {
        return (InputStream)this.getStack().get(this.getStack().size() - 1);
    }

    public ArrayList getStack() {
        return this.stack;
    }

    public String getVariable(String key) {
        return (String)this.getVariables().get(key);
    }

    public Map getVariables() {
        return this.variables;
    }

    public void initializeVariables() {
        Date date = new Date();
        this.addVariable("DATE_LOCAL", date.toString());
        SimpleDateFormat format = new SimpleDateFormat("d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String gmt = format.format(date);
        this.addVariable("DATE_GMT", gmt);
        Calendar calendar = Calendar.getInstance();
        int year = calendar.get(1);
        String yearString = Integer.toString(year);
        this.addEntity("Year", yearString);
        this.addEntity("year", yearString);
        if (this.getEntity("years") == null) {
            this.addEntity("years", yearString);
        }
        if (this.getEntity("Date") == null) {
            StringBuffer buffer = new StringBuffer(64);
            buffer.append(year);
            int month = calendar.get(2) + 1;
            int day = calendar.get(5);
            buffer.append('-');
            if (month < 10) {
                buffer.append('0');
            }
            buffer.append(month);
            buffer.append('-');
            if (day < 10) {
                buffer.append('0');
            }
            buffer.append(day);
            this.addEntity("Date", buffer.toString());
            this.addEntity("date", buffer.toString());
        }
    }

    public InputStream pop() {
        this.getStack().remove(this.getStack().size() - 1);
        return this.getInputStream();
    }

    public InputStream processEntityReference(String comment) {
        String key = comment.substring(1, comment.length() - 1);
        String value = this.getEntity(key);
        if (value != null) {
            return new ByteArrayInputStream(value.getBytes());
        }
        return null;
    }

    public void push(InputStream inputStream) {
        this.getStack().add(inputStream);
    }

    public int read() throws IOException {
        int data = this.getInputStream().read();
        if (data == -1) {
            if (this.getStack().size() == 1) {
                return data;
            }
            this.pop();
            return this.read();
        }
        if (this.buffer.size() == 0) {
            if (data == 38) {
                this.commentLine = false;
                this.entityRef = true;
                this.buffer.write(data);
                return this.read();
            }
        } else {
            this.buffer.write(data);
            if (data == 59 && this.entityRef) {
                String comment = this.buffer.toString();
                InputStream newInputStream = this.processEntityReference(comment);
                if (newInputStream != null) {
                    this.push(newInputStream);
                    this.buffer.reset();
                    return this.read();
                }
                this.push(new ByteArrayInputStream(this.buffer.toByteArray()));
                this.buffer.reset();
                return this.getInputStream().read();
            }
            return this.read();
        }
        return data;
    }

    public InputStream setEchoVar(String variableName) {
        int index = variableName.indexOf(34, 1);
        if (index > -1) {
            String value = "";
            String key = variableName.substring(0, index);
            int eqi = variableName.indexOf(61);
            if (eqi > -1) {
                value = variableName.substring(eqi + 2);
                this.addVariable(key, value);
                return this.getBlankStream();
            }
        }
        return null;
    }

    public void setEntities(Map entities) {
        this.entities = entities;
    }

    public void setVariables(Map variables) {
        this.variables = variables;
    }
}

