/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.util;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.soda.devicekit.generator.util.IJxeConstants;
import org.eclipse.soda.devicekit.generator.util.JxeRulesEntries;
import org.eclipse.soda.devicekit.generator.utilty.DkUtilities;
import org.eclipse.soda.devicekit.util.AnchorUtil;
import org.eclipse.soda.devicekit.util.ParserUtilities;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DkJxeRuleGenerator {
    public static final String JXE_RULE_FILE = "jxeLink.rules";
    private boolean changed = false;
    private String packageBase;
    private Node node;
    private IFile file;
    private Vector requiredIncludes;
    private JxeRulesEntries list = JxeRulesEntries.getInstance();

    public DkJxeRuleGenerator(Node node, IFile file) {
        this.node = node;
        this.file = file;
        this.requiredIncludes = new Vector();
    }

    /*
     * Exception decompiling
     */
    private void addJxeRuleContents(IFile file, Vector generated) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 82->86)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void addRequiredEntry(String entry) {
        this.requiredIncludes.addElement(entry);
    }

    private void checkForPackageBase(NamedNodeMap attributes) {
        int i = 0;
        while (i < attributes.getLength()) {
            Node node = attributes.item(i);
            if ("packagebase".equals(node.getNodeName())) {
                String pb = node.getNodeValue();
                this.setPackageBase(pb);
                return;
            }
            ++i;
        }
    }

    private String extendWithPackage(String string) {
        if (this.getPackageBase() != null) {
            String pb = DkUtilities.getPackageFromClassName(string, this.getPackageBase());
            return String.valueOf(pb) + '.' + string;
        }
        return string;
    }

    private IFile findJxeRuleFile(IFolder folder) throws CoreException {
        IResource res = folder.findMember(JXE_RULE_FILE);
        if (res != null && res.exists()) {
            return (IFile)res;
        }
        IResource[] resources = folder.members();
        int i = 0;
        while (i < resources.length) {
            IFile file;
            if (resources[i] instanceof IFolder && (file = this.findJxeRuleFile((IFolder)resources[i])) != null && file.exists()) {
                return file;
            }
            ++i;
        }
        return null;
    }

    public boolean generate() throws Exception {
        this.generateJxeRules(this.node, this.file);
        return this.changed;
    }

    private void generateJxeRules(Node node, IFile dkmlFile) throws Exception {
        IProject project = dkmlFile.getProject();
        Vector includes = this.getJxeContents(dkmlFile, node, new Vector());
        includes = DkUtilities.mergeVectors(includes, this.requiredIncludes);
        try {
            IFile jxeRule = this.getJxeRuleFile(project);
            if (jxeRule == null) {
                IContainer container = dkmlFile.getParent();
                if (container instanceof IFolder) {
                    IFolder folder = (IFolder)container;
                    jxeRule = folder.getFile(JXE_RULE_FILE);
                } else {
                    jxeRule = project.getFile(JXE_RULE_FILE);
                }
            }
            this.addJxeRuleContents(jxeRule, includes);
            this.updateAdditionalBundles(project, includes);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    protected Vector getCurrentJxeEntries(IFile file) {
        Vector<String> entries = new Vector<String>();
        try {
            File osfile;
            IPath path = file.getLocation().makeAbsolute();
            if (path != null && (osfile = path.makeAbsolute().toFile()).exists()) {
                FileReader freader = new FileReader(osfile);
                BufferedReader reader = new BufferedReader(freader);
                boolean more = true;
                while (more) {
                    String line = reader.readLine();
                    if (line == null) {
                        more = false;
                        continue;
                    }
                    if (!line.toLowerCase().startsWith("-includewholeclass ")) continue;
                    StringTokenizer tokenizer = new StringTokenizer(line, "\" ");
                    String wname = "";
                    while (tokenizer.hasMoreTokens()) {
                        wname = tokenizer.nextToken();
                    }
                    entries.add(wname);
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return entries;
    }

    private Vector getJxeContents(IFile file, Node node, Vector vector) throws Exception {
        String classList;
        Vector tvector = vector;
        if (this.list.getTags().contains(node.getNodeName())) {
            String[] entry = this.list.getTag(node.getNodeName());
            int i = 0;
            while (i < entry.length) {
                if (!tvector.contains(entry[i])) {
                    tvector.addElement(entry[i]);
                }
                ++i;
            }
        }
        if ((classList = this.matchesNestRule(node)) != null) {
            String[] entry = JxeRulesEntries.detokenize(classList);
            int i = 0;
            while (i < entry.length) {
                if (!tvector.contains(entry[i])) {
                    tvector.addElement(entry[i]);
                }
                ++i;
            }
        }
        int i = 0;
        while (i < JxeRulesEntries.DATA.length) {
            if (JxeRulesEntries.DATA[i].equals(node.getNodeName())) {
                String result = ParserUtilities.extractData(node);
                if (result.indexOf(46) == -1) {
                    result = this.extendWithPackage(result);
                }
                if (result != null && !tvector.contains(result)) {
                    tvector.addElement(result);
                }
            }
            ++i;
        }
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            if (this.getPackageBase() == null) {
                this.checkForPackageBase(attributes);
            }
            int i2 = 0;
            while (i2 < this.list.getAttributes().size()) {
                String att = (String)this.list.getAttributes().elementAt(i2);
                int j = 0;
                while (j < attributes.getLength()) {
                    Node n = attributes.item(j);
                    if (att.equals(n.getNodeName())) {
                        String value = n.getNodeValue();
                        if (value.indexOf(46) == -1) {
                            value = this.extendWithPackage(value);
                        }
                        if (!tvector.contains(value)) {
                            tvector.addElement(value);
                        }
                    }
                    ++j;
                }
                if (AnchorUtil.hasAnchorRef(node)) {
                    tvector = this.scanAnchor(file, node, tvector);
                }
                ++i2;
            }
        }
        NodeList children = node.getChildNodes();
        int i3 = 0;
        while (i3 < children.getLength()) {
            this.getJxeContents(file, children.item(i3), tvector);
            ++i3;
        }
        return tvector;
    }

    private String getJxeEntries(Vector generated) {
        StringBuffer buffer = new StringBuffer(generated.size() + 128);
        buffer.append("#Licensed Materials - Property of IBM");
        buffer.append('\n');
        buffer.append(IJxeConstants.PROPERTY_INTRO_COPYRIGHT);
        buffer.append("\n\n");
        int i = 0;
        while (i < generated.size()) {
            buffer.append("-includewholeclass ");
            buffer.append((String)generated.elementAt(i));
            buffer.append('\n');
            ++i;
        }
        return buffer.toString().trim();
    }

    private IFile getJxeRuleFile(IProject project) throws CoreException {
        IResource[] resources = project.members();
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IFolder) {
                IFile file = this.findJxeRuleFile((IFolder)resources[i]);
                if (file != null && file.exists()) {
                    return file;
                }
            } else if (resources[i] instanceof IFile && resources[i].getName().equals(JXE_RULE_FILE)) {
                return (IFile)resources[i];
            }
            ++i;
        }
        return null;
    }

    private InputStream getJxeStream(String contents) {
        return new ByteArrayInputStream(contents.getBytes());
    }

    private String getPackageBase() {
        return this.packageBase;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean jxeRuleContentsChanged(String newContents, IFile file) throws Exception {
        InputStream stream;
        block5: {
            String tnewContents = newContents;
            stream = null;
            try {
                String contents;
                if (tnewContents != null) {
                    tnewContents = tnewContents.trim();
                }
                if (DkUtilities.isEqualString(contents = DkUtilities.getStringFromStream(stream = file.getContents()).trim(), tnewContents)) break block5;
                Object var6_6 = null;
                if (stream == null) return true;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (stream != null) {
                    stream.close();
                }
                stream = null;
                throw throwable;
            }
            stream.close();
            return true;
        }
        Object var6_8 = null;
        if (stream == null) return false;
        stream.close();
        return false;
    }

    public String matchesNestRule(Node node) {
        int i = 0;
        while (i < JxeRulesEntries.NESTED_TAGS.length) {
            boolean result = this.matchesNestRule(node, JxeRulesEntries.detokenize(JxeRulesEntries.NESTED_TAGS[i]));
            if (result) {
                return JxeRulesEntries.getInstance().getNestedEntry(JxeRulesEntries.NESTED_TAGS[i]);
            }
            ++i;
        }
        return null;
    }

    public boolean matchesNestRule(Node node, String[] tags) {
        Node childNode = ParserUtilities.findChildNode(tags[0], node);
        if (childNode != null) {
            int length = tags.length - 1;
            if (length > 0) {
                String[] newArray = new String[length];
                System.arraycopy(tags, 1, newArray, 0, newArray.length);
                return this.matchesNestRule(childNode, newArray);
            }
            return true;
        }
        return false;
    }

    /*
     * Exception decompiling
     */
    private Vector scanAnchor(IFile file, Node node, Vector vector) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [3 : 189->192)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void setPackageBase(String pb) {
        this.packageBase = pb;
    }

    private void updateAdditionalBundles(IProject project, Vector includes) {
    }
}

