/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.generator.visitor;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.soda.devicekit.generator.visitor.Visitor;

public class JavadocVisitor
extends Visitor {
    public static void main(String[] args) {
        JavadocVisitor visitor = new JavadocVisitor();
        visitor.formatSource("// Sample\r\n// unclear\r\n// System.out.println\r\n\treturn;\r\n// unclear\r\n// System.out.println\r\n\treturn;\r\n", true);
        System.out.println(visitor.getStringWriter().getBuffer().toString());
    }

    public void formatSource(String source, boolean declare) {
        int type;
        StringTokenizer tokenizer = new StringTokenizer(source, "\r\n");
        ArrayList<String> code = new ArrayList<String>();
        ArrayList<Integer> flag = new ArrayList<Integer>();
        boolean skip = declare;
        while (tokenizer.hasMoreElements()) {
            int type2 = 0;
            String token = tokenizer.nextToken();
            boolean convert = false;
            String trim = token.trim();
            if (trim.equals("* To change the template for this generated type comment go to") || trim.equals("* Window&gt;Preferences&gt;Java&gt;Code Generation&gt;Code and Comments")) continue;
            if (trim.startsWith("//")) {
                String more = trim.substring(2, trim.length()).trim();
                type2 = 32;
                if (more.length() == 0) {
                    type2 = 45;
                } else if (more.startsWith("TODO")) {
                    type2 = 47;
                } else if (more.startsWith("System.out.print")) {
                    type2 = 46;
                } else if (more.endsWith("{") || more.endsWith(";") || more.startsWith("{") || more.startsWith("if (")) {
                    type2 = 40;
                } else {
                    if (more.endsWith(".")) {
                        type2 = 16;
                        convert = true;
                    } else if (Character.isUpperCase(more.charAt(0))) {
                        convert = true;
                        type2 = 17;
                    }
                    if (convert) {
                        type2 = 16;
                    }
                }
            } else if (skip) {
                token = "";
                skip = false;
            }
            code.add(token);
            flag.add(new Integer(type2));
        }
        flag.add(new Integer(-1));
        int start = -1;
        int end = -1;
        int min = 48;
        int max = 0;
        int size = code.size();
        int[] types = new int[size];
        int i = 0;
        while (i < code.size()) {
            types[i] = type = ((Integer)flag.get(i)).intValue();
            if (type >= 16) {
                min = Math.min(type, min);
                max = Math.max(type, max);
                if (start < 0) {
                    start = i;
                }
                end = i;
            } else {
                if (start >= 0) {
                    int j = start;
                    while (j <= end) {
                        int newType = types[j];
                        if (newType >= 32 && newType < 40) {
                            types[j] = min < 32 ? min : max;
                        }
                        ++j;
                    }
                }
                start = -1;
                end = -1;
                min = 48;
                max = 0;
            }
            ++i;
        }
        i = 0;
        while (i < code.size()) {
            type = types[i];
            String line = code.get(i).toString();
            switch (type >> 4) {
                case 0: {
                    this.println(line);
                    break;
                }
                case 1: {
                    String trim = line.trim();
                    String more = trim.substring(2, trim.length()).trim();
                    System.out.println(more);
                    this.print("\t/* ");
                    this.print(more);
                    this.println(" */");
                    break;
                }
                case 2: {
                    if (type < 32 || type >= 40) break;
                    this.println(line);
                }
            }
            ++i;
        }
    }

    public boolean methodDeclare(MethodDeclaration node, boolean body) {
        TypeDeclaration type;
        ASTNode parent;
        this.setLogMember(node);
        if (this.isPseudo() && this.isPrivate(node.getModifiers())) {
            return false;
        }
        int modifiers = node.getModifiers();
        if (node.isConstructor() && Modifier.isPublic((int)modifiers) && (parent = node.getParent()) instanceof TypeDeclaration && Modifier.isAbstract((int)(type = (TypeDeclaration)parent).getModifiers())) {
            modifiers = modifiers ^ 1 | 4;
        }
        this.printModifiers(modifiers);
        if (!node.isConstructor()) {
            node.getReturnType2().accept((ASTVisitor)this);
            this.print(' ');
        }
        node.getName().accept((ASTVisitor)this);
        String methodName = node.getName().getIdentifier();
        if (methodName.startsWith("set")) {
            String propertyName;
            SingleVariableDeclaration v;
            String name;
            if (node.parameters().size() == 1 && !(name = (v = (SingleVariableDeclaration)node.parameters().get(0)).getName().getIdentifier()).equals(propertyName = this.getPropertyName(methodName.substring(3)))) {
                this.logWarning("Code", "Bad set parameter name " + name + " should be " + propertyName);
            }
        } else {
            methodName.startsWith("get");
        }
        this.print('(');
        boolean main = methodName.equals("main");
        Iterator it = node.parameters().iterator();
        while (it.hasNext()) {
            SingleVariableDeclaration v = (SingleVariableDeclaration)it.next();
            if (!main && !Modifier.isFinal((int)v.getModifiers())) {
                this.print("final ");
            }
            v.accept((ASTVisitor)this);
            if (!it.hasNext()) continue;
            this.print(", ");
        }
        this.print(')');
        if (!node.thrownExceptions().isEmpty()) {
            this.printKeyword(" throws ");
            it = node.thrownExceptions().iterator();
            while (it.hasNext()) {
                Name n = (Name)it.next();
                n.accept((ASTVisitor)this);
                if (!it.hasNext()) continue;
                this.print(", ");
            }
            this.print(' ');
        }
        if (node.getBody() == null) {
            this.printEndOfStatementLine();
        } else if (body) {
            this.print('{');
        }
        return false;
    }

    public boolean visit(MethodDeclaration node) {
        boolean comments;
        int start = node.getStartPosition();
        int length = node.getLength();
        Javadoc javadoc = node.getJavadoc();
        if (javadoc != null) {
            Hashtable table = this.getJavadocLines(node.getJavadoc().tags());
            this.generateJavadoc(node, table);
            start = javadoc.getStartPosition() + javadoc.getLength();
            length -= javadoc.getLength();
        } else {
            this.generateJavadoc(node, new Hashtable());
        }
        String source = this.getSource().substring(start, start + length);
        boolean bl = comments = source.indexOf("//") >= 0;
        if (node.getBody() == null) {
            comments = true;
        }
        this.methodDeclare(node, comments);
        if (comments) {
            this.formatSource(source, true);
        } else {
            Block body = node.getBody();
            if (body.statements().size() == 0) {
                if (node.isConstructor()) {
                    if (node.parameters().size() == 0) {
                        this.println(" {");
                        this.indent();
                        this.println("super();");
                        this.println("}");
                    } else {
                        body.accept((ASTVisitor)this);
                    }
                } else {
                    this.println(" {");
                    this.indent();
                    this.println("/* do nothing */");
                    this.println("}");
                }
            } else {
                body.accept((ASTVisitor)this);
            }
        }
        return false;
    }

    public boolean visit(FieldDeclaration node) {
        int start = node.getStartPosition();
        int length = node.getLength();
        Javadoc javadoc = node.getJavadoc();
        if (javadoc != null) {
            Hashtable table = this.getJavadocLines(node.getJavadoc().tags());
            this.generateJavadoc(node, table);
            start = javadoc.getStartPosition() + javadoc.getLength();
            length -= javadoc.getLength();
        } else {
            this.generateJavadoc(node, new Hashtable());
        }
        String source = this.getSource();
        int index = source.indexOf(13, start + length);
        if (index > 0) {
            length = index - start;
        }
        source = source.substring(start, start + length);
        this.formatSource(source, false);
        return false;
    }
}

