/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.util.Vector;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AnchorUtil {
    private Node node = null;
    private String entry = null;
    private String fileRef = null;
    private String idRef = null;
    private Vector anchors = null;
    private File file = null;

    public AnchorUtil(Node node, Vector anchors) {
        this.node = node;
        this.anchors = anchors;
        this.entry = this.getAnchorRefEntry();
        this.fileRef = this.getAnchorRefFile();
        this.idRef = this.getAnchor();
    }

    public static String getAnchorRefValue(Node node) {
        NamedNodeMap atts = node.getAttributes();
        if (atts != null) {
            int i = 0;
            while (i < atts.getLength()) {
                Node aNode = atts.item(i);
                if ("idref".equals(aNode.getNodeName()) && aNode.getNodeValue().indexOf(35) > -1) {
                    return aNode.getNodeValue();
                }
                ++i;
            }
        }
        return "";
    }

    public static boolean hasAnchorRef(Node node) {
        NamedNodeMap atts = node.getAttributes();
        if (atts != null) {
            int i = 0;
            while (i < atts.getLength()) {
                Node aNode = atts.item(i);
                if ("idref".equals(aNode.getNodeName()) && aNode.getNodeValue().indexOf(35) > -1) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public Node findAnchor(Node node) {
        NodeList children;
        NamedNodeMap atts = node.getAttributes();
        if (atts != null) {
            int i = 0;
            while (i < atts.getLength()) {
                if ("id".equals(atts.item(i).getNodeName())) {
                    String end;
                    String idref = atts.item(i).getNodeValue();
                    if (this.idRef.equals(idref)) {
                        return node;
                    }
                    int index = idref.indexOf(35);
                    if (index > 0 && this.idRef.equals(end = idref.substring(index))) {
                        return node;
                    }
                }
                ++i;
            }
        }
        if ((children = node.getChildNodes()) != null) {
            int i = 0;
            while (i < children.getLength()) {
                Node cNode = this.findAnchor(children.item(i));
                if (cNode != null) {
                    return cNode;
                }
                ++i;
            }
        }
        return null;
    }

    private String getAnchor() {
        return this.entry.substring(this.entry.indexOf(35) + 1, this.entry.length());
    }

    public InputStream getAnchorFile() throws Exception {
        if (this.anchors != null) {
            int i = 0;
            while (i < this.anchors.size()) {
                String data = (String)this.anchors.elementAt(i);
                if (data != null) {
                    return new ByteArrayInputStream(data.getBytes());
                }
                ++i;
            }
        }
        throw new Exception("Could not file file " + this.getFileRef());
    }

    private String getAnchorRefEntry() {
        NamedNodeMap atts = this.node.getAttributes();
        if (atts != null) {
            int i = 0;
            while (i < atts.getLength()) {
                Node aNode = atts.item(i);
                if ("idref".equals(aNode.getNodeName())) {
                    return aNode.getNodeValue();
                }
                ++i;
            }
        }
        return "";
    }

    private String getAnchorRefFile() {
        return this.entry.substring(0, this.entry.indexOf(35));
    }

    public File getFile() {
        return this.file;
    }

    public String getFileRef() {
        return this.fileRef;
    }

    public String getFileSimple() {
        String fullName = this.getFileRef();
        int index = fullName.lastIndexOf(47);
        if (index < 0) {
            return fullName;
        }
        return fullName.substring(index + 1);
    }

    public String getIdRef() {
        return this.idRef;
    }
}

