/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.soda.devicekit.generator.templates.GeneratorTemplates;
import org.eclipse.soda.devicekit.util.DeviceKitUtilityPlugin;
import org.eclipse.soda.devicekit.util.SortedArrayList;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.IWorkingSetManager;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class CoreUtility {
    public static final String[] BASE_TYPES = new String[]{"transport", "agent", "profile", "device", "concrete", "adapter", "connection", "receiver"};
    public static final String[] BUNDLE_TYPES = new String[]{"bundle", "managed", "factory"};
    public static final String[] TEST_TYPES = new String[]{"test", "testcase"};

    public static void addDeviceKitNatureToProject(IProject project, IProgressMonitor monitor) throws CoreException {
        try {
            CoreUtility.addNatureToProject(project, "org.eclipse.soda.devicekit.nature", monitor);
        }
        catch (CoreException exception) {
            exception.printStackTrace();
        }
    }

    public static void addNatureToProject(IProject proj, String natureId, IProgressMonitor monitor) throws CoreException {
        IProjectDescription description = proj.getDescription();
        String[] prevNatures = description.getNatureIds();
        String[] newNatures = new String[prevNatures.length + 1];
        System.arraycopy(prevNatures, 0, newNatures, 0, prevNatures.length);
        newNatures[prevNatures.length] = natureId;
        description.setNatureIds(newNatures);
        proj.setDescription(description, monitor);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void createAboutFile(IContainer container, IProgressMonitor monitor) throws CoreException, IOException {
        IFile file = container.getFile((IPath)new Path("about.html"));
        if (file.exists()) return;
        InputStream stream = CoreUtility.getAboutStream();
        try {
            file.create(stream, true, monitor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            stream.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        stream.close();
    }

    public static final void createBuildPropertiesFile(IProject project, IProgressMonitor progressMonitor) throws CoreException, IOException {
        SortedArrayList additionalBundleList = new SortedArrayList();
        additionalBundleList.add("org.eclipse.osgi");
        additionalBundleList.add("org.eclipse.osgi.services");
        CoreUtility.createBuildPropertiesFile(project, additionalBundleList, progressMonitor);
    }

    public static final void createBuildPropertiesFile(IProject project, List additionalBundleList, IProgressMonitor progressMonitor) throws CoreException, IOException {
        String name = project.getName();
        Properties properties = new Properties();
        boolean serialNeeded = false;
        if (name.startsWith("serial")) {
            serialNeeded = true;
        } else if (name.endsWith("transport.test")) {
            serialNeeded = true;
        } else if (name.endsWith("receiver.test")) {
            serialNeeded = true;
        } else if (name.endsWith("device.test")) {
            serialNeeded = true;
        } else if (name.endsWith("concrete.test")) {
            serialNeeded = true;
        }
        boolean metadata = false;
        if (name.endsWith("factory")) {
            metadata = true;
        } else if (name.endsWith("managed")) {
            metadata = true;
        }
        if (serialNeeded) {
            additionalBundleList.add("org.eclipse.soda.dk.comm");
        }
        IFile file = project.getFile("build.properties");
        if (name.endsWith("testcase") || name.endsWith("agent.test") || name.endsWith("agenttest")) {
            additionalBundleList.add("org.junit");
        }
        properties.put("source..", "src/");
        properties.put("output..", "bin/");
        if (metadata) {
            properties.put("bin.includes", ".,META-INF/,OSGI-INF/,copyright.txt,about.html");
        } else {
            properties.put("bin.includes", ".,META-INF/,copyright.txt,about.html");
        }
        StringBuffer buffer = new StringBuffer(4096);
        Iterator iterator = additionalBundleList.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            if (!first) {
                buffer.append(',');
            }
            first = false;
            buffer.append(iterator.next());
        }
        properties.put("additional.bundles", buffer.toString());
        buffer = new StringBuffer(4096);
        buffer.append("copyright.txt");
        if (project.getFolder("dk").exists()) {
            buffer.append(',');
            buffer.append("dk");
            buffer.append('/');
        }
        properties.put("src.includes", buffer.toString());
        try {
            ByteArrayOutputStream os = new ByteArrayOutputStream(4096);
            CoreUtility.outputPropertiesTo(os, (Hashtable)properties);
            os.close();
            ByteArrayInputStream is = new ByteArrayInputStream(os.toByteArray());
            file.create((InputStream)is, true, progressMonitor);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void createCopyrightFile(IContainer container, IProgressMonitor monitor) throws CoreException, IOException {
        IFile file = container.getFile((IPath)new Path("copyright.txt"));
        if (file.exists()) return;
        InputStream stream = CoreUtility.getCopyrightStream();
        try {
            file.create(stream, true, monitor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            stream.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        stream.close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void createCvsIgnoreFile(IContainer container, IProgressMonitor monitor) throws CoreException, IOException {
        IFile file = container.getFile((IPath)new Path(".cvsignore"));
        if (file.exists()) return;
        ByteArrayInputStream stream = new ByteArrayInputStream("bin\nbinary\ntemp.folder\njavaCompiler...args\n".getBytes());
        try {
            file.create((InputStream)stream, true, monitor);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            ((InputStream)stream).close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        ((InputStream)stream).close();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void createEscPropertiesFile(IContainer container, IProgressMonitor monitor) throws CoreException, IOException {
        String name = container.getName();
        boolean needed = true;
        if (name.endsWith(".bundle") || name.endsWith(".managed") || name.endsWith(".factory")) {
            needed = false;
        }
        if (!needed) return;
        IFile file = container.getFile((IPath)new Path("esc.properties"));
        if (file.exists()) return;
        Map map = GeneratorTemplates.getTemplateVariables(-1);
        String contents = GeneratorTemplates.getCopyrightPropertyString(map);
        ByteArrayInputStream stream = new ByteArrayInputStream(contents.getBytes());
        try {
            file.create((InputStream)stream, true, monitor);
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            ((InputStream)stream).close();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        ((InputStream)stream).close();
    }

    public static void createFolder(IFolder folder, boolean force, boolean local, IProgressMonitor monitor) throws CoreException {
        if (!folder.exists()) {
            IContainer parent = folder.getParent();
            if (parent instanceof IFolder) {
                CoreUtility.createFolder((IFolder)parent, force, local, monitor);
            }
            folder.create(force, local, monitor);
        }
    }

    public static IProject createProject(String projectName, IProgressMonitor monitor) throws CoreException {
        IProject project = CoreUtility.getProject(projectName);
        IProjectDescription desc = project.getWorkspace().newProjectDescription(project.getName());
        project.create(desc, monitor);
        project.open(monitor);
        return project;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void createSettings(IContainer container, IProgressMonitor monitor) throws CoreException, IOException {
        IFile file;
        IFolder folder = container.getFolder((IPath)new Path(".settings"));
        if (!folder.exists()) {
            folder.create(true, true, monitor);
        }
        if ((file = folder.getFile((IPath)new Path("org.eclipse.pde.core.prefs"))).exists()) return;
        ByteArrayInputStream stream = new ByteArrayInputStream("eclipse.preferences.version=1\npluginProject.extensions=false\nresolve.requirebundle=false\npluginProject.equinox=false".getBytes());
        try {
            file.create((InputStream)stream, true, monitor);
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            ((InputStream)stream).close();
            throw throwable;
        }
        {
            Object var5_7 = null;
        }
        ((InputStream)stream).close();
    }

    public static void createWorkingSet(String name) {
        try {
            IWorkspaceRoot root = DeviceKitUtilityPlugin.getWorkspace().getRoot();
            IProject[] projects = root.getProjects();
            ArrayList<IProject> list = new ArrayList<IProject>(projects.length);
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                String elementName = project.getName();
                if (elementName.startsWith(name)) {
                    list.add(project.getProject());
                }
                ++i;
            }
            int size = list.size();
            if (size > 0) {
                IResource[] resources = new IResource[size];
                resources = list.toArray(resources);
                CoreUtility.createWorkingSet(name, resources);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void createWorkingSet(String name, IResource[] resources) {
        if (name.length() > 0) {
            IWorkingSetManager workingSetManager = WorkbenchPlugin.getDefault().getWorkingSetManager();
            try {
                IWorkingSet workingSet = workingSetManager.getWorkingSet(name);
                if (workingSet == null) {
                    workingSet = workingSetManager.createWorkingSet(name, (IAdaptable[])resources);
                    workingSetManager.addWorkingSet(workingSet);
                } else {
                    workingSet.setElements((IAdaptable[])resources);
                }
            }
            catch (Exception exception) {}
        }
    }

    public static void createWorkingSetBase(String name) {
        CoreUtility.createWorkingSet(CoreUtility.getBaseName(name));
    }

    public static String extractPackage(String fqn) {
        int index = fqn.lastIndexOf(46);
        if (index == -1) {
            return fqn;
        }
        return fqn.substring(0, index);
    }

    public static IProject[] findMatchingProjects(String name) {
        try {
            IWorkspaceRoot root = DeviceKitUtilityPlugin.getWorkspace().getRoot();
            IProject[] projects = root.getProjects();
            ArrayList<IProject> list = new ArrayList<IProject>(projects.length);
            int i = 0;
            while (i < projects.length) {
                IProject project = projects[i];
                String elementName = project.getName();
                if (elementName.startsWith(name)) {
                    list.add(project);
                }
                ++i;
            }
            int size = list.size();
            if (size > 0) {
                IProject[] matchingProjects = new IProject[size];
                matchingProjects = list.toArray(matchingProjects);
                return matchingProjects;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new IProject[0];
    }

    public static final InputStream getAboutStream() {
        ByteArrayInputStream stream = new ByteArrayInputStream(GeneratorTemplates.getAbout().getBytes());
        return stream;
    }

    public static String getBaseName(String name) {
        int index = name.lastIndexOf(45);
        if (index >= 0) {
            return name.substring(0, index);
        }
        String root = CoreUtility.extractPackage(name);
        String type = CoreUtility.stripPackage(name);
        int i = 0;
        while (i < BASE_TYPES.length) {
            if (type.equals(BASE_TYPES[i])) {
                return root;
            }
            ++i;
        }
        i = 0;
        while (i < TEST_TYPES.length) {
            if (type.equals(TEST_TYPES[i])) {
                return CoreUtility.getBaseName(root);
            }
            ++i;
        }
        i = 0;
        while (i < BUNDLE_TYPES.length) {
            if (type.equals(BUNDLE_TYPES[i])) {
                return CoreUtility.getBaseName(root);
            }
            ++i;
        }
        return name;
    }

    public static final InputStream getCopyrightStream() {
        ByteArrayInputStream stream = new ByteArrayInputStream(GeneratorTemplates.getCopyright().getBytes());
        return stream;
    }

    public static IJavaProject getJavaProject(IProject project) {
        IJavaProject jProject = JavaCore.create((IProject)project);
        return jProject;
    }

    public static IJavaProject getJavaProject(String projectName) {
        IProject project = CoreUtility.getProject(projectName);
        IJavaProject jProject = JavaCore.create((IProject)project);
        return jProject;
    }

    public static IPackageFragment getPackage(String packageName) {
        IPackageFragment bestResult = null;
        try {
            IPackageFragment packageFragment;
            IJavaProject javaProject = CoreUtility.getJavaProject(packageName);
            if (javaProject.exists() && (packageFragment = CoreUtility.getPackageInProject(javaProject, packageName)) != null) {
                return packageFragment;
            }
            IJavaProject[] javaProjects = JavaCore.create((IWorkspaceRoot)DeviceKitUtilityPlugin.getWorkspace().getRoot()).getJavaProjects();
            int i = 0;
            while (i < javaProjects.length) {
                IJavaProject jproject = javaProjects[i];
                if (jproject.exists()) {
                    IPackageFragmentRoot[] roots = jproject.getPackageFragmentRoots();
                    int j = 0;
                    while (j < roots.length) {
                        IPackageFragment result;
                        if (roots[j].getKind() == 1 && (result = roots[j].getPackageFragment(packageName)) != null && result.exists()) {
                            if (result.getCompilationUnits().length > 0) {
                                return result;
                            }
                            if (bestResult == null) {
                                bestResult = result;
                            }
                        }
                        ++j;
                    }
                }
                ++i;
            }
        }
        catch (CoreException exception) {
            exception.printStackTrace();
        }
        return bestResult;
    }

    public static IPackageFragment getPackageInProject(IJavaProject javaProject, String packageName) {
        try {
            IPackageFragmentRoot[] currProjRoots = javaProject.getAllPackageFragmentRoots();
            int j = 0;
            while (j < currProjRoots.length) {
                IPackageFragment result;
                if (currProjRoots[j].getKind() == 1 && (result = currProjRoots[j].getPackageFragment(packageName)) != null && result.exists() && result.getCompilationUnits().length > 0) {
                    return result;
                }
                ++j;
            }
        }
        catch (JavaModelException javaModelException) {}
        return null;
    }

    public static IProject getProject(String projectName) {
        IWorkspace ws = ResourcesPlugin.getWorkspace();
        IWorkspaceRoot wsRoot = ws.getRoot();
        IProject project = wsRoot.getProject(projectName);
        return project;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final String getStringFromStream(InputStream stream) throws Exception {
        StringBuffer buffer = new StringBuffer();
        try {
            byte[] bytes = new byte[1024];
            int read = stream.read(bytes);
            while (read > 0) {
                byte[] bytes2 = new byte[read];
                System.arraycopy(bytes, 0, bytes2, 0, read);
                String temp = new String(bytes2);
                buffer.append(temp);
                read = stream.read(bytes);
            }
        }
        catch (Throwable throwable) {
            Object var6_7 = null;
            stream.close();
            throw throwable;
        }
        {
            Object var6_8 = null;
        }
        stream.close();
        return buffer.toString();
    }

    public static final int getYear() {
        return Calendar.getInstance().get(1);
    }

    public static void outputPropertiesTo(OutputStream s, Hashtable properties) throws Exception {
        Set set = properties.keySet();
        Object[] keys = new String[set.size()];
        keys = set.toArray(keys);
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            Object key = keys[i];
            Object value = properties.get(key);
            CoreUtility.outputPropertiesTo(s, String.valueOf(key), CoreUtility.valueOf(value));
            ++i;
        }
    }

    public static void outputPropertiesTo(OutputStream s, String key, String value) throws Exception {
        String output = value.trim();
        if (output.length() > 0) {
            s.write(key.getBytes());
            s.write(61);
            if (key.length() + output.length() + 2 > 70) {
                s.write(92);
                s.write(13);
                s.write(10);
                s.write(32);
            }
            if (output.length() + 1 < 70) {
                s.write(output.getBytes());
                s.write(13);
                s.write(10);
            } else {
                int i = 0;
                while (i < output.length()) {
                    if (output.charAt(i) == '\n') {
                        s.write(92);
                        s.write(13);
                        s.write(10);
                        s.write(32);
                    } else if (output.charAt(i) != '\r') {
                        s.write(output.charAt(i));
                        if (output.charAt(i) == ',') {
                            s.write(92);
                            s.write(13);
                            s.write(10);
                            s.write(32);
                        }
                    }
                    ++i;
                }
                s.write(13);
                s.write(10);
            }
        }
    }

    public static void outputPropertiesTo(StringBuffer buffer, Hashtable properties) throws Exception {
        Set set = properties.keySet();
        Object[] keys = new String[set.size()];
        keys = set.toArray(keys);
        Arrays.sort(keys);
        int i = 0;
        while (i < keys.length) {
            Object key = keys[i];
            Object value = properties.get(key);
            CoreUtility.outputPropertiesTo(buffer, String.valueOf(key), CoreUtility.valueOf(value));
            ++i;
        }
    }

    public static void outputPropertiesTo(StringBuffer buffer, String key, String value) throws Exception {
        String output = value.trim();
        if (output.length() > 0) {
            buffer.append(key);
            buffer.append('=');
            if (output.length() + 1 < 70) {
                buffer.append(output);
                buffer.append('\r');
                buffer.append('\n');
            } else {
                int i = 0;
                while (i < output.length()) {
                    if (output.charAt(i) == '\n') {
                        buffer.append('\\');
                        buffer.append('\r');
                        buffer.append('\n');
                    } else if (output.charAt(i) != '\r') {
                        if (output.charAt(i) == '\t') {
                            buffer.append('\t');
                        } else {
                            buffer.append(output.charAt(i));
                            if (output.charAt(i) == ',') {
                                buffer.append('\\');
                                buffer.append('\r');
                                buffer.append('\n');
                            }
                        }
                    }
                    ++i;
                }
                buffer.append('\r');
                buffer.append('\n');
            }
        }
    }

    public static String stripPackage(String type) {
        int index = type.lastIndexOf(46);
        if (index == -1) {
            return type;
        }
        return type.substring(index + 1, type.length());
    }

    public static String valueOf(Object object) {
        if (object instanceof List) {
            StringBuffer buffer = new StringBuffer(1024);
            List list = (List)object;
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                if (buffer.length() > 0) {
                    buffer.append(',');
                }
                buffer.append(String.valueOf(iterator.next()));
            }
            return buffer.toString();
        }
        return String.valueOf(object);
    }

    protected String getCopyright() {
        return GeneratorTemplates.getCopyright(this.getTemplateVariables());
    }

    public Map getTemplateVariables() {
        HashMap map = new HashMap(101);
        return map;
    }
}

