/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.TimeZone;
import java.util.Vector;

public class DkSsiInputStream
extends InputStream {
    private Vector stack;
    private ByteArrayOutputStream buffer;
    private Hashtable variables = new Hashtable();
    private Hashtable entities = new Hashtable();
    int depth = 0;
    boolean commentLine = false;
    boolean entityRef = false;

    public DkSsiInputStream() {
        this.stack = new Vector();
        this.buffer = new ByteArrayOutputStream();
        this.initializeVariables();
    }

    public DkSsiInputStream(InputStream inputStream) {
        this.stack = new Vector();
        this.buffer = new ByteArrayOutputStream();
        this.push(inputStream);
        this.initializeVariables();
    }

    public static void main(String[] args) {
        try {
            int data;
            FileInputStream fileStream = new FileInputStream("test.ssi");
            DkSsiInputStream inputStream = new DkSsiInputStream(fileStream);
            while ((data = inputStream.read()) != -1) {
                System.out.print((char)data);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
        System.exit(0);
    }

    public void addEntity(String key, String value) {
        this.getEntities().put(key, value);
    }

    public void addVariable(String key, String value) {
        this.getVariables().put(key, value);
    }

    public InputStream getBlankStream() {
        return new ByteArrayInputStream("".getBytes());
    }

    public InputStream getEchoVar(String variableName) {
        String value = this.getVariable(variableName);
        if (value != null) {
            return new ByteArrayInputStream(value.getBytes());
        }
        return null;
    }

    public Hashtable getEntities() {
        return this.entities;
    }

    public String getEntity(String key) {
        return (String)this.getEntities().get(key);
    }

    public InputStream getIncludeFile(String value) {
        return null;
    }

    public InputStream getIncludeVirtual(String value) {
        return null;
    }

    public InputStream getInputStream() {
        return (InputStream)this.getStack().elementAt(this.getStack().size() - 1);
    }

    public Vector getStack() {
        return this.stack;
    }

    public InputStream getStream(String commentLine) {
        int startTagIndex;
        int equalIndex;
        int index;
        if (commentLine.startsWith("<--#") & commentLine.endsWith("-->") && (index = commentLine.indexOf(32)) != -1 && (equalIndex = commentLine.indexOf(61, index)) != -1 && (startTagIndex = commentLine.indexOf(34, equalIndex + 1)) != -1) {
            int n = commentLine.indexOf(34, startTagIndex + 1);
        }
        return null;
    }

    public String getVariable(String key) {
        return (String)this.getVariables().get(key);
    }

    public Hashtable getVariables() {
        return this.variables;
    }

    public void initializeVariables() {
        Date date = new Date();
        this.addVariable("DATE_LOCAL", date.toString());
        SimpleDateFormat format = new SimpleDateFormat("d MMM yyyy HH:mm:ss 'GMT'", Locale.US);
        format.setTimeZone(TimeZone.getTimeZone("GMT"));
        String gmt = format.format(date);
        this.addVariable("DATE_GMT", gmt);
    }

    public InputStream pop() {
        this.getStack().removeElementAt(this.getStack().size() - 1);
        return this.getInputStream();
    }

    public InputStream processComment(String comment) {
        String key;
        int index;
        if (comment.startsWith("<!--#") & comment.endsWith("-->")) {
            int index2 = comment.indexOf(32);
            if (index2 != -1) {
                String command = comment.substring(5, index2);
                int equalIndex = comment.indexOf(61, index2);
                if (equalIndex != -1) {
                    int endTagIndex;
                    String tag = comment.substring(index2, equalIndex).trim();
                    int startTagIndex = comment.indexOf(34, equalIndex + 1);
                    if (startTagIndex != -1 && (endTagIndex = comment.lastIndexOf(34)) != -1) {
                        String value = comment.substring(startTagIndex + 1, endTagIndex);
                        return this.processSsiCommand(command, tag, value);
                    }
                }
            }
        } else if (comment.startsWith("<!ENTITY % ") & comment.endsWith(">") && (index = (key = comment.substring("<!ENTITY % ".length(), comment.length() - 1).trim()).indexOf(32)) > 0) {
            String value = key.substring(index).trim();
            key = key.substring(0, index).trim();
            if (value.startsWith("'")) {
                int lastq = value.lastIndexOf(39);
                value = value.substring(1, lastq);
            } else if (value.startsWith("\"")) {
                int lastq = value.lastIndexOf(34);
                value = value.substring(1, lastq);
            } else {
                return null;
            }
            this.addEntity(key, value);
            return this.getBlankStream();
        }
        return null;
    }

    public InputStream processEntityReference(String comment) {
        String key = comment.substring(1, comment.length() - 1);
        String value = this.getEntity(key);
        if (value != null) {
            return new ByteArrayInputStream(value.getBytes());
        }
        return null;
    }

    public InputStream processSsiCommand(String command, String tag, String value) {
        if ("include".equals(command)) {
            if ("virtual".equals(tag)) {
                return this.getIncludeVirtual(value);
            }
            if ("file".equals(tag)) {
                return this.getIncludeFile(value);
            }
        } else if ("echo".equals(command)) {
            if ("var".equals(tag)) {
                return this.getEchoVar(value);
            }
        } else if ("set".equals(command) && "var".equals(tag)) {
            return this.setEchoVar(value);
        }
        return null;
    }

    public void push(InputStream inputStream) {
        this.getStack().addElement(inputStream);
    }

    public int read() throws IOException {
        if (this.getStack().size() < 1) {
            return -1;
        }
        int data = this.getInputStream().read();
        if (data == -1) {
            if (this.commentLine || this.entityRef) {
                this.pop();
                this.commentLine = false;
                this.entityRef = false;
                this.push(new ByteArrayInputStream(this.buffer.toByteArray()));
                this.buffer.reset();
                return this.getInputStream().read();
            }
            if (this.getStack().size() <= 1) {
                return data;
            }
            this.pop();
            return this.read();
        }
        if (this.buffer.size() == 0) {
            if (data == 60) {
                this.commentLine = true;
                this.entityRef = false;
                this.buffer.write(data);
                return this.read();
            }
            if (data == 37 || data == 38) {
                this.commentLine = false;
                this.entityRef = true;
                this.buffer.write(data);
                return this.read();
            }
        } else {
            this.buffer.write(data);
            if (this.commentLine) {
                if (data == 62) {
                    this.commentLine = false;
                    String comment = this.buffer.toString();
                    InputStream newInputStream = this.processComment(comment);
                    if (newInputStream != null) {
                        this.push(newInputStream);
                        this.buffer.reset();
                        return this.read();
                    }
                    this.push(new ByteArrayInputStream(this.buffer.toByteArray()));
                    this.buffer.reset();
                    return this.getInputStream().read();
                }
                if (this.buffer.size() == 2) {
                    if (data == 33) {
                        return this.read();
                    }
                    this.commentLine = false;
                    this.push(new ByteArrayInputStream(new byte[]{(byte)data}));
                    this.buffer.reset();
                    return 60;
                }
                return this.read();
            }
            if ((data == 59 || data == 32 || data == 60) && this.entityRef) {
                this.entityRef = false;
                String comment = this.buffer.toString();
                InputStream newInputStream = this.processEntityReference(comment);
                if (newInputStream != null) {
                    this.push(newInputStream);
                    this.buffer.reset();
                    return this.read();
                }
                this.push(new ByteArrayInputStream(this.buffer.toByteArray()));
                this.buffer.reset();
                return this.getInputStream().read();
            }
            return this.read();
        }
        return data;
    }

    public InputStream setEchoVar(String variableName) {
        int index = variableName.indexOf(34, 1);
        if (index > -1) {
            String value = "";
            String key = variableName.substring(0, index);
            int eqi = variableName.indexOf(61);
            if (eqi > -1) {
                value = variableName.substring(eqi + 2);
                this.addVariable(key, value);
                return this.getBlankStream();
            }
        }
        return null;
    }

    public void setEntities(Hashtable entities) {
        this.entities = entities;
    }

    public void setVariables(Hashtable variables) {
        this.variables = variables;
    }
}

