/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.soda.devicekit.util.DkSsiInputStream;

public class DkSsiProjectInputStream
extends DkSsiInputStream {
    protected IProject project;
    private IFile file;

    public DkSsiProjectInputStream(IProject project, IFile file) throws Exception {
        super(file.getContents(true));
        this.project = project;
        this.file = file;
    }

    public DkSsiProjectInputStream(InputStream stream, IFile file, IProject project) {
        super(stream);
        this.project = project;
        this.file = file;
    }

    public DkSsiProjectInputStream(IFile file) throws Exception {
        this(file.getProject(), file);
    }

    public IFile getBaseFile() {
        return this.file;
    }

    public InputStream getIncludeFile(String value) {
        return this.getIncludeVirtual(value);
    }

    public InputStream getIncludeVirtual(String value) {
        try {
            IResource resource = this.file.getParent().findMember(value);
            if (resource == null && (resource = this.project.findMember(value)) == null) {
                IFolder[] folders = this.getProjectFolders(this.project);
                int i = 0;
                while (i < folders.length) {
                    resource = folders[i].findMember(value);
                    if (resource != null) break;
                    ++i;
                }
            }
            if (resource != null) {
                File file = resource.getLocation().toFile();
                FileInputStream inputStream = new FileInputStream(file);
                return inputStream;
            }
            System.out.println("Did not find:" + value);
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
            throw new RuntimeException(exception.toString());
        }
        return null;
    }

    protected IJavaProject getJavaProject(IProject project) {
        try {
            JavaModel model;
            if (project.hasNature("org.eclipse.jdt.core.javanature") && (model = JavaModelManager.getJavaModelManager().getJavaModel()) != null) {
                return model.getJavaProject((IResource)project);
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public IFolder[] getProjectFolders(IProject project) {
        IJavaProject jp = this.getJavaProject(project);
        if (jp == null) {
            return new IFolder[0];
        }
        try {
            Vector<IResource> list = new Vector<IResource>();
            IPackageFragmentRoot[] roots = jp.getAllPackageFragmentRoots();
            int i2 = 0;
            while (i2 < roots.length) {
                IJavaElement[] children = roots[i2].getChildren();
                int i3 = 0;
                while (i3 < children.length) {
                    IResource resource = children[i3].getUnderlyingResource();
                    if (resource instanceof IFolder) {
                        list.add(resource);
                    }
                    ++i3;
                }
                ++i2;
            }
            IFolder[] folders = new IFolder[list.size()];
            list.toArray(folders);
            return folders;
        }
        catch (JavaModelException javaModelException) {
            return new IFolder[0];
        }
    }
}

