/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.samples.extension;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.soda.devicekit.ui.samples.extension.project.EclipseProject;

public class WizardContent
implements FilenameFilter {
    public static final String ECLIPSE32JAR = ".jar!";
    private String description;
    private String group;
    private String wizardId;
    private boolean primary = false;
    private URL directory;
    private File[] projectFiles = new File[0];
    private EclipseProject[] eclipseProjects = new EclipseProject[0];
    private int installCount = 0;
    private String pluginjardir;
    private String subdir;
    private boolean isEclipse32PluginJar = false;
    private int projectNum;

    public boolean accept(File dir, String name) {
        return name.endsWith(".zip") || name.endsWith(".jar");
    }

    public void decreaseInstallCount() {
        --this.installCount;
    }

    public boolean doInstall() {
        return this.installCount > 0;
    }

    public EclipseProject findProject(String name) {
        int i = 0;
        while (i < this.eclipseProjects.length) {
            if (this.eclipseProjects[i].getProjectName().equals(name)) {
                return this.eclipseProjects[i];
            }
            ++i;
        }
        return null;
    }

    public String getDescription() {
        return this.description;
    }

    public URL getDirectory() {
        return this.directory;
    }

    public EclipseProject[] getEclipseProjects() {
        return this.eclipseProjects;
    }

    public String getGroup() {
        return this.group;
    }

    public String getPluginjardir() {
        return this.pluginjardir;
    }

    public File[] getProjectFiles() {
        return this.projectFiles;
    }

    public int getProjectNum() {
        return this.projectNum;
    }

    public File[] getSelectedFiles() {
        ArrayList<File> list = new ArrayList<File>(this.eclipseProjects.length);
        int i = 0;
        while (i < this.eclipseProjects.length) {
            if (this.eclipseProjects[i].isInstall()) {
                list.add(this.eclipseProjects[i].getZipFile());
            }
            ++i;
        }
        File[] files = new File[list.size()];
        files = list.toArray(files);
        return files;
    }

    public String getSubdir() {
        return this.subdir;
    }

    public String getWizardId() {
        return this.wizardId;
    }

    public void increaseInstallCount(boolean increase) {
        this.installCount = increase ? ++this.installCount : --this.installCount;
    }

    public void installAll(boolean installAll) {
        this.installCount = installAll ? this.eclipseProjects.length : 0;
    }

    private boolean isEclipse32PluginJar(URL directory) {
        return directory.getPath().indexOf(ECLIPSE32JAR) != -1;
    }

    public boolean isEclipse32PluginJar() {
        return this.isEclipse32PluginJar;
    }

    public boolean isInstallProject(String name) {
        int i = 0;
        while (i < this.eclipseProjects.length) {
            if (this.eclipseProjects[i].getProjectName().equals(name)) {
                return this.eclipseProjects[i].isInstall();
            }
            ++i;
        }
        return false;
    }

    public boolean isPartial() {
        if (this.eclipseProjects.length == 0) {
            return false;
        }
        return this.installCount % this.eclipseProjects.length != 0;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    private void loadFiles(URL directory) {
        File dir = new File(directory.getPath());
        if (dir.exists()) {
            this.projectFiles = dir.listFiles(this);
            this.eclipseProjects = new EclipseProject[this.projectFiles.length];
            int i = 0;
            while (i < this.projectFiles.length) {
                this.eclipseProjects[i] = new EclipseProject(this.projectFiles[i], this);
                ++i;
            }
            Arrays.sort(this.eclipseProjects);
        }
    }

    private void loadFiles(String pluginjardir, String subdir) throws IOException {
        ZipFile pluginjar = new ZipFile(pluginjardir);
        this.projectNum = 0;
        ArrayList<String> projects = new ArrayList<String>();
        Enumeration<? extends ZipEntry> zes = pluginjar.entries();
        while (zes.hasMoreElements()) {
            ZipEntry ze = zes.nextElement();
            String entryName = ze.getName();
            if (!entryName.startsWith(subdir) || ze.isDirectory()) continue;
            int beginIndex = subdir.length() + 1;
            int endIndex = entryName.indexOf(".zip");
            if (endIndex <= 0) continue;
            ++this.projectNum;
            String projectName = entryName.substring(beginIndex, endIndex);
            projects.add(projectName);
        }
        this.eclipseProjects = new EclipseProject[this.projectNum];
        int i = 0;
        while (i < this.projectNum) {
            this.eclipseProjects[i] = new EclipseProject(pluginjardir, (String)projects.get(i), this);
            ++i;
        }
        Arrays.sort(this.eclipseProjects);
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDirectory(URL url, String subdir) throws MalformedURLException, IOException {
        if (this.isEclipse32PluginJar(url)) {
            this.isEclipse32PluginJar = true;
            int index = url.getPath().indexOf(ECLIPSE32JAR);
            this.pluginjardir = new URL(url.getPath().substring(0, index + 4)).getPath();
            this.subdir = subdir;
            this.loadFiles(this.pluginjardir, this.subdir);
        } else {
            this.isEclipse32PluginJar = false;
            this.directory = new URL(url, subdir);
            this.loadFiles(this.directory);
        }
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public void setPrimary(boolean b) {
        this.primary = b;
    }

    public void setWizard(String wizardId) {
        this.wizardId = wizardId;
    }

    public void setWizardId(String string) {
        this.wizardId = string;
    }
}

