/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.editor;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.soda.devicekit.editor.dkml.messages.Messages;
import org.eclipse.soda.devicekit.editor.dkml.schema.Choice;
import org.eclipse.soda.devicekit.editor.dkml.schema.ChoiceElement;
import org.eclipse.soda.devicekit.editor.dkml.schema.ComplexTypeHolder;
import org.eclipse.soda.devicekit.editor.dkml.schema.DkmlSchema;
import org.eclipse.soda.devicekit.editor.dkml.schema.IComplexTypeElement;
import org.eclipse.soda.devicekit.editor.dkml.schema.SchemaAttributeGroup;
import org.eclipse.soda.devicekit.editor.dkml.schema.SchemaAttributeHolder;
import org.eclipse.soda.devicekit.editor.dkml.schema.SchemaConstant;
import org.eclipse.soda.devicekit.editor.dkml.schema.Sequence;
import org.eclipse.soda.devicekit.editor.dkml.schema.SequenceElement;
import org.eclipse.soda.devicekit.editor.dkml.schema.SimpleContent;
import org.eclipse.soda.devicekit.editor.dkml.schema.SimpleTypeHolder;
import org.eclipse.soda.devicekit.ui.testmanager.editor.TestScriptSchemaBuild;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestScriptSchema
extends DkmlSchema {
    private Hashtable testTypes = null;
    private Hashtable attGroups = null;
    private Hashtable pAttributeGroups = null;
    private Hashtable pTypes = null;

    public TestScriptSchema() {
        this.build();
    }

    public static int convertToInt(String name) {
        if (name == null) {
            return -1;
        }
        if (name.equals(SchemaConstant.UNBOUNDED)) {
            return -2;
        }
        return Integer.parseInt(name);
    }

    public static String getLocalized(String name) {
        if (name == null) {
            return null;
        }
        int colon = name.indexOf(Messages.getString((String)"COLON"));
        if (colon == -1) {
            return name;
        }
        return name.substring(colon + 1, name.length());
    }

    public static void main(String[] args) {
        DkmlSchema schema = new DkmlSchema();
        schema.build();
    }

    public void build() {
        TestScriptSchemaBuild build = new TestScriptSchemaBuild();
        build.run();
        this.testTypes = build.getTypes();
        this.attGroups = build.getAttributeGroups();
        if (this.testTypes == null || this.attGroups == null) {
            return;
        }
        this.pAttributeGroups = new Hashtable();
        this.pTypes = new Hashtable();
        this.buildAttributeGroups();
        this.buildTypes();
    }

    protected void buildAttributeGroups() {
        Enumeration enumeration = this.attGroups.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            if (this.pAttributeGroups.containsKey(key)) continue;
            Node node = (Node)this.attGroups.get(key);
            this.parseAttributeGroup(node);
        }
    }

    protected IComplexTypeElement buildChoice(Node node) {
        Choice ch = new Choice(1);
        String sMinOccurs = this.getAttribute(node, SchemaConstant.MINOCCURS);
        String sMaxOccurs = this.getAttribute(node, SchemaConstant.MAXOCCURS);
        ch.setMinOccurs(DkmlSchema.convertToInt((String)sMinOccurs));
        ch.setMaxOccurs(DkmlSchema.convertToInt((String)sMaxOccurs));
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node cNode = children.item(i);
            if (cNode.getNodeType() == 1 && cNode.getLocalName().equals(SchemaConstant.ELEMENT)) {
                ChoiceElement e = this.buildChoiceElement(cNode);
                ch.addElement(e);
            }
            ++i;
        }
        return ch;
    }

    protected ChoiceElement buildChoiceElement(Node node) {
        String type = this.getAttribute(node, SchemaConstant.TYPE);
        String name = this.getAttribute(node, SchemaConstant.NAME);
        String sMinOccurs = this.getAttribute(node, SchemaConstant.MINOCCURS);
        String sMaxOccurs = this.getAttribute(node, SchemaConstant.MAXOCCURS);
        int minOccurs = DkmlSchema.convertToInt((String)sMinOccurs);
        int maxOccurs = DkmlSchema.convertToInt((String)sMaxOccurs);
        return new ChoiceElement(type, name, minOccurs, maxOccurs);
    }

    protected IComplexTypeElement buildSequence(Node node) {
        Sequence ss = new Sequence(2);
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node cNode = children.item(i);
            if (cNode.getNodeType() == 1) {
                if (cNode.getLocalName().equals(SchemaConstant.ELEMENT)) {
                    SequenceElement e = this.buildSequenceElement(cNode);
                    ss.addElement((Object)e);
                } else if (cNode.getLocalName().equals(SchemaConstant.CHOICE)) {
                    IComplexTypeElement choice = this.buildChoice(cNode);
                    ss.addElement((Object)choice);
                }
            }
            ++i;
        }
        return ss;
    }

    protected SequenceElement buildSequenceElement(Node node) {
        String type = this.getAttribute(node, SchemaConstant.TYPE);
        String name = this.getAttribute(node, SchemaConstant.NAME);
        String sMinOccurs = this.getAttribute(node, SchemaConstant.MINOCCURS);
        String sMaxOccurs = this.getAttribute(node, SchemaConstant.MAXOCCURS);
        int minOccurs = DkmlSchema.convertToInt((String)sMinOccurs);
        int maxOccurs = DkmlSchema.convertToInt((String)sMaxOccurs);
        return new SequenceElement(TestScriptSchema.getLocalized(type), TestScriptSchema.getLocalized(name), minOccurs, maxOccurs);
    }

    protected IComplexTypeElement buildSimpleContent(Node node) {
        SimpleContent sc = new SimpleContent(3);
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node cNode = children.item(i);
            if (cNode.getNodeType() == 1 && cNode.getLocalName().equals(SchemaConstant.EXTENSION)) {
                sc.setAttributeGroups(this.getAttributeGroupRef(cNode));
                String base = this.getAttribute(cNode, Messages.getString((String)"BASE"));
                if (base != null) {
                    sc.setType(base);
                }
            }
            ++i;
        }
        return sc;
    }

    protected void buildTypes() {
        Enumeration enumeration = this.testTypes.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            if (this.pTypes.contains(key)) continue;
            Node node = (Node)this.testTypes.get(key);
            this.parseTypes(node);
        }
    }

    public SchemaAttributeHolder createAttribute(Node node) {
        String name = "";
        String type = "";
        String use = Messages.getString((String)"OPTIONAL");
        NamedNodeMap attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.getLength()) {
            Node attNode = attributes.item(i);
            if (attNode.getNodeName().equals(SchemaConstant.NAME)) {
                name = TestScriptSchema.getLocalized(attNode.getNodeValue());
            } else if (attNode.getNodeName().equals(SchemaConstant.TYPE)) {
                type = TestScriptSchema.getLocalized(attNode.getNodeValue());
            } else if (attNode.getNodeName().equals(SchemaConstant.USE)) {
                use = TestScriptSchema.getLocalized(attNode.getNodeValue());
            }
            ++i;
        }
        int usei = 0;
        if (use.equals(Messages.getString((String)"MANDATORY"))) {
            usei = 1;
        }
        return new SchemaAttributeHolder(name, type, usei);
    }

    public SchemaAttributeGroup createAttributeGroup(Node node) {
        NamedNodeMap attributes = node.getAttributes();
        String ref = "";
        int i = 0;
        while (i < attributes.getLength()) {
            Node attNode = attributes.item(i);
            if (attNode.getNodeName().equals(SchemaConstant.REF)) {
                ref = TestScriptSchema.getLocalized(attNode.getNodeValue());
                break;
            }
            ++i;
        }
        if (ref.length() > 0) {
            return (SchemaAttributeGroup)this.pAttributeGroups.get(ref);
        }
        return null;
    }

    protected String getAttribute(Node node, String attribute) {
        NamedNodeMap attributes = node.getAttributes();
        if (attributes != null) {
            int i = 0;
            while (i < attributes.getLength()) {
                Node aNode = attributes.item(i);
                if (aNode.getNodeName().equals(attribute)) {
                    return aNode.getNodeValue();
                }
                ++i;
            }
        }
        return null;
    }

    public Object getAttributeGroup(String key) {
        return this.pAttributeGroups.get(key);
    }

    protected Vector getAttributeGroupRef(Node node) {
        NodeList children = node.getChildNodes();
        Vector groups = new Vector();
        int i = 0;
        while (i < children.getLength()) {
            Node cNode = children.item(i);
            if (cNode.getNodeType() == 1 && cNode.getLocalName().equals(SchemaConstant.ATTRIBUTE_GROUP)) {
                String key = this.getAttribute(cNode, SchemaConstant.REF);
                groups.add(this.pAttributeGroups.get(key));
            }
            ++i;
        }
        return groups;
    }

    public Enumeration getAttributeGroups() {
        return this.pAttributeGroups.keys();
    }

    public Object getCmlType(String key) {
        return this.pTypes.get(key);
    }

    public Enumeration getCmlTypes() {
        return this.pTypes.keys();
    }

    protected Vector getEnums(Node node) {
        Vector<String> enums = new Vector<String>();
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node cNode = children.item(i);
            switch (cNode.getNodeType()) {
                case 1: {
                    String val;
                    String cName = cNode.getLocalName();
                    if (!cName.equals(SchemaConstant.ENUMERATION) || (val = this.getAttribute(cNode, SchemaConstant.VALUE)) == null) break;
                    enums.add(val);
                }
            }
            ++i;
        }
        return enums;
    }

    protected int getType(String name) {
        if (name.equals(SchemaConstant.COMPLEX_TYPE)) {
            return 1;
        }
        if (name.equals(SchemaConstant.SIMPLE_TYPE)) {
            return 0;
        }
        return -1;
    }

    protected void handleAttAdd(Node cNode, SchemaAttributeGroup sagh) {
        String type = "";
        String name = "";
        String use = "";
        int usei = -1;
        NamedNodeMap atts = cNode.getAttributes();
        int j = 0;
        while (j < atts.getLength()) {
            Node aNode = atts.item(j);
            if (aNode.getNodeName().equals(SchemaConstant.NAME)) {
                name = DkmlSchema.getLocalized((String)aNode.getNodeValue());
            } else if (aNode.getNodeName().equals(SchemaConstant.TYPE)) {
                type = DkmlSchema.getLocalized((String)aNode.getNodeValue());
            } else if (aNode.getNodeName().equals(SchemaConstant.USE)) {
                use = DkmlSchema.getLocalized((String)aNode.getNodeValue());
            }
            ++j;
        }
        usei = use != null ? (use.equals(Messages.getString((String)"MANDATORY")) ? 1 : 0) : 0;
        sagh.addAttribute(name, type, usei);
    }

    protected void handleAttGroupAdd(Node cNode, SchemaAttributeGroup sagh) {
        NamedNodeMap atts = cNode.getAttributes();
        Node refnode = atts.getNamedItem(Messages.getString((String)"REF"));
        String grp = refnode.getNodeValue();
        if (!this.isGroupProcessed(grp)) {
            Node agnode = (Node)this.attGroups.get(grp);
            this.parseAttributeGroup(agnode);
        }
        SchemaAttributeGroup saghref = (SchemaAttributeGroup)this.pAttributeGroups.get(grp);
        int j = 0;
        while (j < saghref.getAttributes().size()) {
            SchemaAttributeHolder gHolder = (SchemaAttributeHolder)saghref.getAttributes().elementAt(j);
            sagh.addAttribute(gHolder);
            ++j;
        }
    }

    protected void handleComplexType(Node node, ComplexTypeHolder holder) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node cNode = children.item(i);
            switch (cNode.getNodeType()) {
                case 1: {
                    String cName = cNode.getLocalName();
                    if (cName == null) break;
                    if (cName.equals(SchemaConstant.SEQUENCE)) {
                        holder.addElement((Object)this.buildSequence(cNode));
                        break;
                    }
                    if (cName.equals(SchemaConstant.SIMPLE_CONTENT)) {
                        holder.addElement((Object)this.buildSimpleContent(cNode));
                        break;
                    }
                    if (cName.equals(SchemaConstant.CHOICE)) {
                        holder.addElement((Object)this.buildChoice(cNode));
                        break;
                    }
                    if (cName.equals(SchemaConstant.ATTRIBUTE)) {
                        holder.addAttribute(this.createAttribute(cNode));
                        break;
                    }
                    if (!cName.equals(SchemaConstant.ATTRIBUTE_GROUP)) break;
                    holder.addAttributeGroup(this.createAttributeGroup(cNode));
                }
            }
            ++i;
        }
    }

    protected void handleSimpleType(Node node, SimpleTypeHolder holder) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node cNode = children.item(i);
            switch (cNode.getNodeType()) {
                case 1: {
                    String cName = cNode.getLocalName();
                    if (cName == null) break;
                    if (cName.equals(SchemaConstant.RESTRICTION)) {
                        String base = DkmlSchema.getLocalized((String)this.getAttribute(cNode, SchemaConstant.BASE));
                        Vector enums = this.getEnums(cNode);
                        holder.setRestriction(base, enums);
                        break;
                    }
                    if (cName.equals(SchemaConstant.ATTRIBUTE)) {
                        holder.addAttribute(this.createAttribute(cNode));
                        break;
                    }
                    if (!cName.equals(SchemaConstant.ATTRIBUTE_GROUP)) break;
                    holder.addAttributeGroup(this.createAttributeGroup(cNode));
                }
            }
            ++i;
        }
    }

    protected boolean isGroupProcessed(String groupName) {
        return this.pAttributeGroups.contains(groupName);
    }

    protected void parseAttributeGroup(Node node) {
        SchemaAttributeGroup sagh = new SchemaAttributeGroup();
        String groupName = this.getAttribute(node, SchemaConstant.NAME);
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            Node cNode = children.item(i);
            switch (cNode.getNodeType()) {
                case 1: {
                    if (cNode.getLocalName().equals(SchemaConstant.ATTRIBUTE)) {
                        this.handleAttAdd(cNode, sagh);
                        break;
                    }
                    if (!cNode.getLocalName().equals(SchemaConstant.ATTRIBUTE_GROUP)) break;
                    this.handleAttGroupAdd(cNode, sagh);
                }
            }
            ++i;
        }
        this.pAttributeGroups.put(groupName, sagh);
    }

    protected void parseTypes(Node node) {
        String typeName = this.getAttribute(node, SchemaConstant.NAME);
        String tag = node.getLocalName();
        int type = this.getType(tag);
        switch (type) {
            case 1: {
                ComplexTypeHolder cth = new ComplexTypeHolder();
                cth.setType(type);
                cth.setName(typeName);
                this.handleComplexType(node, cth);
                this.pTypes.put(typeName, cth);
                break;
            }
            case 0: {
                SimpleTypeHolder sth = new SimpleTypeHolder();
                sth.setName(typeName);
                sth.setType(type);
                this.handleSimpleType(node, sth);
                this.pTypes.put(typeName, sth);
            }
        }
    }
}

