/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.preferences;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.internal.ui.util.TableLayoutComposite;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ContentViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerMessages;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerPlugin;
import org.eclipse.soda.devicekit.ui.testmanager.preferences.PreferenceConstants;
import org.eclipse.soda.devicekit.ui.testmanager.util.ExceptionHandler;
import org.eclipse.soda.devicekit.ui.testmanager.util.LayoutUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.progress.IProgressService;

public class TestManagerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final String DEFAULT_NEW_FILTER_TEXT = "";
    static final Image IMG_CUNIT = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.class_obj.gif");
    static final Image IMG_PKG = JavaUI.getSharedImages().getImage("org.eclipse.jdt.ui.package_obj.gif");
    private Label fFilterViewerLabel;
    CheckboxTableViewer fFilterViewer;
    private Table fFilterTable;
    private Button fAddPackageButton;
    private Button fAddTypeButton;
    Button fRemoveFilterButton;
    private Button fAddFilterButton;
    private Button fEnableAllButton;
    private Button fDisableAllButton;
    Text fEditorText;
    String fInvalidEditorText = null;
    private TableEditor fTableEditor;
    private TableItem fNewTableItem;
    private Filter fNewStackFilter;
    StackFilterContentProvider fStackFilterContentProvider;
    FieldEditor fMaxTestSessions;
    FieldEditor fControllerRegistryPort;

    public TestManagerPreferencePage() {
        this.setDescription(TestManagerMessages.PreferencePage_description);
        this.setPreferenceStore(TestManagerPlugin.getDefault().getPreferenceStore());
    }

    public static String[] getFilterPatterns() {
        IPreferenceStore store = TestManagerPlugin.getDefault().getPreferenceStore();
        return TestManagerPreferencePage.parseList(store.getString("org.eclipse.soda.devicekit.ui.testmanager.active_filters"));
    }

    public static boolean getFilterStack() {
        IPreferenceStore store = TestManagerPlugin.getDefault().getPreferenceStore();
        return store.getBoolean("org.eclipse.soda.devicekit.ui.testmanager.do_filter_stack");
    }

    private static String[] parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        return list.toArray(new String[list.size()]);
    }

    public static void setFilterStack(boolean filter) {
        IPreferenceStore store = TestManagerPlugin.getDefault().getPreferenceStore();
        store.setValue("org.eclipse.soda.devicekit.ui.testmanager.do_filter_stack", filter);
    }

    void addPackage() {
        Shell shell = this.getShell();
        IProgressService context = PlatformUI.getWorkbench().getProgressService();
        IJavaSearchScope createWorkspaceScope = SearchEngine.createWorkspaceScope();
        SelectionDialog dialog = JavaUI.createPackageDialog((Shell)shell, (IRunnableContext)context, (IJavaSearchScope)createWorkspaceScope, (boolean)true, (boolean)true, (String)DEFAULT_NEW_FILTER_TEXT);
        dialog.setTitle(TestManagerMessages.PreferencePage_addpackagedialog_title);
        dialog.setMessage(TestManagerMessages.PreferencePage_addpackagedialog_message);
        if (dialog.open() != 0) {
            return;
        }
        Object[] packages = dialog.getResult();
        if (packages == null) {
            return;
        }
        int i = 0;
        while (i < packages.length) {
            IJavaElement pkg = (IJavaElement)packages[i];
            String filter = pkg.getElementName();
            filter = filter.length() < 1 ? TestManagerMessages.MainTab_label_defaultpackage : String.valueOf(filter) + ".*";
            this.fStackFilterContentProvider.addFilter(filter, true);
            ++i;
        }
    }

    void addType() {
        Shell shell = this.getShell();
        SelectionDialog dialog = null;
        try {
            dialog = JavaUI.createTypeDialog((Shell)shell, (IRunnableContext)PlatformUI.getWorkbench().getProgressService(), (IJavaSearchScope)SearchEngine.createWorkspaceScope(), (int)2, (boolean)false);
        }
        catch (JavaModelException jme) {
            String title = TestManagerMessages.PreferencePage_addtypedialog_title;
            String message = TestManagerMessages.PreferencePage_addtypedialog_error_message;
            ExceptionHandler.handle((CoreException)((Object)jme), shell, title, message);
            return;
        }
        dialog.setTitle(TestManagerMessages.PreferencePage_addtypedialog_title);
        dialog.setMessage(TestManagerMessages.PreferencePage_addtypedialog_message);
        if (dialog.open() == 1) {
            return;
        }
        Object[] types = dialog.getResult();
        if (types != null && types.length > 0) {
            IType type = (IType)types[0];
            this.fStackFilterContentProvider.addFilter(type.getFullyQualifiedName('.'), true);
        }
    }

    void checkAllFilters(boolean check) {
        Object[] filters = this.fStackFilterContentProvider.getElements(null);
        int i = filters.length - 1;
        while (i >= 0) {
            ((Filter)filters[i]).setChecked(check);
            --i;
        }
        this.fFilterViewer.setAllChecked(check);
    }

    void cleanupEditor() {
        if (this.fEditorText == null) {
            return;
        }
        this.fNewStackFilter = null;
        this.fNewTableItem = null;
        this.fTableEditor.setEditor(null, null, 0);
        this.fEditorText.dispose();
        this.fEditorText = null;
    }

    protected List createActiveStackFiltersList() {
        return Arrays.asList(TestManagerPreferencePage.getFilterPatterns());
    }

    protected Control createContents(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "org.eclipse.soda.devicekit.ui.testmanager.preference_page_context");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        this.createFieldEditors(composite);
        this.createStackFilterPreferences(composite);
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    private void createFieldEditors(Composite parent) {
        Composite grid = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        grid.setLayout((Layout)layout);
        grid.setLayoutData((Object)new GridData(770));
        IPropertyChangeListener listener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                TestManagerPreferencePage.this.setValid(TestManagerPreferencePage.this.fMaxTestSessions.isValid() && TestManagerPreferencePage.this.fControllerRegistryPort.isValid());
            }
        };
        this.fMaxTestSessions = this.createIntegerFieldEditor("org.eclipse.soda.devicekit.ui.testmanager.max_test_runs", TestManagerMessages.PreferencePage_maxtestsessions_label, grid, listener);
    }

    private void createFilterTable(Composite container) {
        TableLayoutComposite layouter = new TableLayoutComposite(container, 0);
        layouter.addColumnData((ColumnLayoutData)new ColumnWeightData(100));
        layouter.setLayoutData((Object)new GridData(1808));
        this.fFilterTable = new Table((Composite)layouter, 67618);
        new TableColumn(this.fFilterTable, 0);
        this.fFilterViewer = new CheckboxTableViewer(this.fFilterTable);
        this.fTableEditor = new TableEditor(this.fFilterTable);
        this.fFilterViewer.setLabelProvider((IBaseLabelProvider)new FilterLabelProvider());
        this.fFilterViewer.setComparator((ViewerComparator)new FilterViewerSorter());
        this.fStackFilterContentProvider = new StackFilterContentProvider();
        this.fFilterViewer.setContentProvider((IContentProvider)this.fStackFilterContentProvider);
        this.fFilterViewer.setInput((Object)this);
        this.fFilterViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Filter filter = (Filter)event.getElement();
                TestManagerPreferencePage.this.fStackFilterContentProvider.toggleFilter(filter);
            }
        });
        this.fFilterViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ISelection selection = event.getSelection();
                TestManagerPreferencePage.this.fRemoveFilterButton.setEnabled(!selection.isEmpty());
            }
        });
    }

    protected List createInactiveStackFiltersList() {
        String[] strings = TestManagerPreferencePage.parseList(this.getPreferenceStore().getString("org.eclipse.soda.devicekit.ui.testmanager.inactive_filters"));
        return Arrays.asList(strings);
    }

    private IntegerFieldEditor createIntegerFieldEditor(String name, String labelText, Composite parent, IPropertyChangeListener listener) {
        IntegerFieldEditor fieldEditor = new IntegerFieldEditor(name, labelText, parent, 10);
        fieldEditor.setPage((DialogPage)this);
        fieldEditor.setValidRange(1, 65535);
        fieldEditor.setPreferenceStore(this.getPreferenceStore());
        fieldEditor.setPropertyChangeListener(listener);
        fieldEditor.load();
        return fieldEditor;
    }

    private void createStackFilterPreferences(Composite composite) {
        this.fFilterViewerLabel = new Label(composite, 16388);
        this.fFilterViewerLabel.setText(TestManagerMessages.PreferencePage_filter_label);
        Composite container = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        container.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        container.setLayoutData((Object)gd);
        this.createFilterTable(container);
        this.createStepFilterButtons(container);
    }

    private void createStepFilterButtons(Composite container) {
        Composite buttonContainer = new Composite(container, 0);
        GridData gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        GridLayout buttonLayout = new GridLayout();
        buttonLayout.numColumns = 1;
        buttonLayout.marginHeight = 0;
        buttonLayout.marginWidth = 0;
        buttonContainer.setLayout((Layout)buttonLayout);
        this.fAddFilterButton = new Button(buttonContainer, 8);
        this.fAddFilterButton.setText(TestManagerMessages.PreferencePage_addfilterbutton_label);
        this.fAddFilterButton.setToolTipText(TestManagerMessages.PreferencePage_addfilterbutton_tooltip);
        gd = new GridData(770);
        this.fAddFilterButton.setLayoutData((Object)gd);
        LayoutUtil.setButtonDimensionHint(this.fAddFilterButton);
        this.fAddFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TestManagerPreferencePage.this.editFilter();
            }
        });
        this.fAddTypeButton = new Button(buttonContainer, 8);
        this.fAddTypeButton.setText(TestManagerMessages.PreferencePage_addtypebutton_label);
        this.fAddTypeButton.setToolTipText(TestManagerMessages.PreferencePage_addtypebutton_tooltip);
        gd = this.getButtonGridData(this.fAddTypeButton);
        this.fAddTypeButton.setLayoutData((Object)gd);
        LayoutUtil.setButtonDimensionHint(this.fAddTypeButton);
        this.fAddTypeButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TestManagerPreferencePage.this.addType();
            }
        });
        this.fAddPackageButton = new Button(buttonContainer, 8);
        this.fAddPackageButton.setText(TestManagerMessages.PreferencePage_addpackagebutton_label);
        this.fAddPackageButton.setToolTipText(TestManagerMessages.PreferencePage_addpackagebutton_tooltip);
        gd = this.getButtonGridData(this.fAddPackageButton);
        this.fAddPackageButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)this.fAddPackageButton);
        this.fAddPackageButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TestManagerPreferencePage.this.addPackage();
            }
        });
        this.fRemoveFilterButton = new Button(buttonContainer, 8);
        this.fRemoveFilterButton.setText(TestManagerMessages.PreferencePage_removefilterbutton_label);
        this.fRemoveFilterButton.setToolTipText(TestManagerMessages.PreferencePage_removefilterbutton_tooltip);
        gd = this.getButtonGridData(this.fRemoveFilterButton);
        this.fRemoveFilterButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)this.fRemoveFilterButton);
        this.fRemoveFilterButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TestManagerPreferencePage.this.removeFilters();
            }
        });
        this.fRemoveFilterButton.setEnabled(false);
        this.fEnableAllButton = new Button(buttonContainer, 8);
        this.fEnableAllButton.setText(TestManagerMessages.PreferencePage_enableallbutton_label);
        this.fEnableAllButton.setToolTipText(TestManagerMessages.PreferencePage_enableallbutton_tooltip);
        gd = this.getButtonGridData(this.fEnableAllButton);
        this.fEnableAllButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)this.fEnableAllButton);
        this.fEnableAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TestManagerPreferencePage.this.checkAllFilters(true);
            }
        });
        this.fDisableAllButton = new Button(buttonContainer, 8);
        this.fDisableAllButton.setText(TestManagerMessages.PreferencePage_disableallbutton_label);
        this.fDisableAllButton.setToolTipText(TestManagerMessages.PreferencePage_disableallbutton_tooltip);
        gd = this.getButtonGridData(this.fDisableAllButton);
        this.fDisableAllButton.setLayoutData((Object)gd);
        SWTUtil.setButtonDimensionHint((Button)this.fDisableAllButton);
        this.fDisableAllButton.addListener(13, new Listener(){

            public void handleEvent(Event e) {
                TestManagerPreferencePage.this.checkAllFilters(false);
            }
        });
    }

    void editFilter() {
        if (this.fEditorText != null) {
            this.validateChangeAndCleanup();
        }
        this.fNewStackFilter = this.fStackFilterContentProvider.addFilter(DEFAULT_NEW_FILTER_TEXT, true);
        this.fNewTableItem = this.fFilterTable.getItem(0);
        int textStyles = 16388;
        if (!SWT.getPlatform().equals("motif")) {
            textStyles |= 0x800;
        }
        this.fEditorText = new Text((Composite)this.fFilterTable, textStyles);
        GridData gd = new GridData(1808);
        this.fEditorText.setLayoutData((Object)gd);
        this.fTableEditor.horizontalAlignment = 16384;
        this.fTableEditor.grabHorizontal = true;
        this.fTableEditor.setEditor((Control)this.fEditorText, this.fNewTableItem, 0);
        this.fEditorText.setText(this.fNewStackFilter.getName());
        this.fEditorText.selectAll();
        this.setEditorListeners(this.fEditorText);
        this.fEditorText.setFocus();
    }

    private GridData getButtonGridData(Button button) {
        GridData gd = new GridData(770);
        int widthHint = this.convertHorizontalDLUsToPixels(61);
        gd.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        return gd;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        this.setDefaultValues();
        super.performDefaults();
    }

    public boolean performOk() {
        this.fMaxTestSessions.store();
        this.fControllerRegistryPort.store();
        this.fStackFilterContentProvider.saveFilters();
        return true;
    }

    void removeFilters() {
        IStructuredSelection selection = (IStructuredSelection)this.fFilterViewer.getSelection();
        this.fStackFilterContentProvider.removeFilters(selection.toArray());
    }

    void removeNewFilter() {
        this.fStackFilterContentProvider.removeFilters(new Object[]{this.fNewStackFilter});
    }

    private void setDefaultValues() {
        this.fMaxTestSessions.loadDefault();
        this.fControllerRegistryPort.loadDefault();
        this.fStackFilterContentProvider.setDefaults();
    }

    private void setEditorListeners(Text text) {
        text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent event) {
                if (event.character == '\r') {
                    if (TestManagerPreferencePage.this.fInvalidEditorText != null) {
                        TestManagerPreferencePage.this.fEditorText.setText(TestManagerPreferencePage.this.fInvalidEditorText);
                        TestManagerPreferencePage.this.fInvalidEditorText = null;
                    } else {
                        TestManagerPreferencePage.this.validateChangeAndCleanup();
                    }
                } else if (event.character == '\u001b') {
                    TestManagerPreferencePage.this.removeNewFilter();
                    TestManagerPreferencePage.this.cleanupEditor();
                }
            }
        });
        text.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent event) {
                if (TestManagerPreferencePage.this.fInvalidEditorText != null) {
                    TestManagerPreferencePage.this.fEditorText.setText(TestManagerPreferencePage.this.fInvalidEditorText);
                    TestManagerPreferencePage.this.fInvalidEditorText = null;
                } else {
                    TestManagerPreferencePage.this.validateChangeAndCleanup();
                }
            }
        });
        text.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                event.doit = false;
            }
        });
    }

    protected void updateActions() {
        if (this.fEnableAllButton == null) {
            return;
        }
        boolean enabled = this.fFilterViewer.getTable().getItemCount() > 0;
        this.fEnableAllButton.setEnabled(enabled);
        this.fDisableAllButton.setEnabled(enabled);
    }

    void validateChangeAndCleanup() {
        String trimmedValue = this.fEditorText.getText().trim();
        if (trimmedValue.length() < 1) {
            this.removeNewFilter();
        } else {
            if (!this.validateEditorInput(trimmedValue)) {
                this.fInvalidEditorText = trimmedValue;
                this.fEditorText.setText(TestManagerMessages.PreferencePage_invalidstepfilterreturnescape);
                this.getShell().getDisplay().beep();
                return;
            }
            Object[] filters = this.fStackFilterContentProvider.getElements(null);
            int i = 0;
            while (i < filters.length) {
                Filter filter = (Filter)filters[i];
                if (filter.getName().equals(trimmedValue)) {
                    this.removeNewFilter();
                    this.cleanupEditor();
                    return;
                }
                ++i;
            }
            this.fNewTableItem.setText(trimmedValue);
            this.fNewStackFilter.setName(trimmedValue);
            this.fFilterViewer.refresh();
        }
        this.cleanupEditor();
    }

    private boolean validateEditorInput(String trimmedValue) {
        char firstChar = trimmedValue.charAt(0);
        if (!Character.isJavaIdentifierStart(firstChar) || firstChar == '*') {
            return false;
        }
        int length = trimmedValue.length();
        int i = 1;
        while (i < length) {
            char c = trimmedValue.charAt(i);
            if (!(Character.isJavaIdentifierPart(c) || c == '.' && i != length - 1 || c == '*' && i == length - 1)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private static class Filter {
        private String fName;
        private boolean fChecked;

        public Filter(String name, boolean checked) {
            this.setName(name);
            this.setChecked(checked);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Filter)) {
                return false;
            }
            Filter other = (Filter)o;
            return this.getName().equals(other.getName());
        }

        public String getName() {
            return this.fName;
        }

        public int hashCode() {
            return this.fName.hashCode();
        }

        public boolean isChecked() {
            return this.fChecked;
        }

        public void setChecked(boolean checked) {
            this.fChecked = checked;
        }

        public void setName(String name) {
            this.fName = name;
        }
    }

    private static class FilterLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        public Image getColumnImage(Object object, int column) {
            String name = ((Filter)object).getName();
            if (name.endsWith(".*") || name.equals(TestManagerMessages.MainTab_label_defaultpackage)) {
                return IMG_PKG;
            }
            if (TestManagerPreferencePage.DEFAULT_NEW_FILTER_TEXT.equals(name)) {
                return null;
            }
            if (Character.isUpperCase(name.charAt(0)) && name.indexOf(46) < 0) {
                return IMG_CUNIT;
            }
            int lastDotIndex = name.lastIndexOf(46);
            if (-1 != lastDotIndex && name.length() - 1 != lastDotIndex && Character.isUpperCase(name.charAt(lastDotIndex + 1))) {
                return IMG_CUNIT;
            }
            return null;
        }

        public String getColumnText(Object object, int column) {
            return column == 0 ? ((Filter)object).getName() : TestManagerPreferencePage.DEFAULT_NEW_FILTER_TEXT;
        }

        public String getText(Object element) {
            return ((Filter)element).getName();
        }
    }

    private static class FilterViewerSorter
    extends ViewerComparator {
        public int compare(Viewer viewer, Object e1, Object e2) {
            ILabelProvider lprov = (ILabelProvider)((ContentViewer)viewer).getLabelProvider();
            String name1 = lprov.getText(e1);
            String name2 = lprov.getText(e2);
            if (name1 == null) {
                name1 = TestManagerPreferencePage.DEFAULT_NEW_FILTER_TEXT;
            }
            if (name2 == null) {
                name2 = TestManagerPreferencePage.DEFAULT_NEW_FILTER_TEXT;
            }
            if (name1.length() > 0 && name2.length() > 0) {
                char char1 = name1.charAt(name1.length() - 1);
                char char2 = name2.charAt(name2.length() - 1);
                if (char1 == '*' && char1 != char2) {
                    return -1;
                }
                if (char2 == '*' && char2 != char1) {
                    return 1;
                }
            }
            return this.getComparator().compare(name1, name2);
        }
    }

    private class StackFilterContentProvider
    implements IStructuredContentProvider {
        private List fFilters;

        public StackFilterContentProvider() {
            List active = TestManagerPreferencePage.this.createActiveStackFiltersList();
            List inactive = TestManagerPreferencePage.this.createInactiveStackFiltersList();
            this.populateFilters(active, inactive);
        }

        public Filter addFilter(String name, boolean checked) {
            Filter filter = new Filter(name, checked);
            if (!this.fFilters.contains(filter)) {
                this.fFilters.add(filter);
                TestManagerPreferencePage.this.fFilterViewer.add((Object)filter);
                TestManagerPreferencePage.this.fFilterViewer.setChecked((Object)filter, checked);
            }
            TestManagerPreferencePage.this.updateActions();
            return filter;
        }

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return this.fFilters.toArray();
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        protected void populateFilters(List activeList, List inactiveList) {
            this.fFilters = new ArrayList(activeList.size() + inactiveList.size());
            this.populateList(activeList, true);
            if (inactiveList.size() != 0) {
                this.populateList(inactiveList, false);
            }
        }

        protected void populateList(List list, boolean checked) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String name = (String)iterator.next();
                this.addFilter(name, checked);
            }
        }

        public void removeFilters(Object[] filters) {
            int i = filters.length - 1;
            while (i >= 0) {
                Filter filter = (Filter)filters[i];
                this.fFilters.remove(filter);
                --i;
            }
            TestManagerPreferencePage.this.fFilterViewer.remove(filters);
            TestManagerPreferencePage.this.updateActions();
        }

        public void saveFilters() {
            ArrayList<String> active = new ArrayList<String>(this.fFilters.size());
            ArrayList<String> inactive = new ArrayList<String>(this.fFilters.size());
            Iterator iterator = this.fFilters.iterator();
            while (iterator.hasNext()) {
                Filter filter = (Filter)iterator.next();
                String name = filter.getName();
                if (filter.isChecked()) {
                    active.add(name);
                    continue;
                }
                inactive.add(name);
            }
            String pref = PreferenceConstants.serializeList(active.toArray(new String[active.size()]));
            TestManagerPreferencePage.this.getPreferenceStore().setValue("org.eclipse.soda.devicekit.ui.testmanager.active_filters", pref);
            pref = PreferenceConstants.serializeList(inactive.toArray(new String[inactive.size()]));
            TestManagerPreferencePage.this.getPreferenceStore().setValue("org.eclipse.soda.devicekit.ui.testmanager.inactive_filters", pref);
        }

        public void setDefaults() {
            TestManagerPreferencePage.this.fFilterViewer.remove(this.fFilters.toArray());
            List active = PreferenceConstants.createDefaultStackFiltersList();
            ArrayList inactive = new ArrayList();
            this.populateFilters(active, inactive);
        }

        public void toggleFilter(Filter filter) {
            boolean newState = !filter.isChecked();
            filter.setChecked(newState);
            TestManagerPreferencePage.this.fFilterViewer.setChecked((Object)filter, newState);
        }
    }
}

