/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.testmanager.view;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.soda.devicekit.ui.testmanager.TestManagerPlugin;
import org.eclipse.soda.devicekit.ui.testmanager.util.TestManagerImages;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;

public class TestManagerImageDescriptor
extends CompositeImageDescriptor {
    public static final int SUCCESS = 1;
    public static final int ERROR = 2;
    public static final int FAILURE = 4;
    private ImageDescriptor fBaseImage;
    private int fFlags;
    private Point fSize;
    static /* synthetic */ Class class$0;

    public TestManagerImageDescriptor(ImageDescriptor baseImage, int flags, Point size) {
        this.fBaseImage = baseImage;
        Assert.isNotNull((Object)this.fBaseImage);
        this.fFlags = flags;
        Assert.isTrue((this.fFlags >= 0 ? 1 : 0) != 0);
        this.fSize = size;
        Assert.isNotNull((Object)this.fSize);
    }

    protected void addBottomLeftImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x;
        int y = pos.y - data.height;
        if (x + data.width < this.getSize().x && y >= 0) {
            this.drawImage(data, x, y);
            pos.x = x + data.width;
        }
    }

    protected void addBottomRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x - data.width;
        int y = pos.y - data.height;
        if (x >= 0 && y >= 0) {
            this.drawImage(data, x, y);
            pos.x = x;
        }
    }

    protected void addTopRightImage(ImageDescriptor desc, Point pos) {
        ImageData data = this.getImageData(desc);
        int x = pos.x - data.width;
        if (x >= 0) {
            this.drawImage(data, x, pos.y);
            pos.x = x;
        }
    }

    private void drawBottomLeft() {
        Point pos = new Point(0, this.getSize().y);
        if ((this.fFlags & 1) != 0) {
            this.addBottomLeftImage(TestManagerImages.fgSuccessOverlayImageDescriptor, pos);
        }
        if ((this.fFlags & 2) != 0) {
            this.addBottomLeftImage(TestManagerImages.fgErrorOverlayImageDescriptor, pos);
        }
        if ((this.fFlags & 4) != 0) {
            this.addBottomLeftImage(TestManagerImages.fgFailedOverlayImageDescriptor, pos);
        }
    }

    private void drawBottomRight() {
    }

    protected void drawCompositeImage(int width, int height) {
        ImageData bg = this.getImageData(this.fBaseImage);
        this.drawImage(bg, 0, 0);
        this.drawTopRight();
        this.drawBottomRight();
        this.drawBottomLeft();
    }

    private void drawTopRight() {
    }

    public boolean equals(Object object) {
        block8: {
            block7: {
                if (object == null) break block7;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.soda.devicekit.ui.testmanager.view.TestManagerImageDescriptor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (clazz.equals(object.getClass())) break block8;
            }
            return false;
        }
        TestManagerImageDescriptor other = (TestManagerImageDescriptor)((Object)object);
        return this.fBaseImage.equals(other.fBaseImage) && this.fFlags == other.fFlags && this.fSize.equals((Object)other.fSize);
    }

    public int getAdronments() {
        return this.fFlags;
    }

    private ImageData getImageData(ImageDescriptor descriptor) {
        ImageData data = descriptor.getImageData();
        if (data == null) {
            data = DEFAULT_IMAGE_DATA;
            TestManagerPlugin.log((IStatus)new Status(4, "org.eclipse.soda.devicekit.ui.testmanager", "Image data not available: " + descriptor.toString()));
        }
        return data;
    }

    public Point getImageSize() {
        return new Point(this.fSize.x, this.fSize.y);
    }

    protected Point getSize() {
        return this.fSize;
    }

    public int hashCode() {
        return this.fBaseImage.hashCode() | this.fFlags | this.fSize.hashCode();
    }

    public void setAdornments(int adornments) {
        Assert.isTrue((adornments >= 0 ? 1 : 0) != 0);
        this.fFlags = adornments;
    }

    public void setImageSize(Point size) {
        Assert.isNotNull((Object)size);
        Assert.isTrue((size.x >= 0 && size.y >= 0 ? 1 : 0) != 0);
        this.fSize = size;
    }
}

