/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.action;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.soda.devicekit.generator.util.PreGenElementHolder;
import org.eclipse.soda.devicekit.generator.util.TransportHolder;
import org.eclipse.soda.devicekit.ui.operation.ComputeClassPathOperation;
import org.eclipse.soda.devicekit.ui.operation.GenerateOperation;
import org.eclipse.soda.devicekit.ui.operation.ReplaceTransportItemsOperation;
import org.eclipse.soda.devicekit.ui.utility.DeviceKitUiUtility;
import org.eclipse.soda.devicekit.ui.wizard.IWizardMessages;
import org.eclipse.soda.devicekit.ui.wizard.WizardMessages;
import org.eclipse.soda.devicekit.util.ProjectUtil;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;

public class DeviceAction
implements IObjectActionDelegate,
Comparator,
IResourceVisitor {
    protected IFile[] files;
    protected PreGenElementHolder customElements;
    protected ArrayList list = null;

    public int compare(Object o1, Object o2) {
        String s1 = String.valueOf(o1);
        String s2 = String.valueOf(o2);
        return s2.compareTo(s1);
    }

    protected void executeComputeClassPath(IJavaProject jProject) throws InterruptedException, InvocationTargetException {
        int count = 0;
        if (jProject.exists()) {
            boolean done;
            String[] oldErrors;
            String[] newErrors;
            do {
                oldErrors = ProjectUtil.getProjectErrors((IJavaProject)jProject);
                ComputeClassPathOperation op = new ComputeClassPathOperation(jProject, true);
                Shell shell = this.getShell();
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                dialog.run(false, true, (IRunnableWithProgress)op);
            } while ((newErrors = ProjectUtil.getProjectErrors((IJavaProject)jProject)).length != 0 && (newErrors.length != oldErrors.length || !(done = ProjectUtil.compareErrors((String[])oldErrors, (String[])newErrors))) && ++count < 5);
        }
    }

    protected void executeComputeImports(IJavaProject jProject) throws InterruptedException, InvocationTargetException {
    }

    protected void executeOrganizeImports(IJavaProject jProject) throws InterruptedException, InvocationTargetException {
        try {
            this.getCompilationUnits(jProject);
        }
        catch (JavaModelException javaModelException) {}
    }

    protected ICompilationUnit[] getCompilationUnits(IJavaProject proj) throws JavaModelException {
        Vector<ICompilationUnit> vCus = new Vector<ICompilationUnit>();
        IPackageFragmentRoot[] roots = proj.getAllPackageFragmentRoots();
        int i = 0;
        while (i < roots.length) {
            if (roots[i].getJavaProject() == proj) {
                IJavaElement[] children = roots[i].getChildren();
                int j = 0;
                while (j < children.length) {
                    IPackageFragment pack;
                    if (children[j] instanceof IPackageFragment && (pack = (IPackageFragment)children[j]).getKind() == 1) {
                        ICompilationUnit[] pCus = pack.getCompilationUnits();
                        int k = 0;
                        while (k < pCus.length) {
                            vCus.add(pCus[k]);
                            ++k;
                        }
                    }
                    ++j;
                }
            }
            ++i;
        }
        Object[] cus = new ICompilationUnit[vCus.size()];
        vCus.copyInto(cus);
        return cus;
    }

    public void getFiles(IJavaProject[] javaProjects) {
        int i = 0;
        while (i < javaProjects.length) {
            this.getFiles(javaProjects[i].getProject());
            ++i;
        }
    }

    public void getFiles(IProject[] projects) {
        int i = 0;
        while (i < projects.length) {
            this.getFiles(projects[i]);
            ++i;
        }
    }

    public void getFiles(IFolder[] folders) {
        int i = 0;
        while (i < folders.length) {
            this.getFiles(folders[i]);
            ++i;
        }
    }

    public void getFiles(IResource[] resources) {
        int i = 0;
        while (i < resources.length) {
            if (resources[i] instanceof IFolder) {
                this.getFiles((IFolder)resources[i]);
            } else if (resources[i].exists()) {
                try {
                    resources[i].accept((IResourceVisitor)this);
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
            ++i;
        }
    }

    public void getFiles(IProject project) {
        IFolder folder = project.getFolder("dk");
        this.getFiles(folder);
    }

    public void getFiles(IFolder folder) {
        if (folder.exists()) {
            try {
                folder.accept((IResourceVisitor)this);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    protected void getFiles(IWorkingSet[] workingSets) {
        int i = 0;
        while (i < workingSets.length) {
            IAdaptable[] elements = workingSets[i].getElements();
            int j = 0;
            while (j < elements.length) {
                if (elements[j] instanceof IProject) {
                    this.getFiles((IProject)elements[j]);
                } else if (elements[j] instanceof IJavaProject) {
                    this.getFiles(((IJavaProject)elements[j]).getProject());
                } else if (elements[j] instanceof IFolder) {
                    this.getFiles((IFolder)elements[j]);
                }
                ++j;
            }
            ++i;
        }
    }

    protected IFile[] getFinalFiles() {
        Arrays.sort(this.files, this);
        return this.files;
    }

    protected IJavaProject[] getJavaProjects() {
        ArrayList<IJavaProject> list = new ArrayList<IJavaProject>();
        int i = 0;
        while (i < this.files.length) {
            IProject project = this.files[i].getProject();
            IJavaProject javaProject = JavaCore.create((IProject)project);
            if (!list.contains(javaProject)) {
                list.add(javaProject);
            }
            ++i;
        }
        IJavaProject[] javaProjects = new IJavaProject[list.size()];
        list.toArray(javaProjects);
        return javaProjects;
    }

    public IWorkspaceRunnable getOperation() {
        return new GenerateOperation(new Hashtable(), this.files, true);
    }

    protected Shell getShell() {
        DeviceKitUiUtility utility = DeviceKitUiUtility.getInstance();
        Shell shell = utility.getShell();
        return shell;
    }

    protected boolean handleError(Throwable t) {
        t.printStackTrace();
        Shell shell = this.getShell();
        if (shell != null) {
            IWizardMessages messages = WizardMessages.getInstance();
            if (t instanceof CoreException) {
                String message = t.getMessage();
                if (message == null || message.length() == 0) {
                    message = t.toString();
                }
                ErrorDialog.openError((Shell)shell, (String)messages.getString("devicekit.error"), (String)message, (IStatus)((CoreException)t).getStatus());
                return false;
            }
            String message = "";
            Throwable nt = t;
            if (t instanceof InvocationTargetException) {
                nt = ((InvocationTargetException)t).getTargetException();
            }
            if ((message = t.getMessage()) == null || message.length() == 0) {
                message = nt.toString();
            }
            WorkbenchException ce = new WorkbenchException(message, nt);
            Status status = new Status(4, "org.eclipse.ui", 0, "details", (Throwable)ce);
            ErrorDialog.openError((Shell)shell, (String)messages.getString("devicekit.error"), (String)message, (IStatus)status);
            return false;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public void performExtraOperations(Object[] projects) throws Exception {
        if (this.customElements != null && this.customElements.getClassInfo() != null) {
            this.putCustomElements();
        }
    }

    private void putCustomElements() throws Exception {
        TransportHolder holder = this.customElements.getClassInfo();
        IPackageFragment frag = holder.pack;
        String name = holder.typeName;
        ICompilationUnit cu = ProjectUtil.findCompilationUnit((IPackageFragment)frag, (String)name);
        List m = this.customElements.getOriginalMethods();
        List f = this.customElements.getOriginalFields();
        if (cu != null) {
            Shell shell = this.getShell();
            ReplaceTransportItemsOperation operation = new ReplaceTransportItemsOperation(cu, f, m);
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            dialog.run(true, true, (IRunnableWithProgress)operation);
        }
    }

    public void run(IAction arg0) {
        Shell shell = this.getShell();
        try {
            final IWorkspaceRunnable fop = this.getOperation();
            WorkspaceModifyOperation mop = new WorkspaceModifyOperation(){

                protected void execute(IProgressMonitor monitor) throws CoreException {
                    try {
                        fop.run(monitor);
                    }
                    catch (Exception exception) {
                        DeviceAction.this.handleError(exception);
                    }
                }
            };
            ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
            dialog.run(true, true, (IRunnableWithProgress)mop);
            if (fop instanceof GenerateOperation) {
                this.customElements = ((GenerateOperation)fop).getCustomElements();
                Object[] projects = this.getJavaProjects();
                this.performExtraOperations(projects);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.handleError(exception);
        }
    }

    public void selectionChanged(IAction arg0, ISelection selection) {
        IStructuredSelection sselection = (IStructuredSelection)selection;
        this.files = new IFile[sselection.size()];
        sselection.toList().toArray(this.files);
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public boolean visit(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            IFile file = (IFile)resource;
            String extension = file.getFileExtension();
            if ("xml".equals(extension)) {
                this.list.add(file);
            }
            return false;
        }
        return resource instanceof IFolder;
    }
}

