/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.action;

import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.soda.devicekit.ui.DeviceKitUiPlugin;
import org.eclipse.soda.devicekit.ui.action.TeamShareDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.operations.ShareProjectOperation;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkingSet;

public class DeviceTeamShareAction
implements IObjectActionDelegate {
    private List list = null;

    protected Shell getShell() {
        return DeviceKitUiPlugin.getActiveWorkbenchShell();
    }

    public void run(IAction arg0) {
        try {
            Shell shell = this.getShell();
            ICVSRepositoryLocation[] locations = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownRepositoryLocations();
            if (locations.length > 0) {
                int index = 0;
                TeamShareDialog teamShareDialog = new TeamShareDialog(shell);
                String[] items = new String[locations.length];
                int i = 0;
                while (i < locations.length) {
                    items[i] = locations[i].toString();
                    ++i;
                }
                teamShareDialog.setItems(items);
                int result = teamShareDialog.open();
                if (result != 0) {
                    return;
                }
                index = teamShareDialog.getIndex();
                ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                dialog.setCancelable(true);
                dialog.create();
                IProgressMonitor pm = dialog.getProgressMonitor();
                dialog.open();
                pm.beginTask("Team Share ", this.list.size());
                int i2 = 0;
                while (i2 < this.list.size()) {
                    if (pm.isCanceled()) break;
                    Object object = this.list.get(i2);
                    if (object instanceof IWorkingSet) {
                        IWorkingSet workingSet = (IWorkingSet)object;
                        IAdaptable[] elements = workingSet.getElements();
                        int j = 0;
                        while (j < elements.length) {
                            if (elements[j] instanceof IProject) {
                                pm.subTask(((IProject)elements[j]).getName());
                                this.teamShare(workingSet, (IProject)elements[j], index);
                            } else if (elements[j] instanceof IJavaProject) {
                                pm.subTask(((IJavaProject)elements[j]).getProject().getName());
                                this.teamShare(workingSet, ((IJavaProject)elements[j]).getProject(), index);
                            }
                            ++j;
                        }
                    }
                    pm.worked(1);
                    ++i2;
                }
                dialog.close();
            }
        }
        catch (Exception ex) {
            System.out.println(ex);
            ex.printStackTrace();
            return;
        }
    }

    public void selectionChanged(IAction arg0, ISelection selection) {
        IStructuredSelection sselection = (IStructuredSelection)selection;
        this.list = sselection.toList();
        arg0.setEnabled(this.list.size() > 0);
    }

    public void setActivePart(IAction arg0, IWorkbenchPart part) {
    }

    protected void teamShare(IWorkingSet workingSet, IProject project, int index) {
        boolean isShared = RepositoryProvider.isShared((IProject)project);
        if (!isShared) {
            System.out.println("Attempt to share " + project.getName());
            try {
                ICVSRepositoryLocation[] locations = CVSUIPlugin.getPlugin().getRepositoryManager().getKnownRepositoryLocations();
                if (locations.length > index) {
                    ICVSRepositoryLocation location = locations[index];
                    String locationName = location.getHost().toLowerCase();
                    String name = project.getName();
                    StringBuffer buffer = new StringBuffer(1024);
                    if (locationName.indexOf("ibm.com") < 0 || locationName.indexOf("dev.eclipse.org") >= 0) {
                        buffer.append("org.eclipse.ohf/plugins/org.eclipse.soda.dk/");
                        String workingName = workingSet.getName();
                        buffer.append(workingName);
                        buffer.append('/');
                    }
                    buffer.append(name);
                    String fullName = buffer.toString();
                    System.out.println("location root " + location.getRootDirectory());
                    ICVSRemoteFolder remoteFolder = location.getRemoteFolder(fullName, CVSTag.DEFAULT);
                    ShareProjectOperation op = new ShareProjectOperation(null, location, project, remoteFolder.getRepositoryRelativePath());
                    op.setShell(this.getShell());
                    op.run((IProgressMonitor)new NullProgressMonitor());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Already sharing " + project.getName());
        }
    }
}

