/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.soda.devicekit.ui.device.operation;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Hashtable;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.soda.devicekit.generator.model.xml.IXmlElement;
import org.eclipse.soda.devicekit.generator.model.xml.XmlModel;
import org.eclipse.soda.devicekit.ui.operation.DeviceKitGenerateOperation;

public class DeviceOperation
extends DeviceKitGenerateOperation {
    public DeviceOperation(Hashtable variables) {
        super(variables);
    }

    protected void addDeviceDkmlBody(IXmlElement dkmlElement) {
        IXmlElement element = dkmlElement.addElement("device");
        boolean abstractState = this.createCommonTop(element);
        String transImpl = (String)this.getVariables().get("transport.implementation");
        String transService = (String)this.getVariables().get("transport.service");
        if (transService != null && transService.trim().length() > 0) {
            IXmlElement transElement = element.addElement("transportservice");
            transElement.addAttribute("service", transService.trim());
            if (transImpl != null && transImpl.trim().length() > 0) {
                transElement.addAttribute("implementation", transImpl.trim());
            }
        } else {
            IXmlElement transport = element.addElement("transport");
            String simpleName = (String)this.getVariables().get("name");
            String transportName = String.valueOf(simpleName) + "Transport";
            StringBuffer refBuffer = new StringBuffer(128);
            String packageBase = this.getPackageBase();
            refBuffer.append(this.getNewBundleName(transportName, packageBase));
            refBuffer.append("/dk/transport.xml#");
            refBuffer.append(transportName);
            transport.addAttribute("idref", refBuffer.toString());
        }
        if (!abstractState) {
            this.addCommonBundle(element);
        }
    }

    protected void addDeviceTestDkmlBody(IXmlElement dkmlElement) {
        IXmlElement test = dkmlElement.addElement("devicetest");
        String name = this.getName();
        this.addCommonTestTop(test);
        IXmlElement device = test.addElement("device");
        StringBuffer refBuffer = new StringBuffer(128);
        refBuffer.append(this.getProjectName());
        refBuffer.append("/dk/device.xml#");
        refBuffer.append(name);
        device.addAttribute("idref", refBuffer.toString());
        if (this.doGenerateTestcase()) {
            test.addElement("testcase");
        }
        this.addCommonBundle(test);
    }

    protected void addDkmlBody(IXmlElement element, int type) {
        switch (type) {
            case 0: {
                this.addDeviceDkmlBody(element);
                break;
            }
            case 1: {
                this.addDeviceTestDkmlBody(element);
            }
        }
    }

    protected IFile createDkmlFile(int type, IFolder folder, IProgressMonitor monitor) throws CoreException {
        IFile iFile;
        InputStream stream = null;
        try {
            String filename = "device.xml";
            if (type == 1) {
                filename = "device_test.xml";
            }
            XmlModel model = new XmlModel(filename);
            this.populateTemplateModel(model, type);
            String contents = model.getContents();
            stream = new BufferedInputStream(new ByteArrayInputStream(contents.getBytes()));
            IFile file = folder.getFile(filename);
            file.create(stream, true, monitor);
            iFile = file;
            Object var9_10 = null;
        }
        catch (Throwable throwable) {
            Object var9_11 = null;
            try {
                if (stream != null) {
                    stream.close();
                    stream = null;
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (stream != null) {
                stream.close();
                stream = null;
            }
        }
        catch (IOException iOException) {}
        return iFile;
    }

    protected String getName() {
        String name = (String)this.getVariables().get("name");
        name = String.valueOf(name) + "Device";
        return name;
    }

    protected String[] getRequiredClasses() {
        return new String[0];
    }
}

